/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.eclipse.jdt.internal.compiler.util.Util;

public class TextBlock
extends StringLiteral {
    public int endLineNumber;

    private TextBlock(char[] token, int start, int end, int lineNumber, int endLineNumber) {
        super(token, start, end, lineNumber);
        this.endLineNumber = endLineNumber - 1;
    }

    public static TextBlock createTextBlock(char[] token, int start, int end, int lineNumber, int endLineNumber) {
        return new TextBlock(token, start, end, lineNumber, endLineNumber);
    }

    public static char[][] convertTextBlockToLines(char[] all) {
        all = TextBlock.normalize(all);
        char[][] lines = CharOperation.splitOn('\n', all);
        int size = lines.length;
        ArrayList<char[]> list = new ArrayList<char[]>(lines.length);
        int i = 0;
        while (i < lines.length) {
            char[] line = lines[i];
            if (i + 1 == size && line.length == 0) {
                list.add(line);
                break;
            }
            char[][] sub = CharOperation.splitOn('\r', line);
            if (sub.length == 0) {
                list.add(line);
            } else {
                char[][] cArray = sub;
                int n = sub.length;
                int n2 = 0;
                while (n2 < n) {
                    char[] cs = cArray[n2];
                    list.add(cs);
                    ++n2;
                }
            }
            ++i;
        }
        size = list.size();
        lines = (char[][])list.toArray((T[])new char[size][]);
        return lines;
    }

    public static int getTextBlockIndent(char[][] lines) {
        int prefix = -1;
        int size = lines.length;
        int i = 0;
        while (i < size) {
            char[] line = lines[i];
            boolean blank = true;
            int whitespaces = 0;
            char[] cArray = line;
            int n = line.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (blank) {
                    if (ScannerHelper.isWhitespace(c)) {
                        ++whitespaces;
                    } else {
                        blank = false;
                    }
                }
                ++n2;
            }
            if (!(blank && i + 1 != size || prefix >= 0 && whitespaces >= prefix)) {
                prefix = whitespaces;
            }
            ++i;
        }
        return prefix == -1 ? 0 : prefix;
    }

    public static int getIndentForFragments(char[][] fragments) {
        int prefix = -1;
        int index = 0;
        while (index < fragments.length) {
            char[][] lines = TextBlock.convertTextBlockToLines(fragments[index]);
            int size = lines.length;
            int i = 0;
            while (i < size) {
                if (index <= 0 || i != 0) {
                    char[] line = lines[i];
                    boolean blank = true;
                    int whitespaces = 0;
                    char[] cArray = line;
                    int n = line.length;
                    int n2 = 0;
                    while (n2 < n) {
                        char c = cArray[n2];
                        if (blank) {
                            if (ScannerHelper.isWhitespace(c)) {
                                ++whitespaces;
                            } else {
                                blank = false;
                            }
                        }
                        ++n2;
                    }
                    if (!(blank && i + 1 != size || prefix >= 0 && whitespaces >= prefix)) {
                        prefix = whitespaces;
                    }
                }
                ++i;
            }
            ++index;
        }
        return prefix == -1 ? 0 : prefix;
    }

    public static char[] formatTextBlock(char[] all, int indent, boolean followsExp, boolean precedesExp) {
        char[][] lines = TextBlock.convertTextBlockToLines(all);
        return TextBlock.formatTextBlock(lines, indent, followsExp, precedesExp);
    }

    public static char[] formatTextBlock(char[][] lines, int indent) {
        return TextBlock.formatTextBlock(lines, indent, false, false);
    }

    public static char[] formatTextBlock(char[][] lines, int indent, boolean followsExp, boolean precedesExp) {
        int size = lines.length;
        StringBuilder result = new StringBuilder();
        boolean newLine = false;
        int i = 0;
        while (i < size) {
            if (i > 0) {
                followsExp = false;
            }
            char[] l = lines[i];
            int length = l.length;
            int prefix = followsExp ? 0 : indent;
            int trail = length;
            if (!precedesExp || i < size - 1) {
                while (trail > 0) {
                    if (!ScannerHelper.isWhitespace(l[trail - 1])) break;
                    --trail;
                }
            }
            if (i >= size - 1) {
                if (newLine) {
                    result.append('\n');
                }
                if (trail >= prefix) {
                    newLine = TextBlock.getLineContent(result, l, prefix, trail - 1, false, true);
                }
            } else {
                if (i > 0 && newLine) {
                    result.append('\n');
                }
                if (trail <= prefix) {
                    newLine = true;
                } else {
                    boolean merge = length > 0 && l[length - 1] == '\\';
                    newLine = TextBlock.getLineContent(result, l, prefix, trail - 1, merge, false);
                }
            }
            ++i;
        }
        return result.toString().toCharArray();
    }

    private static char[] normalize(char[] content) {
        StringBuilder result = new StringBuilder();
        boolean isCR = false;
        char[] cArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\r': {
                    result.append(c);
                    isCR = true;
                    break;
                }
                case '\n': {
                    if (!isCR) {
                        result.append(c);
                    }
                    isCR = false;
                    break;
                }
                default: {
                    result.append(c);
                    isCR = false;
                }
            }
            ++n2;
        }
        return result.toString().toCharArray();
    }

    private static boolean getLineContent(StringBuilder result, char[] line, int start, int end, boolean merge, boolean lastLine) {
        char[] chars;
        int lastPointer = 0;
        int i = start;
        block12: while (i < end) {
            char c = line[i];
            if (c != '\\') {
                ++i;
                continue;
            }
            if (i >= end) continue;
            if (lastPointer + 1 <= i) {
                result.append(CharOperation.subarray(line, lastPointer == 0 ? start : lastPointer, i));
            }
            char next = line[++i];
            switch (next) {
                case '\\': {
                    result.append('\\');
                    if (i != end) break;
                    merge = false;
                    break;
                }
                case 's': {
                    result.append(' ');
                    break;
                }
                case '\"': {
                    result.append('\"');
                    break;
                }
                case 'b': {
                    result.append('\b');
                    break;
                }
                case 'n': {
                    result.append('\n');
                    break;
                }
                case 'r': {
                    result.append('\r');
                    break;
                }
                case 't': {
                    result.append('\t');
                    break;
                }
                case 'f': {
                    result.append('\f');
                    break;
                }
                default: {
                    int pos = i + 1;
                    int number = ScannerHelper.getHexadecimalValue(next);
                    if (number >= 0 && number <= 7) {
                        boolean zeroToThreeNot = number > 3;
                        try {
                            if (pos <= end && ScannerHelper.isDigit(next = line[pos])) {
                                ++pos;
                                int digit = ScannerHelper.getHexadecimalValue(next);
                                if (digit >= 0 && digit <= 7) {
                                    number = number * 8 + digit;
                                    if (pos <= end && ScannerHelper.isDigit(next = line[pos])) {
                                        ++pos;
                                        if (!zeroToThreeNot && (digit = ScannerHelper.getHexadecimalValue(next)) >= 0 && digit <= 7) {
                                            number = number * 8 + digit;
                                        }
                                    }
                                }
                            }
                        }
                        catch (InvalidInputException invalidInputException) {}
                        if (number < 255) {
                            next = (char)number;
                        }
                        result.append(next);
                        lastPointer = i = pos;
                        continue block12;
                    }
                    result.append(c);
                    lastPointer = i;
                    continue block12;
                }
            }
            lastPointer = ++i;
        }
        end = merge ? end : (end >= line.length ? end : end + 1);
        char[] cArray = chars = lastPointer == 0 ? CharOperation.subarray(line, start, end) : CharOperation.subarray(line, lastPointer, end);
        if (chars != null && chars.length > 0) {
            result.append(chars);
        }
        return !merge && !lastLine;
    }

    @Override
    public StringBuilder printExpression(int indent, StringBuilder output) {
        output.append("\"\"\"\n");
        char[] cArray = this.source();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            Util.appendEscapedChar(output, c, true);
            ++n2;
        }
        output.append("\"\"\"");
        return output;
    }
}

