/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.LambdaFactory;
import org.eclipse.jdt.internal.core.LambdaMethod;
import org.eclipse.jdt.internal.core.ResolvedLambdaExpression;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.util.MementoTokenizer;
import org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;

public class LambdaExpression
extends SourceType {
    private final SourceTypeElementInfo elementInfo;
    protected LambdaMethod lambdaMethod;
    protected final int sourceStart;
    protected final int sourceEnd;
    protected final int arrowPosition;
    protected final String interphase;

    LambdaExpression(JavaElement parent, org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambdaExpression) {
        super(parent, org.eclipse.jdt.internal.compiler.util.Util.EMPTY_STRING);
        this.sourceStart = lambdaExpression.sourceStart;
        this.sourceEnd = lambdaExpression.sourceEnd;
        this.arrowPosition = lambdaExpression.arrowPosition;
        TypeBinding supertype = this.findLambdaSuperType(lambdaExpression);
        this.interphase = new String(CharOperation.replaceOnCopy((char[])supertype.genericTypeSignature(), (char)'/', (char)'.'));
        this.elementInfo = LambdaExpression.makeTypeElementInfo(this, this.interphase, this.sourceStart, this.sourceEnd, this.arrowPosition);
        this.lambdaMethod = LambdaFactory.createLambdaMethod(this, lambdaExpression);
        this.elementInfo.children = new IJavaElement[]{this.lambdaMethod};
    }

    public TypeBinding findLambdaSuperType(org.eclipse.jdt.internal.compiler.ast.LambdaExpression lambdaExpression) {
        TypeBinding original = lambdaExpression.resolvedType.original();
        ReferenceBinding descType = lambdaExpression.descriptor.declaringClass;
        if (descType instanceof ParameterizedTypeBinding) {
            final ParameterizedTypeBinding descPTB = (ParameterizedTypeBinding)descType;
            final TypeBinding originalSuper = original.findSuperTypeOriginatingFrom((TypeBinding)descType);
            return Scope.substitute((Substitution)new Substitution(){

                public TypeBinding substitute(TypeVariableBinding typeVariable) {
                    if (originalSuper instanceof ParameterizedTypeBinding) {
                        ParameterizedTypeBinding originalSuperPTB = (ParameterizedTypeBinding)originalSuper;
                        TypeBinding[] superArguments = originalSuperPTB.arguments;
                        int i = 0;
                        while (i < superArguments.length) {
                            if (TypeBinding.equalsEquals((TypeBinding)superArguments[i], (TypeBinding)typeVariable)) {
                                return descPTB.arguments[i];
                            }
                            ++i;
                        }
                    }
                    return descPTB.substitute(typeVariable);
                }

                public boolean isRawSubstitution() {
                    return descPTB.isRawType();
                }

                public LookupEnvironment environment() {
                    return descPTB.environment;
                }

                public ITeamAnchor substituteAnchor(ITeamAnchor anchor, int rank) {
                    return descPTB.substituteAnchor(anchor, rank);
                }
            }, (TypeBinding)original);
        }
        return original;
    }

    LambdaExpression(JavaElement parent, String interphase, int sourceStart, int sourceEnd, int arrowPosition) {
        super(parent, org.eclipse.jdt.internal.compiler.util.Util.EMPTY_STRING);
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.arrowPosition = arrowPosition;
        this.interphase = interphase;
        this.elementInfo = LambdaExpression.makeTypeElementInfo(this, interphase, sourceStart, sourceEnd, arrowPosition);
    }

    LambdaExpression(JavaElement parent, String interphase, int sourceStart, int sourceEnd, int arrowPosition, LambdaMethod lambdaMethod) {
        super(parent, org.eclipse.jdt.internal.compiler.util.Util.EMPTY_STRING);
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        this.arrowPosition = arrowPosition;
        this.interphase = interphase;
        this.elementInfo = LambdaExpression.makeTypeElementInfo(this, interphase, sourceStart, sourceEnd, arrowPosition);
        IJavaElement[] iJavaElementArray = new IJavaElement[1];
        this.lambdaMethod = lambdaMethod;
        iJavaElementArray[0] = this.lambdaMethod;
        this.elementInfo.children = iJavaElementArray;
    }

    private static SourceTypeElementInfo makeTypeElementInfo(LambdaExpression handle, String interphase, int sourceStart, int sourceEnd, int arrowPosition) {
        SourceTypeElementInfo elementInfo = new SourceTypeElementInfo();
        elementInfo.setFlags(0);
        elementInfo.setHandle(handle);
        elementInfo.setSourceRangeStart(sourceStart);
        elementInfo.setSourceRangeEnd(sourceEnd);
        elementInfo.setNameSourceStart(sourceStart);
        elementInfo.setNameSourceEnd(arrowPosition);
        elementInfo.setSuperclassName(null);
        elementInfo.addCategories(handle, null);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        char[][] superinterfaces = new char[][]{manager.intern(Signature.toString(interphase).toCharArray())};
        elementInfo.setSuperInterfaceNames(superinterfaces);
        return elementInfo;
    }

    @Override
    protected void closing(Object info) throws JavaModelException {
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LambdaExpression) {
            LambdaExpression that = (LambdaExpression)o;
            if (this.sourceStart != that.sourceStart) {
                return false;
            }
            ITypeRoot thisTR = this.getTypeRoot();
            ITypeRoot thatTR = that.getTypeRoot();
            return thisTR.getElementName().equals(thatTR.getElementName()) && thisTR.getParent().equals(thatTR.getParent());
        }
        return false;
    }

    @Override
    protected int calculateHashCode() {
        return Util.combineHashCodes(super.calculateHashCode(), this.sourceStart);
    }

    @Override
    public SourceTypeElementInfo getElementInfo(IProgressMonitor monitor) throws JavaModelException {
        return this.elementInfo;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return ')';
    }

    @Override
    protected void getHandleMemento(StringBuilder buff) {
        this.getHandleMemento(buff, true, true);
        this.appendEscapedDelimiter(buff, this.getHandleMementoDelimiter());
    }

    protected void getHandleMemento(StringBuilder buff, boolean serializeParent, boolean serializeChild) {
        if (serializeParent) {
            this.getParent().getHandleMemento(buff);
        }
        this.appendEscapedDelimiter(buff, this.getHandleMementoDelimiter());
        this.appendEscapedDelimiter(buff, '\"');
        this.escapeMementoName(buff, this.interphase);
        buff.append('!');
        buff.append(this.sourceStart);
        buff.append('!');
        buff.append(this.sourceEnd);
        buff.append('!');
        buff.append(this.arrowPosition);
        if (serializeChild) {
            this.lambdaMethod.getHandleMemento(buff, false);
        }
    }

    @Override
    public IJavaElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        if (token.charAt(0) != '&') {
            return null;
        }
        if (!memento.hasMoreTokens()) {
            return this;
        }
        String selector = memento.nextToken();
        if (!memento.hasMoreTokens() || memento.nextToken().charAt(0) != '!') {
            return this;
        }
        if (!memento.hasMoreTokens()) {
            return this;
        }
        int length = Integer.parseInt(memento.nextToken());
        String[] parameterTypes = new String[length];
        String[] parameterNames = new String[length];
        int i = 0;
        while (i < length) {
            if (!memento.hasMoreTokens() || memento.nextToken().charAt(0) != '\"') {
                return this;
            }
            parameterTypes[i] = memento.nextToken();
            if (!memento.hasMoreTokens() || memento.nextToken().charAt(0) != '\"') {
                return this;
            }
            parameterNames[i] = memento.nextToken();
            ++i;
        }
        if (!memento.hasMoreTokens() || memento.nextToken().charAt(0) != '\"') {
            return this;
        }
        String returnType = memento.nextToken();
        if (!memento.hasMoreTokens() || memento.nextToken().charAt(0) != '\"') {
            return this;
        }
        String key = memento.nextToken();
        this.lambdaMethod = LambdaFactory.createLambdaMethod(this, selector, key, this.sourceStart, this.sourceEnd, this.arrowPosition, parameterTypes, parameterNames, returnType);
        ILocalVariable[] parameters = new ILocalVariable[length];
        int i2 = 0;
        while (i2 < length) {
            parameters[i2] = (ILocalVariable)this.lambdaMethod.getHandleFromMemento(memento, workingCopyOwner);
            ++i2;
        }
        this.lambdaMethod.elementInfo.arguments = parameters;
        this.elementInfo.children = new IJavaElement[]{this.lambdaMethod};
        if (!memento.hasMoreTokens()) {
            return this.lambdaMethod;
        }
        switch (memento.nextToken().charAt(0)) {
            case '&': {
                if (!memento.hasMoreTokens()) {
                    return this.lambdaMethod;
                }
                return this.lambdaMethod.getHandleFromMemento(memento, workingCopyOwner);
            }
        }
        return this;
    }

    @Override
    public IJavaElement[] getChildren() throws JavaModelException {
        return new IJavaElement[]{this.lambdaMethod};
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public ResolvedLambdaExpression resolved(Binding binding) {
        return new ResolvedLambdaExpression(this.getParent(), this, new String(binding.computeUniqueKey()));
    }

    public IMethod getMethod() {
        return this.lambdaMethod;
    }

    @Override
    public boolean isLambda() {
        return true;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public void toStringName(StringBuilder buffer) {
        super.toStringName(buffer);
        buffer.append("<lambda #");
        buffer.append(this.getOccurrenceCount());
        buffer.append(">");
    }

    @Override
    public JavaElement getPrimaryElement(boolean checkOwner) {
        CompilationUnit cu;
        if (checkOwner && ((cu = (CompilationUnit)this.getAncestor(5)) == null || cu.isPrimary())) {
            return this;
        }
        JavaElement primaryParent = this.getParent().getPrimaryElement(false);
        if (primaryParent instanceof JavaElement) {
            JavaElement ancestor = primaryParent;
            StringBuilder buffer = new StringBuilder(32);
            this.getHandleMemento(buffer, false, true);
            String memento = buffer.toString();
            return (JavaElement)ancestor.getHandleFromMemento(new MementoTokenizer(memento), DefaultWorkingCopyOwner.PRIMARY).getParent();
        }
        return this;
    }

    @Override
    public String[] getSuperInterfaceTypeSignatures() throws JavaModelException {
        return new String[]{this.interphase};
    }
}

