/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesUtil {
    public static final String USER_HOME = PropertiesUtil.getProperty("user.home", ".");
    public static final String[] EXPERT_FILTER = new String[]{"org.eclipse.ui.views.properties.expert"};
    private static final String TRUE = Boolean.TRUE.toString();

    private PropertiesUtil() {
    }

    public static Boolean getBoolean(String key) {
        String property = PropertiesUtil.getProperty(key);
        if (property != null) {
            return TRUE.equalsIgnoreCase(property);
        }
        return null;
    }

    public static boolean isProperty(String key) {
        String property = PropertiesUtil.getProperty(key);
        if (property != null) {
            return TRUE.equalsIgnoreCase(property);
        }
        return false;
    }

    public static String getProperty(String key) {
        return PropertiesUtil.getProperty(key, null);
    }

    public static String getProperty(String key, String defaultValue) {
        String value = System.getProperty(key);
        if (value == null && (value = System.getenv(key)) == null && key.indexOf(46) != -1) {
            key = key.replace('.', '_');
            value = PropertiesUtil.getProperty(key, defaultValue);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static void saveProperties(File file, Map<String, String> properties, boolean sort) {
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(file);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                ArrayList<String> keys = new ArrayList<String>(properties.keySet());
                if (sort) {
                    Collections.sort(keys);
                }
                for (String key : keys) {
                    String value = properties.get(key);
                    String line = StringUtil.implode(Arrays.asList(key, value), '=');
                    bufferedWriter.write(line);
                    bufferedWriter.write(StringUtil.NL);
                }
                bufferedWriter.close();
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeSilent(fileWriter);
            throw throwable;
        }
        IOUtil.closeSilent(fileWriter);
    }

    public static Map<String, String> loadProperties(File file) {
        LinkedHashMap<String, String> linkedHashMap;
        FileReader fileReader = null;
        try {
            String line;
            fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            while ((line = bufferedReader.readLine()) != null) {
                List<String> tokens = StringUtil.explode(line, "=");
                int size = tokens.size();
                if (size <= 0) continue;
                String key = tokens.get(0);
                String value = null;
                if (size == 2) {
                    value = tokens.get(1);
                } else if (size > 2) {
                    StringBuilder builder = new StringBuilder();
                    int i = 1;
                    while (i < size) {
                        if (builder.length() != 0) {
                            builder.append("=");
                        }
                        builder.append(tokens.get(i));
                        ++i;
                    }
                    value = builder.toString();
                }
                properties.put(key, value);
            }
            linkedHashMap = properties;
        }
        catch (IOException ex) {
            try {
                throw new IORuntimeException(ex);
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(fileReader);
                throw throwable;
            }
        }
        IOUtil.closeSilent(fileReader);
        return linkedHashMap;
    }
}

