/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.repository.Activator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.Window;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.installer.CocoaUtil;
import org.eclipse.oomph.setup.internal.installer.InstallerDialog;
import org.eclipse.oomph.setup.internal.installer.ProxyPreferenceDialog;
import org.eclipse.oomph.setup.internal.installer.SelfUpdate;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.ui.Questionnaire;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;

public class InstallerApplication
implements IApplication {
    public static final Integer EXIT_ERROR = 1;

    private Integer run(final IApplicationContext context) throws Exception {
        int[] sizes = new int[]{16, 32, 48, 64, 128, 256};
        Image[] images = new Image[sizes.length];
        int i = 0;
        while (i < sizes.length) {
            int size = sizes[i];
            images[i] = SetupInstallerPlugin.INSTANCE.getSWTImage("oomph" + size + ".png");
            ++i;
        }
        Window.setDefaultImages((Image[])images);
        boolean restarted = false;
        File restarting = new File(SetupContext.CONFIGURATION_STATE_LOCATION_URI.appendSegment("restarting").toFileString());
        try {
            if (restarting.exists()) {
                restarted = true;
                if (!restarting.delete()) {
                    restarting.deleteOnExit();
                }
            }
        }
        catch (Exception exception) {}
        final Display display = Display.getDefault();
        Display.setAppName((String)"Oomph Installer");
        final InstallerDialog[] installerDialog = new InstallerDialog[1];
        if ("cocoa".equals(Platform.getWS())) {
            Runnable about = new Runnable(){

                public void run() {
                    if (installerDialog[0] != null) {
                        installerDialog[0].showAbout();
                    }
                }
            };
            Runnable preferences = new Runnable(){

                public void run() {
                    if (installerDialog[0] != null) {
                        ProxyPreferenceDialog proxyPreferenceDialog = new ProxyPreferenceDialog(installerDialog[0].getShell());
                        proxyPreferenceDialog.open();
                    }
                }
            };
            Runnable quit = new Runnable(){

                public void run() {
                    if (installerDialog[0] != null) {
                        display.dispose();
                    }
                }
            };
            CocoaUtil.register(display, about, preferences, quit);
        }
        display.asyncExec(new Runnable(){

            public void run() {
                context.applicationRunning();
            }
        });
        if (!SetupUIPlugin.QUESTIONNAIRE_SKIP) {
            Questionnaire.perform(null, (boolean)false);
        }
        P2Util.getCurrentProvisioningAgent().registerService(UIServices.SERVICE_NAME, (Object)SetupWizard.Installer.SERVICE_UI);
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningAgent.SERVICE_NAME);
        agent.registerService(UIServices.SERVICE_NAME, (Object)SetupWizard.Installer.SERVICE_UI);
        installerDialog[0] = new InstallerDialog(null, restarted);
        int retcode = installerDialog[0].open();
        if (retcode == -4) {
            try {
                restarting.createNewFile();
            }
            catch (Exception exception) {}
            return EXIT_RESTART;
        }
        return EXIT_OK;
    }

    public Object start(IApplicationContext context) throws Exception {
        try {
            return this.run(context);
        }
        catch (Throwable t) {
            SetupInstallerPlugin.INSTANCE.log(t);
            final AtomicInteger exitCode = new AtomicInteger(EXIT_ERROR);
            ErrorDialog dialog = new ErrorDialog("Error", t, 0, 2, new String[]{IDialogConstants.OK_LABEL, "Update", IDialogConstants.SHOW_DETAILS_LABEL}){

                protected void buttonPressed(int buttonId) {
                    super.buttonPressed(buttonId);
                    if (buttonId == 1) {
                        this.update();
                    }
                }

                private void update() {
                    try {
                        final Shell shell = this.getShell();
                        if (!MessageDialog.openQuestion((Shell)shell, (String)"Emergency Update", (String)"This is an emergency update. Continue?\n\nTo lower the risk of problems during this update it will be implied that you accept new licenses or unsigned content.")) {
                            return;
                        }
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

                            protected Point getInitialSize() {
                                Point calculatedSize = super.getInitialSize();
                                if (calculatedSize.x < 800) {
                                    calculatedSize.x = 800;
                                }
                                return calculatedSize;
                            }
                        };
                        try {
                            dialog.run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                                    try {
                                        ProfileTransaction.Resolution resolution = SelfUpdate.resolve(null, (IProgressMonitor)progress.newChild(1));
                                        if (resolution == null) {
                                            MessageDialog.openInformation((Shell)shell, (String)"Update", (String)"No updates were found.");
                                            return;
                                        }
                                        try {
                                            resolution.commit((IProgressMonitor)progress.newChild(1));
                                            exitCode.set(EXIT_RESTART);
                                        }
                                        catch (Throwable ex) {
                                            throw new InvocationTargetException(ex);
                                        }
                                    }
                                    finally {
                                        progress.done();
                                    }
                                }
                            });
                        }
                        catch (OperationCanceledException operationCanceledException) {
                        }
                        catch (InvocationTargetException ex) {
                            if (!(ex.getCause() instanceof OperationCanceledException)) {
                                throw ex;
                            }
                        }
                    }
                    catch (Throwable ex) {
                        SetupInstallerPlugin.INSTANCE.log(ex);
                        ErrorDialog.open((Throwable)ex);
                    }
                }
            };
            dialog.open();
            return exitCode.get();
        }
    }

    public void stop() {
    }
}

