/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.quickfixes;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.version.Markers;
import org.eclipse.oomph.version.ui.quickfixes.AbstractResolution;

public class AddNatureResolution
extends AbstractResolution {
    private String nature;

    public AddNatureResolution(IMarker marker, String nature) {
        super(marker, "org.eclipse.oomph.version.VersionNature".equals(nature) ? "Add the version management builder" : "Add the nature " + nature, "icons/correction_configure.gif");
        this.nature = nature;
    }

    protected boolean isApplicable(IMarker marker) {
        String requiredNature = Markers.getQuickFixNature((IMarker)marker);
        return this.nature.equals(requiredNature);
    }

    protected void apply(IMarker marker) throws Exception {
        String nature = Markers.getQuickFixNature((IMarker)marker);
        IProject project = marker.getResource().getProject();
        String projectName = Markers.getQuickFixProject((IMarker)marker);
        if (projectName != null) {
            VersionBuilderArguments arguments = new VersionBuilderArguments(project);
            IProject targetProject = project.getWorkspace().getRoot().getProject(projectName);
            arguments.applyTo(targetProject);
        } else {
            IProjectDescription description = project.getDescription();
            ArrayList<String> natures = new ArrayList<String>(Arrays.asList(description.getNatureIds()));
            if (natures.contains(nature)) {
                natures.remove(nature);
                description.setNatureIds(natures.toArray(new String[natures.size()]));
                project.setDescription(description, null);
            }
            natures.add(nature);
            description.setNatureIds(natures.toArray(new String[natures.size()]));
            project.setDescription(description, null);
        }
    }
}

