/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.oomph.setup.internal.installer.AbstractSimpleDialog;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.setup.internal.installer.SimpleVariablePage;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class SimpleInstallLaunchButton
extends ImageHoverButton {
    private static final Color COLOR_FOREGROUND_DEFAULT = AbstractSimpleDialog.COLOR_WHITE;
    private static final Color COLOR_INSTALL = SetupInstallerPlugin.getColor((int)250, (int)148, (int)0);
    private static final Color COLOR_INSTALLING = SetupInstallerPlugin.getColor((int)50, (int)196, (int)0);
    private static final Color COLOR_INSTALLING_FOREGROUND = AbstractSimpleDialog.COLOR_LABEL_FOREGROUND;
    private static final Color COLOR_LAUNCH = COLOR_INSTALLING;
    private static final long MINIMUM_PROGRESS_ANIMATION_DELAY = 20L;
    private static final long MAXIMUM_PROGRESS_ANIMATION_DELAY = 200L;
    private State currentState;
    private float progress;
    private ProgressSpinner progressSpinner;

    public SimpleInstallLaunchButton(Composite parent) {
        super(parent, 8);
        this.setForeground(UIUtil.getDisplay().getSystemColor(1));
        this.setFont(SimpleInstallerDialog.getFont(5, "bold"));
        this.setCornerWidth(10);
        this.setAlignment(0x1000000);
        this.setDisabledBackgroundColor(COLOR_DEFAULT_DISABLED_BACKGROUND);
        this.setBackgroundMode(2);
        this.setLayout(null);
        if (SimpleVariablePage.PROGRESS_WATCHDOG_TIMEOUT != 0) {
            this.progressSpinner = new ProgressSpinner(SetupInstallerPlugin.INSTANCE.getSWTImage("simple/progress_sprite.png"), 8, 4, 20L);
            this.progressSpinner.setKeyframeRange(1, 31);
        }
        this.setCurrentState(State.INSTALL);
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        if (progress < 0.0f || progress > 1.0f) {
            throw new IllegalArgumentException("Progress must be in [0..1]");
        }
        this.progress = progress;
        this.redraw();
    }

    public boolean isHover() {
        return this.currentState == State.INSTALLING ? false : super.isHover();
    }

    public void setCurrentState(State newState) {
        if (newState == null) {
            throw new IllegalArgumentException("New state cannot be null!");
        }
        if (this.currentState != newState) {
            State oldState = this.currentState;
            this.currentState = newState;
            this.stateChanged(oldState, this.currentState);
        }
    }

    private void stateChanged(State oldState, State newState) {
        this.setDefaultImage(newState.icon);
        this.setHoverImage(newState.hoverIcon);
        this.setDisabledImage(newState.disabledIcon);
        this.setText(newState.label);
        this.setToolTipText(newState.tooltip);
        this.setBackground(newState.backgroundColor);
        this.setForeground(newState.foregroundColor);
        switch (newState) {
            case INSTALLING: {
                this.setListenersPaused(true);
                this.setCursor(null);
                this.setShowButtonDownState(false);
                if (this.progressSpinner == null) break;
                this.progressSpinner.setVisible(true);
                break;
            }
            default: {
                this.setListenersPaused(false);
                this.setCursor(UIUtil.getDisplay().getSystemCursor(21));
                this.setShowButtonDownState(true);
                this.stopProgressAnimation();
                if (this.progressSpinner == null) break;
                this.progressSpinner.setVisible(false);
            }
        }
    }

    public void setProgressAnimationSpeed(float speed) {
        if (this.progressSpinner != null) {
            if (speed < 0.0f || speed > 1.0f) {
                throw new IllegalArgumentException("speed must be between [0..1]");
            }
            int delay = Math.round((1.0f - speed) * 200.0f);
            this.progressSpinner.setDelay(Math.max((long)delay, 20L));
        }
    }

    public void stopProgressAnimation() {
        if (this.progressSpinner != null) {
            this.progressSpinner.setVisible(false);
        }
    }

    public void startProgressAnimation() {
        if (this.progressSpinner != null) {
            this.relocateProgressAnimation();
            this.progressSpinner.setVisible(true);
        }
    }

    private void relocateProgressAnimation() {
        if (this.progressSpinner != null) {
            GC gc = new GC((Drawable)this);
            try {
                Point textExtent = gc.textExtent(this.getText());
                int spinnerTextGap = 10;
                Rectangle clientArea = this.getClientArea();
                int startX = (clientArea.width - textExtent.x) / 2 - spinnerTextGap - this.progressSpinner.getWidth();
                int startY = (clientArea.height - this.progressSpinner.getHeight()) / 2;
                this.progressSpinner.setLocation(startX, startY);
            }
            finally {
                gc.dispose();
            }
        }
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
        if (this.currentState == State.INSTALLING) {
            gc.setBackground(AbstractSimpleDialog.COLOR_LIGHTEST_GRAY);
            gc.fillRoundRectangle(x, y, width, height, this.getCornerWidth(), this.getCornerWidth());
            int progressWidth = (int)((float)width * this.progress);
            gc.setBackground(this.currentState.backgroundColor);
            gc.fillRoundRectangle(x, y, progressWidth, height, this.getCornerWidth(), this.getCornerWidth());
            if (progressWidth <= width - this.getCornerWidth() / 2) {
                gc.fillRectangle(progressWidth - this.getCornerWidth(), y, this.getCornerWidth(), height);
            }
            if (this.progressSpinner != null) {
                this.progressSpinner.update(gc);
            }
        } else {
            super.drawBackground(gc, x, y, width, height, offsetX, offsetY);
        }
    }

    static /* synthetic */ Color access$0() {
        return COLOR_INSTALL;
    }

    static /* synthetic */ Color access$1() {
        return COLOR_FOREGROUND_DEFAULT;
    }

    static /* synthetic */ Color access$2() {
        return COLOR_INSTALLING;
    }

    static /* synthetic */ Color access$3() {
        return COLOR_INSTALLING_FOREGROUND;
    }

    static /* synthetic */ Color access$4() {
        return COLOR_LAUNCH;
    }

    private class ProgressSpinner
    implements Runnable {
        private Image[] sprites;
        private int currentSpriteIndex = 0;
        private long nextKeyframeTime = -1L;
        private boolean visible;
        private long delay;
        private int x = -1;
        private int y = -1;
        private int firstKeyframe = -1;
        private int lastKeyframe = -1;

        public ProgressSpinner(Image textureAtlas, int countX, int countY, long delay) {
            this.delay = delay;
            this.sprites = UIUtil.extractSprites((Image)textureAtlas, (int)countX, (int)countY);
            this.firstKeyframe = 0;
            this.lastKeyframe = this.sprites.length - 1;
            this.visible = false;
        }

        public void setLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void setKeyframeRange(int firstKeyframe, int lastKeyframe) {
            this.firstKeyframe = firstKeyframe;
            this.lastKeyframe = lastKeyframe;
        }

        public int getWidth() {
            return this.sprites[0].getBounds().width;
        }

        public int getHeight() {
            return this.sprites[0].getBounds().height;
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
            if (this.visible) {
                this.schedule();
            }
        }

        public void update(GC gc) {
            if (!this.visible || this.x < 0 || this.y < 0) {
                return;
            }
            gc.drawImage(this.sprites[this.currentSpriteIndex], this.x, this.y);
            long now = System.currentTimeMillis();
            if (now >= this.nextKeyframeTime) {
                if (++this.currentSpriteIndex > this.lastKeyframe) {
                    this.currentSpriteIndex = this.firstKeyframe;
                }
                this.nextKeyframeTime = now + this.delay;
            }
        }

        public void run() {
            if (this.visible && !SimpleInstallLaunchButton.this.isDisposed()) {
                SimpleInstallLaunchButton.this.redraw();
                this.schedule();
            }
        }

        private void schedule() {
            SimpleInstallLaunchButton.this.getDisplay().timerExec((int)this.delay, (Runnable)this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        INSTALL("INSTALL", "Start product installation", SimpleInstallLaunchButton.access$0(), SimpleInstallLaunchButton.access$1(), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/install_button_install.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/install_button_install_hover.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/install_button_install_disabled.png")),
        INSTALLING("INSTALLING", "Installion in progress", SimpleInstallLaunchButton.access$2(), SimpleInstallLaunchButton.access$3(), null, null, null),
        LAUNCH("LAUNCH", "Launch the selected product", SimpleInstallLaunchButton.access$4(), SimpleInstallLaunchButton.access$1(), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/install_button_launch.png"), SetupInstallerPlugin.INSTANCE.getSWTImage("simple/install_button_launch_hover.png"), null);

        public final Image icon;
        public final Image hoverIcon;
        public final Image disabledIcon;
        public final String label;
        public final String tooltip;
        public final Color backgroundColor;
        public final Color foregroundColor;

        private State(String label, String tooltip, Color backgroundColor, Color foregroundColor, Image icon, Image hoverIcon, Image disabledIcon) {
            this.label = label;
            this.tooltip = tooltip;
            this.backgroundColor = backgroundColor;
            this.foregroundColor = foregroundColor;
            this.icon = icon;
            this.hoverIcon = hoverIcon;
            this.disabledIcon = disabledIcon;
        }
    }
}

