/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.p2.impl.P2TaskImpl;
import org.eclipse.oomph.setup.ui.UnsignedContentDialog;
import org.eclipse.oomph.setup.ui.wizards.ProgressPage;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UICallback;
import org.eclipse.oomph.util.Confirmer;
import org.eclipse.oomph.util.ExceptionHandler;
import org.eclipse.oomph.util.IRunnable;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelfUpdate {
    private static final String PROP_INSTALLER_UPDATE_URL = "oomph.installer.update.url";
    private static final String DEFAULT_INSTALLER_UPDATE_URL = "http://download.eclipse.org/oomph/products/repository";
    public static final String INSTALLER_UPDATE_URL = PropertiesUtil.getProperty((String)"oomph.installer.update.url", (String)"http://download.eclipse.org/oomph/products/repository").replace('\\', '/');
    public static final String SELF_HOSTING = "Self Hosting";

    public static String getProductVersion() {
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        IProfile profile = agent.getProfileRegistry().getProfile("_SELF_");
        if (profile == null || "SelfHostingProfile".equals(profile.getProfileId())) {
            return SELF_HOSTING;
        }
        String firstBuildID = null;
        int highestBuildID = 0;
        BundleContext bundleContext = SetupInstallerPlugin.INSTANCE.getBundleContext();
        Bundle[] bundleArray = bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            String buildID;
            Bundle bundle = bundleArray[n2];
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName.startsWith("org.eclipse.oomph") && (buildID = OomphPlugin.getBuildID((Bundle)bundle)) != null) {
                if (firstBuildID == null) {
                    firstBuildID = buildID;
                }
                try {
                    int id = Integer.parseInt(buildID);
                    if (id > highestBuildID) {
                        highestBuildID = id;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            ++n2;
        }
        String buildID = highestBuildID != 0 ? Integer.toString(highestBuildID) : firstBuildID;
        Iterator iterator = P2Util.asIterable((IQueryResult)profile.query(QueryUtil.createIUQuery((String)"org.eclipse.oomph.setup.installer.product"), null)).iterator();
        if (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            Version version = iu.getVersion();
            String label = buildID != null && version.getSegmentCount() > 3 ? version.getSegment(0) + "." + version.getSegment(1) + "." + version.getSegment(2) : version.toString();
            if (buildID != null) {
                label = String.valueOf(label) + " Build " + buildID;
            }
            return label;
        }
        return null;
    }

    public static ProfileTransaction.Resolution resolve(final User user, IProgressMonitor monitor) throws CoreException {
        Agent agent = P2Util.getAgentManager().getCurrentAgent();
        Profile profile = agent.getCurrentProfile();
        ProfileTransaction transaction = profile.change();
        VersionRange deprecatedVersionRange = new VersionRange("[1.0.0,1.1.0)");
        ProfileDefinition profileDefinition = transaction.getProfileDefinition();
        for (Requirement requirement : profileDefinition.getRequirements()) {
            if (!"org.eclipse.equinox.p2.iu".equals(requirement.getNamespace()) || !"org.eclipse.oomph.setup.installer.product".equals(requirement.getName()) || !deprecatedVersionRange.equals((Object)requirement.getVersionRange())) continue;
            requirement.setVersionRange(new VersionRange("[1.0.0,2.0.0)"));
            transaction.commit(monitor);
            transaction = profile.change();
            break;
        }
        final boolean repositoryChanged = SelfUpdate.changeRepositoryIfNeeded(transaction);
        ProfileTransaction.CommitContext commitContext = new ProfileTransaction.CommitContext(){
            private IProvisioningPlan provisioningPlan;

            public boolean handleProvisioningPlan(ProfileTransaction.CommitContext.ResolutionInfo info) throws CoreException {
                if (repositoryChanged && info.getIUDeltas().isEmpty() && info.getPropertyDeltas().size() <= 1) {
                    return false;
                }
                this.provisioningPlan = info.getProvisioningPlan();
                return true;
            }

            public Confirmer getUnsignedContentConfirmer() {
                if (user == null) {
                    return Confirmer.ACCEPT;
                }
                P2TaskImpl.processLicenses((IProvisioningPlan)this.provisioningPlan, (Confirmer)ProgressPage.LICENSE_CONFIRMER, (User)user, (boolean)true, (IProgressMonitor)new NullProgressMonitor());
                this.provisioningPlan = null;
                return UnsignedContentDialog.createUnsignedContentConfirmer((User)user, (boolean)true);
            }
        };
        return transaction.resolve(commitContext, monitor);
    }

    public static void update(Shell shell, final ProfileTransaction.Resolution resolution, final Runnable successRunnable, final ExceptionHandler<CoreException> exceptionHandler, final Runnable finalRunnable) {
        String shellText = shell.getText();
        if (!StringUtil.isEmpty((String)shellText)) {
            shellText = String.valueOf(shellText) + " ";
        }
        final UICallback callback = new UICallback(shell, String.valueOf(shellText) + "Update");
        callback.runInProgressDialog(false, new IRunnable(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        resolution.commit(monitor);
                        callback.execInUI(true, new Runnable(){

                            public void run() {
                                callback.information(false, "Updates were installed. Press OK to restart.");
                                if (successRunnable != null) {
                                    successRunnable.run();
                                }
                            }
                        });
                    }
                    catch (CoreException ex) {
                        if (exceptionHandler != null) {
                            exceptionHandler.handleException((Throwable)ex);
                        } else {
                            ErrorDialog.open((Throwable)ex);
                        }
                        if (finalRunnable != null) {
                            finalRunnable.run();
                        }
                    }
                }
                finally {
                    if (finalRunnable != null) {
                        finalRunnable.run();
                    }
                }
            }
        });
    }

    private static boolean changeRepositoryIfNeeded(ProfileTransaction transaction) {
        ProfileDefinition profileDefinition = transaction.getProfileDefinition();
        EList repositories = profileDefinition.getRepositories();
        if (repositories.size() != 1 || !INSTALLER_UPDATE_URL.equals(((Repository)repositories.get(0)).getURL())) {
            Repository repository = P2Factory.eINSTANCE.createRepository(INSTALLER_UPDATE_URL);
            profileDefinition.setRepositories(ECollections.singletonEList((Object)repository));
            return true;
        }
        return false;
    }
}

