/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IUpdateableItemParent;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.util.BaseResource;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.setup.CatalogSelection;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.ProjectContainer;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.Stream;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.CatalogManager;
import org.eclipse.oomph.setup.internal.core.util.IndexManager;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.provider.CatalogSelectionItemProvider;
import org.eclipse.oomph.setup.provider.IndexItemProvider;
import org.eclipse.oomph.setup.provider.ProjectCatalogItemProvider;
import org.eclipse.oomph.setup.provider.ProjectItemProvider;
import org.eclipse.oomph.setup.provider.SetupItemProviderAdapterFactory;
import org.eclipse.oomph.setup.provider.WorkspaceItemProvider;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.setup.ui.SetupTransferSupport;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.ToolTipLabelProvider;
import org.eclipse.oomph.setup.ui.wizards.CatalogSelector;
import org.eclipse.oomph.setup.ui.wizards.ConfigurationProcessor;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardPage;
import org.eclipse.oomph.ui.ButtonAnimator;
import org.eclipse.oomph.ui.FilteredTreeWithoutWorkbench;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.URLTransfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectPage
extends SetupWizardPage {
    private final Set<URI> existingStreams = new HashSet<URI>();
    private final SetupWizard.SelectionMemento selectionMemento;
    private final AtomicBoolean selectionMementoTried = new AtomicBoolean();
    private ComposedAdapterFactory adapterFactory;
    private ToolTipLabelProvider labelProvider;
    private CatalogSelector catalogSelector;
    private CheckboxTreeViewer projectViewer;
    private TableViewer streamViewer;
    private AddButtonAnimator addButtonAnimator;
    private boolean projectsChanged;
    private boolean inactive;
    private ConfigurationListener configurationListener;
    private SetupTransferSupport.DropListener dropListener;
    private FilteredTreeWithoutWorkbench.WithCheckboxes filteredTree;

    public ProjectPage(SetupWizard.SelectionMemento selectionMemento) {
        super("ProjectPage");
        this.selectionMemento = selectionMemento;
        this.setTitle("Projects");
        this.setDescription("Check the projects you want to provision, and for each choose its stream in the table column.");
    }

    @Override
    protected Control createUI(Composite parent) {
        CatalogManager catalogManager = this.getCatalogManager();
        this.catalogSelector = new CatalogSelector(catalogManager, false);
        this.adapterFactory = new ComposedAdapterFactory((AdapterFactory)this.getAdapterFactory());
        this.adapterFactory.insertAdapterFactory((AdapterFactory)new ItemProviderAdapterFactory(this.catalogSelector.getSelection()));
        BaseEditUtil.replaceReflectiveItemProvider((ComposedAdapterFactory)this.adapterFactory);
        ResourceSet resourceSet = this.getResourceSet();
        final AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)new BasicCommandStack(){

            public void execute(Command command) {
                super.execute(command);
                final Collection affectedObjects = command.getAffectedObjects();
                UIUtil.asyncExec((Control)ProjectPage.this.projectViewer.getControl(), (Runnable)new Runnable(){

                    public void run() {
                        ProjectPage.this.projectViewer.setSelection((ISelection)new StructuredSelection(affectedObjects.toArray()), true);
                    }
                });
            }
        }, resourceSet);
        SashForm sashForm = new SashForm(parent, 66048);
        Composite upperComposite = new Composite((Composite)sashForm, 0);
        upperComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        Composite filterComposite = new Composite(upperComposite, 0);
        filterComposite.setLayout((Layout)UIUtil.createGridLayout((int)2));
        filterComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite filterPlaceholder = new Composite(filterComposite, 0);
        filterPlaceholder.setLayout((Layout)UIUtil.createGridLayout((int)1));
        filterPlaceholder.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        ToolBar filterToolBar = new ToolBar(filterComposite, 0x820000);
        final ToolItem addProjectButton = new ToolItem(filterToolBar, 0);
        addProjectButton.setToolTipText("Add user projects");
        addProjectButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("add_project"));
        AccessUtil.setKey((Widget)addProjectButton, (Object)"addProject");
        final HashSet projectCatalogs = new HashSet();
        addProjectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddUserProjectDialog dialog = new AddUserProjectDialog(ProjectPage.this.getShell(), projectCatalogs, ProjectPage.this.catalogSelector, editingDomain);
                dialog.open();
            }
        });
        final ToolItem removeProjectButton = new ToolItem(filterToolBar, 0);
        removeProjectButton.setToolTipText("Remove the selected user projects");
        removeProjectButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("remove_project"));
        removeProjectButton.setEnabled(false);
        AccessUtil.setKey((Widget)removeProjectButton, (Object)"removeProject");
        final ArrayList projects = new ArrayList();
        final ArrayList userProjects = new ArrayList();
        final SelectionAdapter removeProjectSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Workspace workspace = ProjectPage.this.getWorkspace();
                ArrayList<Stream> streamsToRemove = new ArrayList<Stream>();
                UniqueEList parents = new UniqueEList();
                block0: for (Project project : userProjects) {
                    Project parentProject = project.getParentProject();
                    parentProject.getProjects().remove((Object)project);
                    parents.add(parentProject);
                    if (workspace == null) continue;
                    EList streams = project.getStreams();
                    for (Stream stream : workspace.getStreams()) {
                        if (!streams.contains((Object)stream)) continue;
                        streamsToRemove.add(stream);
                        continue block0;
                    }
                }
                for (Project parent : parents) {
                    BaseUtil.saveEObject((EObject)parent);
                }
                if (!streamsToRemove.isEmpty()) {
                    ProjectPage.this.streamViewer.setSelection((ISelection)new StructuredSelection(streamsToRemove));
                    ProjectPage.this.removeSelectedStreams();
                }
                ProjectPage.this.projectViewer.setSelection((ISelection)new StructuredSelection((List)parents));
            }
        };
        removeProjectButton.addSelectionListener((SelectionListener)removeProjectSelectionAdapter);
        ToolItem collapseAllButton = new ToolItem(filterToolBar, 0);
        collapseAllButton.setToolTipText("Collapse All");
        collapseAllButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("collapse-all"));
        AccessUtil.setKey((Widget)collapseAllButton, (Object)"collapse");
        final boolean supportsIndexSwitching = this.getPreviousPage() instanceof SetupWizardPage;
        this.configurationListener = new ConfigurationListener(this.getWizard(), catalogManager, filterToolBar){

            @Override
            protected void filter(Collection<? extends Resource> resources) {
                super.filter(resources);
                if (!supportsIndexSwitching) {
                    Iterator<? extends Resource> it = resources.iterator();
                    while (it.hasNext()) {
                        Resource resource = it.next();
                        if (!ConfigurationListener.isIndexURI(resource.getURI())) continue;
                        it.remove();
                    }
                }
            }
        };
        ToolItem catalogsButton = new ToolItem(filterToolBar, 4);
        catalogsButton.setToolTipText("Select Catalogs");
        catalogsButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("catalogs"));
        this.catalogSelector.configure(this.getWizard(), catalogsButton, supportsIndexSwitching);
        AccessUtil.setKey((Widget)catalogsButton, (Object)"catalogs");
        PatternFilter patternFilter = new PatternFilter(){

            protected boolean isLeafMatch(Viewer viewer, Object element) {
                Project project;
                ProjectContainer projectContainer;
                boolean result = super.isLeafMatch(viewer, element);
                if (!result && element instanceof Project && (projectContainer = (project = (Project)element).getProjectContainer()) instanceof Project) {
                    Project parentProject = (Project)projectContainer;
                    return this.isLeafMatch(viewer, parentProject);
                }
                return result;
            }
        };
        this.filteredTree = new FilteredTreeWithoutWorkbench.WithCheckboxes(upperComposite, 2050, patternFilter, null);
        Control filterControl = this.filteredTree.getChildren()[0];
        filterControl.setParent(filterPlaceholder);
        AccessUtil.setKey((Widget)this.filteredTree.getFilterControl(), (Object)"filter");
        this.projectViewer = this.filteredTree.getViewer();
        this.projectViewer.setUseHashlookup(true);
        this.projectViewer.setCheckStateProvider(new ICheckStateProvider(){
            private Set<ProjectContainer> projectContainers;

            private boolean containsAll(List<Project> projects) {
                if (projects.isEmpty()) {
                    return true;
                }
                for (Project project : projects) {
                    if (!this.projectContainers.contains(project)) {
                        if (project.getProjects().isEmpty() && project.getStreams().isEmpty()) continue;
                        return false;
                    }
                    if (this.containsAll((List<Project>)project.getProjects())) continue;
                    return false;
                }
                return true;
            }

            public boolean isGrayed(Object element) {
                Workspace workspace = ProjectPage.this.getWorkspace();
                if (workspace == null) {
                    return false;
                }
                this.projectContainers = new HashSet<ProjectContainer>();
                for (Stream stream : workspace.getStreams()) {
                    Project projectContainer = stream.getProject();
                    while (projectContainer != null) {
                        this.projectContainers.add((ProjectContainer)projectContainer);
                        projectContainer = projectContainer.getProjectContainer();
                    }
                }
                ProjectContainer projectContainer = (ProjectContainer)element;
                return !this.containsAll((List<Project>)projectContainer.getProjects());
            }

            public boolean isChecked(Object element) {
                Workspace workspace = ProjectPage.this.getWorkspace();
                if (workspace != null) {
                    for (Stream stream : workspace.getStreams()) {
                        Project projectContainer = stream.getProject();
                        while (projectContainer != null) {
                            if (projectContainer == element) {
                                return true;
                            }
                            projectContainer = projectContainer.getProjectContainer();
                        }
                    }
                }
                return false;
            }
        });
        ColumnViewerInformationControlToolTipSupport toolTipSupport = new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.projectViewer, new LocationListener(){

            public void changing(LocationEvent event) {
                if (!"about:blank".equals(event.location)) {
                    OS.INSTANCE.openSystemBrowser(event.location);
                    event.doit = false;
                }
            }

            public void changed(LocationEvent event) {
            }
        });
        this.labelProvider = new ToolTipLabelProvider(this.adapterFactory, toolTipSupport){
            private final Font baseFont;
            {
                this.baseFont = ProjectPage.this.projectViewer.getControl().getFont();
            }

            public Font getFont(Object object) {
                Project project;
                if (object instanceof Project && ProjectPage.this.isSelected(project = (Project)object)) {
                    return ExtendedFontRegistry.INSTANCE.getFont(this.baseFont, (Object)IItemFontProvider.BOLD_FONT);
                }
                return super.getFont(object);
            }

            public String getToolTipText(Object element) {
                if (element instanceof Scope) {
                    String description;
                    Scope scope = (Scope)element;
                    String localBrandingImageURI = SetupWizard.getLocalBrandingImageURI(scope);
                    URI brandingSiteURI = SetupWizard.getBrandingSiteURI(scope);
                    String label = SetupCoreUtil.getLabel((Scope)scope);
                    StringBuilder result = new StringBuilder();
                    result.append("<span style='white-space: nowrap; font-size: 150%;'><b>");
                    if (brandingSiteURI != null) {
                        result.append("<a style='text-decoration: none; color: inherit;' href='");
                        result.append(brandingSiteURI);
                        result.append("'>");
                    }
                    result.append("<img style='padding-top: 4px;' src='");
                    result.append(localBrandingImageURI);
                    result.append("' width='42' height='42' align='absmiddle'/>&nbsp;");
                    result.append(DiagnosticDecorator.escapeContent((String)label).replace(" ", "&nbsp;"));
                    result.append("</b></span>");
                    if (brandingSiteURI != null) {
                        result.append("</a>");
                    }
                    if (!StringUtil.isEmpty((String)(description = scope.getDescription()))) {
                        result.append("<br/>");
                        result.append("<span style='font-size: 50%;'><br/></span>");
                        result.append(description);
                        result.append("<br/>");
                    }
                    result.append("<div style='height=0px; display:none;'>&nbps;&nbps;&nbps;&nbps;&nbps;<br/><br/></br></div>");
                    return result.toString();
                }
                return "";
            }
        };
        this.projectViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.projectViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            private boolean applySelectionMemento() {
                List<URI> uris = ProjectPage.this.selectionMemento.getStreams();
                if (uris != null) {
                    ArrayList<Project> projects = new ArrayList<Project>();
                    ResourceSet resourceSet = ProjectPage.this.getResourceSet();
                    for (URI uri : uris) {
                        EObject object = resourceSet.getEObject(uri, true);
                        if (!(object instanceof Stream)) continue;
                        Stream stream = (Stream)object;
                        projects.add(stream.getProject());
                    }
                    if (!projects.isEmpty()) {
                        ProjectPage.this.projectViewer.setSelection((ISelection)new StructuredSelection(projects), true);
                        ProjectPage.this.addProjects(projects);
                        addProjectButton.setEnabled(false);
                        ProjectPage.this.gotoNextPage();
                        return true;
                    }
                }
                return false;
            }

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                final Workspace workspace = ProjectPage.this.getWorkspace();
                if (ProjectPage.this.streamViewer.getInput() != workspace) {
                    UIUtil.asyncExec((Control)ProjectPage.this.streamViewer.getControl(), (Runnable)new Runnable(){

                        public void run() {
                            ProjectPage.this.streamViewer.setInput((Object)workspace);
                        }
                    });
                }
                if (notification.getFeature() == SetupPackage.Literals.CATALOG_SELECTION__PROJECT_CATALOGS) {
                    UIUtil.asyncExec((Control)ProjectPage.this.projectViewer.getControl(), (Runnable)new Runnable(){

                        public void run() {
                            Object[] elements;
                            if (!ProjectPage.this.selectionMementoTried.getAndSet(true) && this.applySelectionMemento()) {
                                return;
                            }
                            if (ProjectPage.this.projectViewer.getExpandedElements().length == 0 && (elements = this.getElements(ProjectPage.this.projectViewer.getInput())).length > 0) {
                                ProjectPage.this.projectViewer.setExpandedState(elements[0], true);
                            }
                        }
                    });
                }
            }
        });
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance(), URLTransfer.getInstance()};
        this.projectViewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new URIDropAdapter((EditingDomain)editingDomain, (Viewer)this.projectViewer));
        Tree projectTree = this.projectViewer.getTree();
        projectTree.setLayoutData((Object)new GridData(1808));
        this.addHelpCallout((Control)projectTree, 1);
        ToolBar bucketToolBar = new ToolBar(upperComposite, 0x1800000);
        bucketToolBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        bucketToolBar.setSize(46, 22);
        final ToolItem addButton = new ToolItem(bucketToolBar, 8);
        addButton.setToolTipText("Add Projects (or double-click in upper tree)");
        addButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("add"));
        addButton.setEnabled(false);
        AccessUtil.setKey((Widget)addButton, (Object)"choose");
        this.addButtonAnimator = new AddButtonAnimator(addButton);
        final ToolItem removeButton = new ToolItem(bucketToolBar, 8);
        removeButton.setToolTipText("Remove Projects (or double-click in lower table)");
        removeButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("remove"));
        removeButton.setEnabled(false);
        AccessUtil.setKey((Widget)removeButton, (Object)"unchoose");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPage.this.addSelectedProjects();
                addButton.setEnabled(false);
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPage.this.removeSelectedStreams();
            }
        });
        Composite lowerComposite = new Composite((Composite)sashForm, 0);
        lowerComposite.setLayout((Layout)UIUtil.createGridLayout((int)1));
        TableColumnLayout streamTableLayout = new TableColumnLayout();
        Composite streamComposite = new Composite(lowerComposite, 0);
        streamComposite.setLayout((Layout)streamTableLayout);
        streamComposite.setLayoutData((Object)new GridData(1808));
        this.streamViewer = new TableViewer(streamComposite, 67586);
        this.streamViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        Table streamTable = this.streamViewer.getTable();
        streamTable.setLinesVisible(true);
        streamTable.setHeaderVisible(true);
        streamTable.setLayoutData((Object)new GridData(1808));
        this.addHelpCallout((Control)streamTable, 2);
        TableViewerColumn catalogViewerColumn = new TableViewerColumn(this.streamViewer, 0);
        catalogViewerColumn.setLabelProvider((CellLabelProvider)new CatalogColumnLabelProvider(this.labelProvider.getImage(SetupFactory.eINSTANCE.createProjectCatalog()), this.existingStreams));
        TableColumn catalogColumn = catalogViewerColumn.getColumn();
        catalogColumn.setText("Catalog");
        streamTableLayout.setColumnData((Widget)catalogColumn, (ColumnLayoutData)new ColumnWeightData(30, true));
        TableViewerColumn projectViewerColumn = new TableViewerColumn(this.streamViewer, 0);
        projectViewerColumn.setLabelProvider((CellLabelProvider)new ProjectColumnLabelProvider(this.labelProvider.getImage(SetupFactory.eINSTANCE.createProject()), this.existingStreams));
        TableColumn projectColumn = projectViewerColumn.getColumn();
        projectColumn.setText("Project");
        streamTableLayout.setColumnData((Widget)projectColumn, (ColumnLayoutData)new ColumnWeightData(40, true));
        TableViewerColumn streamViewerColumn = new TableViewerColumn(this.streamViewer, 0);
        streamViewerColumn.setLabelProvider((CellLabelProvider)new StreamColumnLabelProvider(this.labelProvider.getImage(SetupFactory.eINSTANCE.createStream()), this.existingStreams));
        this.hookCellEditor(streamViewerColumn);
        TableColumn streamColumn = streamViewerColumn.getColumn();
        streamColumn.setText("Stream");
        streamTableLayout.setColumnData((Widget)streamColumn, (ColumnLayoutData)new ColumnWeightData(30, true));
        collapseAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPage.this.projectViewer.collapseAll();
            }
        });
        this.projectViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                projects.clear();
                userProjects.clear();
                projectCatalogs.clear();
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    if (value instanceof Project) {
                        Project project = (Project)value;
                        projects.add(project);
                        projectCatalogs.add(project.getProjectCatalog());
                        this.addRootUserProject(project);
                    } else if (value instanceof ProjectCatalog) {
                        ProjectCatalog projectCatalog = (ProjectCatalog)value;
                        projectCatalogs.add(projectCatalog);
                    }
                    ++n2;
                }
                removeProjectButton.setEnabled(!userProjects.isEmpty());
                Workspace workspace = ProjectPage.this.getWorkspace();
                ArrayList projectsToAdd = new ArrayList(projects);
                if (workspace != null) {
                    for (Stream stream : workspace.getStreams()) {
                        projectsToAdd.remove(stream.getProject());
                    }
                }
                for (Project project : projectsToAdd) {
                    if (project.getStreams().isEmpty()) continue;
                    addButton.setEnabled(true);
                    return;
                }
                addButton.setEnabled(false);
            }

            protected void addRootUserProject(Project project) {
                Project parentProject = project.getParentProject();
                if (parentProject != null) {
                    if (ConfigurationProcessor.isUserProject(parentProject)) {
                        userProjects.add(project);
                    } else {
                        this.addRootUserProject(project.getParentProject());
                    }
                }
            }
        });
        this.projectViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Project project;
                EList streams;
                IStructuredSelection selection = (IStructuredSelection)ProjectPage.this.projectViewer.getSelection();
                Object element = selection.getFirstElement();
                if (element instanceof Project && !(streams = (project = (Project)element).getStreams()).isEmpty()) {
                    Workspace workspace = ProjectPage.this.getWorkspace();
                    if (workspace != null) {
                        for (Stream stream : workspace.getStreams()) {
                            if (!streams.contains((Object)stream)) continue;
                            ProjectPage.this.removeStreams(Collections.singletonList(stream), false);
                            addButton.setEnabled(true);
                            return;
                        }
                    }
                    ProjectPage.this.addProjects(Collections.singletonList(project));
                    addButton.setEnabled(false);
                    return;
                }
                boolean expanded = ProjectPage.this.projectViewer.getExpandedState(element);
                ProjectPage.this.projectViewer.setExpandedState(element, !expanded);
            }
        });
        this.projectViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectContainer element = (ProjectContainer)event.getElement();
                ProjectPage.this.projectViewer.setSelection((ISelection)new StructuredSelection((Object)element));
                ArrayList<Stream> streams = new ArrayList<Stream>();
                Workspace workspace = ProjectPage.this.getWorkspace();
                if (workspace != null) {
                    for (Stream stream : workspace.getStreams()) {
                        if (ProjectPage.this.existingStreams.contains(EcoreUtil.getURI((EObject)stream))) continue;
                        Project projectContainer = stream.getProject();
                        while (projectContainer != null) {
                            if (projectContainer == element) {
                                streams.add(stream);
                            }
                            projectContainer = projectContainer.getProjectContainer();
                        }
                    }
                }
                if (streams.isEmpty()) {
                    ArrayList<Project> projects = new ArrayList<Project>();
                    if (element instanceof Project) {
                        projects.add((Project)element);
                    } else {
                        projects.addAll((Collection<Project>)element.getProjects());
                    }
                    int i = 0;
                    while (i < projects.size()) {
                        projects.addAll((Collection<Project>)((Project)projects.get(i)).getProjects());
                        ++i;
                    }
                    ProjectPage.this.addProjects(projects);
                    addButton.setEnabled(false);
                } else {
                    ProjectPage.this.removeStreams(streams, false);
                    addButton.setEnabled(!(element instanceof Project) || !((Project)element).getStreams().isEmpty());
                }
                ProjectPage.this.projectViewer.refresh();
            }
        });
        this.projectViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\u007f') {
                    ArrayList<Stream> selectedProjectStreams = new ArrayList<Stream>();
                    Workspace workspace = ProjectPage.this.getWorkspace();
                    if (workspace != null) {
                        for (Stream stream : workspace.getStreams()) {
                            Project project = stream.getProject();
                            if (!projects.contains(project)) continue;
                            selectedProjectStreams.add(stream);
                        }
                    }
                    if (selectedProjectStreams.isEmpty()) {
                        if (removeProjectButton.isEnabled()) {
                            removeProjectSelectionAdapter.widgetSelected(null);
                        }
                    } else {
                        ProjectPage.this.streamViewer.setSelection((ISelection)new StructuredSelection(selectedProjectStreams), true);
                        ProjectPage.this.removeSelectedStreams();
                    }
                } else if (event.keyCode == 0x1000009 && addButton.isEnabled()) {
                    ProjectPage.this.addSelectedProjects();
                    addButton.setEnabled(false);
                }
            }
        });
        this.streamViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enabled = false;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object[] objectArray = selection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof Stream) {
                        Stream stream = (Stream)object;
                        if (!ProjectPage.this.existingStreams.contains(EcoreUtil.getURI((EObject)stream))) {
                            enabled = true;
                            break;
                        }
                    }
                    ++n2;
                }
                removeButton.setEnabled(enabled);
            }
        });
        this.streamViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectPage.this.removeSelectedStreams();
            }
        });
        this.streamViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\u007f' && removeButton.isEnabled()) {
                    ProjectPage.this.removeSelectedStreams();
                } else if (event.keyCode == 0x1000009 && addButton.isEnabled()) {
                    ProjectPage.this.addSelectedProjects();
                    addProjectButton.setEnabled(false);
                }
            }
        });
        this.setPageComplete(false);
        sashForm.setWeights(new int[]{3, 1});
        this.dropListener = new SetupTransferSupport.DropListener(){

            @Override
            public void resourcesDropped(Collection<? extends Resource> resources) {
                SetupWizard setupWizard = ProjectPage.this.getWizard();
                setupWizard.setConfigurationResources(resources);
                ConfigurationProcessor configurationProcessor = new ConfigurationProcessor(ProjectPage.this.getWizard()){

                    @Override
                    protected boolean applyStreams(List<Stream> streams) {
                        ProjectPage.this.filteredTree.clearText();
                        ArrayList<Project> projects = new ArrayList<Project>();
                        for (Stream stream : streams) {
                            Project project = stream.getProject();
                            projects.add(project);
                        }
                        ProjectPage.this.addProjects(projects);
                        ProjectPage.this.projectViewer.setSelection((ISelection)new StructuredSelection(projects), true);
                        Workspace viewerWorkspace = ProjectPage.this.getWorkspace();
                        EList viewerWorkspaceStreams = viewerWorkspace.getStreams();
                        for (Stream stream : streams) {
                            Project project = stream.getProject();
                            for (Stream viewerWorkspaceStream : viewerWorkspaceStreams) {
                                if (viewerWorkspaceStream.getProject() != project || viewerWorkspaceStream == stream) continue;
                                viewerWorkspaceStreams.remove((Object)viewerWorkspaceStream);
                                break;
                            }
                            viewerWorkspaceStreams.add((Object)stream);
                            ProjectPage.this.saveProjectStreamSelection(stream);
                        }
                        ProjectPage.this.streamViewer.refresh();
                        ProjectPage.this.projectViewer.refresh();
                        if (ProjectPage.this.isCurrentPage()) {
                            ProjectPage.this.gotoNextPage();
                        }
                        return true;
                    }

                    @Override
                    protected boolean applyNoStreams() {
                        Workspace workspace = ProjectPage.this.getWorkspace();
                        if (workspace == null) {
                            SetupWizard wizard = ProjectPage.this.getWizard();
                            wizard.setSetupContext(SetupContext.create((Installation)ProjectPage.this.getInstallation(), Collections.emptyList(), (User)ProjectPage.this.getUser()));
                            workspace = ProjectPage.this.getWorkspace();
                            ProjectPage.this.streamViewer.setInput((Object)workspace);
                        }
                        return true;
                    }
                };
                configurationProcessor.processWorkspace();
                IStatus status = configurationProcessor.getStatus();
                if (!status.isOK()) {
                    ErrorDialog.openError((Shell)ProjectPage.this.getShell(), (String)"Workspace Problems", null, (IStatus)status);
                }
            }
        };
        this.getWizard().getTransferSupport().addDropListener(this.dropListener);
        return sashForm;
    }

    protected void checkPageComplete() {
        Workspace workspace = this.getWorkspace();
        this.setPageComplete(this.getPreviousPage() instanceof SetupWizardPage || workspace != null && workspace.getStreams().size() > this.existingStreams.size());
    }

    @Override
    protected void handleInactivity(Display display, boolean inactive) {
        this.inactive = inactive;
        if (this.addButtonAnimator.shouldAnimate()) {
            UIUtil.asyncExec((Control)this.getControl(), (Runnable)((Object)this.addButtonAnimator));
        }
    }

    @Override
    public void enterPage(boolean forward) {
        ProjectPage.hookTransferControl(this.getShell(), this.getControl(), this.getWizard().getTransferSupport(), this.configurationListener);
        if (forward) {
            if (SetupPropertyTester.getHandlingShell() != this.getShell()) {
                this.setErrorMessage("Another setup wizard is already open.  Complete that interaction before importing projects.");
                this.projectViewer.getTree().setEnabled(false);
            } else if (!this.isPageComplete() || this.projectViewer.getInput() == null) {
                Runnable initializer = new Runnable(){

                    public void run() {
                        EObject eObject;
                        URI projectURI;
                        SetupWizard wizard = ProjectPage.this.getWizard();
                        SetupWizard.IndexLoader indexLoader = wizard.getIndexLoader();
                        if (indexLoader != null) {
                            indexLoader.awaitIndexLoad();
                        }
                        Tree tree = ProjectPage.this.projectViewer.getTree();
                        tree.setRedraw(false);
                        CatalogSelection selection = ProjectPage.this.catalogSelector.getSelection();
                        ProjectPage.this.projectViewer.setInput((Object)selection);
                        boolean isPageComplete = ProjectPage.this.isPageComplete();
                        Workspace workspace = ProjectPage.this.getWorkspace();
                        if (workspace != null) {
                            Iterator it = workspace.getStreams().iterator();
                            while (it.hasNext()) {
                                Stream stream = (Stream)it.next();
                                if (stream.eIsProxy()) {
                                    it.remove();
                                    continue;
                                }
                                if (isPageComplete) continue;
                                ProjectPage.this.existingStreams.add(EcoreUtil.getURI((EObject)stream));
                            }
                            ProjectPage.this.streamViewer.setInput((Object)workspace);
                        }
                        ArrayList<Project> projects = new ArrayList<Project>();
                        for (Stream stream : selection.getSelectedStreams()) {
                            projects.add(stream.getProject());
                        }
                        if (projects.isEmpty()) {
                            EList projectCatalogs = selection.getProjectCatalogs();
                            if (!projectCatalogs.isEmpty()) {
                                ProjectPage.this.projectViewer.expandToLevel(projectCatalogs.get(0), 1);
                            }
                        } else {
                            ProjectPage.this.projectViewer.setSelection((ISelection)new StructuredSelection(projects), true);
                        }
                        tree.setRedraw(true);
                        if (wizard instanceof SetupWizard.Importer && (projectURI = ((SetupWizard.Importer)wizard).getProject()) != null && (eObject = ProjectPage.this.getResourceSet().getEObject(projectURI, false)) instanceof Project) {
                            Project project = (Project)eObject;
                            ProjectPage.this.projectViewer.setSelection((ISelection)new StructuredSelection((Object)project), true);
                            TreeItem[] treeSelection = ProjectPage.this.projectViewer.getTree().getSelection();
                            if (treeSelection.length > 0) {
                                ProjectPage.this.projectViewer.expandToLevel((Object)project, -1);
                                ProjectPage.this.projectViewer.setChecked((Object)project, true);
                                Event event = new Event();
                                event.item = treeSelection[0];
                                event.detail = 32;
                                ProjectPage.this.projectViewer.getControl().notifyListeners(13, event);
                            }
                        }
                        ProjectPage.this.checkPageComplete();
                    }
                };
                Index index = this.catalogSelector.getCatalogManager().getIndex();
                if (index == null) {
                    UIUtil.timerExec((int)500, (Runnable)initializer);
                } else {
                    initializer.run();
                }
            }
        }
    }

    public static void hookTransferControl(Shell shell, Control execludedControl, SetupTransferSupport transferSupport, ConfigurationListener configurationListener) {
        shell.addShellListener((ShellListener)configurationListener);
        Control[] controlArray = shell.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                transferSupport.addControl(control);
                break;
            }
            ++n2;
        }
        transferSupport.excludeControl(execludedControl);
        configurationListener.checkConfigurationAvailability();
    }

    @Override
    public void leavePage(boolean forward) {
        Workspace workspace;
        ProjectPage.unhookTransferControl(this.getShell(), this.getControl(), this.getWizard().getTransferSupport(), this.configurationListener);
        if (forward && (workspace = this.getWorkspace()) != null) {
            ArrayList<URI> uris = new ArrayList<URI>();
            for (Stream stream : workspace.getStreams()) {
                URI uri = EcoreUtil.getURI((EObject)stream);
                uris.add(uri);
            }
            this.selectionMemento.setStreams(uris);
            this.selectionMementoTried.set(true);
        }
    }

    public static void unhookTransferControl(Shell shell, Control execludedControl, SetupTransferSupport transferSupport, ConfigurationListener configurationListener) {
        shell.removeShellListener((ShellListener)configurationListener);
        transferSupport.removeControls();
    }

    @Override
    public void sendStats(boolean success) {
        if (this.getTrigger() == Trigger.BOOTSTRAP) {
            return;
        }
        super.sendStats(success);
        Workspace workspace = this.getWizard().getSetupContext().getWorkspace();
        if (workspace != null) {
            OS os = this.getPerformer().getOS();
            for (Stream stream : workspace.getStreams()) {
                if (this.existingStreams.contains(EcoreUtil.getURI((EObject)stream))) continue;
                SetupCoreUtil.sendStats((boolean)success, (Scope)stream, (OS)os);
            }
        }
    }

    private void saveProjectStreamSelection(Stream stream) {
        CatalogManager catalogManager = this.catalogSelector.getCatalogManager();
        EMap defaultStreams = catalogManager.getSelection().getDefaultStreams();
        Project project = stream.getProject();
        defaultStreams.put((Object)project, (Object)stream);
        catalogManager.saveSelection();
    }

    private void hookCellEditor(TableViewerColumn viewerColumn) {
        Table table = this.streamViewer.getTable();
        final ComboBoxViewerCellEditor cellEditor = new ComboBoxViewerCellEditor((Composite)table);
        cellEditor.setActivationStyle(3);
        cellEditor.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        cellEditor.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Project project = (Project)inputElement;
                return project.getStreams().toArray();
            }
        });
        viewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)this.streamViewer){

            protected void setValue(Object element, Object value) {
                EList streams;
                int index;
                Workspace workspace;
                if (element != value && (workspace = ProjectPage.this.getWorkspace()) != null && (index = (streams = workspace.getStreams()).indexOf(element)) != -1) {
                    Stream stream = (Stream)value;
                    streams.set(index, (Object)stream);
                    ProjectPage.this.saveProjectStreamSelection(stream);
                    ProjectPage.this.streamViewer.refresh();
                }
            }

            protected Object getValue(Object element) {
                return element;
            }

            protected CellEditor getCellEditor(Object element) {
                Stream stream = (Stream)element;
                if (ProjectPage.this.existingStreams.contains(EcoreUtil.getURI((EObject)stream))) {
                    return null;
                }
                cellEditor.setInput((Object)stream.getProject());
                return cellEditor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }
        });
        this.streamViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ComboViewer comboViewer = cellEditor.getViewer();
                comboViewer.refresh();
            }
        });
    }

    private boolean isSelected(Project project) {
        Workspace workspace = this.getWorkspace();
        if (workspace != null) {
            for (Stream stream : workspace.getStreams()) {
                if (project != stream.getProject()) continue;
                return true;
            }
        }
        return false;
    }

    private void addSelectedProjects() {
        ArrayList<Project> projects = new ArrayList<Project>();
        IStructuredSelection selection = (IStructuredSelection)this.projectViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof Project) {
                Project project = (Project)element;
                projects.add(project);
            }
            ++n2;
        }
        this.addProjects(projects);
    }

    private void addProjects(List<Project> projects) {
        this.projectsChanged = true;
        ArrayList<Project> addedProjects = new ArrayList<Project>();
        ArrayList<Stream> addedStreams = new ArrayList<Stream>();
        CatalogManager catalogManager = this.catalogSelector.getCatalogManager();
        CatalogSelection catalogSelection = catalogManager.getSelection();
        EMap defaultStreams = catalogSelection.getDefaultStreams();
        for (Project project : projects) {
            EList projectStreams = project.getStreams();
            if (projectStreams.isEmpty() || this.isSelected(project)) continue;
            Stream stream = (Stream)defaultStreams.get((Object)project);
            if (stream == null) {
                stream = (Stream)projectStreams.get(0);
            }
            addedStreams.add(stream);
            addedProjects.add(project);
        }
        if (!addedProjects.isEmpty()) {
            Workspace workspace = this.getWorkspace();
            if (workspace == null) {
                SetupWizard wizard = this.getWizard();
                wizard.setSetupContext(SetupContext.create((Installation)this.getInstallation(), addedStreams, (User)this.getUser()));
                workspace = this.getWorkspace();
                this.streamViewer.setInput((Object)workspace);
            } else {
                EList workspaceStreams = workspace.getStreams();
                workspaceStreams.addAll(addedStreams);
                this.streamViewer.refresh();
            }
            catalogSelection.getSelectedStreams().clear();
            catalogSelection.getSelectedStreams().addAll((Collection)workspace.getStreams());
            catalogManager.saveSelection();
            this.streamViewer.setSelection((ISelection)new StructuredSelection(addedStreams), true);
            this.projectViewer.refresh();
            this.checkPageComplete();
        }
    }

    private void removeSelectedStreams() {
        ArrayList<Stream> streams = new ArrayList<Stream>();
        IStructuredSelection selection = (IStructuredSelection)this.streamViewer.getSelection();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            streams.add((Stream)element);
            ++n2;
        }
        this.removeStreams(streams, true);
    }

    private void removeStreams(List<Stream> streams, boolean select) {
        this.projectsChanged = true;
        Workspace workspace = this.getWorkspace();
        if (workspace != null) {
            EList workspaceStreams = workspace.getStreams();
            ArrayList<Project> removedProjects = new ArrayList<Project>();
            int selectionIndex = -1;
            for (Stream stream : streams) {
                if (this.existingStreams.contains(EcoreUtil.getURI((EObject)stream))) continue;
                selectionIndex = Math.max(selectionIndex, workspaceStreams.indexOf((Object)stream) - 1);
                workspaceStreams.remove((Object)stream);
                Project project = stream.getProject();
                removedProjects.add(project);
            }
            if (!removedProjects.isEmpty()) {
                if (select) {
                    this.projectViewer.setSelection((ISelection)new StructuredSelection(removedProjects));
                }
                CatalogManager catalogManager = this.catalogSelector.getCatalogManager();
                CatalogSelection catalogSelection = catalogManager.getSelection();
                catalogSelection.getSelectedStreams().clear();
                catalogSelection.getSelectedStreams().addAll((Collection)workspace.getStreams());
                catalogManager.saveSelection();
                this.streamViewer.refresh();
                this.projectViewer.refresh();
                this.checkPageComplete();
            }
            if (this.streamViewer.getSelection().isEmpty() && !workspaceStreams.isEmpty()) {
                this.streamViewer.setSelection((ISelection)new StructuredSelection(workspaceStreams.get(selectionIndex <= 0 ? 0 : selectionIndex)), true);
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.adapterFactory.dispose();
    }

    private static void createProjectLabel(Project project, StringBuilder builder) {
        Project parentProject = project.getParentProject();
        if (parentProject != null) {
            ProjectPage.createProjectLabel(parentProject, builder);
        }
        if (builder.length() != 0) {
            builder.append(" - ");
        }
        String label = SetupCoreUtil.getLabel((Scope)project);
        builder.append(label);
    }

    private final class AddButtonAnimator
    extends ButtonAnimator {
        public AddButtonAnimator(ToolItem addButton) {
            super((OomphUIPlugin)SetupUIPlugin.INSTANCE, addButton, "add", 7);
        }

        public Shell getShell() {
            IWizardContainer container = ProjectPage.this.getContainer();
            return container == null ? null : container.getShell();
        }

        protected boolean doAnimate() {
            return ProjectPage.this.inactive && !ProjectPage.this.projectsChanged;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AddUserProjectDialog
    extends ResourceDialog {
        private final Set<ProjectCatalog> projectCatalogs;
        private final CatalogSelector catalogSelector;
        private final AdapterFactoryEditingDomain editingDomain;
        private ComboViewer catalogViewer;

        public AddUserProjectDialog(Shell parent, Set<ProjectCatalog> projectCatalogs, CatalogSelector catalogSelector, AdapterFactoryEditingDomain editingDomain) {
            super(parent, "Add User Projects", 4098);
            this.projectCatalogs = projectCatalogs;
            this.catalogSelector = catalogSelector;
            this.editingDomain = editingDomain;
        }

        protected Control createDialogArea(Composite parent) {
            Composite main = new Composite(parent, 0);
            main.setLayout((Layout)UIUtil.createGridLayout((int)1));
            main.setLayoutData((Object)new GridData(1808));
            Composite upperComposite = new Composite(main, 0);
            GridLayout upperLayout = new GridLayout(2, false);
            upperLayout.marginTop = 10;
            upperLayout.marginWidth = 10;
            upperComposite.setLayout((Layout)upperLayout);
            upperComposite.setLayoutData((Object)new GridData(1808));
            AddUserProjectDialog.applyDialogFont((Control)upperComposite);
            Label label = new Label(upperComposite, 0);
            label.setText("Catalog:");
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.catalogViewer = new ComboViewer(upperComposite, 8);
            this.catalogViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.catalogViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            this.catalogViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return SetupCoreUtil.getLabel((Scope)((Scope)element));
                }
            });
            ArrayList<Scope> catalogs = new ArrayList<Scope>();
            block0: for (Scope scope : this.catalogSelector.getCatalogs()) {
                for (EObject eObject : scope.eContents()) {
                    InternalEObject internalEObject = (InternalEObject)eObject;
                    Resource.Internal resource = internalEObject.eDirectResource();
                    if (resource == null || !SetupContext.isUserScheme((String)resource.getURI().scheme())) continue;
                    catalogs.add(scope);
                    continue block0;
                }
            }
            this.catalogViewer.setInput(catalogs);
            if (catalogs.size() == 1) {
                this.catalogViewer.setSelection((ISelection)new StructuredSelection(catalogs.get(0)));
            } else if (this.projectCatalogs.size() == 1 && catalogs.containsAll(this.projectCatalogs)) {
                this.catalogViewer.setSelection((ISelection)new StructuredSelection((Object)this.projectCatalogs.iterator().next()));
            }
            this.catalogViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AddUserProjectDialog.this.validate();
                }
            });
            Composite composite = new Composite(main, 0);
            GridLayout lowerLayout = new GridLayout();
            lowerLayout.marginHeight = 0;
            lowerLayout.marginWidth = 0;
            lowerLayout.verticalSpacing = 0;
            composite.setLayout((Layout)lowerLayout);
            composite.setLayoutData((Object)new GridData(1808));
            AddUserProjectDialog.applyDialogFont((Control)composite);
            UIUtil.asyncExec((Control)main, (Runnable)new Runnable(){

                public void run() {
                    AddUserProjectDialog.this.validate();
                }
            });
            return super.createDialogArea(composite);
        }

        protected void prepareBrowseFileSystemButton(Button browseFileSystemButton) {
            browseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FileDialog fileDialog = new FileDialog(AddUserProjectDialog.this.getShell(), AddUserProjectDialog.this.style);
                    fileDialog.setFilterExtensions(new String[]{"*.setup"});
                    fileDialog.open();
                    String filterPath = fileDialog.getFilterPath();
                    String[] fileNames = fileDialog.getFileNames();
                    StringBuffer uris = new StringBuffer();
                    int i = 0;
                    int len = fileNames.length;
                    while (i < len) {
                        uris.append(URI.createFileURI((String)(String.valueOf(filterPath) + File.separator + fileNames[i])).toString());
                        uris.append("  ");
                        ++i;
                    }
                    AddUserProjectDialog.this.uriField.setText((String.valueOf(AddUserProjectDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                }
            });
        }

        protected void prepareBrowseWorkspaceButton(Button browseWorkspaceButton) {
            browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    StringBuffer uris = new StringBuffer();
                    IFile[] files = WorkspaceResourceDialog.openFileSelection((Shell)AddUserProjectDialog.this.getShell(), null, null, (boolean)true, (Object[])this.getContextSelection(), Collections.singletonList(new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            if (element instanceof IFile) {
                                IFile file = (IFile)element;
                                return "setup".equals(file.getFileExtension());
                            }
                            return true;
                        }
                    }));
                    int i = 0;
                    int len = files.length;
                    while (i < len) {
                        uris.append(URI.createURI((String)files[i].getLocationURI().toString(), (boolean)true));
                        uris.append("  ");
                        ++i;
                    }
                    AddUserProjectDialog.this.uriField.setText((String.valueOf(AddUserProjectDialog.this.uriField.getText()) + "  " + uris.toString()).trim());
                }

                private String getContextPath() {
                    return AddUserProjectDialog.this.context != null && AddUserProjectDialog.this.context.isPlatformResource() ? URI.createURI((String)".").resolve(AddUserProjectDialog.this.context).path().substring(9) : null;
                }

                private Object[] getContextSelection() {
                    IWorkspaceRoot root;
                    IResource resource;
                    String path = this.getContextPath();
                    if (path != null && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(path)) != null && resource.isAccessible()) {
                        return new Object[]{resource};
                    }
                    return null;
                }
            });
        }

        protected void validate() {
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(this.getSelectedCatalog() != null);
            }
        }

        protected boolean processResources() {
            int invalidProjectsSize;
            ArrayList<Project> validProjects = new ArrayList<Project>();
            ArrayList<Project> invalidProjects = new ArrayList<Project>();
            ArrayList<URI> invalidURIs = new ArrayList<URI>();
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            for (URI uri : this.getURIs()) {
                BaseResource resource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)uri);
                Project project = (Project)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.PROJECT);
                if (project == null) {
                    invalidURIs.add(uri);
                    continue;
                }
                if (project.eContainer() != null) {
                    invalidProjects.add(project);
                    continue;
                }
                validProjects.add(project);
            }
            if (!validProjects.isEmpty()) {
                ProjectCatalog selectedCatalog = this.getSelectedCatalog();
                if (!this.catalogSelector.getSelectedCatalogs().contains(selectedCatalog)) {
                    this.catalogSelector.select((Scope)selectedCatalog, true);
                }
                Command command = DragAndDropCommand.create((EditingDomain)this.editingDomain, (Object)selectedCatalog, (float)0.5f, (int)4, (int)4, validProjects);
                this.editingDomain.getCommandStack().execute(command);
                return true;
            }
            StringBuilder message = new StringBuilder();
            int invalidURIsSize = invalidURIs.size();
            if (invalidURIsSize != 0) {
                if (invalidURIsSize == 1) {
                    message.append("The URI ");
                } else {
                    message.append("The URIs ");
                }
                int i = 0;
                while (i < invalidURIsSize) {
                    if (i != 0) {
                        message.append(", ");
                        if (i + 1 == invalidURIsSize) {
                            message.append(" and ");
                        }
                    }
                    message.append('\'');
                    message.append(invalidURIs.get(i));
                    message.append('\'');
                    ++i;
                }
                if (invalidURIsSize == 1) {
                    message.append(" does not contain a valid project.");
                } else {
                    message.append(" do not contain valid projects.");
                }
            }
            if ((invalidProjectsSize = invalidProjects.size()) != 0) {
                if (message.length() != 0) {
                    message.append("\n\n");
                }
                if (invalidProjectsSize == 1) {
                    message.append("The project ");
                } else {
                    message.append("The projects ");
                }
                int i = 0;
                while (i < invalidProjectsSize) {
                    if (i != 0) {
                        message.append(", ");
                        if (i + 1 == invalidProjectsSize) {
                            message.append(" and ");
                        }
                    }
                    message.append('\'');
                    message.append(((Project)invalidProjects.get(i)).getLabel());
                    message.append('\'');
                    ++i;
                }
                if (invalidProjectsSize == 1) {
                    message.append(" is already contained in the index.");
                } else {
                    message.append(" are already contained in the index.");
                }
            }
            if (message.length() == 0) {
                message.append("No URIs were specified. Hit Cancel to terminate the dialog.");
            }
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error Adding Projects", null, (IStatus)new Status(4, SetupUIPlugin.INSTANCE.getSymbolicName(), message.toString()));
            return false;
        }

        private ProjectCatalog getSelectedCatalog() {
            IStructuredSelection selection = (IStructuredSelection)this.catalogViewer.getSelection();
            ProjectCatalog selectedCatalog = (ProjectCatalog)selection.getFirstElement();
            return selectedCatalog;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CatalogColumnLabelProvider
    extends DisablingColumnLabelProvider {
        public CatalogColumnLabelProvider(Image image, Set<URI> existingStreams) {
            super(image, existingStreams);
        }

        public String getText(Object element) {
            Stream stream = (Stream)element;
            ProjectCatalog catalog = stream.getProject().getProjectCatalog();
            return SetupCoreUtil.getLabel((Scope)catalog);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigurationListener
    extends ShellAdapter {
        private final SetupWizard setupWizard;
        private final CatalogManager catalogManager;
        private final ToolBar toolBar;
        private ToolItem applyConfigurationButton;

        public ConfigurationListener(SetupWizard setupWizard, CatalogManager catalogManager, ToolBar toolBar) {
            this.setupWizard = setupWizard;
            this.catalogManager = catalogManager;
            this.toolBar = toolBar;
        }

        public void shellActivated(ShellEvent e) {
            this.checkConfigurationAvailability();
        }

        public void checkConfigurationAvailability() {
            Collection<? extends Resource> resources = this.setupWizard.getTransferSupport().getResources();
            this.filter(resources);
            URI indexLocation = ConfigurationListener.getIndexURI(resources);
            if (!(resources.isEmpty() || indexLocation != null && this.catalogManager.isCurrentIndex(indexLocation))) {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ConfigurationSelectionAdapter
                extends SelectionAdapter {
                    final Collection<Resource> resources = new ArrayList<Resource>();

                    ConfigurationSelectionAdapter() {
                    }

                    public void widgetSelected(SelectionEvent e) {
                        ConfigurationListener.this.setupWizard.getTransferSupport().resourcesDropped(this.resources);
                        ConfigurationListener.this.disposeApplyConfigurationButton();
                    }

                    public void updateResources(Collection<? extends Resource> resources) {
                        this.resources.clear();
                        this.resources.addAll(resources);
                    }
                }
                if (this.applyConfigurationButton == null) {
                    this.applyConfigurationButton = new ToolItem(this.toolBar, 0, 0);
                    this.applyConfigurationButton.setImage(SetupUIPlugin.INSTANCE.getSWTImage("full/obj16/Configuration"));
                    ConfigurationSelectionAdapter selectionListener = new ConfigurationSelectionAdapter();
                    selectionListener.updateResources(resources);
                    this.applyConfigurationButton.addSelectionListener((SelectionListener)selectionListener);
                    this.applyConfigurationButton.setData("ConfigurationSelectionAdapter", (Object)selectionListener);
                    AccessUtil.setKey((Widget)this.applyConfigurationButton, (Object)"applyConfiguration");
                    this.toolBar.getParent().layout(true);
                    this.toolBar.layout(true);
                } else {
                    ConfigurationSelectionAdapter selectionListener = (ConfigurationSelectionAdapter)((Object)this.applyConfigurationButton.getData("ConfigurationSelectionAdapter"));
                    selectionListener.updateResources(resources);
                }
                if (indexLocation != null) {
                    this.applyConfigurationButton.setToolTipText("Switch to the catalog index from the clipboard: " + IndexManager.getUnderlyingLocation((URI)indexLocation));
                } else {
                    this.applyConfigurationButton.setToolTipText("Apply the configuration from the clipboard");
                }
            } else {
                this.disposeApplyConfigurationButton();
            }
        }

        protected void filter(Collection<? extends Resource> resources) {
            for (Resource resource : this.setupWizard.getAppliedConfigurationResources()) {
                URI uri = resource.getURI();
                Iterator<? extends Resource> iterator = resources.iterator();
                while (iterator.hasNext()) {
                    if (!uri.equals(iterator.next().getURI())) continue;
                    iterator.remove();
                }
            }
        }

        private void disposeApplyConfigurationButton() {
            if (this.applyConfigurationButton != null) {
                this.applyConfigurationButton.dispose();
                this.applyConfigurationButton = null;
                this.toolBar.getParent().layout(true);
                this.toolBar.layout(true);
            }
        }

        public static boolean isIndexURI(URI uri) {
            return uri != null && (uri.isArchive() || "org.eclipse.setup".equals(uri.lastSegment()) || "zip".equals(uri.fileExtension()));
        }

        public static URI getIndexURI(Collection<? extends Resource> resources) {
            for (Resource resource : resources) {
                URI uri = resource.getURI();
                if (!ConfigurationListener.isIndexURI(uri)) continue;
                return uri;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DisablingColumnLabelProvider
    extends ColumnLabelProvider {
        private static final Color DARK_GRAY = Display.getCurrent().getSystemColor(16);
        private final Image image;
        private final Image disabledImage;
        private final Set<URI> existingStreams;

        public DisablingColumnLabelProvider(Image image, Set<URI> existingStreams) {
            this.image = image;
            this.existingStreams = existingStreams;
            this.disabledImage = ExtendedImageRegistry.INSTANCE.getImage((Object)ImageDescriptor.createWithFlags((ImageDescriptor)ImageDescriptor.createFromImage((Image)image), (int)1));
        }

        public Color getForeground(Object element) {
            if (this.isDisabled(element)) {
                return DARK_GRAY;
            }
            return super.getForeground(element);
        }

        public Image getImage(Object element) {
            return this.isDisabled(element) ? this.disabledImage : this.image;
        }

        private boolean isDisabled(Object element) {
            return this.existingStreams.contains(EcoreUtil.getURI((EObject)((EObject)element)));
        }
    }

    private static final class ItemProviderAdapterFactory
    extends SetupItemProviderAdapterFactory
    implements SetupPackage.Literals {
        private CatalogSelection selection;

        public ItemProviderAdapterFactory(CatalogSelection selection) {
            this.selection = selection;
        }

        public Adapter createCatalogSelectionAdapter() {
            if (this.catalogSelectionItemProvider == null) {
                this.catalogSelectionItemProvider = new CatalogSelectionItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(CATALOG_SELECTION__PROJECT_CATALOGS);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.catalogSelectionItemProvider;
        }

        public Adapter createIndexAdapter() {
            if (this.indexItemProvider == null) {
                this.indexItemProvider = new IndexItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(INDEX__PROJECT_CATALOGS);
                        }
                        return this.childrenFeatures;
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.indexItemProvider;
        }

        public Adapter createProjectCatalogAdapter() {
            return new ProjectCatalogItemProvider((AdapterFactory)this){
                private AdapterFactoryItemDelegator itemDelegator;
                {
                    this.itemDelegator = new AdapterFactoryItemDelegator(this.getRootAdapterFactory());
                }

                public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                    if (this.childrenFeatures == null) {
                        this.childrenFeatures = new ArrayList();
                        this.childrenFeatures.add(PROJECT_CONTAINER__PROJECTS);
                    }
                    return this.childrenFeatures;
                }

                public Collection<?> getChildren(Object object) {
                    ArrayList result = new ArrayList(super.getChildren(object));
                    Iterator it = result.iterator();
                    while (it.hasNext()) {
                        Project project = (Project)it.next();
                        if (project.getStreams().isEmpty() && project.getProjects().isEmpty()) {
                            it.remove();
                            continue;
                        }
                        IUpdateableItemParent updateableItemParent = (IUpdateableItemParent)this.getRootAdapterFactory().adapt((Notifier)project, IEditingDomainItemProvider.class);
                        updateableItemParent.setParent((Object)project, object);
                    }
                    return result;
                }

                protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
                    ProjectCatalog projectCatalog = (ProjectCatalog)owner;
                    for (Project project : projectCatalog.getProjects()) {
                        Command command = this.itemDelegator.createCommand((Object)project, domain, DragAndDropCommand.class, new CommandParameter((Object)project, (Object)new DragAndDropCommand.Detail(location, operations, operation), collection));
                        if (!command.canExecute()) continue;
                        return command;
                    }
                    return UnexecutableCommand.INSTANCE;
                }

                protected Command createDragAndDropCommand(EditingDomain domain, ResourceSet resourceSet, float location, int operations, int operation, Collection<URI> collection) {
                    return this.createPrimaryDragAndDropCommand(domain, this.getTarget(), location, operations, operation, collection);
                }

                public Object getParent(Object object) {
                    return ItemProviderAdapterFactory.this.selection;
                }

                protected Object overlayImage(Object object, Object image) {
                    return image;
                }
            };
        }

        public Adapter createProjectAdapter() {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class SpecializedProjectItemProvider
            extends ProjectItemProvider
            implements IUpdateableItemParent {
                private Object parent;

                SpecializedProjectItemProvider(AdapterFactory adapterFactory) {
                    super(adapterFactory);
                }

                public Object getImage(Object object) {
                    Project project;
                    if (object instanceof Project && (project = (Project)object).getStreams().isEmpty()) {
                        return SetupUIPlugin.INSTANCE.getSWTImage("folder");
                    }
                    return super.getImage(object);
                }

                public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                    if (this.childrenFeatures == null) {
                        this.childrenFeatures = new ArrayList();
                        this.childrenFeatures.add(PROJECT_CONTAINER__PROJECTS);
                    }
                    return this.childrenFeatures;
                }

                protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
                    final Project targetProject = (Project)this.getTarget();
                    Resource.Internal directResource = ((InternalEObject)targetProject).eDirectResource();
                    if (directResource != null && SetupContext.isUserScheme((String)directResource.getURI().scheme())) {
                        final ResourceSet resourceSet = domain.getResourceSet();
                        return new DragAndDropCommand(domain, resourceSet, location, operations, operation, collection){
                            final Set<Project> projects;
                            final Set<Project> affectedObjects;
                            {
                                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                                this.projects = new LinkedHashSet<Project>();
                                this.affectedObjects = new LinkedHashSet<Project>();
                            }

                            public void execute() {
                                EList targetProjects = targetProject.getProjects();
                                block0: for (Project project : this.projects) {
                                    if (this.operation != 4) {
                                        if (project.eContainer() != null) {
                                            project = (Project)EcoreUtil.copy((EObject)project);
                                        } else {
                                            Resource resource = project.eResource();
                                            resource.getContents().clear();
                                            resourceSet.getResources().remove((Object)resource);
                                        }
                                    }
                                    this.affectedObjects.add(project);
                                    String name = project.getName();
                                    for (Project otherProject : targetProjects) {
                                        if (!name.equals(otherProject.getName())) continue;
                                        targetProjects.set(targetProjects.indexOf((Object)otherProject), (Object)project);
                                        continue block0;
                                    }
                                    targetProjects.add((Object)project);
                                }
                                BaseUtil.saveEObject((EObject)targetProject);
                                ProjectCatalog projectCatalog = targetProject.getProjectCatalog();
                                if (projectCatalog != null) {
                                    this.fireNotifyChanged((Notification)new ViewerNotification((Notification)new ENotificationImpl((InternalEObject)projectCatalog, 1, (EStructuralFeature)SetupPackage.Literals.PRODUCT_CATALOG__PRODUCTS, (Object)targetProject, (Object)targetProject, projectCatalog.getProjects().indexOf((Object)targetProject)), (Object)projectCatalog, true, false));
                                }
                            }

                            protected boolean prepare() {
                                this.projects.clear();
                                for (Object value : this.collection) {
                                    Project project;
                                    if (value instanceof URI) {
                                        URI uri = (URI)value;
                                        BaseResource resource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)uri);
                                        Project project2 = (Project)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)SetupPackage.Literals.PROJECT);
                                        if (project2 == null || project2.getName() == null || this.operation != 1 && project2.eContainer() != null) continue;
                                        this.projects.add(project2);
                                        continue;
                                    }
                                    if (!(value instanceof Project) || (project = (Project)value).getName() == null || this.operation != 1 && project.eContainer() != null) continue;
                                    this.projects.add(project);
                                }
                                if (this.operation == 2) {
                                    this.operation = 4;
                                }
                                return !this.projects.isEmpty();
                            }

                            public Collection<?> getAffectedObjects() {
                                return this.affectedObjects;
                            }

                            public void redo() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                    return UnexecutableCommand.INSTANCE;
                }

                protected Command createDragAndDropCommand(EditingDomain domain, ResourceSet resourceSet, float location, int operations, int operation, Collection<URI> collection) {
                    return this.createPrimaryDragAndDropCommand(domain, this.getTarget(), location, operations, operation, collection);
                }

                protected Object overlayImage(Object object, Object image) {
                    return image;
                }

                public Object getParent(Object object) {
                    return this.parent == null ? super.getParent(object) : this.parent;
                }

                public void setParent(Object object, Object parent) {
                    this.parent = parent;
                }
            }
            return new SpecializedProjectItemProvider((AdapterFactory)this);
        }

        public Adapter createWorkspaceAdapter() {
            if (this.workspaceItemProvider == null) {
                this.workspaceItemProvider = new WorkspaceItemProvider((AdapterFactory)this){

                    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
                        if (this.childrenFeatures == null) {
                            this.childrenFeatures = new ArrayList();
                            this.childrenFeatures.add(WORKSPACE__STREAMS);
                        }
                        return this.childrenFeatures;
                    }

                    public void notifyChanged(Notification notification) {
                        switch (notification.getFeatureID(Workspace.class)) {
                            case 6: {
                                this.updateChildren(notification);
                                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                                return;
                            }
                        }
                        super.notifyChanged(notification);
                    }

                    protected Object overlayImage(Object object, Object image) {
                        return image;
                    }
                };
            }
            return this.workspaceItemProvider;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ProjectColumnLabelProvider
    extends DisablingColumnLabelProvider {
        public ProjectColumnLabelProvider(Image image, Set<URI> existingStreams) {
            super(image, existingStreams);
        }

        public String getText(Object element) {
            Stream stream = (Stream)element;
            StringBuilder builder = new StringBuilder();
            ProjectPage.createProjectLabel(stream.getProject(), builder);
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StreamColumnLabelProvider
    extends DisablingColumnLabelProvider {
        public StreamColumnLabelProvider(Image image, Set<URI> existingStreams) {
            super(image, existingStreams);
        }

        public String getText(Object element) {
            Stream stream = (Stream)element;
            return SetupCoreUtil.getLabel((Scope)stream);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URIDropAdapter
    extends EditingDomainViewerDropAdapter {
        public URIDropAdapter(EditingDomain domain, Viewer viewer) {
            super(domain, viewer);
        }

        protected Collection<?> getDragSource(DropTargetEvent event) {
            URLTransfer urlTransfer = URLTransfer.getInstance();
            if (urlTransfer.isSupportedType(event.currentDataType)) {
                if (IS_MOTIF) {
                    return null;
                }
                Object object = urlTransfer.nativeToJava(event.currentDataType);
                return object == null ? null : this.extractDragSource(object);
            }
            return super.getDragSource(event);
        }

        protected Collection<?> extractDragSource(Object object) {
            if (object instanceof String) {
                return this.convertPlatformResourceURIs(Collections.singleton(URI.createURI((String)((String)object))));
            }
            return this.convertPlatformResourceURIs(super.extractDragSource(object));
        }

        protected Collection<?> convertPlatformResourceURIs(Collection<?> uris) {
            ArrayList result = new ArrayList(uris);
            ListIterator<URI> it = result.listIterator();
            while (it.hasNext()) {
                URI uri;
                Object object = it.next();
                if (!(object instanceof URI) || !(uri = (URI)object).isPlatformResource() || !CommonPlugin.IS_RESOURCES_BUNDLE_AVAILABLE) continue;
                it.set(ResourceHelper.convert(uri));
            }
            return result;
        }

        private static class ResourceHelper {
            private ResourceHelper() {
            }

            public static URI convert(URI uri) {
                IPath location;
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                if (file.isAccessible() && (location = file.getLocation()) != null) {
                    return URI.createFileURI((String)location.toOSString());
                }
                return uri;
            }
        }
    }
}

