/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash.decorators;

import java.lang.reflect.Method;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BranchDecorator
implements ILabelDecorator {
    private static final String DEFAULT_PATH = "refs/heads/";
    private static final Method FORMAT_METHOD = BranchDecorator.getFormatMethod();

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image decorateImage(Image image, Object element) {
        return null;
    }

    public String decorateText(String text, Object element) {
        try {
            String decoration;
            RefNode node;
            if (element instanceof RefNode && (node = (RefNode)element).getType() == RepositoryTreeNodeType.REF && this.isLocal((RepositoryTreeNode<?>)node) && (decoration = this.getDecoration(node)) != null) {
                return String.valueOf(text) + " [" + decoration + "]";
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    private boolean isLocal(RepositoryTreeNode<?> node) {
        if (node.getType() == RepositoryTreeNodeType.LOCAL) {
            return true;
        }
        if ((node = node.getParent()) != null) {
            return this.isLocal(node);
        }
        return false;
    }

    private String getDecoration(RefNode node) {
        String branchName = Repository.shortenRefName((String)((Ref)node.getObject()).getName());
        Repository repository = node.getRepository();
        StoredConfig config = repository.getConfig();
        String branch = config.getString("branch", branchName, "merge");
        if (branch != null) {
            String remote = config.getString("branch", branchName, "remote");
            boolean rebaseFlag = config.getBoolean("branch", branchName, "rebase", false);
            if (branch.startsWith(DEFAULT_PATH)) {
                branch = branch.substring(DEFAULT_PATH.length());
            }
            String prefix = ".".equals(remote) ? "" : String.valueOf(remote) + "/";
            String result = String.valueOf(rebaseFlag ? "REBASE" : "MERGE") + ": " + prefix + branch;
            try {
                BranchTrackingStatus trackingStatus = BranchTrackingStatus.of((Repository)repository, (String)branchName);
                if (trackingStatus != null && (trackingStatus.getAheadCount() != 0 || trackingStatus.getBehindCount() != 0)) {
                    result = String.valueOf(result) + " " + BranchDecorator.formatBranchTrackingStatus(trackingStatus);
                }
            }
            catch (Throwable throwable) {}
            return result;
        }
        return null;
    }

    private static String formatBranchTrackingStatus(BranchTrackingStatus status) throws Exception {
        return (String)FORMAT_METHOD.invoke(null, status);
    }

    private static Method getFormatMethod() {
        Class<?> c = null;
        try {
            c = Class.forName("org.eclipse.egit.ui.internal.GitLabels");
        }
        catch (Throwable throwable) {}
        if (c == null) {
            try {
                c = Class.forName("org.eclipse.egit.ui.internal.GitLabelProvider");
            }
            catch (Throwable throwable) {}
        }
        try {
            return c.getDeclaredMethod("formatBranchTrackingStatus", c, BranchTrackingStatus.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

