/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.DateConversionDelegateFactory;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.EMFEditUIPropertyEditorFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NebulaDatePropertyEditorFactory
extends EMFEditUIPropertyEditorFactory {
    public static final URI PROPERTY_EDITOR_FACTORY_URI = URI.createURI((String)"editor://org.eclipse.nebula.widgets.cdatetime/");
    public static final NebulaDatePropertyEditorFactory INSTANCE = new NebulaDatePropertyEditorFactory();
    public static final int INVALID_MISSING_FORMAT = 1;
    public static final int INVALID_FORMAT = 2;
    public static final int INVALID_STYLE_ELEMENT = 3;
    public static final int INVALID_INSTANCE_TYPE = 4;
    public static final int INVALID_CALENDAR_TYPE = 4;
    public static Set<Class<?>> SUPPORTED_INSTANCE_CLASSES = Collections.unmodifiableSet(new LinkedHashSet<Class>(Arrays.asList(Long.TYPE, Long.class, java.util.Date.class, Date.class, Calendar.class, GregorianCalendar.class, XMLGregorianCalendar.class)));

    public NebulaDatePropertyEditorFactory() {
        super(PROPERTY_EDITOR_FACTORY_URI);
    }

    @Override
    public CellEditor createEditor(Object object, IItemPropertyDescriptor propertyDescriptor, Composite composite) {
        URI propertyEditorURI = this.getPropertyEditorURI(object, propertyDescriptor);
        if (propertyEditorURI != null) {
            EStructuralFeature eStructuralFeature;
            int segmentCount = propertyEditorURI.segmentCount();
            if (propertyEditorURI != null && segmentCount >= 1 && (eStructuralFeature = this.getEStructuralFeature(object, propertyDescriptor)) != null && !eStructuralFeature.isMany()) {
                String format;
                String dateFormatPattern = URI.decode((String)propertyEditorURI.segment(0));
                int style = 0;
                if (segmentCount > 1) {
                    String styleSegment = propertyEditorURI.segment(1);
                    style |= this.getStyle(styleSegment, DateCellEditor.CDT_STYLES);
                }
                String calendarType = null;
                Class instanceClass = eStructuralFeature.getEType().getInstanceClass();
                if (instanceClass == Calendar.class && (calendarType = propertyEditorURI.query()) == null && (format = EcoreUtil.getAnnotation((EModelElement)eStructuralFeature.getEType(), (String)"http:///org/eclipse/emf/ecore/util/DateConversionDelegate", (String)"format")) != null) {
                    URI formatURI = URI.createURI((String)format);
                    calendarType = formatURI.query();
                }
                ValueConverter valueConverter = NebulaDatePropertyEditorFactory.getValueConverter(instanceClass, calendarType);
                return DateCellEditor.create(composite, style, dateFormatPattern, valueConverter);
            }
        }
        return null;
    }

    public static ValueConverter getValueConverter(Class<?> instanceClass, String calendarType) {
        if (instanceClass == Long.TYPE || instanceClass == Long.class) {
            return ValueConverter.LongDateConverter.INSTANCE;
        }
        if (instanceClass == java.util.Date.class) {
            return ValueConverter.DateConverter.INSTANCE;
        }
        if (instanceClass == Date.class) {
            return ValueConverter.SQLDateConverter.INSTANCE;
        }
        if (instanceClass == XMLGregorianCalendar.class) {
            return ValueConverter.XMLGregorianCalendarDateConverter.INSTANCE;
        }
        if (instanceClass == GregorianCalendar.class) {
            DateConversionDelegateFactory.CalendarBuilder calendarBuilder = DateConversionDelegateFactory.getCalendarBuilder((String)"gregory");
            return new ValueConverter.CalendarDateConverter(calendarBuilder);
        }
        if (instanceClass == Calendar.class) {
            DateConversionDelegateFactory.CalendarBuilder calendarBuilder = DateConversionDelegateFactory.getCalendarBuilder((String)(calendarType == null ? "gregory" : calendarType));
            return new ValueConverter.CalendarDateConverter(calendarBuilder);
        }
        return null;
    }

    public IItemLabelProvider createLabelProvider(Object object, IItemPropertyDescriptor propertyDescriptor) {
        EStructuralFeature eStructuralFeature;
        URI propertyEditorURI = this.getPropertyEditorURI(object, propertyDescriptor);
        int segmentCount = propertyEditorURI.segmentCount();
        if (propertyEditorURI != null && segmentCount >= 1 && (eStructuralFeature = this.getEStructuralFeature(object, propertyDescriptor)) != null && !eStructuralFeature.isMany()) {
            final String dateFormatPattern = URI.decode((String)propertyEditorURI.segment(0));
            return new IItemLabelProvider(){

                public String getText(Object object) {
                    if (object instanceof java.util.Date) {
                        return new SimpleDateFormat(dateFormatPattern).format(object);
                    }
                    if (object instanceof Calendar) {
                        return new SimpleDateFormat(dateFormatPattern).format(((Calendar)object).getTime());
                    }
                    if (object instanceof XMLGregorianCalendar) {
                        return new SimpleDateFormat(dateFormatPattern).format(((XMLGregorianCalendar)object).toGregorianCalendar().getTime());
                    }
                    if (object instanceof Long) {
                        return new SimpleDateFormat(dateFormatPattern).format(new java.util.Date((Long)object));
                    }
                    return "";
                }

                public Object getImage(Object object) {
                    return ItemPropertyDescriptor.GENERIC_VALUE_IMAGE;
                }
            };
        }
        return null;
    }

    public boolean validate(EModelElement eModelElement, URI propertyEditorSpecification, DiagnosticChain diagnostics, Map<Object, Object> context) {
        String style;
        EModelElement effectiveEModelElement;
        int segmentCount = propertyEditorSpecification.segmentCount();
        if (segmentCount == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, 1, this.getString("_UI_NebulaInvalidMissingFormat_diagnostic", new Object[0]), new Object[]{eModelElement, propertyEditorSpecification}));
            }
            return false;
        }
        String dateFormatPattern = URI.decode((String)propertyEditorSpecification.segment(0));
        try {
            new SimpleDateFormat(dateFormatPattern);
        }
        catch (IllegalArgumentException exception) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, 2, this.getString("_UI_NebulaInvalidFormat_diagnostic", new Object[]{dateFormatPattern, exception.getLocalizedMessage()}), new Object[]{eModelElement, propertyEditorSpecification}));
            }
            return false;
        }
        Object object = effectiveEModelElement = eModelElement instanceof EStructuralFeature ? ((EStructuralFeature)eModelElement).getEType() : eModelElement;
        if (effectiveEModelElement instanceof EDataType) {
            DateConversionDelegateFactory.CalendarBuilder calendarBuilder;
            String query;
            EDataType eDataType = (EDataType)effectiveEModelElement;
            Class instanceClass = eDataType.getInstanceClass();
            if (!SUPPORTED_INSTANCE_CLASSES.contains(instanceClass)) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, 4, this.getString("_UI_NebulaInvalidInstanceType_diagnostic", new Object[]{eDataType.getInstanceTypeName(), EObjectValidator.INSTANCE.getAvailableChoices(SUPPORTED_INSTANCE_CLASSES, false, "", 10)}), new Object[]{eModelElement, propertyEditorSpecification}));
                }
                return false;
            }
            if (instanceClass == Calendar.class && (query = propertyEditorSpecification.query()) != null && (calendarBuilder = DateConversionDelegateFactory.getCalendarBuilder((String)query)) == null) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)this.createDiagnostic(4, 4, this.getString("_UI_NebulaInvalidCalendarType_diagnostic", new Object[]{query, EObjectValidator.INSTANCE.getAvailableChoices((Collection)DateConversionDelegateFactory.CALENDAR_TYPES, false, "", 10)}), new Object[]{eModelElement, propertyEditorSpecification}));
                }
                return false;
            }
        }
        if (segmentCount > 1 && (style = propertyEditorSpecification.segment(1)).length() > 0) {
            LinkedHashSet styleElements = new LinkedHashSet(this.getStyleElements(style));
            styleElements.removeAll(DateCellEditor.CDT_STYLES.keySet());
            if (!styleElements.isEmpty()) {
                if (diagnostics != null) {
                    diagnostics.add((Diagnostic)this.createDiagnostic(2, 3, this.getString("_UI_NebulaInvalidStyleElements_diagnostic", new Object[]{EObjectValidator.INSTANCE.getAvailableChoices(styleElements, true, "'", 5), EObjectValidator.INSTANCE.getAvailableChoices(DateCellEditor.CDT_STYLES.keySet(), true, "", 10)}), new Object[]{eModelElement, propertyEditorSpecification}));
                }
                return false;
            }
        }
        return true;
    }

    public Set<String> getChoices(EModelElement eModelElement) {
        EStructuralFeature eStructuralFeature;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (eModelElement instanceof EDataType) {
            EDataType eDataType = (EDataType)eModelElement;
            Class instanceClass = eDataType.getInstanceClass();
            if (instanceClass == null) {
                result.add("");
            } else {
                String format = EcoreUtil.getAnnotation((EModelElement)eModelElement, (String)"http:///org/eclipse/emf/ecore/util/DateConversionDelegate", (String)"format");
                if (format != null) {
                    URI formatURI = URI.createURI((String)format);
                    try {
                        DateFormat dateFormat = DateConversionDelegateFactory.getDateFormat((URI)formatURI);
                        if (dateFormat instanceof SimpleDateFormat) {
                            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
                            String pattern = URI.encodeSegment((String)simpleDateFormat.toPattern(), (boolean)false).replace("%20", " ");
                            result.add(pattern);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (result.isEmpty()) {
                    result.add("yyyy-MM-dd");
                    result.add("yyyy%2FMM%2Fdd");
                    result.add("yyyy-MM-dd'T'HH:mm");
                    result.add("yyyy-MM-dd'T'HH:mm:ss");
                    result.add("yyyy-MM-dd'T'HH:mm:ss'.'SSS");
                    result.add("yyyy-MM-dd'T'HH:mm:ss'.'SSSZ");
                }
            }
        } else if (eModelElement instanceof EStructuralFeature && !(eStructuralFeature = (EStructuralFeature)eModelElement).isMany()) {
            return this.getChoices((EModelElement)eStructuralFeature.getEType());
        }
        return result;
    }

    protected ResourceLocator getResourceLocator() {
        return EMFEditUIPlugin.INSTANCE;
    }

    private static class DateCellEditor
    extends CellEditor {
        private static final Map<String, Integer> CDT_STYLES = new TreeMap<String, Integer>();
        protected static final boolean CDATETIME_IS_AVAILABLE;
        private static final Constructor<?> CDATE_TIME_CONSTRUCTOR;
        private static final Method GET_SELECTION_METHOD;
        private static final Method SET_SELECTION_METHOD;
        private static final Method SET_PATTERN_METHOD;
        private static final Method ADD_SELECTION_LISTENER_METHOD;
        private Composite cDateTime;
        private final ValueConverter valueConverter;

        static {
            Constructor cDateTimeConstructor = null;
            Method getSelectionMethod = null;
            Method setSelectionMethod = null;
            Method setPatternMethod = null;
            Method addSelectionListenerMethod = null;
            boolean cDateTimeIsAvailable = false;
            try {
                Class cdtClass = CommonPlugin.loadClass((String)"org.eclipse.nebula.widgets.cdatetime", (String)"org.eclipse.nebula.widgets.cdatetime.CDT");
                Pattern styleNamePattern = Pattern.compile("[A-Z124_]*");
                Field[] fieldArray = cdtClass.getFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    String name = field.getName();
                    if (styleNamePattern.matcher(name).matches()) {
                        int modifiers = field.getModifiers();
                        if (field.getType() == Integer.TYPE && Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isStatic(modifiers)) {
                            int value = field.getInt(null);
                            CDT_STYLES.put(name, value);
                        }
                    }
                    ++n2;
                }
                Class cDateTimeClass = CommonPlugin.loadClass((String)"org.eclipse.nebula.widgets.cdatetime", (String)"org.eclipse.nebula.widgets.cdatetime.CDateTime");
                cDateTimeConstructor = cDateTimeClass.getConstructor(Composite.class, Integer.TYPE);
                getSelectionMethod = cDateTimeClass.getMethod("getSelection", new Class[0]);
                setSelectionMethod = cDateTimeClass.getMethod("setSelection", java.util.Date.class);
                setPatternMethod = cDateTimeClass.getMethod("setPattern", String.class);
                addSelectionListenerMethod = cDateTimeClass.getMethod("addSelectionListener", SelectionListener.class);
                cDateTimeIsAvailable = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (CDT_STYLES.isEmpty()) {
                CDT_STYLES.put("NONE", 0);
                CDT_STYLES.put("BORDER", 1);
                CDT_STYLES.put("DROP_DOWN", 4);
                CDT_STYLES.put("SIMPLE", 8);
                CDT_STYLES.put("BUTTON_LEFT", 256);
                CDT_STYLES.put("BUTTON_RIGHT", 512);
                CDT_STYLES.put("BUTTON_AUTO", 524288);
                CDT_STYLES.put("TEXT_LEFT", 1024);
                CDT_STYLES.put("TEXT_LEAD", 1024);
                CDT_STYLES.put("TEXT_RIGHT", 2048);
                CDT_STYLES.put("TEXT_TRAIL", 2048);
                CDT_STYLES.put("HORIZONTAL", 4096);
                CDT_STYLES.put("VERTICAL", 8192);
                CDT_STYLES.put("READ_ONLY", 16384);
                CDT_STYLES.put("DATE_SHORT", 0x200000);
                CDT_STYLES.put("DATE_MEDIUM", 0x400000);
                CDT_STYLES.put("DATE_LONG", 0x800000);
                CDT_STYLES.put("TIME_SHORT", 0x1000000);
                CDT_STYLES.put("TIME_MEDIUM", 0x2000000);
                CDT_STYLES.put("COMPACT", 65536);
                CDT_STYLES.put("ADD_ON_ROLL", 0x100000);
                CDT_STYLES.put("TAB_FIELDS", 0x4000000);
                CDT_STYLES.put("SPINNER", 0x8000000);
                CDT_STYLES.put("CLOCK_DISCRETE", 0x10000000);
                CDT_STYLES.put("CLOCK_12_HOUR", 0x20000000);
                CDT_STYLES.put("CLOCK_24_HOUR", 0x40000000);
                CDT_STYLES.put("MULTI", Integer.MIN_VALUE);
            }
            CDATE_TIME_CONSTRUCTOR = cDateTimeConstructor;
            GET_SELECTION_METHOD = getSelectionMethod;
            SET_SELECTION_METHOD = setSelectionMethod;
            SET_PATTERN_METHOD = setPatternMethod;
            ADD_SELECTION_LISTENER_METHOD = addSelectionListenerMethod;
            CDATETIME_IS_AVAILABLE = cDateTimeIsAvailable;
        }

        private static CellEditor create(Composite composite, int style, String pattern, ValueConverter valueConverter) {
            if (CDATETIME_IS_AVAILABLE && valueConverter != null) {
                return new DateCellEditor(composite, style, pattern, valueConverter);
            }
            return null;
        }

        private static Object invoke(Method method, Object target, Object ... arguments) {
            try {
                return method.invoke(target, arguments);
            }
            catch (Exception exception) {
                throw new RuntimeException();
            }
        }

        public DateCellEditor(Composite parent, int style, String pattern, ValueConverter valueConverter) {
            super(parent, style);
            this.valueConverter = valueConverter;
            DateCellEditor.invoke(SET_PATTERN_METHOD, this.cDateTime, pattern);
        }

        private Composite createCDateTime(Composite composite, int style) {
            try {
                return (Composite)CDATE_TIME_CONSTRUCTOR.newInstance(composite, style);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        protected Control createControl(Composite parent) {
            this.cDateTime = this.createCDateTime(parent, CDT_STYLES.get("DROP_DOWN") | this.getStyle());
            DateCellEditor.invoke(ADD_SELECTION_LISTENER_METHOD, this.cDateTime, new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DateCellEditor.this.markDirty();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    DateCellEditor.this.markDirty();
                    DateCellEditor.this.fireApplyEditorValue();
                    DateCellEditor.this.deactivate();
                }
            });
            this.cDateTime.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2) {
                        DateCellEditor.this.deactivate();
                    }
                }
            });
            this.cDateTime.setFont(parent.getFont());
            this.cDateTime.setBackground(parent.getBackground());
            return this.cDateTime;
        }

        public void deactivate() {
            if (this.isDirty()) {
                this.fireApplyEditorValue();
            }
            super.deactivate();
        }

        protected Object doGetValue() {
            return this.valueConverter.createFromDate((java.util.Date)DateCellEditor.invoke(GET_SELECTION_METHOD, this.cDateTime, new Object[0]));
        }

        protected void doSetFocus() {
            this.cDateTime.setFocus();
        }

        protected void doSetValue(Object value) {
            DateCellEditor.invoke(SET_SELECTION_METHOD, this.cDateTime, this.valueConverter.convertToDate(value));
        }
    }

    public static abstract class ValueConverter {
        private ValueConverter() {
        }

        public abstract java.util.Date convertToDate(Object var1);

        public abstract Object createFromDate(java.util.Date var1);

        private static class CalendarDateConverter
        extends ValueConverter {
            private final DateConversionDelegateFactory.CalendarBuilder calendarBuilder;

            private CalendarDateConverter(DateConversionDelegateFactory.CalendarBuilder calendarBuilder) {
                this.calendarBuilder = calendarBuilder;
            }

            public java.util.Date convertToDate(Object value) {
                return value == null ? null : ((Calendar)value).getTime();
            }

            public Object createFromDate(java.util.Date date) {
                return date == null ? null : this.calendarBuilder.create(date);
            }
        }

        private static class DateConverter
        extends ValueConverter {
            private static final DateConverter INSTANCE = new DateConverter();

            private DateConverter() {
            }

            public java.util.Date convertToDate(Object value) {
                return (java.util.Date)value;
            }

            public Object createFromDate(java.util.Date date) {
                return date;
            }
        }

        private static class LongDateConverter
        extends ValueConverter {
            private static final LongDateConverter INSTANCE = new LongDateConverter();

            private LongDateConverter() {
            }

            public java.util.Date convertToDate(Object value) {
                return value == null ? null : new java.util.Date((Long)value);
            }

            public Object createFromDate(java.util.Date date) {
                return date == null ? null : Long.valueOf(date.getTime());
            }
        }

        private static class SQLDateConverter
        extends ValueConverter {
            private static final SQLDateConverter INSTANCE = new SQLDateConverter();

            private SQLDateConverter() {
            }

            public java.util.Date convertToDate(Object value) {
                return (java.util.Date)value;
            }

            public Object createFromDate(java.util.Date date) {
                return date == null ? null : new Date(date.getTime());
            }
        }

        private static class XMLGregorianCalendarDateConverter
        extends ValueConverter {
            private static final XMLGregorianCalendarDateConverter INSTANCE = new XMLGregorianCalendarDateConverter();
            private static final DatatypeFactory DATATYPE_FACTORY;

            static {
                DatatypeFactory datatypeFactory = null;
                try {
                    datatypeFactory = DatatypeFactory.newInstance();
                }
                catch (DatatypeConfigurationException datatypeConfigurationException) {
                    // empty catch block
                }
                DATATYPE_FACTORY = datatypeFactory;
            }

            private XMLGregorianCalendarDateConverter() {
            }

            public java.util.Date convertToDate(Object value) {
                return value == null ? null : ((XMLGregorianCalendar)value).toGregorianCalendar().getTime();
            }

            public Object createFromDate(java.util.Date date) {
                if (date == null) {
                    return null;
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                return DATATYPE_FACTORY.newXMLGregorianCalendar(gregorianCalendar);
            }
        }
    }
}

