/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.internal.ui.UIPlugin;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.installer.AboutDialog;
import org.eclipse.oomph.setup.internal.installer.Installer;
import org.eclipse.oomph.setup.internal.installer.InstallerUI;
import org.eclipse.oomph.setup.internal.installer.KeepInstallerDialog;
import org.eclipse.oomph.setup.internal.installer.NetworkConnectionsDialog;
import org.eclipse.oomph.setup.internal.installer.NetworkSSH2Dialog;
import org.eclipse.oomph.setup.internal.installer.ProductPage;
import org.eclipse.oomph.setup.internal.installer.SelfUpdate;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.URISchemeUtil;
import org.eclipse.oomph.setup.ui.wizards.ConfirmationPage;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.setup.ui.wizards.SetupWizardDialog;
import org.eclipse.oomph.util.ExceptionHandler;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public final class InstallerDialog
extends SetupWizardDialog
implements InstallerUI {
    private final IPageChangedListener pageChangedListener = new PageChangedListener();
    private final boolean restarted;
    private ToolItem updateToolItem;
    private boolean updateSearching;
    private ProfileTransaction.Resolution updateResolution;
    private IStatus updateError;
    private String version;
    private Link versionLink;

    public InstallerDialog(Shell parentShell, boolean restarted) {
        this(parentShell, new Installer(new SetupWizard.SelectionMemento()), restarted);
    }

    public InstallerDialog(Shell parentShell, Installer installer, boolean restarted) {
        super(parentShell, (SetupWizard)installer);
        this.restarted = restarted;
        this.addPageChangedListener(this.pageChangedListener);
        if (UIPlugin.isRecorderEnabled()) {
            this.setNonModal();
        }
    }

    public Installer getInstaller() {
        return (Installer)this.getWizard();
    }

    public boolean refreshJREs() {
        ProductPage page = (ProductPage)this.getWizard().getPage("ProductPage");
        if (page != null) {
            return page.refreshJREs();
        }
        return false;
    }

    public void create() {
        super.create();
        final Shell shell = this.getShell();
        shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2) {
                    shell.close();
                    e.detail = 0;
                    e.doit = false;
                }
            }
        });
        shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                final Installer installer = InstallerDialog.this.getInstaller();
                if (!shell.isDisposed()) {
                    final 2 checkIndex = this;
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (!shell.isDisposed()) {
                                installer.getIndexLoader().awaitIndexLoad();
                                UIPlugin.openRecorderIfEnabled();
                                SetupInstallerPlugin.runTests();
                                if (installer.getCatalogManager().getIndex() == null) {
                                    if (installer.handleMissingIndex(shell)) {
                                        shell.getDisplay().asyncExec(checkIndex);
                                    } else {
                                        InstallerDialog.this.close();
                                    }
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    protected Control createHelpControl(Composite parent) {
        Control helpControl = super.createHelpControl(parent);
        this.setProductVersionLink(parent);
        return helpControl;
    }

    protected void createToolItemsForToolBar(ToolBar toolBar) {
        ToolItem networkProxySettingsToolItem = this.createToolItem(toolBar, "install_prefs_proxy.png", "Network proxy settings");
        networkProxySettingsToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkConnectionsDialog dialog = new NetworkConnectionsDialog(InstallerDialog.this.getShell());
                dialog.open();
            }
        });
        AccessUtil.setKey((Widget)networkProxySettingsToolItem, (Object)"proxy");
        ToolItem sshSettingsToolItem = this.createToolItem(toolBar, "install_prefs_ssh2.png", "SSH2 settings");
        sshSettingsToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NetworkSSH2Dialog dialog = new NetworkSSH2Dialog(InstallerDialog.this.getShell());
                dialog.open();
            }
        });
        AccessUtil.setKey((Widget)sshSettingsToolItem, (Object)"ssh");
        ToolItem simpleToolItem = this.createToolItem(toolBar, "simple.png", "Switch to simple mode");
        simpleToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallerDialog.this.close();
                InstallerDialog.this.setReturnCode(2);
            }
        });
        AccessUtil.setKey((Widget)simpleToolItem, (Object)"simple");
        final ToolItem webLinksToolItem = this.createToolItem(toolBar, URISchemeUtil.isRegistered() ? "web_links_registered.png" : "web_links_unregistered.png", "Register this installer to automatically launch for links in a web browser");
        webLinksToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KeepInstallerDialog keepInstallerDialog;
                if (URISchemeUtil.manageRegistrations(InstallerDialog.this.getShell()) == URISchemeUtil.RegistrationConfirmation.KEEP_INSTALLER && (keepInstallerDialog = new KeepInstallerDialog(InstallerDialog.this.getShell(), true)).open() == 0) {
                    InstallerDialog.this.close();
                    return;
                }
                webLinksToolItem.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage(URISchemeUtil.isRegistered() ? "web_links_registered.png" : "web_links_unregistered.png"));
            }
        });
        AccessUtil.setKey((Widget)simpleToolItem, (Object)"web-links");
        this.updateToolItem = this.createToolItem(toolBar, "install_update0.png", "Update");
        this.updateToolItem.setDisabledImage(SetupInstallerPlugin.INSTANCE.getSWTImage("install_searching0.png"));
        this.updateToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallerDialog.this.selfUpdate();
            }
        });
        AccessUtil.setKey((Widget)this.updateToolItem, (Object)"update");
    }

    protected final ToolItem createToolItem(ToolBar toolBar, String iconPath, String toolTip) {
        ToolItem toolItem = new ToolItem(toolBar, 8);
        if (iconPath == null) {
            toolItem.setText(toolTip);
        } else {
            Image image = SetupInstallerPlugin.INSTANCE.getSWTImage(iconPath);
            toolItem.setImage(image);
            toolItem.setToolTipText(toolTip);
        }
        return toolItem;
    }

    private void selfUpdate() {
        this.updateError = null;
        this.setUpdateIcon(0);
        if (this.updateResolution == null) {
            this.initUpdateSearch();
        } else {
            Runnable successRunnable = new Runnable(){

                public void run() {
                    InstallerDialog.this.restart();
                }
            };
            ExceptionHandler<CoreException> exceptionHandler = new ExceptionHandler<CoreException>(){

                public void handleException(CoreException ex) {
                    InstallerDialog.this.updateError = ex.getStatus();
                }
            };
            Runnable finalRunnable = new Runnable(){

                public void run() {
                    InstallerDialog.this.updateResolution = null;
                    InstallerDialog.this.setUpdateIcon(0);
                }
            };
            SelfUpdate.update(this.getShell(), this.updateResolution, successRunnable, exceptionHandler, finalRunnable);
        }
    }

    private void initUpdateSearch() {
        this.updateSearching = true;
        UpdateIconAnimator updateIconSetter = new UpdateIconAnimator();
        updateIconSetter.start();
        UpdateSearcher updateSearcher = new UpdateSearcher();
        updateSearcher.start();
    }

    private void setUpdateIcon(final int icon) {
        this.updateToolItem.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (InstallerDialog.this.updateToolItem == null || InstallerDialog.this.updateToolItem.isDisposed()) {
                    return;
                }
                try {
                    if (InstallerDialog.this.updateSearching) {
                        InstallerDialog.this.updateToolItem.setToolTipText("Checking for updates...");
                        InstallerDialog.this.updateToolItem.setDisabledImage(SetupInstallerPlugin.INSTANCE.getSWTImage("install_searching" + icon + ".png"));
                        InstallerDialog.this.updateToolItem.setEnabled(false);
                    } else if (InstallerDialog.this.updateError != null) {
                        StringBuilder builder = new StringBuilder();
                        this.formatStatus(builder, "", InstallerDialog.this.updateError);
                        InstallerDialog.this.updateToolItem.setToolTipText(builder.toString());
                        InstallerDialog.this.updateToolItem.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("install_error.png"));
                        InstallerDialog.this.updateToolItem.setEnabled(true);
                    } else if (InstallerDialog.this.updateResolution != null) {
                        InstallerDialog.this.updateToolItem.setToolTipText("Install available updates");
                        InstallerDialog.this.updateToolItem.setImage(SetupInstallerPlugin.INSTANCE.getSWTImage("install_update" + icon + ".png"));
                        InstallerDialog.this.updateToolItem.setEnabled(true);
                    } else {
                        InstallerDialog.this.updateToolItem.setToolTipText("No updates available");
                        InstallerDialog.this.updateToolItem.setDisabledImage(SetupInstallerPlugin.INSTANCE.getSWTImage("install_update_disabled.png"));
                        InstallerDialog.this.updateToolItem.setEnabled(false);
                    }
                }
                catch (Exception exception) {}
            }

            private void formatStatus(StringBuilder builder, String indent, IStatus status) {
                if (builder.length() != 0) {
                    builder.append('\n');
                }
                builder.append(indent);
                builder.append(status.getMessage());
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStatus child = iStatusArray[n2];
                    this.formatStatus(builder, String.valueOf(indent) + "   ", child);
                    ++n2;
                }
            }
        });
    }

    private void setProductVersionLink(Composite parent) {
        GridLayout parentLayout = (GridLayout)parent.getLayout();
        ++parentLayout.numColumns;
        parentLayout.horizontalSpacing = 10;
        this.versionLink = new Link(parent, 524288);
        this.versionLink.setLayoutData((Object)new GridData(68));
        this.versionLink.setToolTipText("About");
        this.versionLink.setText("<a>0.0.0</a>");
        AccessUtil.setKey((Widget)this.versionLink, (Object)"version");
        ProductVersionInitializer thread = new ProductVersionInitializer();
        thread.start();
    }

    public int show() {
        this.setBlockOnOpen(false);
        this.open();
        this.getInstaller().runEventLoop(this.getShell());
        return this.getReturnCode();
    }

    public void showAbout() {
        new AboutDialog(this.getShell(), this.version).open();
    }

    public void restart() {
        this.close();
        this.setReturnCode(-4);
    }

    public void reset() {
        this.close();
        this.setReturnCode(3);
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        initialSize.x = initialSize.x * 11 / 10;
        return initialSize;
    }

    private final class PageChangedListener
    implements IPageChangedListener {
        private PageChangedListener() {
        }

        public void pageChanged(PageChangedEvent event) {
            if (event.getSelectedPage() instanceof ConfirmationPage) {
                InstallerDialog.this.updateSearching = false;
                InstallerDialog.this.updateResolution = null;
                InstallerDialog.this.updateError = null;
                InstallerDialog.this.setUpdateIcon(0);
                SetupTaskPerformer performer = InstallerDialog.this.getInstaller().getPerformer();
                performer.getBundles().add(SetupInstallerPlugin.INSTANCE.getBundle());
            }
        }
    }

    private final class ProductVersionInitializer
    extends Thread {
        public ProductVersionInitializer() {
            super("Product Version Initializer");
        }

        public void run() {
            try {
                InstallerDialog.this.version = SelfUpdate.getProductVersion();
                if (InstallerDialog.this.version != null) {
                    if (InstallerDialog.this.version == "Self Hosting") {
                        InstallerDialog.this.updateSearching = false;
                        InstallerDialog.this.setUpdateIcon(0);
                    } else if (!InstallerDialog.this.restarted) {
                        InstallerDialog.this.initUpdateSearch();
                    }
                    InstallerDialog.this.versionLink.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                InstallerDialog.this.versionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                    public void widgetSelected(SelectionEvent e) {
                                        InstallerDialog.this.showAbout();
                                    }
                                });
                                InstallerDialog.this.versionLink.setText("<a>" + InstallerDialog.this.version + "</a>");
                                InstallerDialog.this.versionLink.getParent().layout();
                            }
                            catch (Exception ex) {
                                SetupInstallerPlugin.INSTANCE.log(ex);
                            }
                        }
                    });
                }
            }
            catch (Exception ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
    }

    private final class UpdateIconAnimator
    extends Thread {
        public UpdateIconAnimator() {
            super("Update Icon Animator");
        }

        public void run() {
            try {
                int i = 0;
                while (InstallerDialog.this.updateSearching || InstallerDialog.this.updateResolution != null) {
                    if (InstallerDialog.this.updateToolItem == null || InstallerDialog.this.updateToolItem.isDisposed()) {
                        return;
                    }
                    int icon = i > 7 ? 0 : i;
                    InstallerDialog.this.setUpdateIcon(icon);
                    UpdateIconAnimator.sleep(80L);
                    ++i;
                    i %= 20;
                }
                InstallerDialog.this.setUpdateIcon(0);
            }
            catch (Exception ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
    }

    private final class UpdateSearcher
    extends Thread {
        public UpdateSearcher() {
            super("Update Searcher");
        }

        public void run() {
            try {
                try {
                    User user = InstallerDialog.this.getInstaller().getUser();
                    InstallerDialog.this.updateResolution = SelfUpdate.resolve(user, null);
                }
                catch (CoreException ex) {
                    InstallerDialog.this.updateError = ex.getStatus();
                    InstallerDialog.this.updateSearching = false;
                }
            }
            finally {
                InstallerDialog.this.updateSearching = false;
            }
        }
    }
}

