/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.svg;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.nebula.cwt.svg.SvgColors;
import org.eclipse.nebula.cwt.svg.SvgContainer;
import org.eclipse.nebula.cwt.svg.SvgDocument;
import org.eclipse.nebula.cwt.svg.SvgElement;
import org.eclipse.nebula.cwt.svg.SvgFragment;
import org.eclipse.nebula.cwt.svg.SvgGradient;
import org.eclipse.nebula.cwt.svg.SvgGradientStop;
import org.eclipse.nebula.cwt.svg.SvgGraphic;
import org.eclipse.nebula.cwt.svg.SvgPaint;
import org.eclipse.nebula.cwt.svg.SvgShape;
import org.eclipse.nebula.cwt.svg.SvgStyle;
import org.eclipse.nebula.cwt.svg.SvgTransform;
import org.eclipse.nebula.cwt.svg.SvgUse;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

class SvgLoader {
    private static final char[] ATTR_CLASS = new char[]{'c', 'l', 'a', 's', 's'};
    private static final char[] ATTR_CX = new char[]{'c', 'x'};
    private static final char[] ATTR_CY = new char[]{'c', 'y'};
    private static final char[] ATTR_D = new char[]{'d'};
    private static final char[] ATTR_FILL = new char[]{'f', 'i', 'l', 'l'};
    private static final char[] ATTR_FILL_OPACITY = new char[]{'f', 'i', 'l', 'l', '-', 'o', 'p', 'a', 'c', 'i', 't', 'y'};
    private static final char[] ATTR_FILL_RULE = new char[]{'f', 'i', 'l', 'l', '-', 'r', 'u', 'l', 'e'};
    private static final char[] ATTR_FX = new char[]{'f', 'x'};
    private static final char[] ATTR_FY = new char[]{'f', 'y'};
    private static final char[] ATTR_GRADIENT_TRANSFORM = new char[]{'g', 'r', 'a', 'd', 'i', 'e', 'n', 't', 'T', 'r', 'a', 'n', 's', 'f', 'o', 'r', 'm'};
    private static final char[] ATTR_GRADIENT_UNITS = new char[]{'g', 'r', 'a', 'd', 'i', 'e', 'n', 't', 'U', 'n', 'i', 't', 's'};
    private static final char[] ATTR_HEIGHT = new char[]{'h', 'e', 'i', 'g', 'h', 't'};
    private static final char[] ATTR_ID = new char[]{'i', 'd'};
    private static final char[] ATTR_OFFSET = new char[]{'o', 'f', 'f', 's', 'e', 't'};
    private static final char[] ATTR_POINTS = new char[]{'p', 'o', 'i', 'n', 't', 's'};
    private static final char[] ATTR_R = new char[]{'r'};
    private static final char[] ATTR_RX = new char[]{'r', 'x'};
    private static final char[] ATTR_RY = new char[]{'r', 'y'};
    private static final char[] ATTR_SPREAD_METHOD = new char[]{'s', 'p', 'r', 'e', 'a', 'd', 'M', 'e', 't', 'h', 'o', 'd'};
    private static final char[] ATTR_STOP = new char[]{'s', 't', 'o', 'p'};
    private static final char[] ATTR_STOP_COLOR = new char[]{'s', 't', 'o', 'p', '-', 'c', 'o', 'l', 'o', 'r'};
    private static final char[] ATTR_STOP_OPACITY = new char[]{'s', 't', 'o', 'p', '-', 'o', 'p', 'a', 'c', 'i', 't', 'y'};
    private static final char[] ATTR_STROKE = new char[]{'s', 't', 'r', 'o', 'k', 'e'};
    private static final char[] ATTR_STROKE_OPACITY = new char[]{'s', 't', 'r', 'o', 'k', 'e', '-', 'o', 'p', 'a', 'c', 'i', 't', 'y'};
    private static final char[] ATTR_STROKE_WIDTH = new char[]{'s', 't', 'r', 'o', 'k', 'e', '-', 'w', 'i', 'd', 't', 'h'};
    private static final char[] ATTR_STROKE_CAP = new char[]{'s', 't', 'r', 'o', 'k', 'e', '-', 'l', 'i', 'n', 'e', 'c', 'a', 'p'};
    private static final char[] ATTR_STROKE_JOIN = new char[]{'s', 't', 'r', 'o', 'k', 'e', '-', 'l', 'i', 'n', 'e', 'j', 'o', 'i', 'n'};
    private static final char[] ATTR_STYLE = new char[]{'s', 't', 'y', 'l', 'e'};
    private static final char[] ATTR_TRANSFORM = new char[]{'t', 'r', 'a', 'n', 's', 'f', 'o', 'r', 'm'};
    private static final char[] ATTR_VIEWBOX = new char[]{'v', 'i', 'e', 'w', 'B', 'o', 'x'};
    private static final char[] ATTR_WIDTH = new char[]{'w', 'i', 'd', 't', 'h'};
    private static final char[] ATTR_X = new char[]{'x'};
    private static final char[] ATTR_X1 = new char[]{'x', '1'};
    private static final char[] ATTR_X2 = new char[]{'x', '2'};
    private static final char[] ATTR_XLINK_HREF = new char[]{'x', 'l', 'i', 'n', 'k', ':', 'h', 'r', 'e', 'f'};
    private static final char[] ATTR_Y = new char[]{'y'};
    private static final char[] ATTR_Y1 = new char[]{'y', '1'};
    private static final char[] ATTR_Y2 = new char[]{'y', '2'};
    private static final char[] ELEMENT_CDATA = new char[]{'!', '[', 'C', 'D', 'A', 'T', 'A', '['};
    private static final char[] ELEMENT_CDATA_END = new char[]{']', ']', '>'};
    private static final char[] ELEMENT_CIRCLE = new char[]{'c', 'i', 'r', 'c', 'l', 'e'};
    private static final char[] ELEMENT_COMMENT = new char[]{'!', '-', '-'};
    private static final char[] ELEMENT_COMMENT_END = new char[]{'-', '-', '>'};
    private static final char[] ELEMENT_DESCRIPTION = new char[]{'d', 'e', 's', 'c'};
    private static final char[] ELEMENT_DEFS = new char[]{'d', 'e', 'f', 's'};
    private static final char[] ELEMENT_DOCTYPE = new char[]{'!', 'D', 'O', 'C', 'T', 'Y', 'P', 'E'};
    private static final char[] ELEMENT_ELLIPSE = new char[]{'e', 'l', 'l', 'i', 'p', 's', 'e'};
    private static final char[] ELEMENT_GROUP = new char[]{'g'};
    private static final char[] ELEMENT_LINEAR_GRADIENT = new char[]{'l', 'i', 'n', 'e', 'a', 'r', 'G', 'r', 'a', 'd', 'i', 'e', 'n', 't'};
    private static final char[] ELEMENT_LINE = new char[]{'l', 'i', 'n', 'e'};
    private static final char[] ELEMENT_PATH = new char[]{'p', 'a', 't', 'h'};
    private static final char[] ELEMENT_POLYGON = new char[]{'p', 'o', 'l', 'y', 'g', 'o', 'n'};
    private static final char[] ELEMENT_POLYLINE = new char[]{'p', 'o', 'l', 'y', 'l', 'i', 'n', 'e'};
    private static final char[] ELEMENT_RADIAL_GRADIENT = new char[]{'r', 'a', 'd', 'i', 'a', 'l', 'G', 'r', 'a', 'd', 'i', 'e', 'n', 't'};
    private static final char[] ELEMENT_RECT = new char[]{'r', 'e', 'c', 't'};
    private static final char[] ELEMENT_SVG = new char[]{'s', 'v', 'g'};
    private static final char[] ELEMENT_STYLE = new char[]{'s', 't', 'y', 'l', 'e'};
    private static final char[] ELEMENT_TITLE = new char[]{'t', 'i', 't', 'l', 'e'};
    private static final char[] ELEMENT_USE = new char[]{'u', 's', 'e'};
    private static final char[] ELEMENT_XML = new char[]{'?', 'x', 'm', 'l'};
    private static final String paramRegex = "[ ,]+";
    private static final Matcher urlMatcher = Pattern.compile(" *url\\( *#(\\w+) *\\) *").matcher("");

    private static void addArc(String[] sa, int ix, List<Byte> types, List<Float> points, boolean relative) {
        double radicand;
        double y0;
        float x1 = points.get(points.size() - 2).floatValue();
        float y1 = points.get(points.size() - 1).floatValue();
        float rx = Math.abs(Float.parseFloat(sa[ix++]));
        float ry = Math.abs(Float.parseFloat(sa[ix++]));
        float phi = SvgLoader.clampAngle(Float.parseFloat(sa[ix++]));
        boolean largeArc = !sa[ix++].equals("0");
        boolean sweep = !sa[ix++].equals("0");
        float x2 = Float.parseFloat(sa[ix++]);
        float y2 = Float.parseFloat(sa[ix++]);
        if (relative) {
            x2 += x1;
            y2 += y1;
        }
        if (x1 == x2 && y1 == y2) {
            return;
        }
        if (rx == 0.0f || ry == 0.0f) {
            types.add((byte)2);
            points.add(Float.valueOf(x2));
            points.add(Float.valueOf(y2));
            return;
        }
        double radPhi = Math.toRadians(phi);
        double x0 = Math.cos(radPhi) * (double)((x1 - x2) / 2.0f) + Math.sin(radPhi) * (double)((y1 - y2) / 2.0f);
        double lambda = x0 * x0 / (double)(rx * rx) + (y0 = -Math.sin(radPhi) * (double)((x1 - x2) / 2.0f) + Math.cos(radPhi) * (double)((y1 - y2) / 2.0f)) * y0 / (double)(ry * ry);
        if (lambda > 1.0) {
            rx = (float)((double)rx * Math.sqrt(lambda));
            ry = (float)((double)ry * Math.sqrt(lambda));
            radicand = 0.0;
        } else {
            radicand = ((double)(rx * rx * ry * ry) - (double)(rx * rx) * y0 * y0 - (double)(ry * ry) * x0 * x0) / ((double)(rx * rx) * y0 * y0 + (double)(ry * ry) * x0 * x0);
        }
        if (radicand < 0.0) {
            rx = (float)((double)rx * Math.sqrt(lambda));
            ry = (float)((double)ry * Math.sqrt(lambda));
            radicand = 0.0;
        }
        int sign = largeArc != sweep ? 1 : -1;
        double cx0 = (double)sign * Math.sqrt(radicand) * (double)rx * y0 / (double)ry;
        double cy0 = (double)sign * Math.sqrt(radicand) * (double)(-ry) * x0 / (double)rx;
        double cx = Math.cos(radPhi) * cx0 - Math.sin(radPhi) * cy0 + (double)((x1 + x2) / 2.0f);
        double cy = Math.sin(radPhi) * cx0 + Math.cos(radPhi) * cy0 + (double)((y1 + y2) / 2.0f);
        double theta1 = SvgLoader.getAngle(1.0, 0.0, (x0 - cx0) / (double)rx, (y0 - cy0) / (double)ry);
        double dTheta = SvgLoader.getAngle((x0 - cx0) / (double)rx, (y0 - cy0) / (double)ry, (-x0 - cx0) / (double)rx, (-y0 - cy0) / (double)ry);
        double theta2 = theta1 + dTheta;
        theta1 = SvgLoader.clampAngle(theta1);
        dTheta = SvgLoader.clampAngle(dTheta);
        theta2 = SvgLoader.clampAngle(theta2);
        if (!sweep) {
            dTheta = 360.0 - dTheta;
        }
        int increment = 5;
        int lines = Math.round((float)dTheta) / increment;
        double theta = theta1;
        int i = 0;
        while (i < lines) {
            sign = sweep ? 1 : -1;
            theta = SvgLoader.clampAngle(theta + (double)(sign * increment));
            double radTheta = Math.toRadians(theta);
            double x = Math.cos(radPhi) * (double)rx * Math.cos(radTheta) - Math.sin(radPhi) * (double)ry * Math.sin(radTheta) + cx;
            double y = Math.sin(radPhi) * (double)rx * Math.cos(radTheta) + Math.cos(radPhi) * (double)ry * Math.sin(radTheta) + cy;
            types.add((byte)2);
            if (i == lines - 1) {
                points.add(Float.valueOf(x2));
                points.add(Float.valueOf(y2));
            } else {
                points.add(Float.valueOf((float)x));
                points.add(Float.valueOf((float)y));
            }
            ++i;
        }
    }

    private static void addPoint(List<Float> points, String s, boolean relative) {
        SvgLoader.addPoint(points, s, relative, 2);
    }

    private static void addPoint(List<Float> points, String s, boolean relative, int relativeOffset) {
        if (relative) {
            points.add(Float.valueOf(points.get(points.size() - relativeOffset).floatValue() + Float.parseFloat(s)));
        } else {
            points.add(new Float(s));
        }
    }

    private static double clampAngle(double deg) {
        if (deg < 0.0) {
            deg += 360.0;
        } else if (deg > 360.0) {
            deg -= 360.0;
        }
        return deg;
    }

    private static float clampAngle(float deg) {
        if (deg < 0.0f) {
            deg += 360.0f;
        } else if (deg > 360.0f) {
            deg -= 360.0f;
        }
        return deg;
    }

    private static int closer(char[] ca, int start, int end) {
        if (start >= 0) {
            char opener = ca[start];
            char closer = SvgLoader.closerChar(opener);
            int count = 1;
            int i = start + 1;
            while (i < ca.length && i <= end) {
                if (ca[i] == opener && ca[i] != closer) {
                    ++count;
                } else if (ca[i] == closer) {
                    if ((closer != '\"' || ca[i - 1] != '\\') && --count == 0) {
                        return i;
                    }
                } else if (ca[i] == '\"') {
                    i = SvgLoader.closer(ca, i, end);
                }
                ++i;
            }
        }
        return -1;
    }

    private static char closerChar(char c) {
        switch (c) {
            case '<': {
                return '>';
            }
            case '(': {
                return ')';
            }
            case '{': {
                return '}';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        return '\u0000';
    }

    private static int findAll(char[] ca, int from, int to, char ... cs) {
        int i = from;
        while (i >= 0 && i < ca.length && i <= to) {
            if (ca[i] == cs[0]) {
                if (cs.length == 1) {
                    return i;
                }
                int j = 1;
                while (j < cs.length && i + j <= to) {
                    if (i + j == ca.length) {
                        return -1;
                    }
                    if (ca[i + j] != cs[j]) break;
                    if (j == cs.length - 1) {
                        return i;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return -1;
    }

    private static int findAny(char[] ca, int from, int to, char ... cs) {
        int i = from;
        while (i >= 0 && i < ca.length && i <= to) {
            char[] cArray = cs;
            int n = cs.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                if (ca[i] == c) {
                    return i;
                }
                ++n2;
            }
            ++i;
        }
        return -1;
    }

    private static int findClosingTag(char[] ca, int start, int end) {
        int s1;
        if (start >= 0 && start < ca.length && start < end && (s1 = SvgLoader.findAny(ca, start, end, ' ', '>')) != -1) {
            char[] opener = new char[s1 - start];
            opener[0] = 60;
            char[] closer = new char[s1 - start + 2];
            closer[0] = 60;
            closer[1] = 47;
            closer[closer.length - 1] = 62;
            int i = start + 1;
            while (i < s1) {
                opener[i - start] = ca[i];
                closer[i - start + 1] = ca[i];
                ++i;
            }
            int count1 = 1;
            int count2 = 1;
            while (i < ca.length) {
                if (ca[i] == '<') {
                    ++count1;
                    if (SvgLoader.isNext(ca, i, opener)) {
                        ++count2;
                    } else if (SvgLoader.isNext(ca, i, closer)) {
                        if (--count2 == 0) {
                            return i;
                        }
                    } else if (SvgLoader.isNext(ca, i, ELEMENT_CDATA)) {
                        i = SvgLoader.findAll(ca, i + ELEMENT_CDATA.length, end, ELEMENT_CDATA_END);
                    }
                } else if (ca[i] == '>') {
                    if (ca[i - 1] == '/') {
                        --count1;
                    }
                    if (count1 == 0) {
                        return i;
                    }
                } else if (ca[i] == '\"') {
                    i = SvgLoader.closer(ca, i, end);
                }
                ++i;
            }
        }
        return -1;
    }

    private static int findNextTag(char[] ca, int start, int end) {
        int s1 = SvgLoader.findAll(ca, start, end, '<');
        if (s1 != -1 && s1 < ca.length - 1) {
            if (ca[s1 + 1] != '/') {
                return s1;
            }
            return SvgLoader.findNextTag(ca, s1 + 1, end);
        }
        return -1;
    }

    private static int forward(char[] ca, int from) {
        int i = from;
        while (i >= 0 && i < ca.length) {
            if (!Character.isWhitespace(ca[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static double getAngle(double ux, double uy, double vx, double vy) {
        double av;
        double dot = ux * vx + uy * vy;
        double au = Math.hypot(ux, uy);
        double alpha = dot / (au * (av = Math.hypot(vx, vy)));
        if (alpha > 1.0) {
            alpha = 1.0;
        } else if (alpha < -1.0) {
            alpha = -1.0;
        }
        double theta = 180.0 * Math.acos(alpha) / Math.PI;
        if (ux * vy - uy * vx < 0.0) {
            theta *= -1.0;
        }
        return theta;
    }

    private static String getAttrValue(char[] ca, int start, int end, char ... name) {
        char[] search = new char[name.length + 2];
        System.arraycopy(name, 0, search, 1, name.length);
        search[0] = 32;
        search[search.length - 1] = 61;
        int s1 = SvgLoader.findAll(ca, start, end, search);
        if (s1 != -1 && (s1 = SvgLoader.findAll(ca, s1, end, '\"')) != -1) {
            int s2 = SvgLoader.closer(ca, s1, end);
            if (s1 != -1) {
                return new String(ca, s1 + 1, s2 - s1 - 1);
            }
        }
        return null;
    }

    private static int[] getAttrValueRange(char[] ca, int start, int end, char ... name) {
        char[] search = new char[name.length + 2];
        System.arraycopy(name, 0, search, 1, name.length);
        search[0] = 32;
        search[search.length - 1] = 61;
        int s1 = SvgLoader.findAll(ca, start, end, search);
        if (s1 != -1 && (s1 = SvgLoader.findAll(ca, s1, end, '\"')) != -1) {
            int s2 = SvgLoader.closer(ca, s1, end);
            if (s1 != -1) {
                return new int[]{s1 + 1, s2 - 1};
            }
        }
        return new int[]{-1, -1};
    }

    private static Map<String, String> getClassStyles(SvgElement element, char[] ca, int start, int end) {
        String s = SvgLoader.getAttrValue(ca, start, end, ATTR_CLASS);
        if (s != null) {
            String[] classes;
            HashMap<String, String> styles = new HashMap<String, String>();
            String[] stringArray = classes = s.trim().split(" +");
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                Map<String, String> pairs = element.getFragment().getStyles("." + c);
                if (pairs != null) {
                    styles.putAll(pairs);
                }
                ++n2;
            }
            return styles;
        }
        return new HashMap<String, String>(0);
    }

    private static Integer getColorAsInt(String color) {
        if (color != null) {
            if (SvgColors.contains(color)) {
                return SvgColors.get(color);
            }
            if ('#' == color.charAt(0)) {
                if (color.length() == 4) {
                    char[] ca = new char[]{color.charAt(1), color.charAt(1), color.charAt(2), color.charAt(2), color.charAt(3), color.charAt(3)};
                    return Integer.parseInt(new String(ca), 16);
                }
                if (color.length() == 7) {
                    return Integer.parseInt(color.substring(1), 16);
                }
            }
        }
        return null;
    }

    private static Map<String, String> getIdStyles(SvgElement element, char[] ca, int start, int end) {
        String s = element.getId();
        if (s != null) {
            HashMap<String, String> styles = new HashMap<String, String>();
            Map<String, String> pairs = element.getFragment().getStyles("#" + s);
            if (pairs != null) {
                styles.putAll(pairs);
            }
            return styles;
        }
        return new HashMap<String, String>(0);
    }

    private static String getLink(String link) {
        urlMatcher.reset(link);
        if (urlMatcher.matches()) {
            return urlMatcher.group(1);
        }
        return null;
    }

    private static SvgTransform getTransform(char[] ca, int[] range) {
        int s1 = range[0];
        SvgTransform first = null;
        SvgTransform transform = null;
        while (s1 != -1 && s1 < range[1]) {
            int s2 = SvgLoader.findAll(ca, s1, range[1], '(');
            int s3 = SvgLoader.findAll(ca, s2, range[1], ')');
            if (s1 != -1 && s2 != -1 && s3 != -1) {
                if (transform == null) {
                    first = transform = new SvgTransform();
                } else {
                    transform = transform.next = new SvgTransform();
                }
                if (SvgLoader.isEqual(ca, s1, s2 - 1, "matrix".toCharArray())) {
                    transform.setData(SvgTransform.Type.Matrix, new String(ca, s2 + 1, s3 - s2 - 1).split(paramRegex));
                } else if (SvgLoader.isEqual(ca, s1, s2 - 1, "translate".toCharArray())) {
                    transform.setData(SvgTransform.Type.Translate, new String(ca, s2 + 1, s3 - s2 - 1).split(paramRegex));
                } else if (SvgLoader.isEqual(ca, s1, s2 - 1, "scale".toCharArray())) {
                    transform.setData(SvgTransform.Type.Scale, new String(ca, s2 + 1, s3 - s2 - 1).split(paramRegex));
                } else if (SvgLoader.isEqual(ca, s1, s2 - 1, "rotate".toCharArray())) {
                    transform.setData(SvgTransform.Type.Rotate, new String(ca, s2 + 1, s3 - s2 - 1).split(paramRegex));
                } else if (SvgLoader.isEqual(ca, s1, s2 - 1, "skewx".toCharArray())) {
                    transform.setData(SvgTransform.Type.SkewX, new String(ca, s2 + 1, s3 - s2 - 1).split(paramRegex));
                } else if (SvgLoader.isEqual(ca, s1, s2 - 1, "skewy".toCharArray())) {
                    transform.setData(SvgTransform.Type.SkewY, new String(ca, s2 + 1, s3 - s2 - 1).split(paramRegex));
                }
            }
            s1 = SvgLoader.forward(ca, s3 + 1);
        }
        if (first != null) {
            return first;
        }
        return new SvgTransform();
    }

    private static String getValue(String name, Map<String, String> idStyles, Map<String, String> classStyles, Map<String, String> attrStyles, String attrValue) {
        return SvgLoader.getValue(name, idStyles, classStyles, attrStyles, attrValue, null);
    }

    private static String getValue(String name, Map<String, String> idStyles, Map<String, String> classStyles, Map<String, String> attrStyles, String attrValue, String defaultValue) {
        if (attrValue != null) {
            return attrValue;
        }
        if (attrStyles.containsKey(name)) {
            return attrStyles.get(name);
        }
        if (classStyles.containsKey(name)) {
            return classStyles.get(name);
        }
        if (idStyles.containsKey(name)) {
            return idStyles.get(name);
        }
        return defaultValue;
    }

    private static boolean isEqual(char[] ca, int start, int end, char ... test) {
        if (test.length != end - start + 1) {
            return false;
        }
        int i = start;
        int j = 0;
        while (i < end && j < test.length) {
            if (ca[i] != test[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static boolean isNext(char[] ca, int start, char ... test) {
        int i = start;
        int j = 0;
        while (j < test.length) {
            if (ca[i] != test[j]) {
                return false;
            }
            ++i;
            ++j;
        }
        return true;
    }

    private static boolean isTag(char[] ca, int start, char[] tagName) {
        if (start >= 0 && start < ca.length && ca[start] == '<') {
            int i = start + 1;
            int j = 0;
            while (i < ca.length && j < tagName.length) {
                if (ca[i] != tagName[j]) {
                    return false;
                }
                ++i;
                ++j;
            }
            if (i < ca.length) {
                return ca[i] == ' ' || ca[i] == '>';
            }
        }
        return false;
    }

    static SvgDocument load(InputStream in) {
        StringBuilder sb = new StringBuilder();
        BufferedInputStream bis = new BufferedInputStream(in);
        try {
            int i;
            while ((i = bis.read()) != -1) {
                char c = (char)i;
                if (Character.isWhitespace(c)) {
                    if (' ' == sb.charAt(sb.length() - 1)) continue;
                    sb.append(' ');
                    continue;
                }
                sb.append(c);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        char[] ca = new char[sb.length()];
        sb.getChars(0, sb.length(), ca, 0);
        SvgDocument doc = new SvgDocument();
        SvgLoader.parse(doc, ca, 0, ca.length - 1);
        return doc;
    }

    static SvgDocument load(String src) {
        SvgDocument doc = new SvgDocument();
        SvgLoader.parse(doc, src.toCharArray(), 0, src.length() - 1);
        return doc;
    }

    private static void parse(SvgContainer container, char[] ca, int start, int end) {
        int s1 = start;
        while (s1 != -1 && s1 < end) {
            if (SvgLoader.isTag(ca, s1 = SvgLoader.findNextTag(ca, s1, end), ELEMENT_GROUP)) {
                s1 = SvgLoader.parseGroup(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_TITLE)) {
                s1 = SvgLoader.parseTitle(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_DESCRIPTION)) {
                s1 = SvgLoader.parseDescription(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_SVG)) {
                s1 = SvgLoader.parseSvg(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_STYLE)) {
                s1 = SvgLoader.parseStyle(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_USE)) {
                s1 = SvgLoader.parseUse(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_PATH)) {
                s1 = SvgLoader.parsePath(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_CIRCLE)) {
                s1 = SvgLoader.parseCircle(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_ELLIPSE)) {
                s1 = SvgLoader.parseEllipse(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_LINE)) {
                s1 = SvgLoader.parseLine(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_POLYGON)) {
                s1 = SvgLoader.parsePolygon(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_POLYLINE)) {
                s1 = SvgLoader.parsePolyline(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_RECT)) {
                s1 = SvgLoader.parseRectangle(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_LINEAR_GRADIENT)) {
                s1 = SvgLoader.parseLinearGradient(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_RADIAL_GRADIENT)) {
                s1 = SvgLoader.parseRadialGradient(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_DEFS)) {
                s1 = SvgLoader.parseDefs(container, ca, s1, end);
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_XML) || SvgLoader.isTag(ca, s1, ELEMENT_DOCTYPE)) {
                s1 = SvgLoader.findAll(ca, s1, end, '>');
                continue;
            }
            if (SvgLoader.isTag(ca, s1, ELEMENT_COMMENT)) {
                s1 = SvgLoader.findAll(ca, s1, end, ELEMENT_COMMENT_END);
                continue;
            }
            if (s1 != -1) {
                int s2 = SvgLoader.findAny(ca, s1, end, ' ', '>');
                System.out.println("dunno: " + new String(ca, s1 + 1, s2 - s1 - 1));
            }
            s1 = SvgLoader.findClosingTag(ca, s1, end);
        }
    }

    private static int parseCircle(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgShape element = new SvgShape(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            element.pathData = new PathData();
            element.pathData.points = new float[4];
            element.pathData.points[0] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_CX), 0.0f);
            element.pathData.points[1] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_CY), 0.0f);
            element.pathData.points[2] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_R)).floatValue();
            element.pathData.points[3] = element.pathData.points[2];
            SvgLoader.parseFill(element, ca, start, endAttrs);
            SvgLoader.parseStroke(element, ca, start, endAttrs);
            element.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_TRANSFORM));
        }
        return end;
    }

    private static void parseCss(SvgStyle element, char[] ca, int start, int end) {
        HashMap<String, Map<String, String>> styles = new HashMap<String, Map<String, String>>();
        int s1 = SvgLoader.forward(ca, start);
        int s = SvgLoader.findAll(ca, s1, end, '{');
        int s2 = SvgLoader.reverse(ca, s - 1);
        while (s1 != -1 && s2 != -1) {
            String names = new String(ca, s1, s2 - s1 + 1);
            s2 = SvgLoader.closer(ca, s, end);
            if (s2 == -1) continue;
            Map<String, String> pairs = SvgLoader.parseStyles(ca, s + 1, s2 - 1);
            String[] stringArray = names.split(" *, *");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                Map existing = (Map)styles.get(name);
                if (existing != null) {
                    HashMap<String, String> m = new HashMap<String, String>();
                    m.putAll(existing);
                    m.putAll(pairs);
                    styles.put(name, m);
                } else {
                    styles.put(name, pairs);
                }
                ++n2;
            }
            s1 = SvgLoader.forward(ca, s2 + 1);
            s = SvgLoader.findAll(ca, s1, end, '{');
            s2 = SvgLoader.reverse(ca, s - 1);
        }
        element.styles = styles;
    }

    private static int parseDefs(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgContainer element = new SvgContainer(container, "defs");
            element.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_TRANSFORM));
            SvgLoader.parse(element, ca, endAttrs, end);
        }
        return end;
    }

    private static int parseDescription(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1 && (start = SvgLoader.closer(ca, start, end)) != -1) {
            container.description = new String(ca, start + 1, end - start - 1);
        }
        return end;
    }

    private static int parseEllipse(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgShape element = new SvgShape(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            element.pathData = new PathData();
            element.pathData.points = new float[4];
            element.pathData.points[0] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_CX), 0.0f);
            element.pathData.points[1] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_CY), 0.0f);
            element.pathData.points[2] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_RX)).floatValue();
            element.pathData.points[3] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_RY)).floatValue();
            SvgLoader.parseFill(element, ca, start, endAttrs);
            SvgLoader.parseStroke(element, ca, start, endAttrs);
            element.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_TRANSFORM));
        }
        return end;
    }

    private static void parseFill(SvgGraphic element, char[] ca, int start, int end) {
        Map<String, String> idStyles = SvgLoader.getIdStyles(element, ca, start, end);
        Map<String, String> classStyles = SvgLoader.getClassStyles(element, ca, start, end);
        Map<String, String> attrStyles = SvgLoader.parseStyles(SvgLoader.getAttrValue(ca, start, end, ATTR_STYLE));
        String s = SvgLoader.getValue("fill", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, end, ATTR_FILL));
        SvgLoader.parsePaint(element.fill, s);
        s = SvgLoader.getValue("fill-opacity", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, end, ATTR_FILL_OPACITY));
        element.fill.opacity = SvgLoader.parseFloat(s);
        s = SvgLoader.getValue("fill-rule", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, end, ATTR_FILL_RULE));
        element.fill.rule = SvgLoader.parseRule(s);
    }

    private static Float parseFloat(String s) {
        return SvgLoader.parseFloat(s, null);
    }

    private static float parseFloat(String s, float defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Float.parseFloat(s);
    }

    private static Float parseFloat(String s, Float defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return new Float(s);
    }

    private static int parseGradientStop(SvgGradient gradient, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgGradientStop stop = new SvgGradientStop(gradient, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            Map<String, String> idStyles = SvgLoader.getIdStyles(stop, ca, start, endAttrs);
            Map<String, String> classStyles = SvgLoader.getClassStyles(stop, ca, start, endAttrs);
            Map<String, String> attrStyles = SvgLoader.parseStyles(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_STYLE));
            String s = SvgLoader.getValue("offset", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_OFFSET));
            stop.offset = SvgLoader.parsePercentage(s, Float.valueOf(0.0f), true);
            s = SvgLoader.getValue("stop-color", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_STOP_COLOR));
            stop.color = SvgLoader.getColorAsInt(s);
            s = SvgLoader.getValue("stop-opacity", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_STOP_OPACITY), "1");
            stop.opacity = SvgLoader.parseFloat(s);
            gradient.stops.add(stop);
        }
        return end;
    }

    private static int parseGroup(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgContainer element = new SvgContainer(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            SvgLoader.parseFill(element, ca, start, endAttrs);
            SvgLoader.parseStroke(element, ca, start, endAttrs);
            element.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_TRANSFORM));
            SvgLoader.parse(element, ca, endAttrs, end);
        }
        return end;
    }

    private static float parseLength(String s, String defaultString) {
        if (s == null) {
            s = defaultString;
        }
        if (s.endsWith("%")) {
            throw new UnsupportedOperationException("TODO parseLength: %");
        }
        if (s.endsWith("cm")) {
            final Point dpi = new Point(0, 0);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    dpi.x = Display.getDefault().getDPI().x;
                }
            });
            return Float.parseFloat(s.substring(0, s.length() - 2)) * (float)dpi.x * 0.39370078f;
        }
        if (s.endsWith("em")) {
            throw new UnsupportedOperationException("TODO parseLength: em");
        }
        if (s.endsWith("ex")) {
            throw new UnsupportedOperationException("TODO parseLength: ex");
        }
        if (s.endsWith("in")) {
            final Point dpi = new Point(0, 0);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    dpi.x = Display.getDefault().getDPI().x;
                }
            });
            return Float.parseFloat(s.substring(0, s.length() - 2)) * (float)dpi.x;
        }
        if (s.endsWith("mm")) {
            final Point dpi = new Point(0, 0);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    dpi.x = Display.getDefault().getDPI().x;
                }
            });
            return Float.parseFloat(s.substring(0, s.length() - 2)) * (float)dpi.x * 0.03937008f;
        }
        if (s.endsWith("pc")) {
            throw new UnsupportedOperationException("TODO parseLength: pc");
        }
        if (s.endsWith("pt")) {
            throw new UnsupportedOperationException("TODO parseLength: pt");
        }
        if (s.endsWith("px")) {
            return Float.parseFloat(s.substring(0, s.length() - 2));
        }
        return Float.parseFloat(s);
    }

    private static int parseLine(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgShape element = new SvgShape(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            element.pathData = new PathData();
            element.pathData.types = new byte[2];
            element.pathData.points = new float[4];
            element.pathData.types[0] = 1;
            element.pathData.points[0] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_X1), 0.0f);
            element.pathData.points[1] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_Y1), 0.0f);
            element.pathData.types[1] = 2;
            element.pathData.points[2] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_X2), 0.0f);
            element.pathData.points[3] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_Y2), 0.0f);
            SvgLoader.parseFill(element, ca, start, endAttrs);
            SvgLoader.parseStroke(element, ca, start, endAttrs);
        }
        return end;
    }

    private static int parseLinearGradient(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgGradient gradient = new SvgGradient(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            gradient.data = new float[4];
            gradient.data[0] = SvgLoader.parsePercentage(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_X1), Float.valueOf(0.0f), false).floatValue();
            gradient.data[1] = SvgLoader.parsePercentage(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_Y1), Float.valueOf(0.0f), false).floatValue();
            gradient.data[2] = SvgLoader.parsePercentage(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_X2), Float.valueOf(1.0f), false).floatValue();
            gradient.data[3] = SvgLoader.parsePercentage(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_Y2), Float.valueOf(0.0f), false).floatValue();
            gradient.setLinkId(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_XLINK_HREF));
            gradient.setSpreadMethod(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_SPREAD_METHOD));
            gradient.setUnits(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_GRADIENT_UNITS));
            gradient.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_GRADIENT_TRANSFORM));
            int s1 = endAttrs;
            while (s1 != -1 && s1 < end) {
                if (!SvgLoader.isNext(ca, (s1 = SvgLoader.findNextTag(ca, s1 + 1, end)) + 1, ATTR_STOP)) continue;
                s1 = SvgLoader.parseGradientStop(gradient, ca, s1, end);
            }
        }
        return end;
    }

    private static String parseLinkId(String id) {
        if (id != null && id.length() > 2 && '#' == id.charAt(0)) {
            return id.substring(1);
        }
        return null;
    }

    private static void parsePaint(SvgPaint paint, String s) {
        if (s != null) {
            if ("none".equals(s)) {
                paint.type = SvgPaint.PaintType.None;
            } else if ("currentColor".equals(s)) {
                paint.type = SvgPaint.PaintType.Current;
            } else if (s.startsWith("url")) {
                paint.type = SvgPaint.PaintType.Link;
                paint.linkId = SvgLoader.getLink(s);
            } else {
                Integer i = SvgLoader.getColorAsInt(s);
                if (i != null) {
                    paint.type = SvgPaint.PaintType.Color;
                    paint.color = i;
                } else {
                    paint.type = SvgPaint.PaintType.None;
                    System.out.println("dunno fill " + paint);
                }
            }
        }
    }

    private static int parsePath(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgShape element = new SvgShape(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            SvgLoader.parseFill(element, ca, start, endAttrs);
            SvgLoader.parseStroke(element, ca, start, endAttrs);
            SvgLoader.parsePathData(element, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_D));
            element.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_TRANSFORM));
        }
        return end;
    }

    public static void parsePathData(SvgShape path, String data) {
        String[] sa = SvgLoader.parsePathDataStrings(data);
        ArrayList<Byte> types = new ArrayList<Byte>();
        ArrayList<Float> points = new ArrayList<Float>();
        int i = -1;
        while (i < sa.length - 1) {
            boolean relative = Character.isLowerCase(sa[++i].charAt(0));
            switch (sa[i].charAt(0)) {
                case 'M': 
                case 'm': {
                    types.add((byte)1);
                    SvgLoader.addPoint(points, sa[++i], relative);
                    SvgLoader.addPoint(points, sa[++i], relative);
                    break;
                }
                case 'L': 
                case 'l': {
                    types.add((byte)2);
                    SvgLoader.addPoint(points, sa[++i], relative);
                    SvgLoader.addPoint(points, sa[++i], relative);
                    break;
                }
                case 'H': 
                case 'h': {
                    types.add((byte)2);
                    SvgLoader.addPoint(points, sa[++i], relative);
                    points.add((Float)points.get(points.size() - 2));
                    break;
                }
                case 'V': 
                case 'v': {
                    types.add((byte)2);
                    points.add((Float)points.get(points.size() - 2));
                    SvgLoader.addPoint(points, sa[++i], relative);
                    break;
                }
                case 'C': 
                case 'c': {
                    types.add((byte)4);
                    SvgLoader.addPoint(points, sa[++i], relative);
                    SvgLoader.addPoint(points, sa[++i], relative);
                    SvgLoader.addPoint(points, sa[++i], relative, 4);
                    SvgLoader.addPoint(points, sa[++i], relative, 4);
                    SvgLoader.addPoint(points, sa[++i], relative, 6);
                    SvgLoader.addPoint(points, sa[++i], relative, 6);
                    break;
                }
                case 'S': 
                case 's': {
                    float y1;
                    float x1;
                    float y;
                    float x;
                    float y2;
                    float x2;
                    types.add((byte)4);
                    if (4 == (Byte)types.get(types.size() - 2)) {
                        x2 = ((Float)points.get(points.size() - 4)).floatValue();
                        y2 = ((Float)points.get(points.size() - 3)).floatValue();
                        x = ((Float)points.get(points.size() - 2)).floatValue();
                        y = ((Float)points.get(points.size() - 1)).floatValue();
                        x1 = 2.0f * x - x2;
                        y1 = 2.0f * y - y2;
                        points.add(Float.valueOf(x1));
                        points.add(Float.valueOf(y1));
                    } else {
                        points.add((Float)points.get(points.size() - 2));
                        points.add((Float)points.get(points.size() - 2));
                    }
                    SvgLoader.addPoint(points, sa[++i], relative, 4);
                    SvgLoader.addPoint(points, sa[++i], relative, 4);
                    SvgLoader.addPoint(points, sa[++i], relative, 6);
                    SvgLoader.addPoint(points, sa[++i], relative, 6);
                    break;
                }
                case 'Q': 
                case 'q': {
                    types.add((byte)3);
                    SvgLoader.addPoint(points, sa[++i], relative);
                    SvgLoader.addPoint(points, sa[++i], relative);
                    SvgLoader.addPoint(points, sa[++i], relative, 4);
                    SvgLoader.addPoint(points, sa[++i], relative, 4);
                    break;
                }
                case 'T': 
                case 't': {
                    float y1;
                    float x1;
                    float y;
                    float x;
                    float y2;
                    float x2;
                    types.add((byte)3);
                    if (3 == (Byte)types.get(types.size() - 2)) {
                        x2 = ((Float)points.get(points.size() - 4)).floatValue();
                        y2 = ((Float)points.get(points.size() - 3)).floatValue();
                        x = ((Float)points.get(points.size() - 2)).floatValue();
                        y = ((Float)points.get(points.size() - 1)).floatValue();
                        x1 = 2.0f * x - x2;
                        y1 = 2.0f * y - y2;
                        points.add(Float.valueOf(x1));
                        points.add(Float.valueOf(y1));
                    } else {
                        points.add((Float)points.get(points.size() - 2));
                        points.add((Float)points.get(points.size() - 2));
                    }
                    SvgLoader.addPoint(points, sa[++i], relative, 4);
                    SvgLoader.addPoint(points, sa[++i], relative, 4);
                    break;
                }
                case 'Z': 
                case 'z': {
                    types.add((byte)5);
                    break;
                }
                case 'A': 
                case 'a': {
                    SvgLoader.addArc(sa, ++i, types, points, relative);
                    i += 6;
                }
            }
        }
        path.pathData = new PathData();
        path.pathData.types = new byte[types.size()];
        i = 0;
        while (i < types.size()) {
            path.pathData.types[i] = (Byte)types.get(i);
            ++i;
        }
        path.pathData.points = new float[points.size()];
        i = 0;
        while (i < points.size()) {
            path.pathData.points[i] = ((Float)points.get(i)).floatValue();
            ++i;
        }
    }

    private static String[] parsePathDataStrings(String data) {
        ArrayList<String> strs = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        char[] ca = data.toCharArray();
        int i = 0;
        while (i < ca.length) {
            char c = ca[i];
            if ('e' == c) {
                sb.append(c);
                if (i < ca.length - 1 && ca[i + 1] == '-') {
                    sb.append(ca[++i]);
                }
            } else if (Character.isLetter(c)) {
                if (sb != null && sb.length() > 0) {
                    strs.add(sb.toString());
                }
                strs.add(Character.toString(c));
                sb = new StringBuilder();
            } else if ('.' == c || Character.isDigit(c)) {
                sb.append(c);
            } else {
                if (sb != null && sb.length() > 0) {
                    strs.add(sb.toString());
                }
                sb = new StringBuilder();
                if ('-' == c) {
                    sb.append(c);
                }
            }
            ++i;
        }
        if (sb != null && sb.length() > 0) {
            strs.add(sb.toString());
        }
        return strs.toArray(new String[strs.size()]);
    }

    private static Float parsePercentage(String s, Float defaultValue, boolean clamp) {
        if (s != null) {
            Float offset = '%' == s.charAt(s.length() - 1) ? Float.valueOf(Float.parseFloat(s.substring(0, s.length() - 1)) / 100.0f) : Float.valueOf(Float.parseFloat(s));
            if (clamp) {
                if (offset.floatValue() > 1.0f) {
                    offset = new Float(1.0f);
                } else if (offset.floatValue() < 0.0f) {
                    offset = new Float(0.0f);
                }
            }
            return offset;
        }
        return defaultValue;
    }

    private static float[] parsePoints(String s) {
        if (s != null) {
            String[] sa = s.trim().split("[ ,]");
            float[] points = new float[sa.length];
            int i = 0;
            while (i < sa.length) {
                points[i] = SvgLoader.parseFloat(sa[i]).floatValue();
                ++i;
            }
            return points;
        }
        return new float[0];
    }

    private static int parsePolygon(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgShape element = new SvgShape(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            float[] linePoints = SvgLoader.parsePoints(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_POINTS));
            element.pathData = new PathData();
            element.pathData.types = new byte[1 + linePoints.length / 2];
            element.pathData.points = new float[linePoints.length];
            element.pathData.types[0] = 1;
            element.pathData.points[0] = linePoints[0];
            element.pathData.points[1] = linePoints[1];
            int i = 2;
            int j = 1;
            while (i < linePoints.length - 1) {
                element.pathData.types[j++] = 2;
                element.pathData.points[i] = linePoints[i++];
                element.pathData.points[i] = linePoints[i++];
            }
            element.pathData.types[element.pathData.types.length - 1] = 5;
            SvgLoader.parseFill(element, ca, start, endAttrs);
            SvgLoader.parseStroke(element, ca, start, endAttrs);
            element.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_TRANSFORM));
        }
        return end;
    }

    private static int parsePolyline(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgShape element = new SvgShape(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            float[] linePoints = SvgLoader.parsePoints(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_POINTS));
            element.pathData = new PathData();
            element.pathData.types = new byte[linePoints.length / 2];
            element.pathData.points = new float[linePoints.length];
            element.pathData.types[0] = 1;
            element.pathData.points[0] = linePoints[0];
            element.pathData.points[1] = linePoints[1];
            int i = 2;
            int j = 1;
            while (i < linePoints.length - 1) {
                element.pathData.types[j++] = 2;
                element.pathData.points[i] = linePoints[i++];
                element.pathData.points[i] = linePoints[i++];
            }
            SvgLoader.parseFill(element, ca, start, endAttrs);
            SvgLoader.parseStroke(element, ca, start, endAttrs);
            element.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_TRANSFORM));
        }
        return end;
    }

    private static int parseRadialGradient(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgGradient gradient = new SvgGradient(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            gradient.data = new float[5];
            gradient.data[0] = SvgLoader.parsePercentage(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_CX), null, false).floatValue();
            gradient.data[1] = SvgLoader.parsePercentage(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_CY), null, false).floatValue();
            gradient.data[2] = SvgLoader.parsePercentage(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_FX), Float.valueOf(gradient.data[0]), false).floatValue();
            gradient.data[3] = SvgLoader.parsePercentage(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_FY), Float.valueOf(gradient.data[1]), false).floatValue();
            gradient.data[4] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_R)).floatValue();
            gradient.setLinkId(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_XLINK_HREF));
            gradient.setSpreadMethod(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_SPREAD_METHOD));
            gradient.setUnits(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_GRADIENT_UNITS));
            gradient.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_GRADIENT_TRANSFORM));
            int s1 = endAttrs;
            while (s1 != -1 && s1 < end) {
                if (!SvgLoader.isNext(ca, (s1 = SvgLoader.findNextTag(ca, s1 + 1, end)) + 1, ATTR_STOP)) continue;
                s1 = SvgLoader.parseGradientStop(gradient, ca, s1, end);
            }
        }
        return end;
    }

    private static int parseRectangle(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgShape element = new SvgShape(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            element.pathData = new PathData();
            element.pathData.points = new float[6];
            element.pathData.points[0] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_X)).floatValue();
            element.pathData.points[1] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_Y)).floatValue();
            element.pathData.points[2] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_WIDTH)).floatValue();
            element.pathData.points[3] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_HEIGHT)).floatValue();
            element.pathData.points[4] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_RX), 0.0f);
            element.pathData.points[5] = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_RY), 0.0f);
            SvgLoader.parseFill(element, ca, start, endAttrs);
            SvgLoader.parseStroke(element, ca, start, endAttrs);
            element.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_TRANSFORM));
        }
        return end;
    }

    private static Integer parseRule(String s) {
        if (s != null) {
            if ("evenodd".equals(s)) {
                return 1;
            }
            if ("winding".equals(s)) {
                return 2;
            }
        }
        return null;
    }

    private static void parseStroke(SvgGraphic element, char[] ca, int start, int end) {
        Map<String, String> idStyles = SvgLoader.getIdStyles(element, ca, start, end);
        Map<String, String> classStyles = SvgLoader.getClassStyles(element, ca, start, end);
        Map<String, String> attrStyles = SvgLoader.parseStyles(SvgLoader.getAttrValue(ca, start, end, ATTR_STYLE));
        String s = SvgLoader.getValue("stroke", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, end, ATTR_STROKE));
        SvgLoader.parsePaint(element.stroke, s);
        s = SvgLoader.getValue("stroke-opacity", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, end, ATTR_STROKE_OPACITY));
        element.stroke.opacity = SvgLoader.parseFloat(s);
        s = SvgLoader.getValue("stroke-width", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, end, ATTR_STROKE_WIDTH));
        element.stroke.width = SvgLoader.parseStrokeWidth(s);
        s = SvgLoader.getValue("stroke-linecap", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, end, ATTR_STROKE_CAP));
        element.stroke.lineCap = SvgLoader.parseStrokeLineCap(s);
        s = SvgLoader.getValue("stroke-linejoin", idStyles, classStyles, attrStyles, SvgLoader.getAttrValue(ca, start, end, ATTR_STROKE_JOIN));
        element.stroke.lineJoin = SvgLoader.parseStrokeLineJoin(s);
    }

    private static Integer parseStrokeLineCap(String s) {
        if (s != null) {
            if ("butt".equals(s)) {
                return 1;
            }
            if ("round".equals(s)) {
                return 2;
            }
            if ("square".equals(s)) {
                return 3;
            }
        }
        return null;
    }

    private static Integer parseStrokeLineJoin(String s) {
        if (s != null) {
            if ("bevel".equals(s)) {
                return 3;
            }
            if ("miter".equals(s)) {
                return 1;
            }
            if ("round".equals(s)) {
                return 2;
            }
        }
        return null;
    }

    private static Float parseStrokeWidth(String s) {
        if (s != null) {
            if (s.endsWith("px")) {
                return new Float(s.substring(0, s.length() - 2));
            }
            return new Float(s);
        }
        return null;
    }

    private static int parseStyle(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endData = SvgLoader.closer(ca, start, end);
            SvgStyle element = new SvgStyle(container);
            int cd1 = SvgLoader.findAll(ca, start, end, ELEMENT_CDATA);
            if (cd1 != -1) {
                start = cd1 + ELEMENT_CDATA.length;
                endData = SvgLoader.findAll(ca, start, end, ELEMENT_CDATA_END);
            } else {
                start = endData + 1;
                endData = end;
            }
            SvgLoader.parseCss(element, ca, start, endData);
        }
        return end;
    }

    private static Map<String, String> parseStyles(char[] ca, int start, int end) {
        HashMap<String, String> styles = new HashMap<String, String>();
        int len = end - start + 1;
        if (len > 0 && start + len <= ca.length) {
            String[] sa;
            String[] stringArray = sa = new String(ca, start, end - start + 1).trim().split(" *; *");
            int n = sa.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                String[] sa2 = s.split(" *: *");
                if (sa2.length == 2) {
                    styles.put(sa2[0], sa2[1]);
                }
                ++n2;
            }
        }
        return styles;
    }

    private static Map<String, String> parseStyles(String styles) {
        if (styles != null) {
            return SvgLoader.parseStyles(styles.toCharArray(), 0, styles.length() - 1);
        }
        return new HashMap<String, String>(0);
    }

    private static int parseSvg(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgFragment element = new SvgFragment(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            if (container != null) {
                element.x = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_X));
                element.y = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_Y));
            }
            element.width = Float.valueOf(SvgLoader.parseLength(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_WIDTH), "100%"));
            element.height = Float.valueOf(SvgLoader.parseLength(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_HEIGHT), "100%"));
            element.viewBox = SvgLoader.parseViewBox(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_VIEWBOX));
            SvgLoader.parse(element, ca, endAttrs, end);
        }
        return end;
    }

    private static int parseTitle(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1 && (start = SvgLoader.closer(ca, start, end)) != -1) {
            container.title = new String(ca, start + 1, end - start - 1);
        }
        return end;
    }

    private static int parseUse(SvgContainer container, char[] ca, int start, int end) {
        if ((end = SvgLoader.findClosingTag(ca, start, end)) != -1) {
            int endAttrs = SvgLoader.closer(ca, start, end);
            SvgUse element = new SvgUse(container, SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_ID));
            element.x = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_X), 0.0f);
            element.y = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_Y), 0.0f);
            element.w = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_WIDTH));
            element.h = SvgLoader.parseFloat(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_HEIGHT));
            element.linkId = SvgLoader.parseLinkId(SvgLoader.getAttrValue(ca, start, endAttrs, ATTR_XLINK_HREF));
            element.transform = SvgLoader.getTransform(ca, SvgLoader.getAttrValueRange(ca, start, endAttrs, ATTR_TRANSFORM));
        }
        return end;
    }

    private static float[] parseViewBox(String s) {
        if (s != null) {
            float[] vb = new float[4];
            String[] sa = s.split(paramRegex);
            if (sa.length == 4) {
                vb[0] = Float.parseFloat(sa[0]);
                vb[1] = Float.parseFloat(sa[1]);
                vb[2] = Float.parseFloat(sa[2]);
                vb[3] = Float.parseFloat(sa[3]);
                return vb;
            }
        }
        return null;
    }

    private static int reverse(char[] ca, int from) {
        int i = from;
        while (i >= 0 && i < ca.length) {
            if (!Character.isWhitespace(ca[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    private SvgLoader() {
    }
}

