/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.internal.dialogs.WorkbenchWizardElement;
import org.eclipse.ui.internal.registry.Category;
import org.eclipse.ui.internal.registry.RegistryReader;

public class WizardsRegistryReader
extends RegistryReader {
    private String pluginPoint;
    private WizardCollectionElement wizardElements = null;
    private ArrayList<WorkbenchWizardElement> deferWizards = null;
    private ArrayList<Category> deferCategories = null;
    private Set<String> deferPrimary;
    public static final String FULL_EXAMPLES_WIZARD_CATEGORY = "org.eclipse.ui.Examples";
    public static final String UNCATEGORIZED_WIZARD_CATEGORY = "org.eclipse.ui.Other";
    public static final String GENERAL_WIZARD_CATEGORY = "org.eclipse.ui.Basic";
    private static final String UNCATEGORIZED_WIZARD_CATEGORY_LABEL = WorkbenchMessages.NewWizardsRegistryReader_otherCategory;
    private static final String CATEGORY_SEPARATOR = "/";
    private WorkbenchWizardElement[] primaryWizards = new WorkbenchWizardElement[0];
    private static final Comparator<CategoryNode> comparer = new Comparator<CategoryNode>(){
        private Collator collator = Collator.getInstance();

        @Override
        public int compare(CategoryNode arg0, CategoryNode arg1) {
            String s1 = arg0.getPath();
            String s2 = arg1.getPath();
            return this.collator.compare(s1, s2);
        }
    };
    private boolean readAll = true;
    private String plugin;

    public WizardsRegistryReader(String pluginId, String pluginPointId) {
        this.pluginPoint = pluginPointId;
        this.plugin = pluginId;
    }

    protected void addNewElementToResult(WorkbenchWizardElement element, IConfigurationElement config) {
        this.deferWizard(element);
    }

    private WizardCollectionElement createCollectionElement(WizardCollectionElement parent, IConfigurationElement element) {
        WizardCollectionElement newElement = new WizardCollectionElement(element, parent);
        parent.add(newElement);
        return newElement;
    }

    protected WizardCollectionElement createCollectionElement(WizardCollectionElement parent, String id, String pluginId, String label) {
        WizardCollectionElement newElement = new WizardCollectionElement(id, pluginId, label, parent);
        parent.add(newElement);
        return newElement;
    }

    protected void createEmptyWizardCollection() {
        this.wizardElements = new WizardCollectionElement("root", null, "root", null);
    }

    public void setInitialCollection(WizardCollectionElement wizards) {
        this.wizardElements = wizards;
        this.readAll = false;
    }

    private void deferCategory(IConfigurationElement config) {
        Category category = null;
        try {
            category = new Category(config);
        }
        catch (CoreException e) {
            WorkbenchPlugin.log("Cannot create category: ", e.getStatus());
            return;
        }
        if (this.deferCategories == null) {
            this.deferCategories = new ArrayList(20);
        }
        this.deferCategories.add(category);
    }

    private void deferWizard(WorkbenchWizardElement element) {
        if (this.deferWizards == null) {
            this.deferWizards = new ArrayList(50);
        }
        this.deferWizards.add(element);
    }

    private void finishCategories() {
        if (this.deferCategories == null) {
            return;
        }
        CategoryNode[] flatArray = new CategoryNode[this.deferCategories.size()];
        int i = 0;
        while (i < this.deferCategories.size()) {
            flatArray[i] = new CategoryNode(this.deferCategories.get(i));
            ++i;
        }
        Arrays.asList(flatArray).sort(comparer);
        CategoryNode[] categoryNodeArray = flatArray;
        int n = flatArray.length;
        int n2 = 0;
        while (n2 < n) {
            CategoryNode categoryNode = categoryNodeArray[n2];
            Category cat = categoryNode.getCategory();
            this.finishCategory(cat);
            ++n2;
        }
        this.deferCategories = null;
    }

    private void finishCategory(Category category) {
        WizardCollectionElement test;
        String[] categoryPath = category.getParentPath();
        WizardCollectionElement parent = this.wizardElements;
        if (categoryPath != null) {
            String[] stringArray = categoryPath;
            int n = categoryPath.length;
            int n2 = 0;
            while (n2 < n) {
                String parentPath = stringArray[n2];
                WizardCollectionElement tempElement = this.getChildWithID(parent, parentPath);
                if (tempElement == null) {
                    return;
                }
                parent = tempElement;
                ++n2;
            }
        }
        if ((test = this.getChildWithID(parent, category.getId())) != null) {
            return;
        }
        if (parent != null) {
            this.createCollectionElement(parent, (IConfigurationElement)Adapters.adapt((Object)category, IConfigurationElement.class));
        }
    }

    private void finishPrimary() {
        if (this.deferPrimary != null) {
            ArrayList<WorkbenchWizardElement> primary = new ArrayList<WorkbenchWizardElement>();
            for (String id : this.deferPrimary) {
                WorkbenchWizardElement element;
                WorkbenchWizardElement workbenchWizardElement = element = this.wizardElements == null ? null : this.wizardElements.findWizard(id, true);
                if (element == null) continue;
                primary.add(element);
            }
            this.primaryWizards = primary.toArray(new WorkbenchWizardElement[primary.size()]);
            this.deferPrimary = null;
        }
    }

    private void finishWizard(WorkbenchWizardElement element, IConfigurationElement config) {
        StringTokenizer familyTokenizer = new StringTokenizer(this.getCategoryStringFor(config), CATEGORY_SEPARATOR);
        WizardCollectionElement currentCollectionElement = this.wizardElements;
        boolean moveToOther = false;
        while (familyTokenizer.hasMoreElements()) {
            WizardCollectionElement tempCollectionElement = this.getChildWithID(currentCollectionElement, familyTokenizer.nextToken());
            if (tempCollectionElement == null) {
                moveToOther = true;
                break;
            }
            currentCollectionElement = tempCollectionElement;
        }
        if (moveToOther) {
            this.moveElementToUncategorizedCategory(this.wizardElements, element);
        } else {
            currentCollectionElement.add(element);
            element.setParent(currentCollectionElement);
        }
    }

    private void finishWizards() {
        if (this.deferWizards != null) {
            for (WorkbenchWizardElement wizard : this.deferWizards) {
                IConfigurationElement config = wizard.getConfigurationElement();
                this.finishWizard(wizard, config);
            }
            this.deferWizards = null;
        }
    }

    protected String getCategoryStringFor(IConfigurationElement config) {
        String result = config.getAttribute("category");
        if (result == null) {
            result = UNCATEGORIZED_WIZARD_CATEGORY;
        }
        return result;
    }

    protected WizardCollectionElement getChildWithID(WizardCollectionElement parent, String id) {
        Object[] objectArray = parent.getChildren(null);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            WizardCollectionElement currentChild = (WizardCollectionElement)child;
            if (currentChild.getId().equals(id)) {
                return currentChild;
            }
            ++n2;
        }
        return null;
    }

    protected void moveElementToUncategorizedCategory(WizardCollectionElement root, WorkbenchWizardElement element) {
        WizardCollectionElement otherCategory = this.getChildWithID(root, UNCATEGORIZED_WIZARD_CATEGORY);
        if (otherCategory == null) {
            otherCategory = this.createCollectionElement(root, UNCATEGORIZED_WIZARD_CATEGORY, null, UNCATEGORIZED_WIZARD_CATEGORY_LABEL);
        }
        otherCategory.add(element);
        element.setParent(otherCategory);
    }

    private void pruneEmptyCategories(WizardCollectionElement parent) {
        Object[] children;
        Object[] objectArray = children = parent.getChildren(null);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            WizardCollectionElement child = (WizardCollectionElement)element;
            this.pruneEmptyCategories(child);
            boolean shouldPrune = child.getId().equals(FULL_EXAMPLES_WIZARD_CATEGORY);
            if (child.isEmpty() && shouldPrune) {
                parent.remove(child);
            }
            ++n2;
        }
    }

    @Override
    public boolean readElement(IConfigurationElement element) {
        if (element.getName().equals("category")) {
            this.deferCategory(element);
            return true;
        }
        if (element.getName().equals("primaryWizard")) {
            if (this.deferPrimary == null) {
                this.deferPrimary = new HashSet<String>();
            }
            this.deferPrimary.add(element.getAttribute("id"));
            return true;
        }
        if (!element.getName().equals("wizard")) {
            return false;
        }
        WorkbenchWizardElement wizard = this.createWizardElement(element);
        if (wizard != null) {
            this.addNewElementToResult(wizard, element);
        }
        return true;
    }

    protected void readWizards() {
        if (this.readAll && !this.areWizardsRead()) {
            this.createEmptyWizardCollection();
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            this.readRegistry(registry, this.plugin, this.pluginPoint);
        }
        this.finishCategories();
        this.finishWizards();
        this.finishPrimary();
        if (this.wizardElements != null) {
            this.pruneEmptyCategories(this.wizardElements);
        }
    }

    public WorkbenchWizardElement[] getPrimaryWizards() {
        if (!this.areWizardsRead()) {
            this.readWizards();
        }
        return (WorkbenchWizardElement[])WorkbenchActivityHelper.restrictArray(this.primaryWizards);
    }

    protected boolean areWizardsRead() {
        return this.wizardElements != null && this.readAll;
    }

    public WizardCollectionElement getWizardElements() {
        if (!this.areWizardsRead()) {
            this.readWizards();
        }
        return this.wizardElements;
    }

    protected Object[] getWizardCollectionElements() {
        if (!this.areWizardsRead()) {
            this.readWizards();
        }
        return this.wizardElements.getChildren();
    }

    protected WorkbenchWizardElement createWizardElement(IConfigurationElement element) {
        if (element.getAttribute("name") == null) {
            WizardsRegistryReader.logMissingAttribute(element, "name");
            return null;
        }
        if (WizardsRegistryReader.getClassValue(element, "class") == null) {
            WizardsRegistryReader.logMissingAttribute(element, "class");
            return null;
        }
        return new WorkbenchWizardElement(element);
    }

    public WorkbenchWizardElement findWizard(String id) {
        Object[] objectArray = this.getWizardCollectionElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object wizard = objectArray[n2];
            WizardCollectionElement collection = (WizardCollectionElement)wizard;
            WorkbenchWizardElement element = collection.findWizard(id, true);
            if (element != null && !WorkbenchActivityHelper.restrictUseOf(element)) {
                return element;
            }
            ++n2;
        }
        return null;
    }

    private static class CategoryNode {
        private Category category;
        private String path;

        CategoryNode(Category cat) {
            this.category = cat;
            this.path = "";
            String[] categoryPath = this.category.getParentPath();
            if (categoryPath != null) {
                String[] stringArray = categoryPath;
                int n = categoryPath.length;
                int n2 = 0;
                while (n2 < n) {
                    String parentPath = stringArray[n2];
                    this.path = String.valueOf(this.path) + parentPath + '/';
                    ++n2;
                }
            }
            this.path = String.valueOf(this.path) + cat.getId();
        }

        String getPath() {
            return this.path;
        }

        Category getCategory() {
            return this.category;
        }
    }
}

