/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.net.proxy.unix;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.core.internal.net.AbstractProxyProvider;
import org.eclipse.core.internal.net.Activator;
import org.eclipse.core.internal.net.Policy;
import org.eclipse.core.internal.net.ProxyData;
import org.eclipse.core.internal.net.StringUtil;
import org.eclipse.core.net.proxy.IProxyData;

public class UnixProxyProvider
extends AbstractProxyProvider {
    private static final String LIBRARY_NAME = "gnomeproxy-1.0.0";
    private static final String ENABLE_GNOME = "org.eclipse.core.net.enableGnome";
    private static boolean isGnomeLibLoaded = false;

    static {
        String value = System.getProperty(ENABLE_GNOME);
        if ("".equals(value) || "true".equals(value)) {
            UnixProxyProvider.loadGnomeLib();
        }
    }

    @Override
    public IProxyData[] select(URI uri) {
        int n;
        int n2;
        Object[] objectArray;
        String[] nonProxyHosts = this.getNonProxiedHosts();
        if (nonProxyHosts != null) {
            String host = uri.getHost();
            objectArray = nonProxyHosts;
            n2 = nonProxyHosts.length;
            n = 0;
            while (n < n2) {
                String nonProxyHost = objectArray[n];
                if (StringUtil.hostMatchesFilter(host, nonProxyHost)) {
                    return new IProxyData[0];
                }
                ++n;
            }
        }
        IProxyData[] proxies = new IProxyData[]{};
        if (uri.getScheme() != null) {
            IProxyData[] iProxyDataArray;
            ProxyData pd = this.getSystemProxyInfo(uri.getScheme());
            if (pd != null) {
                IProxyData[] iProxyDataArray2 = new IProxyData[1];
                iProxyDataArray = iProxyDataArray2;
                iProxyDataArray2[0] = pd;
            } else {
                iProxyDataArray = new IProxyData[]{};
            }
            proxies = iProxyDataArray;
        } else {
            proxies = this.getProxyData();
        }
        if (Policy.DEBUG) {
            Policy.debug("UnixProxyProvider#select result for [" + uri + "]");
            objectArray = proxies;
            n2 = proxies.length;
            n = 0;
            while (n < n2) {
                Object proxy = objectArray[n];
                System.out.println("\t" + proxy);
                ++n;
            }
        }
        return proxies;
    }

    @Override
    public IProxyData[] getProxyData() {
        String[] commonTypes = new String[]{"HTTP", "SOCKS", "HTTPS"};
        return this.getProxyForTypes(commonTypes);
    }

    private IProxyData[] getProxyForTypes(String[] types) {
        ArrayList<ProxyData> allData = new ArrayList<ProxyData>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            ProxyData pd = this.getSystemProxyInfo(type);
            if (pd != null && pd.getHost() != null) {
                allData.add(pd);
            }
            ++n2;
        }
        return allData.toArray(new IProxyData[0]);
    }

    @Override
    public String[] getNonProxiedHosts() {
        String npEnv;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug("Getting no_proxy");
        }
        if ((npEnv = UnixProxyProvider.getEnv("no_proxy")) != null) {
            String[] npHosts = StringUtil.split(npEnv, new String[]{","});
            int i = 0;
            while (i < npHosts.length) {
                npHosts[i] = npHosts[i].trim();
                ++i;
            }
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Got Env no_proxy: " + npEnv);
                this.debugPrint(npHosts);
            }
            return npHosts;
        }
        if (isGnomeLibLoaded) {
            try {
                String[] npHosts = UnixProxyProvider.getGSettingsNonProxyHosts();
                if (npHosts != null && npHosts.length > 0) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug("Got Gnome no_proxy");
                        this.debugPrint(npHosts);
                    }
                    return npHosts;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError("Problem during accessing Gnome library", e);
            }
        }
        return new String[0];
    }

    protected ProxyData getSystemProxyInfo(String protocol) {
        ProxyData pd = null;
        String envName = null;
        if (Policy.DEBUG_SYSTEM_PROVIDERS) {
            Policy.debug("Getting proxies for: " + protocol);
        }
        try {
            protocol = protocol.toLowerCase(Locale.ENGLISH);
            envName = String.valueOf(protocol) + "_proxy";
            String proxyEnv = UnixProxyProvider.getEnv(envName);
            if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                Policy.debug("Got proxyEnv: " + proxyEnv);
            }
            if (proxyEnv != null) {
                int colonInd = proxyEnv.indexOf(":");
                if (colonInd != -1 && proxyEnv.length() > colonInd + 2 && !"//".equals(proxyEnv.substring(colonInd + 1, colonInd + 3))) {
                    proxyEnv = "http://" + proxyEnv;
                }
                URI uri = new URI(proxyEnv);
                pd = new ProxyData(protocol);
                pd.setHost(Objects.requireNonNull(uri.getHost(), "no host in " + proxyEnv));
                int port = uri.getPort();
                if (port == -1) {
                    throw new IllegalStateException("no port in " + proxyEnv);
                }
                pd.setPort(port);
                String userInfo = uri.getUserInfo();
                if (userInfo != null) {
                    String user = null;
                    String password = null;
                    int pwInd = userInfo.indexOf(58);
                    if (pwInd >= 0) {
                        user = userInfo.substring(0, pwInd);
                        password = userInfo.substring(pwInd + 1);
                    } else {
                        user = userInfo;
                    }
                    pd.setUserid(user);
                    pd.setPassword(password);
                }
                pd.setSource("LINUX_ENV");
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Got Env proxy: " + pd);
                }
                return pd;
            }
        }
        catch (Exception e) {
            Activator.logError("Problem during accessing system variable: " + envName, e);
        }
        if (isGnomeLibLoaded) {
            try {
                pd = UnixProxyProvider.getGSettingsProxyInfo(protocol);
                if (pd != null) {
                    if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                        Policy.debug("Got Gnome proxy: " + pd);
                    }
                    pd.setSource("LINUX_GNOME");
                    return pd;
                }
            }
            catch (UnsatisfiedLinkError e) {
                Activator.logError("Problem during accessing Gnome library", e);
            }
        }
        return null;
    }

    private static String getEnv(String env) {
        try {
            Method m = System.class.getMethod("getenv", String.class);
            return (String)m.invoke(null, env);
        }
        catch (Throwable throwable) {
            Properties props;
            block12: {
                String[] cmd = new String[]{"/bin/sh", "-c", "env | grep -i proxy"};
                props = new Properties();
                Process proc = null;
                try {
                    proc = Runtime.getRuntime().exec(cmd);
                    props.load(proc.getInputStream());
                }
                catch (IOException e) {
                    Activator.logError("Problem during accessing system variable: " + env, e);
                    if (proc != null) {
                        proc.destroy();
                    }
                    break block12;
                }
                catch (IllegalArgumentException e) {
                    try {
                        Activator.logError("Problem during accessing system variable: " + env, e);
                        break block12;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                    }
                    finally {
                        if (proc != null) {
                            proc.destroy();
                        }
                    }
                }
                if (proc != null) {
                    proc.destroy();
                }
            }
            return props.getProperty(env);
        }
    }

    private static void loadGnomeLib() {
        block3: {
            try {
                System.loadLibrary(LIBRARY_NAME);
                isGnomeLibLoaded = true;
                if (Policy.DEBUG_SYSTEM_PROVIDERS) {
                    Policy.debug("Loaded " + System.mapLibraryName(LIBRARY_NAME) + " library");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (!Policy.DEBUG_SYSTEM_PROVIDERS) break block3;
                Policy.debug("Could not load library: " + System.mapLibraryName(LIBRARY_NAME));
            }
        }
    }

    private void debugPrint(String[] strs) {
        int i = 0;
        while (i < strs.length) {
            System.out.println(String.valueOf(i) + ": " + strs[i]);
            ++i;
        }
    }

    protected static native void gsettingsInit();

    protected static native ProxyData getGSettingsProxyInfo(String var0);

    protected static native String[] getGSettingsNonProxyHosts();
}

