/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.wizards.datatransfer.ArchiveFileManipulations;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.internal.wizards.datatransfer.ILeveledImportStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.TarEntry;
import org.eclipse.ui.internal.wizards.datatransfer.TarException;
import org.eclipse.ui.internal.wizards.datatransfer.TarFile;
import org.eclipse.ui.internal.wizards.datatransfer.TarLeveledStructureProvider;
import org.eclipse.ui.internal.wizards.datatransfer.ZipLeveledStructureProvider;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;

public class WizardProjectsImportPage
extends WizardDataTransferPage {
    public static final String METADATA_FOLDER = ".metadata";
    private ILeveledImportStructureProvider structureProvider;
    private static final String STORE_DIRECTORIES = "WizardProjectsImportPage.STORE_DIRECTORIES";
    private static final String STORE_ARCHIVES = "WizardProjectsImportPage.STORE_ARCHIVES";
    private static final String STORE_NESTED_PROJECTS = "WizardProjectsImportPage.STORE_NESTED_PROJECTS";
    private static final String STORE_COPY_PROJECT_ID = "WizardProjectsImportPage.STORE_COPY_PROJECT_ID";
    private static final String STORE_ARCHIVE_SELECTED = "WizardProjectsImportPage.STORE_ARCHIVE_SELECTED";
    private Combo directoryPathField;
    private CheckboxTreeViewer projectsList;
    private Button nestedProjectsCheckbox;
    private boolean nestedProjects = false;
    private Button copyCheckbox;
    private boolean copyFiles = false;
    private ProjectRecord[] selectedProjects = new ProjectRecord[0];
    private static String previouslyBrowsedDirectory = "";
    private static String previouslyBrowsedArchive = "";
    private Button projectFromDirectoryRadio;
    private Button projectFromArchiveRadio;
    private Combo archivePathField;
    private Button browseDirectoriesButton;
    private Button browseArchivesButton;
    private String lastPath;
    private static final String[] FILE_IMPORT_MASK = new String[]{"*.jar;*.zip;*.tar;*.tar.gz;*.tgz", "*.*"};
    private String initialPath;
    private WorkingSetGroup workingSetGroup;
    private IStructuredSelection currentSelection;
    private Button hideConflictingProjects;
    private ConflictingProjectFilter conflictingProjectsFilter = new ConflictingProjectFilter();
    List<IProject> createdProjects;

    public WizardProjectsImportPage() {
        this("wizardExternalProjectsPage", null, null);
    }

    public WizardProjectsImportPage(String pageName) {
        this(pageName, null, null);
    }

    public WizardProjectsImportPage(String pageName, String initialPath, IStructuredSelection currentSelection) {
        super(pageName);
        this.initialPath = initialPath;
        this.currentSelection = currentSelection;
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.WizardProjectsImportPage_ImportProjectsTitle);
        this.setDescription(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createProjectsList(workArea);
        this.createOptionsGroup(workArea);
        this.createWorkingSetGroup(workArea);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)workArea);
    }

    private void createWorkingSetGroup(Composite workArea) {
        String[] workingSetIds = new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"};
        this.workingSetGroup = new WorkingSetGroup(workArea, this.currentSelection, workingSetIds);
    }

    @Override
    protected void createOptionsGroupButtons(Group optionsGroup) {
        this.nestedProjectsCheckbox = new Button((Composite)optionsGroup, 32);
        this.nestedProjectsCheckbox.setText(DataTransferMessages.WizardProjectsImportPage_SearchForNestedProjects);
        this.nestedProjectsCheckbox.setLayoutData((Object)new GridData(768));
        this.nestedProjectsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.nestedProjects = WizardProjectsImportPage.this.nestedProjectsCheckbox.getSelection();
                if (WizardProjectsImportPage.this.projectFromDirectoryRadio.getSelection()) {
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText().trim(), true);
                } else {
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText().trim(), true);
                }
            }
        });
        this.copyCheckbox = new Button((Composite)optionsGroup, 32);
        this.copyCheckbox.setText(DataTransferMessages.WizardProjectsImportPage_CopyProjectsIntoWorkspace);
        this.copyCheckbox.setLayoutData((Object)new GridData(768));
        this.copyCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.copyFiles = WizardProjectsImportPage.this.copyCheckbox.getSelection();
                WizardProjectsImportPage.this.projectsList.refresh(true);
            }
        });
        this.hideConflictingProjects = new Button((Composite)optionsGroup, 32);
        this.hideConflictingProjects.setText(DataTransferMessages.WizardProjectsImportPage_hideExistingProjects);
        this.hideConflictingProjects.setLayoutData((Object)new GridData(768));
        this.hideConflictingProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.projectsList.removeFilter((ViewerFilter)WizardProjectsImportPage.this.conflictingProjectsFilter);
                if (WizardProjectsImportPage.this.hideConflictingProjects.getSelection()) {
                    WizardProjectsImportPage.this.projectsList.addFilter((ViewerFilter)WizardProjectsImportPage.this.conflictingProjectsFilter);
                }
            }
        });
        Dialog.applyDialogFont((Control)this.hideConflictingProjects);
    }

    private void createProjectsList(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText(DataTransferMessages.WizardProjectsImportPage_ProjectsListTitle);
        Composite listComposite = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        listComposite.setLayout((Layout)layout);
        listComposite.setLayoutData((Object)new GridData(1808));
        this.projectsList = new CheckboxTreeViewer(listComposite, 2048);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.widthHint = new PixelConverter(this.projectsList.getControl()).convertWidthInCharsToPixels(25);
        gridData.heightHint = new PixelConverter(this.projectsList.getControl()).convertHeightInCharsToPixels(10);
        this.projectsList.getControl().setLayoutData((Object)gridData);
        this.projectsList.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return WizardProjectsImportPage.this.getProjectRecords();
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectsList.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectsList.addCheckStateListener(event -> {
            ProjectRecord element = (ProjectRecord)event.getElement();
            if (element.hasConflicts || element.isInvalid) {
                this.projectsList.setChecked((Object)element, false);
            }
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        });
        this.projectsList.setInput((Object)this);
        this.projectsList.setComparator(new ViewerComparator());
        this.createSelectionButtons(listComposite);
    }

    private void createSelectionButtons(Composite listComposite) {
        Composite buttonsComposite = new Composite(listComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonsComposite.setLayout((Layout)layout);
        buttonsComposite.setLayoutData((Object)new GridData(2));
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(DataTransferMessages.DataTransfer_selectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectRecord[] projectRecordArray = WizardProjectsImportPage.this.selectedProjects;
                int n = projectRecordArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ProjectRecord selectedProject = projectRecordArray[n2];
                    if (selectedProject.hasConflicts || selectedProject.isInvalid) {
                        WizardProjectsImportPage.this.projectsList.setChecked((Object)selectedProject, false);
                    } else {
                        WizardProjectsImportPage.this.projectsList.setChecked((Object)selectedProject, true);
                    }
                    ++n2;
                }
                WizardProjectsImportPage.this.setPageComplete(WizardProjectsImportPage.this.projectsList.getCheckedElements().length > 0);
            }
        });
        Dialog.applyDialogFont((Control)selectAll);
        this.setButtonLayoutData(selectAll);
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(DataTransferMessages.DataTransfer_deselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.projectsList.setCheckedElements(new Object[0]);
                WizardProjectsImportPage.this.setPageComplete(false);
            }
        });
        Dialog.applyDialogFont((Control)deselectAll);
        this.setButtonLayoutData(deselectAll);
        Button refresh = new Button(buttonsComposite, 8);
        refresh.setText(DataTransferMessages.DataTransfer_refresh);
        refresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (WizardProjectsImportPage.this.projectFromDirectoryRadio.getSelection()) {
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText().trim(), true);
                } else {
                    WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText().trim(), true);
                }
            }
        });
        Dialog.applyDialogFont((Control)refresh);
        this.setButtonLayoutData(refresh);
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.projectFromDirectoryRadio = new Button(projectGroup, 16);
        this.projectFromDirectoryRadio.setText(DataTransferMessages.WizardProjectsImportPage_RootSelectTitle);
        this.directoryPathField = new Combo(projectGroup, 2048);
        GridData directoryPathData = new GridData(768);
        directoryPathData.widthHint = new PixelConverter((Control)this.directoryPathField).convertWidthInCharsToPixels(25);
        this.directoryPathField.setLayoutData((Object)directoryPathData);
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.projectFromArchiveRadio = new Button(projectGroup, 16);
        this.projectFromArchiveRadio.setText(DataTransferMessages.WizardProjectsImportPage_ArchiveSelectTitle);
        this.archivePathField = new Combo(projectGroup, 2048);
        GridData archivePathData = new GridData(768);
        archivePathData.widthHint = new PixelConverter((Control)this.archivePathField).convertWidthInCharsToPixels(25);
        this.archivePathField.setLayoutData((Object)archivePathData);
        this.browseArchivesButton = new Button(projectGroup, 8);
        this.browseArchivesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseArchivesButton);
        this.projectFromDirectoryRadio.setSelection(true);
        this.archivePathField.setEnabled(false);
        this.browseArchivesButton.setEnabled(false);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        this.browseArchivesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.handleLocationArchiveButtonPressed();
            }
        });
        this.directoryPathField.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
                this.updateProjectsList(this.directoryPathField.getText().trim());
            }
        });
        this.directoryPathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText().trim());
            }
        });
        this.directoryPathField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.directoryPathField.getText().trim());
            }
        });
        this.archivePathField.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
                this.updateProjectsList(this.archivePathField.getText().trim());
            }
        });
        this.archivePathField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText().trim());
            }
        });
        this.archivePathField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.updateProjectsList(WizardProjectsImportPage.this.archivePathField.getText().trim());
            }
        });
        this.projectFromDirectoryRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.directoryRadioSelected();
            }
        });
        this.projectFromArchiveRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardProjectsImportPage.this.archiveRadioSelected();
            }
        });
    }

    private void archiveRadioSelected() {
        if (this.projectFromArchiveRadio.getSelection()) {
            this.directoryPathField.setEnabled(false);
            this.browseDirectoriesButton.setEnabled(false);
            this.archivePathField.setEnabled(true);
            this.browseArchivesButton.setEnabled(true);
            this.updateProjectsList(this.archivePathField.getText());
            this.archivePathField.setFocus();
            this.nestedProjectsCheckbox.setSelection(true);
            this.nestedProjectsCheckbox.setEnabled(false);
            this.copyCheckbox.setSelection(true);
            this.copyCheckbox.setEnabled(false);
        }
    }

    private void directoryRadioSelected() {
        if (this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setEnabled(true);
            this.browseDirectoriesButton.setEnabled(true);
            this.archivePathField.setEnabled(false);
            this.browseArchivesButton.setEnabled(false);
            this.updateProjectsList(this.directoryPathField.getText());
            this.directoryPathField.setFocus();
            this.nestedProjectsCheckbox.setEnabled(true);
            this.nestedProjectsCheckbox.setSelection(this.nestedProjects);
            this.copyCheckbox.setEnabled(true);
            this.copyCheckbox.setSelection(this.copyFiles);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.projectFromDirectoryRadio.getSelection()) {
            this.directoryPathField.setFocus();
        }
        if (visible && this.projectFromArchiveRadio.getSelection()) {
            this.archivePathField.setFocus();
        }
    }

    public void updateProjectsList(String path) {
        this.updateProjectsList(path, false);
    }

    private void updateProjectsList(String path, boolean forceUpdate) {
        if (path == null || path.length() == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
            this.selectedProjects = new ProjectRecord[0];
            this.projectsList.refresh(true);
            this.projectsList.setCheckedElements((Object[])this.selectedProjects);
            this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
            this.lastPath = path;
            return;
        }
        File directory = new File(path);
        if (path.equals(this.lastPath) && !forceUpdate) {
            return;
        }
        boolean dirSelected = this.projectFromDirectoryRadio.getSelection();
        try {
            this.getContainer().run(true, true, monitor -> {
                monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_SearchingMessage, 100);
                this.selectedProjects = new ProjectRecord[0];
                ArrayList<ProjectRecord> files = new ArrayList<ProjectRecord>();
                monitor.worked(10);
                if (!dirSelected && ArchiveFileManipulations.isTarFile(path)) {
                    TarFile sourceTarFile = this.getSpecifiedTarSourceFile(path);
                    if (sourceTarFile == null) {
                        return;
                    }
                    this.structureProvider = new TarLeveledStructureProvider(sourceTarFile);
                    Object child1 = this.structureProvider.getRoot();
                    if (!this.collectProjectFilesFromProvider(files, child1, 0, monitor)) {
                        return;
                    }
                    Iterator filesIterator1 = files.iterator();
                    this.selectedProjects = new ProjectRecord[files.size()];
                    int index1 = 0;
                    monitor.worked(50);
                    monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                    while (filesIterator1.hasNext()) {
                        this.selectedProjects[index1++] = (ProjectRecord)filesIterator1.next();
                    }
                } else if (!dirSelected && ArchiveFileManipulations.isZipFile(path)) {
                    ZipFile sourceFile = this.getSpecifiedZipSourceFile(path);
                    if (sourceFile == null) {
                        return;
                    }
                    this.structureProvider = new ZipLeveledStructureProvider(sourceFile);
                    Object child2 = this.structureProvider.getRoot();
                    if (!this.collectProjectFilesFromProvider(files, child2, 0, monitor)) {
                        return;
                    }
                    Iterator filesIterator2 = files.iterator();
                    this.selectedProjects = new ProjectRecord[files.size()];
                    int index2 = 0;
                    monitor.worked(50);
                    monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                    while (filesIterator2.hasNext()) {
                        this.selectedProjects[index2++] = (ProjectRecord)filesIterator2.next();
                    }
                } else if (dirSelected && directory.isDirectory()) {
                    if (!this.collectProjectFilesFromDirectory(files, directory, null, monitor)) {
                        return;
                    }
                    Iterator filesIterator3 = files.iterator();
                    this.selectedProjects = new ProjectRecord[files.size()];
                    int index3 = 0;
                    monitor.worked(50);
                    monitor.subTask(DataTransferMessages.WizardProjectsImportPage_ProcessingMessage);
                    while (filesIterator3.hasNext()) {
                        File file2 = (File)filesIterator3.next();
                        this.selectedProjects[index3] = new ProjectRecord(file2);
                        ++index3;
                    }
                } else {
                    monitor.worked(60);
                }
                monitor.done();
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), e);
        }
        catch (InterruptedException interruptedException) {}
        this.lastPath = path;
        this.updateProjectsStatus();
    }

    private void updateProjectsStatus() {
        this.projectsList.refresh(true);
        ProjectRecord[] projects = this.getProjectRecords();
        boolean displayConflictWarning = false;
        boolean displayInvalidWarning = false;
        ProjectRecord[] projectRecordArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            ProjectRecord project = projectRecordArray[n2];
            if (project.hasConflicts || project.isInvalid) {
                this.projectsList.setGrayed((Object)project, true);
                displayConflictWarning |= project.hasConflicts;
                displayInvalidWarning |= project.isInvalid;
            } else {
                this.projectsList.setChecked((Object)project, true);
            }
            ++n2;
        }
        if (displayConflictWarning && displayInvalidWarning) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInWorkspaceAndInvalid, 2);
        } else if (displayConflictWarning) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInWorkspace, 2);
        } else if (displayInvalidWarning) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_projectsInvalid, 2);
        } else {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_ImportProjectsDescription);
        }
        this.setPageComplete(this.projectsList.getCheckedElements().length > 0);
        if (this.selectedProjects.length == 0) {
            this.setMessage(DataTransferMessages.WizardProjectsImportPage_noProjectsToImport, 2);
        }
    }

    private ZipFile getSpecifiedZipSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new ZipFile(fileName);
        }
        catch (ZipException zipException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private TarFile getSpecifiedTarSourceFile(String fileName) {
        if (fileName.length() == 0) {
            return null;
        }
        try {
            return new TarFile(fileName);
        }
        catch (TarException tarException) {
            this.displayErrorDialog(DataTransferMessages.TarImport_badFormat);
        }
        catch (IOException iOException) {
            this.displayErrorDialog(DataTransferMessages.ZipImport_couldNotRead);
        }
        this.archivePathField.setFocus();
        return null;
    }

    private boolean collectProjectFilesFromDirectory(Collection files, File directory, Set directoriesVisited, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)directory.getPath()));
        File[] contents = directory.listFiles();
        if (contents == null) {
            return false;
        }
        if (directoriesVisited == null) {
            directoriesVisited = new HashSet<String>();
            try {
                directoriesVisited.add(directory.getCanonicalPath());
            }
            catch (IOException exception) {
                StatusManager.getManager().handle(StatusUtil.newStatus(4, exception.getLocalizedMessage(), (Throwable)exception));
            }
        }
        File[] fileArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isFile() && file.getName().equals(".project")) {
                files.add(file);
                if (!this.nestedProjects) {
                    return true;
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < contents.length) {
            block13: {
                if (contents[i].isDirectory() && !contents[i].getName().equals(METADATA_FOLDER)) {
                    block12: {
                        try {
                            String canonicalPath = contents[i].getCanonicalPath();
                            if (directoriesVisited.add(canonicalPath)) break block12;
                            break block13;
                        }
                        catch (IOException exception) {
                            StatusManager.getManager().handle(StatusUtil.newStatus(4, exception.getLocalizedMessage(), (Throwable)exception));
                        }
                    }
                    this.collectProjectFilesFromDirectory(files, contents[i], directoriesVisited, monitor);
                }
            }
            ++i;
        }
        return true;
    }

    private boolean collectProjectFilesFromProvider(Collection<ProjectRecord> files, Object entry, int level, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return false;
        }
        monitor.subTask(NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_CheckingMessage, (Object)this.structureProvider.getLabel(entry)));
        ArrayList children = this.structureProvider.getChildren(entry);
        if (children == null) {
            children = new ArrayList(1);
        }
        for (Object child : children) {
            String elementLabel;
            if (this.structureProvider.isFolder(child)) {
                this.collectProjectFilesFromProvider(files, child, level + 1, monitor);
            }
            if (!(elementLabel = this.structureProvider.getLabel(child)).equals(".project")) continue;
            files.add(new ProjectRecord(child, entry, level));
        }
        return true;
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell(), 0x10000000);
        dialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
            this.updateProjectsList(selectedDirectory);
        }
    }

    protected void handleLocationArchiveButtonPressed() {
        FileDialog dialog = new FileDialog(this.archivePathField.getShell(), 0x10000000);
        dialog.setFilterExtensions(FILE_IMPORT_MASK);
        dialog.setText(DataTransferMessages.WizardProjectsImportPage_SelectArchiveDialogTitle);
        String fileName = this.archivePathField.getText().trim();
        if (fileName.length() == 0) {
            fileName = previouslyBrowsedArchive;
        }
        if (fileName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(fileName).getParentFile();
            if (path != null && path.exists()) {
                dialog.setFilterPath(path.toString());
            }
        }
        String selectedArchive = dialog.open();
        if (selectedArchive != null) {
            previouslyBrowsedArchive = selectedArchive;
            this.archivePathField.setText(previouslyBrowsedArchive);
            this.updateProjectsList(selectedArchive);
        }
    }

    public boolean createProjects() {
        this.saveWidgetValues();
        final Object[] selected = this.projectsList.getCheckedElements();
        this.createdProjects = new ArrayList<IProject>();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            @Override
            protected void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.beginTask("", selected.length);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    MultiStatus status = new MultiStatus("org.eclipse.ui.ide", 1, DataTransferMessages.WizardProjectsImportPage_projectsInWorkspaceAndInvalid, null);
                    Object[] objectArray = selected;
                    int n = selected.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        status.add(WizardProjectsImportPage.this.createExistingProject((ProjectRecord)element, (IProgressMonitor)new SubProgressMonitor(monitor, 1)));
                        ++n2;
                    }
                    if (!status.isOK()) {
                        throw new InvocationTargetException(new CoreException((IStatus)status));
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            try {
                this.getContainer().run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
                ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
                this.addToWorkingSets();
                return false;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                String message = DataTransferMessages.WizardExternalProjectImportPage_errorMessage;
                Object status = t instanceof CoreException ? ((CoreException)t).getStatus() : new Status(4, "org.eclipse.ui.ide", 1, message, t);
                this.updateProjectsStatus();
                ErrorDialog.openError((Shell)this.getShell(), (String)message, null, (IStatus)status);
                ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
                this.addToWorkingSets();
                return false;
            }
        }
        finally {
            ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
            this.addToWorkingSets();
        }
        return true;
    }

    private void addToWorkingSets() {
        IWorkingSet[] selectedWorkingSets = this.workingSetGroup.getSelectedWorkingSets();
        if (selectedWorkingSets == null || selectedWorkingSets.length == 0) {
            return;
        }
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        for (IProject element : this.createdProjects) {
            workingSetManager.addToWorkingSets((IAdaptable)element, selectedWorkingSets);
        }
    }

    public void performCancel() {
        ArchiveFileManipulations.closeStructureProvider(this.structureProvider, this.getShell());
    }

    private IStatus createExistingProject(ProjectRecord record, IProgressMonitor monitor) throws InterruptedException {
        IStatus desc;
        URI locationURI;
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(projectName);
        this.createdProjects.add(project);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        if (record.projectArchiveFile != null) {
            List fileSystemObjects = this.structureProvider.getChildren(record.parent);
            this.structureProvider.setStrip(record.level);
            ImportOperation operation = new ImportOperation(project.getFullPath(), this.structureProvider.getRoot(), this.structureProvider, this, fileSystemObjects);
            operation.setContext(this.getShell());
            try {
                operation.run(monitor);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    return ((CoreException)e.getCause()).getStatus();
                }
                return new Status(4, "org.eclipse.ui.ide", 2, e.getCause().getLocalizedMessage(), (Throwable)e);
            }
            return operation.getStatus();
        }
        File importSource = null;
        if (this.copyFiles && (locationURI = record.description.getLocationURI()) != null) {
            IStatus result = ResourcesPlugin.getWorkspace().validateProjectLocationURI(project, locationURI);
            if (!result.isOK()) {
                return result;
            }
            importSource = new File(locationURI);
            desc = workspace.newProjectDescription(projectName);
            desc.setBuildSpec(record.description.getBuildSpec());
            desc.setComment(record.description.getComment());
            desc.setDynamicReferences(record.description.getDynamicReferences());
            desc.setNatureIds(record.description.getNatureIds());
            desc.setReferencedProjects(record.description.getReferencedProjects());
            record.description = desc;
        }
        try {
            try {
                monitor.beginTask(DataTransferMessages.WizardProjectsImportPage_CreateProjectsTask, 100);
                project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 70));
            }
            catch (CoreException e) {
                desc = e.getStatus();
                monitor.done();
                return desc;
            }
        }
        finally {
            monitor.done();
        }
        if (this.copyFiles && importSource != null) {
            List filesToImport = FileSystemStructureProvider.INSTANCE.getChildren(importSource);
            ImportOperation operation = new ImportOperation(project.getFullPath(), importSource, FileSystemStructureProvider.INSTANCE, this, filesToImport);
            operation.setContext(this.getShell());
            operation.setOverwriteResources(true);
            operation.setCreateContainerStructure(false);
            try {
                operation.run(monitor);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    return ((CoreException)e.getCause()).getStatus();
                }
                return new Status(4, "org.eclipse.ui.ide", 2, e.getCause().getLocalizedMessage(), (Throwable)e);
            }
            return operation.getStatus();
        }
        return Status.OK_STATUS;
    }

    public Button getProjectFromDirectoryRadio() {
        return this.projectFromDirectoryRadio;
    }

    public CheckboxTreeViewer getProjectsList() {
        return this.projectsList;
    }

    private IProject[] getProjectsInWorkspace() {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getProjects();
    }

    public ProjectRecord[] getProjectRecords() {
        ArrayList<ProjectRecord> projectRecords = new ArrayList<ProjectRecord>();
        int i = 0;
        while (i < this.selectedProjects.length) {
            String projectName = this.selectedProjects[i].getProjectName();
            this.selectedProjects[i].hasConflicts = this.isProjectInWorkspacePath(projectName) && this.copyFiles || this.isProjectInWorkspace(projectName);
            projectRecords.add(this.selectedProjects[i]);
            ++i;
        }
        return projectRecords.toArray(new ProjectRecord[projectRecords.size()]);
    }

    private boolean isProjectInWorkspacePath(String projectName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath wsPath = workspace.getRoot().getLocation();
        IPath localProjectPath = wsPath.append(projectName);
        return localProjectPath.toFile().exists();
    }

    private boolean isProjectInWorkspace(String projectName) {
        IProject[] workspaceProjects;
        if (projectName == null) {
            return false;
        }
        IProject[] iProjectArray = workspaceProjects = this.getProjectsInWorkspace();
        int n = workspaceProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject workspaceProject = iProjectArray[n2];
            if (projectName.equals(workspaceProject.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.restoreFromHistory(settings, STORE_DIRECTORIES, this.directoryPathField);
            this.restoreFromHistory(settings, STORE_ARCHIVES, this.archivePathField);
            this.nestedProjects = settings.getBoolean(STORE_NESTED_PROJECTS);
            this.nestedProjectsCheckbox.setSelection(this.nestedProjects);
            this.copyFiles = settings.getBoolean(STORE_COPY_PROJECT_ID);
            this.copyCheckbox.setSelection(this.copyFiles);
        }
        if (this.initialPath == null && settings != null) {
            boolean archiveSelected = settings.getBoolean(STORE_ARCHIVE_SELECTED);
            this.projectFromDirectoryRadio.setSelection(!archiveSelected);
            this.projectFromArchiveRadio.setSelection(archiveSelected);
            if (archiveSelected) {
                this.archiveRadioSelected();
            } else {
                this.directoryRadioSelected();
            }
        } else if (this.initialPath != null) {
            boolean dir = new File(this.initialPath).isDirectory();
            this.projectFromDirectoryRadio.setSelection(dir);
            this.projectFromArchiveRadio.setSelection(!dir);
            if (dir) {
                this.directoryPathField.setText(this.initialPath);
                this.directoryPathField.setSelection(new Point(this.initialPath.length(), this.initialPath.length()));
                this.directoryRadioSelected();
            } else {
                this.archivePathField.setText(this.initialPath);
                this.archivePathField.setSelection(new Point(this.initialPath.length(), this.initialPath.length()));
                this.archiveRadioSelected();
            }
        }
    }

    private void restoreFromHistory(IDialogSettings settings, String key, Combo combo) {
        String[] sourceNames = settings.getArray(key);
        if (sourceNames == null) {
            return;
        }
        String[] stringArray = sourceNames;
        int n = sourceNames.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceName = stringArray[n2];
            combo.add(sourceName);
            ++n2;
        }
    }

    @Override
    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.saveInHistory(settings, STORE_DIRECTORIES, this.directoryPathField.getText());
            this.saveInHistory(settings, STORE_ARCHIVES, this.archivePathField.getText());
            settings.put(STORE_NESTED_PROJECTS, this.nestedProjectsCheckbox.getSelection());
            settings.put(STORE_COPY_PROJECT_ID, this.copyCheckbox.getSelection());
            settings.put(STORE_ARCHIVE_SELECTED, this.projectFromArchiveRadio.getSelection());
        }
    }

    private void saveInHistory(IDialogSettings settings, String key, String value) {
        String[] sourceNames = settings.getArray(key);
        if (sourceNames == null) {
            sourceNames = new String[]{};
        }
        sourceNames = this.addToHistory(sourceNames, value);
        settings.put(key, sourceNames);
    }

    public Button getCopyCheckbox() {
        return this.copyCheckbox;
    }

    public Button getNestedProjectsCheckbox() {
        return this.nestedProjectsCheckbox;
    }

    public void handleEvent(Event event) {
    }

    @Override
    protected boolean allowNewContainerName() {
        return true;
    }

    class ConflictingProjectFilter
    extends ViewerFilter {
        ConflictingProjectFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return !((ProjectRecord)element).hasConflicts;
        }
    }

    private final class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private ProjectLabelProvider() {
        }

        public String getText(Object element) {
            return ((ProjectRecord)element).getProjectLabel();
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            ProjectRecord projectRecord = (ProjectRecord)element;
            if (projectRecord.hasConflicts || projectRecord.isInvalid) {
                return WizardProjectsImportPage.this.getShell().getDisplay().getSystemColor(15);
            }
            return null;
        }
    }

    public class ProjectRecord {
        File projectSystemFile;
        Object projectArchiveFile;
        String projectName;
        Object parent;
        int level;
        boolean hasConflicts;
        boolean isInvalid = false;
        IProjectDescription description;

        ProjectRecord(File file) {
            this.projectSystemFile = file;
            this.setProjectName();
        }

        ProjectRecord(Object file, Object parent, int level) {
            this.projectArchiveFile = file;
            this.parent = parent;
            this.level = level;
            this.setProjectName();
        }

        private void setProjectName() {
            try {
                if (this.projectArchiveFile != null) {
                    InputStream stream = WizardProjectsImportPage.this.structureProvider.getContents(this.projectArchiveFile);
                    if (stream == null) {
                        if (this.projectArchiveFile instanceof ZipEntry) {
                            Path path = new Path(((ZipEntry)this.projectArchiveFile).getName());
                            this.projectName = path.segment(path.segmentCount() - 2);
                        } else if (this.projectArchiveFile instanceof TarEntry) {
                            Path path = new Path(((TarEntry)this.projectArchiveFile).getName());
                            this.projectName = path.segment(path.segmentCount() - 2);
                        }
                    } else {
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription(stream);
                        stream.close();
                        this.projectName = this.description.getName();
                    }
                }
                if (this.projectName == null) {
                    Path path = new Path(this.projectSystemFile.getPath());
                    if (this.isDefaultLocation((IPath)path)) {
                        this.projectName = path.segment(path.segmentCount() - 2);
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().newProjectDescription(this.projectName);
                    } else {
                        this.description = IDEWorkbenchPlugin.getPluginWorkspace().loadProjectDescription((IPath)path);
                        this.projectName = this.description.getName();
                    }
                }
            }
            catch (CoreException coreException) {
                this.projectName = DataTransferMessages.WizardProjectsImportPage_invalidProjectName;
                this.isInvalid = true;
            }
            catch (IOException iOException) {
                this.projectName = DataTransferMessages.WizardProjectsImportPage_invalidProjectName;
                this.isInvalid = true;
            }
        }

        private boolean isDefaultLocation(IPath path) {
            if (path.segmentCount() < 2) {
                return false;
            }
            return path.removeLastSegments(2).toFile().equals(Platform.getLocation().toFile());
        }

        public String getProjectName() {
            return this.projectName;
        }

        public boolean isInvalidProject() {
            return this.isInvalid;
        }

        public String getProjectLabel() {
            String path = this.projectSystemFile == null ? WizardProjectsImportPage.this.structureProvider.getLabel(this.parent) : this.projectSystemFile.getParent();
            return NLS.bind((String)DataTransferMessages.WizardProjectsImportPage_projectLabel, (Object)this.projectName, (Object)path);
        }

        public boolean hasConflicts() {
            return this.hasConflicts;
        }
    }
}

