/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerSupportView;
import org.eclipse.ui.views.markers.MarkerViewHandler;

public class MarkerCopyHandler
extends MarkerViewHandler {
    public Object execute(ExecutionEvent event) {
        MarkerSupportView view = this.getView(event);
        if (view == null) {
            return null;
        }
        this.setClipboard(view);
        return this;
    }

    private void setClipboard(ExtendedMarkersView view) {
        Transfer[] transferTypes;
        Object[] data;
        IMarker[] markers = view.getSelectedMarkers();
        String markerReport = MarkerCopyHandler.createMarkerReport(view, markers);
        if (markerReport == null) {
            data = new Object[]{markers};
            transferTypes = new Transfer[]{MarkerTransfer.getInstance()};
        } else {
            data = new Object[]{markers, markerReport};
            transferTypes = new Transfer[]{MarkerTransfer.getInstance(), TextTransfer.getInstance()};
        }
        view.getClipboard().setContents(data, transferTypes);
    }

    static String createMarkerReport(ExtendedMarkersView view, IMarker[] markers) {
        StringBuffer report = new StringBuffer();
        MarkerField[] fields = view.getVisibleFields();
        String NEWLINE = System.getProperty("line.separator");
        int i = 0;
        while (i < fields.length) {
            report.append(fields[i].getColumnHeaderText());
            if (i == fields.length - 1) {
                report.append(NEWLINE);
            } else {
                report.append('\t');
            }
            ++i;
        }
        i = 0;
        while (i < markers.length) {
            int j = 0;
            while (j < fields.length) {
                report.append(fields[j].getValue(MarkerSupportInternalUtilities.newMarkerItem(markers[i])));
                if (j == fields.length - 1) {
                    report.append(NEWLINE);
                } else {
                    report.append('\t');
                }
                ++j;
            }
            ++i;
        }
        return report.toString();
    }
}

