/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.SetupP2Factory;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.XMLUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogGenerator
implements IApplication {
    private static final String JAVA_VERSION_PREFIX = "addJvmArg(jvmArg:-Dosgi.requiredJavaVersion=";
    private static final String PACKAGES = "http://download.eclipse.org/technology/epp/packages";
    private static final String RELEASES = "http://download.eclipse.org/releases";
    private static final String ICON_URL_PREFIX = "http://www.eclipse.org/downloads/images/";
    private static final String ICON_DEFAULT = "http://www.eclipse.org/downloads/images/committers.png";
    private static final Map<String, String> ICONS = new HashMap<String, String>();
    private static final List<String> PRODUCT_IDS = Arrays.asList("epp.package.java", "epp.package.jee", "epp.package.cpp", "epp.package.php", "epp.package.committers", "epp.package.dsl", "epp.package.reporting", "epp.package.modeling", "epp.package.rcp", "epp.package.testing", "epp.package.parallel", "epp.package.automotive", "epp.package.scout", "org.eclipse.platform.ide");
    private static final Set<String> EXCLUDED_IDS = new HashSet<String>(Arrays.asList("epp.package.mobile"));

    public Object start(IApplicationContext context) throws Exception {
        String[] arguments = (String[])context.getArguments().get("application.args");
        URI outputLocation = null;
        String stagingTrain = null;
        java.net.URI stagingEPPLocation = null;
        java.net.URI stagingTrainLocation = null;
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                String option = arguments[i];
                if ("-outputLocation".equals(option)) {
                    outputLocation = URI.createURI((String)arguments[++i]);
                } else if ("-staging".equals(option)) {
                    stagingTrain = arguments[++i];
                    stagingEPPLocation = new java.net.URI(arguments[++i]);
                    stagingTrainLocation = new java.net.URI(arguments[++i]);
                }
                ++i;
            }
        }
        ICONS.put("reporting", "http://www.eclipse.org/downloads/images/birt-icon_48x48.png");
        ICONS.put("cpp", "http://www.eclipse.org/downloads/images/cdt.png");
        ICONS.put("automotive", "http://www.eclipse.org/downloads/images/classic.jpg");
        ICONS.put("standard", ICON_DEFAULT);
        ICONS.put("committers", ICON_DEFAULT);
        ICONS.put("dsl", "http://www.eclipse.org/downloads/images/dsl-package_42.png");
        ICONS.put("java", "http://www.eclipse.org/downloads/images/java.png");
        ICONS.put("jee", "http://www.eclipse.org/downloads/images/javaee.png");
        ICONS.put("modeling", "http://www.eclipse.org/downloads/images/modeling.png");
        ICONS.put("parallel", "http://www.eclipse.org/downloads/images/parallel.png");
        ICONS.put("php", "http://www.eclipse.org/downloads/images/php.png");
        ICONS.put("rcp", "http://www.eclipse.org/downloads/images/rcp.png");
        ICONS.put("scout", "http://www.eclipse.org/downloads/images/scout.jpg");
        ICONS.put("testing", "http://www.eclipse.org/downloads/images/testing.png");
        ICONS.put("mobile", "http://www.eclipse.org/downloads/images/mobile.jpg");
        this.generate(outputLocation, stagingTrain, stagingEPPLocation, stagingTrainLocation);
        return null;
    }

    public void stop() {
    }

    private String[] getTrains() {
        return new String[]{"juno", "kepler", "luna", "mars", "neon"};
    }

    private String[] getRootIUs() {
        return new String[]{"org.eclipse.platform.feature.group", "org.eclipse.rcp.feature.group", "org.eclipse.jdt.feature.group", "org.eclipse.pde.feature.group"};
    }

    private boolean isLatestReleased() {
        return false;
    }

    private boolean testNewUnreleasedProduct() {
        return false;
    }

    public void generate(URI outputLocation, String stagingTrain, java.net.URI stagingEPPLocation, java.net.URI stagingTrainLocation) {
        final String[] TRAINS = this.getTrains();
        String LATEST_TRAIN = TRAINS[TRAINS.length - 1];
        boolean LATEST_RELEASED = !this.testNewUnreleasedProduct() && this.isLatestReleased();
        try {
            Version version;
            ProductCatalog productCatalog = SetupFactory.eINSTANCE.createProductCatalog();
            productCatalog.setName("org.eclipse.products");
            productCatalog.setLabel("Eclipse.org");
            Annotation annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
            annotation.getDetails().put((Object)"readmePath", (Object)"readme/readme_eclipse.html");
            productCatalog.getAnnotations().add((Object)annotation);
            InstallationTask installationTask = SetupFactory.eINSTANCE.createInstallationTask();
            installationTask.setID("installation");
            productCatalog.getSetupTasks().add((Object)installationTask);
            IMetadataRepositoryManager manager = this.getMetadataRepositoryManager();
            Requirement oomphRequirement = P2Factory.eINSTANCE.createRequirement("org.eclipse.oomph.setup.feature.group");
            Repository oomphRepository = P2Factory.eINSTANCE.createRepository("${oomph.update.url}");
            String emfRepositoryLocation = this.trimEmptyTrailingSegment(this.loadLatestRepository(manager, null, new java.net.URI("http://download.eclipse.org/modeling/emf/emf/updates/2.10.x/core")).getLocation()).toString();
            P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
            p2Task.getRequirements().add((Object)oomphRequirement);
            p2Task.getRepositories().add((Object)oomphRepository);
            productCatalog.getSetupTasks().add((Object)p2Task);
            HashMap<String, IMetadataRepository> eppMetaDataRepositories = new HashMap<String, IMetadataRepository>();
            final HashMap trainsAndVersions = new HashMap();
            final HashMap<String, Object> labels = new HashMap<String, Object>();
            String[] stringArray = TRAINS;
            int n = TRAINS.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                Object label;
                java.net.URI originalEPPURI;
                String train = stringArray[n2];
                java.net.URI eppURI = originalEPPURI = new java.net.URI("http://download.eclipse.org/technology/epp/packages/" + train);
                System.out.print(eppURI);
                boolean isStaging = train.equals(stagingTrain);
                if (isStaging) {
                    System.out.print(" -> " + stagingEPPLocation);
                }
                System.out.flush();
                java.net.URI effectiveEPPURI = isStaging ? stagingEPPLocation : eppURI;
                IMetadataRepository eppMetaDataRepository = manager.loadRepository(effectiveEPPURI, null);
                IMetadataRepository latestEPPMetaDataRepository = this.getLatestRepository(manager, eppMetaDataRepository);
                if (latestEPPMetaDataRepository != eppMetaDataRepository) {
                    java.net.URI latestLocation = latestEPPMetaDataRepository.getLocation();
                    System.out.print(" -> " + latestLocation);
                    URI relativeLocation = URI.createURI((String)latestLocation.toString()).deresolve(URI.createURI((String)effectiveEPPURI.toString()).appendSegment(""));
                    if (relativeLocation.isRelative()) {
                        java.net.URI actualLatestEPPURI = new java.net.URI(URI.createURI((String)eppURI.toString()).appendSegments(relativeLocation.segments()).toString());
                        try {
                            manager.loadRepository(actualLatestEPPURI, null);
                            System.out.print(" -> " + actualLatestEPPURI);
                            eppURI = this.trimEmptyTrailingSegment(actualLatestEPPURI);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                System.out.println();
                eppMetaDataRepositories.put(train, eppMetaDataRepository);
                HashMap<String, IInstallableUnit> ius = new HashMap<String, IInstallableUnit>();
                java.net.URI releaseURI = new java.net.URI("http://download.eclipse.org/releases/" + train);
                System.out.print(releaseURI);
                IMetadataRepository releaseMetaDataRepository = this.loadLatestRepository(manager, originalEPPURI, isStaging ? stagingTrainLocation : releaseURI);
                releaseURI = this.trimEmptyTrailingSegment(releaseMetaDataRepository.getLocation());
                System.out.println(" -> " + releaseURI);
                HashSet<String> requirements = new HashSet<String>();
                for (IInstallableUnit iInstallableUnit : P2Util.asIterable((IQueryResult)eppMetaDataRepository.query(QueryUtil.createLatestIUQuery(), null))) {
                    IInstallableUnit existingIU;
                    String id2;
                    String fragment = iInstallableUnit.getProperty("org.eclipse.equinox.p2.type.fragment");
                    if ("true".equals(fragment)) continue;
                    label = iInstallableUnit.getProperty("org.eclipse.equinox.p2.name");
                    if (label == null || ((String)label).startsWith("%") || ((String)label).equals("Uncategorized")) {
                        requirements.add(iInstallableUnit.getId());
                    }
                    if ("epp.package.standard".equals(id2 = iInstallableUnit.getId())) {
                        label = "Eclipse Standard";
                    }
                    if ((existingIU = (IInstallableUnit)ius.get(id2)) != null) continue;
                    ius.put(id2, iInstallableUnit);
                    labels.put(id2, label);
                }
                for (IInstallableUnit iInstallableUnit : ius.values()) {
                    for (IRequirement requirement : iInstallableUnit.getRequirements()) {
                        IRequiredCapability capability;
                        if (!(requirement instanceof IRequiredCapability) || !"org.eclipse.equinox.p2.iu".equals((capability = (IRequiredCapability)requirement).getNamespace())) continue;
                        requirements.add(capability.getName());
                    }
                }
                ius.keySet().removeAll(requirements);
                for (IInstallableUnit iInstallableUnit : P2Util.asIterable((IQueryResult)releaseMetaDataRepository.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)"org.eclipse.platform.ide")), null))) {
                    id = iInstallableUnit.getId();
                    label = iInstallableUnit.getProperty("org.eclipse.equinox.p2.name");
                    ius.put(id, iInstallableUnit);
                    labels.put(id, label);
                }
                for (Map.Entry entry : ius.entrySet()) {
                    id = (String)entry.getKey();
                    label = (String)labels.get(id);
                    IInstallableUnit iu = (IInstallableUnit)entry.getValue();
                    version = iu.getVersion();
                    System.out.println("  " + (String)label + "  --  " + id + " " + version);
                    ArrayList<TrainAndVersion> list = (ArrayList<TrainAndVersion>)trainsAndVersions.get(id);
                    if (list == null) {
                        list = new ArrayList<TrainAndVersion>();
                        trainsAndVersions.put(id, list);
                    }
                    HashMap<String, Set<IInstallableUnit>> versionIUs = new HashMap<String, Set<IInstallableUnit>>();
                    this.gatherReleaseIUs(versionIUs, iu, releaseMetaDataRepository, eppMetaDataRepository);
                    this.filterRoots(versionIUs);
                    list.add(new TrainAndVersion(train, version, releaseURI, eppURI, versionIUs));
                }
                System.out.println();
                ++n2;
            }
            if (this.testNewUnreleasedProduct()) {
                ArrayList<TrainAndVersion> list = new ArrayList<TrainAndVersion>();
                list.add(new TrainAndVersion("mars", null, null, null, null));
                trainsAndVersions.put("test.product", list);
                labels.put("test.product", "Eclipse Test Product");
            }
            System.out.println("#################################################################################################################");
            System.out.println();
            ArrayList ids = new ArrayList(trainsAndVersions.keySet());
            Collections.sort(ids, new Comparator<String>(){

                @Override
                public int compare(String id1, String id2) {
                    int result = this.getLatestTrain(id2) - this.getLatestTrain(id1);
                    if (result == 0) {
                        String label1 = StringUtil.safe((String)((String)labels.get(id1)));
                        String label2 = StringUtil.safe((String)((String)labels.get(id2)));
                        result = label1.compareTo(label2);
                    }
                    return result;
                }

                private int getLatestTrain(String id) {
                    List list = (List)trainsAndVersions.get(id);
                    TrainAndVersion lastEntry = (TrainAndVersion)list.get(list.size() - 1);
                    String lastTrain = lastEntry.getTrain();
                    int i = 0;
                    while (i < TRAINS.length) {
                        String train = TRAINS[i];
                        if (train == lastTrain) {
                            return i;
                        }
                        ++i;
                    }
                    throw new IllegalStateException();
                }
            });
            EList products = productCatalog.getProducts();
            for (String id : ids) {
                String label;
                String p2TaskLabel = label = (String)labels.get(id);
                List list = (List)trainsAndVersions.get(id);
                int size = list.size();
                TrainAndVersion latestTrainAndVersion = (TrainAndVersion)list.get(size - 1);
                String latestTrain = latestTrainAndVersion.getTrain();
                String latestTrainLabel = this.getTrainLabel(latestTrain);
                Version latestVersion = latestTrainAndVersion.getVersion();
                Map<String, Set<IInstallableUnit>> latestTrainsIUs = latestTrainAndVersion.getIUs();
                boolean latestUnreleased = latestTrain == LATEST_TRAIN && !LATEST_RELEASED;
                System.out.println(String.valueOf(label) + " (" + id + ")");
                Product product = SetupFactory.eINSTANCE.createProduct();
                product.setName(id);
                product.setLabel(label);
                this.attachBrandingInfos(product);
                products.add((Object)product);
                this.addProductVersion(product, latestVersion, VersionSegment.MAJOR, latestTrainAndVersion.getTrainURI(), latestTrainAndVersion.getEPPURI(), latestTrain, eppMetaDataRepositories, "latest", "Latest (" + latestTrainLabel + ")", p2TaskLabel, latestTrainsIUs, emfRepositoryLocation);
                if (!latestUnreleased || size != 1) {
                    int offset = 1;
                    if (latestUnreleased && size > 1) {
                        ++offset;
                    }
                    TrainAndVersion releasedTrainAndVersion = (TrainAndVersion)list.get(size - offset);
                    String releasedTrain = releasedTrainAndVersion.getTrain();
                    String releasedTrainLabel = this.getTrainLabel(releasedTrain);
                    Version releasedVersion = releasedTrainAndVersion.getVersion();
                    this.addProductVersion(product, releasedVersion, VersionSegment.MINOR, releasedTrainAndVersion.getTrainURI(), releasedTrainAndVersion.getEPPURI(), releasedTrain, eppMetaDataRepositories, "latest.released", "Latest Release (" + releasedTrainLabel + ")", p2TaskLabel, releasedTrainAndVersion.getIUs(), emfRepositoryLocation);
                }
                int i = 0;
                while (i < size) {
                    TrainAndVersion entry = (TrainAndVersion)list.get(size - i - 1);
                    String train = entry.getTrain();
                    String trainLabel = this.getTrainLabel(train);
                    version = entry.getVersion();
                    this.addProductVersion(product, version, VersionSegment.MINOR, entry.getTrainURI(), entry.getEPPURI(), train, eppMetaDataRepositories, train, trainLabel, p2TaskLabel, entry.getIUs(), emfRepositoryLocation);
                    ++i;
                }
                System.out.println();
            }
            UniqueEList productIDs = new UniqueEList(PRODUCT_IDS);
            for (Product product : products) {
                productIDs.add(product.getName());
            }
            ECollections.sort((EList)products, (Comparator)new Comparator<Product>((List)productIDs){
                private final /* synthetic */ List val$productIDs;
                {
                    this.val$productIDs = list;
                }

                @Override
                public int compare(Product product1, Product product2) {
                    int index1 = this.val$productIDs.indexOf(product1.getName());
                    int index2 = this.val$productIDs.indexOf(product2.getName());
                    return index1 - index2;
                }
            });
            System.out.println("#################################################################################################################");
            System.out.println();
            this.checkVersionRanges(productCatalog);
            this.postProcess(productCatalog);
            Resource resource = new BaseResourceFactoryImpl().createResource(outputLocation == null ? URI.createURI((String)"org.eclipse.products.setup") : outputLocation);
            resource.getContents().add((Object)productCatalog);
            if (outputLocation != null) {
                resource.save(null);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private java.net.URI trimEmptyTrailingSegment(java.net.URI uri) throws URISyntaxException {
        String value = uri.toString();
        if (value.endsWith("/")) {
            return new java.net.URI(value.substring(0, value.length() - 1));
        }
        return uri;
    }

    private IMetadataRepositoryManager getMetadataRepositoryManager() throws IOException {
        File agentLocation = File.createTempFile("test-", "-agent");
        agentLocation.delete();
        agentLocation.mkdirs();
        AgentImpl agent = new AgentImpl(null, agentLocation);
        IMetadataRepositoryManager manager = agent.getMetadataRepositoryManager();
        return manager;
    }

    private IMetadataRepository getLatestRepository(IMetadataRepositoryManager manager, IMetadataRepository repository) throws URISyntaxException, ProvisionException {
        IMetadataRepository result = repository;
        java.net.URI location = repository.getLocation();
        if (location.getPath().endsWith("mars")) {
            IMetadataRepository childRepository = manager.loadRepository(new java.net.URI(location + "/R"), null);
            return childRepository;
        }
        if (!this.isLatestReleased() && repository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)repository;
            long latest = Integer.MIN_VALUE;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository = manager.loadRepository(childURI = this.trimEmptyTrailingSegment(childURI), null);
                String value = (String)childRepository.getProperties().get("p2.timestamp");
                long timestamp = Long.parseLong(value);
                if (timestamp <= latest) continue;
                result = childRepository;
                latest = timestamp;
            }
        }
        return result;
    }

    private IMetadataRepository loadLatestRepository(IMetadataRepositoryManager manager, java.net.URI eppURI, java.net.URI releaseURI) throws URISyntaxException, ProvisionException {
        IMetadataRepository releaseMetaDataRepository;
        IMetadataRepository result = releaseMetaDataRepository = manager.loadRepository(releaseURI, null);
        if (releaseMetaDataRepository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)releaseMetaDataRepository;
            long latest = Integer.MIN_VALUE;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository;
                String value;
                long timestamp;
                if ((childURI = this.trimEmptyTrailingSegment(childURI)).equals(eppURI) || (timestamp = Long.parseLong(value = (String)(childRepository = manager.loadRepository(childURI, null)).getProperties().get("p2.timestamp"))) <= latest) continue;
                result = childRepository;
                latest = timestamp;
            }
        }
        return result;
    }

    private void checkVersionRanges(ProductCatalog productCatalog) {
        if (!this.isLatestReleased()) {
            for (Product product : productCatalog.getProducts()) {
                EList versions = product.getVersions();
                if (versions.size() <= 3) continue;
                ProductVersion latestReleaseVersion = (ProductVersion)versions.get(1);
                ProductVersion latestDevelopmentVersion = (ProductVersion)versions.get(2);
                P2Task latestReleaseP2Task = (P2Task)latestReleaseVersion.getSetupTasks().get(0);
                P2Task latestDevelopmentP2Task = (P2Task)latestDevelopmentVersion.getSetupTasks().get(0);
                block1: for (Requirement developmentRequirement : latestDevelopmentP2Task.getRequirements()) {
                    String name = developmentRequirement.getName();
                    for (Requirement releaseRequirement : latestReleaseP2Task.getRequirements()) {
                        VersionRange releaseVersionRange;
                        if (!name.equals(releaseRequirement.getName())) continue;
                        VersionRange developmentVersionRange = developmentRequirement.getVersionRange();
                        if (!developmentVersionRange.equals((Object)(releaseVersionRange = releaseRequirement.getVersionRange()))) continue block1;
                        OSGiVersion minimum = (OSGiVersion)developmentVersionRange.getMinimum();
                        OSGiVersion maximum = (OSGiVersion)developmentVersionRange.getMaximum();
                        int major = minimum.getMajor();
                        if (major != maximum.getMajor()) continue block1;
                        developmentRequirement.setVersionRange(new VersionRange((Version)minimum, true, Version.createOSGi((int)major, (int)(maximum.getMinor() + 1), (int)0), false));
                        continue block1;
                    }
                }
            }
        }
    }

    private void postProcess(ProductCatalog productCatalog) {
        Iterator it = productCatalog.getProducts().iterator();
        while (it.hasNext()) {
            Product product = (Product)it.next();
            String id = product.getName();
            if (EXCLUDED_IDS.contains(id)) {
                it.remove();
            }
            if (!"epp.package.standard".equals(id)) continue;
            for (ProductVersion version : product.getVersions()) {
                if (!version.getLabel().contains("Mars")) continue;
                P2Task task = (P2Task)version.getSetupTasks().get(0);
                Requirement requirement = (Requirement)task.getRequirements().get(0);
                requirement.setName("epp.package.committers");
            }
        }
    }

    private void gatherReleaseIUs(Map<String, Set<IInstallableUnit>> releaseIUs, IInstallableUnit iu, IMetadataRepository releaseMetaDataRepository, IMetadataRepository eppMetaDataRepository) {
        for (IRequirement requirement : iu.getRequirements()) {
            IRequiredCapability capability;
            String capabilityName;
            if (!(requirement instanceof IRequiredCapability) || !(capabilityName = (capability = (IRequiredCapability)requirement).getName()).endsWith(".feature.group")) continue;
            CompoundQueryable queriable = new CompoundQueryable(new IQueryable[]{releaseMetaDataRepository, eppMetaDataRepository});
            IQuery query = QueryUtil.createIUQuery((String)capabilityName, (VersionRange)capability.getRange());
            for (IInstallableUnit requiredIU : P2Util.asIterable((IQueryResult)queriable.query(query, null))) {
                if (!CollectionUtil.add(releaseIUs, (Object)capabilityName, (Object)requiredIU)) continue;
                this.gatherReleaseIUs(releaseIUs, requiredIU, releaseMetaDataRepository, eppMetaDataRepository);
            }
        }
    }

    private void filterRoots(Map<String, Set<IInstallableUnit>> releaseIUs) {
        Iterator<Map.Entry<String, Set<IInstallableUnit>>> it = releaseIUs.entrySet().iterator();
        while (it.hasNext()) {
            String id = it.next().getKey();
            if (id.endsWith("feature.group") && !id.startsWith("org.eclipse.epp") && !id.endsWith("epp.feature.group")) continue;
            it.remove();
        }
    }

    private void addProductVersion(Product product, Version version, VersionSegment versionSegment, java.net.URI trainURI, java.net.URI eppURI, String train, Map<String, IMetadataRepository> eppMetaDataRepositories, String name, String label, String p2TaskLabel, Map<String, Set<IInstallableUnit>> ius, String emfRepositoryLocation) {
        IMetadataRepository eppMetaDataRepository;
        System.out.print("  " + label);
        ProductVersion productVersion = SetupFactory.eINSTANCE.createProductVersion();
        productVersion.setName(name);
        productVersion.setLabel(label);
        product.getVersions().add((Object)productVersion);
        String productName = product.getName();
        VersionRange versionRange = this.createVersionRange(version, versionSegment);
        Requirement requirement = P2Factory.eINSTANCE.createRequirement();
        requirement.setName(productName);
        requirement.setVersionRange(versionRange);
        Repository packageRepository = P2Factory.eINSTANCE.createRepository();
        packageRepository.setURL(eppURI.toString());
        Repository releaseRepository = P2Factory.eINSTANCE.createRepository();
        releaseRepository.setURL(trainURI.toString());
        P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
        p2Task.setLabel(String.valueOf(p2TaskLabel) + " (" + this.getTrainLabel(train) + ")");
        p2Task.getRequirements().add((Object)requirement);
        this.addRootIURequirements((EList<Requirement>)p2Task.getRequirements(), versionSegment, ius);
        if (!"org.eclipse.platform.ide".equals(name)) {
            p2Task.getRepositories().add((Object)packageRepository);
        }
        p2Task.getRepositories().add((Object)releaseRepository);
        if (train.compareTo("luna") < 0) {
            Repository emfRepository = P2Factory.eINSTANCE.createRepository(emfRepositoryLocation);
            p2Task.getRepositories().add((Object)emfRepository);
        }
        productVersion.getSetupTasks().add((Object)p2Task);
        String idPrefix = "tooling" + productName + ".ini.";
        Version maxJavaVersion = null;
        if (train.compareTo("mars") >= 0) {
            maxJavaVersion = Version.create((String)"1.7.0");
        }
        if ((eppMetaDataRepository = eppMetaDataRepositories.get(train)) != null) {
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)eppMetaDataRepository.query(QueryUtil.createIUAnyQuery(), null))) {
                Collection touchpointDatas;
                String id = iu.getId();
                if (!id.startsWith(idPrefix) || !iu.getVersion().equals(version) || (touchpointDatas = iu.getTouchpointData()) == null) continue;
                for (ITouchpointData touchpointData : touchpointDatas) {
                    int pos;
                    String body;
                    ITouchpointInstruction instruction = touchpointData.getInstruction("configure");
                    if (instruction == null || (body = instruction.getBody()) == null || (pos = body.indexOf(JAVA_VERSION_PREFIX)) == -1) continue;
                    Version javaVersion = Version.parseVersion((String)body.substring(pos += JAVA_VERSION_PREFIX.length(), body.indexOf(41, pos)));
                    if (maxJavaVersion != null && maxJavaVersion.compareTo((Object)javaVersion) >= 0) continue;
                    maxJavaVersion = javaVersion;
                }
            }
        }
        if (maxJavaVersion != null) {
            String javaVersion = maxJavaVersion.toString();
            while (javaVersion.endsWith(".0")) {
                javaVersion = javaVersion.substring(0, javaVersion.length() - 2);
            }
            productVersion.setRequiredJavaVersion(javaVersion);
            System.out.print(" --> Java " + javaVersion);
        }
        System.out.println();
    }

    private VersionRange createVersionRange(Version version, VersionSegment versionSegment) {
        VersionRange versionRange = P2Factory.eINSTANCE.createVersionRange(version, versionSegment);
        if (versionSegment == VersionSegment.MAJOR) {
            VersionRange minorVersionRange = P2Factory.eINSTANCE.createVersionRange(version, VersionSegment.MINOR);
            versionRange = new VersionRange(minorVersionRange.getMinimum(), true, versionRange.getMaximum(), false);
        }
        return versionRange;
    }

    private void addRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, Map<String, Set<IInstallableUnit>> ius) {
        String[] stringArray = this.getRootIUs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String iu = stringArray[n2];
            Set<IInstallableUnit> rootIUs = ius.get(iu);
            if (rootIUs != null) {
                VersionRange range = null;
                for (IInstallableUnit rootIU : rootIUs) {
                    Version version = rootIU.getVersion();
                    VersionRange versionRange = this.createVersionRange(version, versionSegment);
                    if (range != null) continue;
                    range = versionRange;
                }
                if (range != null) {
                    Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                    requirement.setName(iu);
                    requirement.setVersionRange(range);
                    requirements.add((Object)requirement);
                }
            }
            ++n2;
        }
    }

    private String getTrainLabel(String train) {
        return String.valueOf(Character.toString((char)(train.charAt(0) + 65 - 97))) + train.substring(1);
    }

    /*
     * Loose catch block
     */
    private void attachBrandingInfos(final Product product) {
        String staticIconURL;
        String name = product.getName();
        if (name.equals("org.eclipse.platform.ide")) {
            product.setDescription("This package contains the absolute minimal IDE, suitable only as a base for installing other tools.");
            return;
        }
        if (name.startsWith("epp.package.")) {
            name = name.substring("epp.package.".length());
        }
        if ((staticIconURL = ICONS.get(name)) != null) {
            this.addImageURI(product, staticIconURL);
        }
        String[] trains = this.getTrains();
        int i = trains.length;
        while (i >= 0) {
            block12: {
                InputStream in = null;
                try {
                    String branch = i == trains.length ? "master" : trains[i].toUpperCase();
                    String url = "http://git.eclipse.org/c/epp/org.eclipse.epp.packages.git/plain/packages/org.eclipse.epp.package." + name + ".feature/epp.website.xml" + "?h=" + branch;
                    in = new URL(url).openStream();
                    System.out.println(url);
                    DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                    Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (InputStream)in);
                    XMLUtil.handleElementsByTagName((Element)rootElement, (String)"packageMetaData", (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                        public void handleElement(Element element) throws Exception {
                            if (staticIconURL != null) {
                                System.out.println(staticIconURL);
                            } else {
                                String iconurl = element.getAttribute("iconurl");
                                if (iconurl != null) {
                                    ProductCatalogGenerator.this.addImageURI(product, iconurl);
                                    System.out.println(iconurl);
                                }
                            }
                            XMLUtil.handleChildElements((Element)element, (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                                public void handleElement(Element childElement) throws Exception {
                                    String description;
                                    String localName = childElement.getLocalName();
                                    if ("description".equals(localName) && (description = childElement.getTextContent()) != null) {
                                        product.setDescription(description.trim());
                                    }
                                }
                            });
                        }
                    });
                    IOUtil.closeSilent((Closeable)in);
                }
                catch (FileNotFoundException ex) {
                    System.out.println(String.valueOf(ex.getMessage()) + " (FAILED)");
                    break block12;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                    break block12;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtil.closeSilent(in);
                }
                return;
            }
            --i;
        }
        if (staticIconURL != null) {
            System.out.println(staticIconURL);
        }
    }

    private void addImageURI(Product product, String imageURI) {
        if (ICON_DEFAULT.equals(imageURI)) {
            return;
        }
        EMap<String, String> brandingInfos = this.getBrandingInfos(product);
        if (!brandingInfos.containsKey((Object)"imageURI")) {
            brandingInfos.put((Object)"imageURI", (Object)imageURI);
        }
    }

    private EMap<String, String> getBrandingInfos(Product product) {
        Annotation annotation = product.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
        if (annotation == null) {
            annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
            product.getAnnotations().add((Object)annotation);
        }
        return annotation.getDetails();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrainAndVersion {
        private final String train;
        private final Version version;
        private final Map<String, Set<IInstallableUnit>> ius;
        private final java.net.URI trainURI;
        private java.net.URI eppURI;

        public TrainAndVersion(String train, Version version, java.net.URI trainURI, java.net.URI eppURI, Map<String, Set<IInstallableUnit>> ius) {
            this.train = train;
            this.version = version;
            this.trainURI = trainURI;
            this.eppURI = eppURI;
            this.ius = ius;
        }

        public String getTrain() {
            return this.train;
        }

        public Version getVersion() {
            return this.version;
        }

        public java.net.URI getTrainURI() {
            return this.trainURI;
        }

        public java.net.URI getEPPURI() {
            return this.eppURI;
        }

        public Map<String, Set<IInstallableUnit>> getIUs() {
            return this.ius;
        }
    }
}

