/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.outgoing;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IIncomingFileTransferRequestListener;
import org.eclipse.ecf.filetransfer.SendFileTransferException;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.ISendFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferNamespace;
import org.eclipse.ecf.provider.filetransfer.outgoing.LocalFileOutgoingFileTransfer;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiProtocolOutgoingAdapter
implements ISendFileTransfer {
    IConnectContext connectContext = null;
    Proxy proxy = null;

    public Namespace getOutgoingNamespace() {
        return IDFactory.getDefault().getNamespaceByName(FileTransferNamespace.PROTOCOL);
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.connectContext = connectContext;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public void sendOutgoingRequest(IFileID targetID, File outgoingFile, IFileTransferListener transferListener, Map options) throws SendFileTransferException {
        Assert.isNotNull((Object)targetID);
        Assert.isNotNull((Object)outgoingFile);
        Assert.isNotNull((Object)transferListener);
        String protocol = null;
        try {
            protocol = targetID.getURI().getScheme();
        }
        catch (URISyntaxException e) {
            try {
                protocol = targetID.getURL().getProtocol();
            }
            catch (MalformedURLException e1) {
                throw new SendFileTransferException(Messages.AbstractRetrieveFileTransfer_MalformedURLException);
            }
        }
        ISendFileTransfer fileTransfer = Activator.getDefault().getSendFileTransfer(protocol);
        if (fileTransfer == null && protocol.equalsIgnoreCase("file")) {
            fileTransfer = new LocalFileOutgoingFileTransfer();
        }
        if (fileTransfer == null) {
            throw new SendFileTransferException(NLS.bind((String)Messages.MultiProtocolOutgoingAdapter_EXCEPTION_NO_PROTOCOL_HANDER, (Object)targetID));
        }
        fileTransfer.setConnectContextForAuthentication(this.connectContext);
        fileTransfer.setProxy(this.proxy);
        fileTransfer.sendOutgoingRequest(targetID, outgoingFile, transferListener, options);
    }

    public void addListener(IIncomingFileTransferRequestListener listener) {
    }

    public boolean removeListener(IIncomingFileTransferRequestListener listener) {
        return false;
    }

    public void sendOutgoingRequest(IFileID targetID, IFileTransferInfo localFileToSend, IFileTransferListener transferListener, Map options) throws SendFileTransferException {
        Assert.isNotNull((Object)targetID);
        Assert.isNotNull((Object)localFileToSend);
        Assert.isNotNull((Object)transferListener);
        String protocol = null;
        try {
            protocol = targetID.getURI().getScheme();
        }
        catch (URISyntaxException e) {
            try {
                protocol = targetID.getURL().getProtocol();
            }
            catch (MalformedURLException e1) {
                throw new SendFileTransferException(Messages.AbstractRetrieveFileTransfer_MalformedURLException);
            }
        }
        ISendFileTransfer fileTransfer = Activator.getDefault().getSendFileTransfer(protocol);
        if (fileTransfer == null) {
            throw new SendFileTransferException(NLS.bind((String)Messages.MultiProtocolOutgoingAdapter_EXCEPTION_NO_PROTOCOL_HANDER, (Object)targetID));
        }
        fileTransfer.setConnectContextForAuthentication(this.connectContext);
        fileTransfer.setProxy(this.proxy);
        fileTransfer.sendOutgoingRequest(targetID, localFileToSend, transferListener, options);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == null) {
            return null;
        }
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        if (adapterManager == null) {
            return null;
        }
        return (T)adapterManager.loadAdapter((Object)this, adapter.getName());
    }
}

