/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.restarts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.specs.Constr;

public class MixedRestartsStrategy
implements RestartStrategy {
    private static final long serialVersionUID = 1L;
    private final List<RestartStrategy> strategies;

    private MixedRestartsStrategy(List<RestartStrategy> strategies) {
        this.strategies = strategies;
    }

    public static RestartStrategy of(RestartStrategy first, RestartStrategy ... others) {
        ArrayList<RestartStrategy> strategies = new ArrayList<RestartStrategy>(others.length + 1);
        strategies.add(first);
        Collections.addAll(strategies, others);
        return new MixedRestartsStrategy(strategies);
    }

    public void reset() {
        for (RestartStrategy strategy : this.strategies) {
            strategy.reset();
        }
    }

    public void newConflict() {
        for (RestartStrategy strategy : this.strategies) {
            strategy.newConflict();
        }
    }

    public void init(SearchParams params, SolverStats stats) {
        for (RestartStrategy strategy : this.strategies) {
            strategy.init(params, stats);
        }
    }

    public long nextRestartNumberOfConflict() {
        return 0L;
    }

    public boolean shouldRestart() {
        for (RestartStrategy strategy : this.strategies) {
            if (!strategy.shouldRestart()) continue;
            return true;
        }
        return false;
    }

    public void onRestart() {
        for (RestartStrategy strategy : this.strategies) {
            strategy.onRestart();
        }
    }

    public void onBackjumpToRootLevel() {
        for (RestartStrategy strategy : this.strategies) {
            strategy.onBackjumpToRootLevel();
        }
    }

    public void newLearnedClause(Constr learned, int trailLevel) {
        for (RestartStrategy strategy : this.strategies) {
            strategy.newLearnedClause(learned, trailLevel);
        }
    }

    public String toString() {
        return "Mixed Restarts strategy of: " + this.strategies;
    }
}

