/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import java.util.List;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class ModeledPageLayoutUtils {
    private EModelService modelService;

    public ModeledPageLayoutUtils(EModelService modelService) {
        this.modelService = modelService;
    }

    public int plRelToSwt(int rel) {
        switch (rel) {
            case 4: {
                return 1024;
            }
            case 1: {
                return 16384;
            }
            case 2: {
                return 131072;
            }
            case 3: {
                return 128;
            }
        }
        return 0;
    }

    public void insert(MUIElement toInsert, MUIElement relTo, int swtSide, float ratio) {
        int pct = (int)(ratio * 10000.0f);
        this.insert(toInsert, relTo, swtSide, pct);
    }

    public void insert(MUIElement toInsert, MUIElement relTo, int swtSide, int ratio) {
        if (toInsert == null || relTo == null) {
            return;
        }
        MElementContainer relParent = relTo.getParent();
        if (relParent != null) {
            List children = relParent.getChildren();
            int index = children.indexOf(relTo);
            MPartSashContainer psc = (MPartSashContainer)this.modelService.createModelElement(MPartSashContainer.class);
            psc.setContainerData(relTo.getContainerData());
            relParent.getChildren().add(index + 1, psc);
            switch (swtSide) {
                case 16384: {
                    psc.getChildren().add((MPartSashContainerElement)toInsert);
                    psc.getChildren().add((MPartSashContainerElement)relTo);
                    toInsert.setContainerData(Integer.toString(ratio));
                    relTo.setContainerData(Integer.toString(10000 - ratio));
                    psc.setHorizontal(true);
                    break;
                }
                case 131072: {
                    psc.getChildren().add((MPartSashContainerElement)relTo);
                    psc.getChildren().add((MPartSashContainerElement)toInsert);
                    relTo.setContainerData(Integer.toString(ratio));
                    toInsert.setContainerData(Integer.toString(10000 - ratio));
                    psc.setHorizontal(true);
                    break;
                }
                case 128: {
                    psc.getChildren().add((MPartSashContainerElement)toInsert);
                    psc.getChildren().add((MPartSashContainerElement)relTo);
                    toInsert.setContainerData(Integer.toString(ratio));
                    relTo.setContainerData(Integer.toString(10000 - ratio));
                    psc.setHorizontal(false);
                    break;
                }
                case 1024: {
                    psc.getChildren().add((MPartSashContainerElement)relTo);
                    psc.getChildren().add((MPartSashContainerElement)toInsert);
                    relTo.setContainerData(Integer.toString(ratio));
                    toInsert.setContainerData(Integer.toString(10000 - ratio));
                    psc.setHorizontal(false);
                }
            }
            if (relTo.isToBeRendered() || toInsert.isToBeRendered()) {
                this.resetToBeRenderedFlag((MUIElement)psc, true);
            } else {
                psc.setToBeRendered(false);
            }
            return;
        }
    }

    public void resetToBeRenderedFlag(MUIElement element, boolean toBeRendered) {
        MElementContainer parent = element.getParent();
        while (parent != null && !(parent instanceof MPerspective)) {
            parent.setToBeRendered(toBeRendered);
            parent = parent.getParent();
        }
        element.setToBeRendered(toBeRendered);
    }

    public MPartStack createStack(String id, boolean visible) {
        MPartStack newStack = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        newStack.setElementId(id);
        newStack.setToBeRendered(visible);
        return newStack;
    }
}

