/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.internal.progress.FinishedJobs;
import org.eclipse.ui.internal.progress.GroupInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.ProgressManager;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.SubTaskInfo;
import org.eclipse.ui.internal.progress.TaskInfo;

public class JobInfo
extends JobTreeElement {
    private IStatus blockedStatus;
    private volatile boolean canceled;
    private final Queue<JobTreeElement> children = new ConcurrentLinkedQueue<JobTreeElement>();
    private final Job job;
    private GroupInfo parent;
    private volatile Optional<TaskInfo> taskInfo;
    private ProgressManager progressManager;
    private FinishedJobs finishedJobs;
    private int ticks = -1;

    protected JobInfo(Job enclosingJob) {
        this.job = enclosingJob;
        this.progressManager = ProgressManager.getInstance();
        this.finishedJobs = FinishedJobs.getInstance();
        this.taskInfo = Optional.empty();
    }

    public int hashCode() {
        return this.job.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JobInfo) {
            return this.job.equals(((JobInfo)obj).job);
        }
        return false;
    }

    void addSubTask(String subTaskName) {
        this.children.add(new SubTaskInfo(this, subTaskName));
    }

    void addWork(double workIncrement) {
        Optional<TaskInfo> optionalInfo = this.getTaskInfo();
        if (!optionalInfo.isPresent()) {
            return;
        }
        TaskInfo taskInfo = optionalInfo.get();
        if (this.parent == null || this.ticks < 1) {
            taskInfo.addWork(workIncrement);
        } else {
            taskInfo.addWork(workIncrement, this.parent, this.ticks);
        }
    }

    void beginTask(String taskName, int work) {
        this.taskInfo = Optional.of(new TaskInfo(this, taskName, work));
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.job.cancel();
        this.progressManager.refreshJobInfo(this);
    }

    void clearChildren() {
        this.children.clear();
    }

    void clearTaskInfo() {
        this.taskInfo.ifPresent(this.finishedJobs::remove);
        this.taskInfo = Optional.empty();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "('" + this.job.getName() + "' isUser=" + this.job.isUser() + " isBlocked=" + this.isBlocked() + " priority=" + this.job.getPriority() + ")";
    }

    void dispose() {
        if (this.parent != null) {
            this.parent.removeJobInfo(this);
        }
    }

    public IStatus getBlockedStatus() {
        return this.blockedStatus;
    }

    @Override
    Object[] getChildren() {
        return this.children.toArray();
    }

    @Override
    String getCondensedDisplayString() {
        Optional<TaskInfo> optionalInfo = this.getTaskInfo();
        if (optionalInfo.isPresent()) {
            return optionalInfo.get().getDisplayStringWithoutTask(true);
        }
        return this.getJob().getName();
    }

    @Override
    public Image getDisplayImage() {
        int done = this.getPercentDone();
        if (done > 0) {
            return super.getDisplayImage();
        }
        if (this.isBlocked()) {
            return JFaceResources.getImage((String)"LOCKED_JOB");
        }
        int state = this.getJob().getState();
        if (state == 1) {
            return JFaceResources.getImage((String)"SLEEPING_JOB");
        }
        if (state == 2) {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }
        return super.getDisplayImage();
    }

    @Override
    String getDisplayString() {
        return this.getDisplayString(true);
    }

    @Override
    String getDisplayString(boolean showProgress) {
        String name = this.getDisplayStringWithStatus(showProgress);
        if (this.job.isSystem()) {
            return NLS.bind((String)ProgressMessages.JobInfo_System, (Object[])new Object[]{name});
        }
        return name;
    }

    private String getDisplayStringWithStatus(boolean showProgress) {
        if (this.isCanceled()) {
            return NLS.bind((String)ProgressMessages.JobInfo_Cancelled, (Object[])new Object[]{this.getJob().getName()});
        }
        IStatus blockedStatusLocal = this.getBlockedStatus();
        if (blockedStatusLocal != null) {
            return NLS.bind((String)ProgressMessages.JobInfo_Blocked, (Object[])new Object[]{this.getJob().getName(), blockedStatusLocal.getMessage()});
        }
        if (this.getJob().getState() == 4) {
            Optional<TaskInfo> optionalInfo = this.getTaskInfo();
            if (!optionalInfo.isPresent()) {
                return this.getJob().getName();
            }
            return optionalInfo.get().getDisplayString(showProgress);
        }
        if (this.getJob().getState() == 1) {
            return NLS.bind((String)ProgressMessages.JobInfo_Sleeping, (Object[])new Object[]{this.getJob().getName()});
        }
        return NLS.bind((String)ProgressMessages.JobInfo_Waiting, (Object[])new Object[]{this.getJob().getName()});
    }

    GroupInfo getGroupInfo() {
        if (this.parent != null) {
            return this.parent;
        }
        return null;
    }

    public Job getJob() {
        return this.job;
    }

    @Override
    public GroupInfo getParent() {
        return this.parent;
    }

    int getPercentDone() {
        Optional<TaskInfo> optionalInfo = this.getTaskInfo();
        if (optionalInfo.isPresent()) {
            TaskInfo info = optionalInfo.get();
            if (info.totalWork == -1) {
                return -1;
            }
            if (info.totalWork == 0) {
                return 0;
            }
            return (int)info.preWork * 100 / info.totalWork;
        }
        return -1;
    }

    Optional<TaskInfo> getTaskInfo() {
        return this.taskInfo;
    }

    @Override
    boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    boolean isActive() {
        return this.getJob().getState() != 0;
    }

    public boolean isBlocked() {
        return this.getBlockedStatus() != null;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public boolean isCancellable() {
        return super.isCancellable();
    }

    @Override
    boolean isJobInfo() {
        return true;
    }

    public void setBlockedStatus(IStatus blockedStatus) {
        this.blockedStatus = blockedStatus;
    }

    void setGroupInfo(GroupInfo group) {
        this.parent = group;
    }

    void setTaskName(String name) {
        this.taskInfo.ifPresent(info -> info.setTaskName(name));
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }
}

