/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPPublicKeyStore;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPSignatureVerifier;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.ui.internal.about.AboutBundleData;
import org.osgi.framework.Bundle;

public class KeySigningInfoFactory
implements IAdapterFactory {
    private static final Class<?>[] CLASSES = new Class[]{AboutBundleData.ExtendedSigningInfo.class};

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == AboutBundleData.ExtendedSigningInfo.class) {
            return adapterType.cast(new AboutBundleData.ExtendedSigningInfo(){
                private final Map<File, Map<PGPSignature, PGPPublicKey>> bundlePoolArtficactSigningDetails = KeySigningInfoFactory.getBundlePoolArtficactPGPSigningDetails();

                public boolean isSigned(Bundle bundle) {
                    return this.getDetails(bundle) != null;
                }

                public String getSigningType(Bundle bundle) {
                    return ProvUIMessages.KeySigningInfoFactory_PGPSigningType;
                }

                public String getSigningDetails(Bundle bundle) {
                    Map<PGPSignature, PGPPublicKey> details = this.getDetails(bundle);
                    if (details != null) {
                        PGPPublicKeyService keyService = this.getKeyService();
                        ArrayList<String> lines = new ArrayList<String>();
                        for (PGPPublicKey key : details.values()) {
                            if (keyService != null) {
                                key = keyService.addKey(key);
                            }
                            if (!lines.isEmpty()) {
                                lines.add("");
                            }
                            this.addDetails(key, lines, "");
                            if (keyService == null) continue;
                            Set verifiedCertifications = keyService.getVerifiedCertifications(key);
                            boolean first = true;
                            for (PGPPublicKey verifyingKey : verifiedCertifications) {
                                if (verifyingKey.equals(key)) continue;
                                if (first) {
                                    lines.add("  " + ProvUIMessages.KeySigningInfoFactory_KeySignersSection);
                                    first = false;
                                }
                                this.addDetails(verifyingKey, lines, "    ");
                            }
                        }
                        return String.join((CharSequence)"\n", lines);
                    }
                    return null;
                }

                public Date getSigningTime(Bundle bundle) {
                    Map<PGPSignature, PGPPublicKey> details = this.getDetails(bundle);
                    return details == null ? null : details.keySet().iterator().next().getCreationTime();
                }

                private void addDetails(PGPPublicKey key, List<String> lines, String indentation) {
                    lines.add(String.valueOf(indentation) + ProvUIMessages.KeySigningInfoFactory_FingerprintItem + PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key));
                    Iterator userIDs = key.getUserIDs();
                    while (userIDs.hasNext()) {
                        lines.add(String.valueOf(indentation) + ProvUIMessages.KeySigningInfoFactory_UserIDItem + (String)userIDs.next());
                    }
                }

                private PGPPublicKeyService getKeyService() {
                    IProvisioningAgent agent = Activator.getCurrentAgent();
                    return agent == null ? null : (PGPPublicKeyService)agent.getService(PGPPublicKeyService.class);
                }

                private Map<PGPSignature, PGPPublicKey> getDetails(Bundle bundle) {
                    try {
                        File bundleFile = ((File)FileLocator.getBundleFileLocation((Bundle)bundle).orElseThrow()).getCanonicalFile();
                        return this.bundlePoolArtficactSigningDetails.get(bundleFile);
                    }
                    catch (IOException | RuntimeException e) {
                        ProvUIActivator.getDefault().getLog().log(Status.error((String)e.getMessage(), (Throwable)e));
                        return null;
                    }
                }
            });
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return CLASSES;
    }

    private static Map<File, Map<PGPSignature, PGPPublicKey>> getBundlePoolArtficactPGPSigningDetails() {
        LinkedHashMap<File, Map<PGPSignature, PGPPublicKey>> result = new LinkedHashMap<File, Map<PGPSignature, PGPPublicKey>>();
        try {
            IFileArtifactRepository bundlePoolRepository = Activator.getBundlePoolRepository();
            if (bundlePoolRepository == null) {
                return Collections.emptyMap();
            }
            IQueryResult allArtifactKeys = bundlePoolRepository.query((IQuery)ArtifactKeyQuery.ALL_KEYS, null);
            for (IArtifactKey key : allArtifactKeys) {
                IArtifactDescriptor[] iArtifactDescriptorArray = bundlePoolRepository.getArtifactDescriptors(key);
                int n = iArtifactDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
                    File file = bundlePoolRepository.getArtifactFile(descriptor);
                    if (file != null) {
                        try {
                            Collection signatures = PGPSignatureVerifier.getSignatures((IArtifactDescriptor)descriptor);
                            if (!signatures.isEmpty()) {
                                LinkedHashMap<PGPSignature, PGPPublicKey> details = new LinkedHashMap<PGPSignature, PGPPublicKey>();
                                PGPPublicKeyStore keys = PGPSignatureVerifier.getKeys((IArtifactDescriptor)descriptor);
                                for (PGPSignature signature : signatures) {
                                    Collection signingKeys = keys.getKeys(signature.getKeyID());
                                    if (signingKeys.isEmpty()) continue;
                                    details.put(signature, (PGPPublicKey)signingKeys.iterator().next());
                                }
                                if (!details.isEmpty()) {
                                    result.put(file.getCanonicalFile(), details);
                                }
                            }
                        }
                        catch (IOException | RuntimeException | PGPException e) {
                            ProvUIActivator.getDefault().getLog().log(Status.error((String)e.getMessage(), (Throwable)e));
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (RuntimeException e) {
            ProvUIActivator.getDefault().getLog().log(Status.error((String)e.getMessage(), (Throwable)e));
        }
        return result;
    }
}

