/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.oomph.p2.internal.ui.P2ServiceUI;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.internal.core.util.ECFURIHandlerImpl;
import org.eclipse.oomph.setup.internal.installer.ExtensionPage;
import org.eclipse.oomph.setup.internal.installer.ProductPage;
import org.eclipse.oomph.setup.ui.wizards.ProjectPage;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;

public class Installer
extends SetupWizard {
    public static final P2ServiceUI SERVICE_UI = new P2ServiceUI();
    private final SetupWizard.SelectionMemento selectionMemento;

    public Installer(SetupWizard.SelectionMemento selectionMemento) {
        this.selectionMemento = selectionMemento;
        this.setTrigger(Trigger.BOOTSTRAP);
        this.getResourceSet().getLoadOptions().put("OPTION_CACHE_HANDLING", ECFURIHandlerImpl.CacheHandling.CACHE_WITHOUT_ETAG_CHECKING);
        this.setSetupContext(SetupContext.createUserOnly((ResourceSet)this.getResourceSet()));
        this.setWindowTitle("Eclipse Installer");
    }

    public SetupWizard.SelectionMemento getSelectionMemento() {
        return this.selectionMemento;
    }

    public String getHelpPath() {
        return "/org.eclipse.oomph.setup.doc/html/user/wizard/DocInstallWizard.html";
    }

    public void addPages() {
        this.addPage((IWizardPage)new ProductPage(this.selectionMemento));
        this.addPage((IWizardPage)new ProjectPage(this.selectionMemento));
        this.addPage((IWizardPage)new ExtensionPage());
        super.addPages();
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                Installer.this.loadIndex();
            }
        });
    }

    protected void indexLoaded(Index index) {
        super.indexLoaded(index);
        this.getCatalogManager().indexLoaded(index);
    }

    public void setPerformer(SetupTaskPerformer performer) {
        super.setPerformer(performer);
        if (performer != null) {
            performer.put(UIServices.class, (Object)SERVICE_UI);
        }
    }
}

