/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.version.VersionUtil;
import org.eclipse.oomph.version.ui.views.Messages;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class VersionsView
extends ViewPart {
    public static final String ID = "org.eclipse.oomph.version.VersionsView";
    private TreeViewer viewer;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setComparator((ViewerComparator)new NameSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                VersionsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.action2);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
    }

    private void makeActions() {
        this.action1 = new Action(){

            public void run() {
                VersionsView.this.showMessage(Messages.VersionsView_action1_executedMessage);
            }
        };
        this.action1.setText(Messages.VersionsView_action1_text);
        this.action1.setToolTipText(Messages.VersionsView_action1_tooltip);
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action(){

            public void run() {
                VersionsView.this.showMessage(Messages.VersionsView_action2_executedMessage);
            }
        };
        this.action2.setText(Messages.VersionsView_action2_text);
        this.action2.setToolTipText(Messages.VersionsView_action2_tooltip);
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = VersionsView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                VersionsView.this.showMessage(NLS.bind((String)Messages.VersionsView_doubleClickAction_detectedMessage, (Object)obj.toString()));
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                VersionsView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.VersionsView_messageDialog_versions, (String)message);
    }

    class NameSorter
    extends ViewerComparator {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        private final Map<String, Set<BundleDescription>> bundles = new HashMap<String, Set<BundleDescription>>();
        private final Map<String, Set<ExportPackageDescription>> packages = new HashMap<String, Set<ExportPackageDescription>>();

        public ViewContentProvider() {
            IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getActiveModels((boolean)true);
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase pluginModel = iPluginModelBaseArray[n2];
                BundleDescription bundleDescription = pluginModel.getBundleDescription();
                if (bundleDescription != null) {
                    CollectionUtil.add(this.bundles, (Object)bundleDescription.getSymbolicName(), (Object)bundleDescription);
                }
                ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getExportPackages();
                int n3 = exportPackageDescriptionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ExportPackageDescription exportPackageDescription = exportPackageDescriptionArray[n4];
                    CollectionUtil.add(this.packages, (Object)exportPackageDescription.getName(), (Object)exportPackageDescription);
                    ++n4;
                }
                ++n2;
            }
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parent) {
            ImportPackageSpecification importPackageSpecification;
            Set<ExportPackageDescription> resolvedPackages;
            ArrayList<Object> result = new ArrayList<Object>();
            if (parent instanceof IPluginModelBase) {
                IPluginModelBase pluginModel = (IPluginModelBase)parent;
                BundleDescription bundleDescription = pluginModel.getBundleDescription();
                if (bundleDescription != null) {
                    BundleSpecification[] requiredBundles = bundleDescription.getRequiredBundles();
                    ImportPackageSpecification[] importPackages = bundleDescription.getImportPackages();
                    result.addAll(Arrays.asList(requiredBundles));
                    result.addAll(Arrays.asList(importPackages));
                }
            } else if (parent instanceof BundleSpecification) {
                BundleSpecification bundleSpecification = (BundleSpecification)parent;
                Set<BundleDescription> resolvedBundles = this.bundles.get(bundleSpecification.getName());
                if (resolvedBundles != null) {
                    result.addAll(resolvedBundles);
                }
            } else if (parent instanceof ImportPackageSpecification && (resolvedPackages = this.packages.get((importPackageSpecification = (ImportPackageSpecification)parent).getName())) != null) {
                result.addAll(resolvedPackages);
            }
            return result.toArray();
        }

        public Object[] getElements(Object parent) {
            ArrayList allComponentModels = new ArrayList();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isAccessible()) {
                    try {
                        List componentModels = VersionUtil.getComponentModels((IProject)project);
                        allComponentModels.addAll(componentModels);
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            return allComponentModels.toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object getParent(Object element) {
            return null;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

