/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.setup.Argument;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Macro;
import org.eclipse.oomph.setup.MacroTask;
import org.eclipse.oomph.setup.Parameter;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTaskContainer;
import org.eclipse.oomph.setup.p2.util.MarketPlaceListing;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.actions.Messages;
import org.eclipse.oomph.setup.ui.wizards.MarketPlaceListingProcessor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ConfigureMarketPlaceListingAction
implements IObjectActionDelegate {
    private final Set<MacroTask> macroTasks = new HashSet<MacroTask>();
    private Shell shell;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart == null ? null : targetPart.getSite().getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.macroTasks.clear();
        if (selection instanceof IStructuredSelection) {
            Object[] objectArray = ((IStructuredSelection)selection).toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                MacroTask macroTask;
                Object element = objectArray[n2];
                if (element instanceof MacroTask && ConfigureMarketPlaceListingAction.isValid(macroTask = (MacroTask)element)) {
                    this.macroTasks.add(macroTask);
                }
                ++n2;
            }
        }
        action.setEnabled(this.shell != null && this.macroTasks.size() == 1);
        action.setImageDescriptor(SetupUIPlugin.INSTANCE.getImageDescriptor("marketplace16.png"));
    }

    public void run(IAction action) {
        MacroTask macroTask = this.macroTasks.iterator().next();
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)macroTask);
        if (domain != null) {
            ConfigureMarketPlaceListingAction.execute(this.shell, domain, macroTask);
        }
    }

    public static void configure(Shell shell, EditingDomain domain, MacroTask macroTask) {
        if (ConfigureMarketPlaceListingAction.isValid(macroTask)) {
            ConfigureMarketPlaceListingAction.execute(shell, domain, macroTask);
        }
    }

    private static boolean isValid(MacroTask macroTask) {
        Macro macro = macroTask.getMacro();
        return macro != null && macro.eResource() != null && Diagnostician.INSTANCE.validate(macro.eClass(), (EObject)macro, null, Diagnostician.INSTANCE.createDefaultContext()) && MarketPlaceListing.isMarketPlaceListing((URI)macro.eResource().getURI());
    }

    private static void execute(Shell shell, final EditingDomain domain, final MacroTask macroTask) {
        final Macro macro = macroTask.getMacro();
        Resource resource = macro.eResource();
        URI uri = resource.getURI();
        final LinkedHashMap<String, Argument> arguments = new LinkedHashMap<String, Argument>();
        for (Argument argument : macroTask.getArguments()) {
            String name;
            Parameter parameter = argument.getParameter();
            if (parameter == null || (name = parameter.getName()) == null) continue;
            arguments.put(name, argument);
        }
        new MarketPlaceListingProcessor(shell, MarketPlaceListing.getMarketPlaceListing((URI)uri, (URIConverter)domain.getResourceSet().getURIConverter()), resource){

            @Override
            protected boolean isSelected(Requirement requirement) {
                String correspondParameterName = this.getCorrespondParameterName(requirement);
                Argument argument = (Argument)arguments.get(correspondParameterName);
                return argument != null && "true".equals(argument.getValue());
            }

            @Override
            protected void applyMarketPlaceListing(Set<Requirement> checkedRequirements) {
                CompoundTask compoundTask = SetupFactory.eINSTANCE.createCompoundTask();
                MacroTask newMacroTask = this.createMacroTask((SetupTaskContainer)compoundTask, macro, checkedRequirements);
                LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
                for (Parameter parameter : macro.getParameters()) {
                    String name = parameter.getName();
                    parameters.put(name, parameter);
                }
                ArrayList<Argument> newArguments = new ArrayList<Argument>();
                LinkedHashMap<Argument, String> newArgumentValues = new LinkedHashMap<Argument, String>();
                boolean addArgument = false;
                for (Argument argument : newMacroTask.getArguments()) {
                    String name = argument.getParameter().getName();
                    Argument otherArgument = (Argument)arguments.get(name);
                    if (otherArgument == null) {
                        otherArgument = SetupFactory.eINSTANCE.createArgument();
                        otherArgument.setParameter((Parameter)parameters.get(name));
                        otherArgument.setValue(argument.getValue());
                        addArgument = true;
                    } else {
                        newArgumentValues.put(otherArgument, argument.getValue());
                    }
                    newArguments.add(otherArgument);
                }
                CompoundCommand compoundCommand = new CompoundCommand(Messages.ConfigureMarketPlaceListingAction_commandLabel);
                if (addArgument) {
                    compoundCommand.append(SetCommand.create((EditingDomain)domain, (Object)macroTask, (Object)SetupPackage.Literals.MACRO_TASK__ARGUMENTS, newArguments));
                }
                for (Map.Entry entry : newArgumentValues.entrySet()) {
                    compoundCommand.append(SetCommand.create((EditingDomain)domain, entry.getKey(), (Object)SetupPackage.Literals.ARGUMENT__VALUE, entry.getValue()));
                }
                domain.getCommandStack().execute((Command)compoundCommand);
            }
        }.processMarketPlaceListing();
    }
}

