/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.formatter;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingStrategyExtension;

public abstract class ContextBasedFormattingStrategy
implements IFormattingStrategy,
IFormattingStrategyExtension {
    private Map<String, String> fCurrentPreferences = null;
    private final LinkedList<Map<String, String>> fPreferences = new LinkedList();

    @Override
    public void format() {
        this.fCurrentPreferences = this.fPreferences.removeFirst();
    }

    @Override
    public String format(String content, boolean start, String indentation, int[] positions) {
        return null;
    }

    @Override
    public void formatterStarts(IFormattingContext context) {
        Map prefs = (Map)context.getProperty("formatting.context.preferences");
        this.fPreferences.addLast(prefs);
    }

    @Override
    public void formatterStarts(String indentation) {
    }

    @Override
    public void formatterStops() {
        this.fPreferences.clear();
        this.fCurrentPreferences = null;
    }

    public final Map<String, String> getPreferences() {
        return this.fCurrentPreferences;
    }
}

