/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.navigator.CommonNavigatorMessages;
import org.eclipse.ui.internal.navigator.ContributorTrackingSet;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.navigator.NavigatorSafeRunnable;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.internal.navigator.extensions.SafeDelegateTreeContentProvider;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;
import org.eclipse.ui.navigator.OverridePolicy;

public class NavigatorContentServiceContentProvider
implements ITreeContentProvider,
ITreePathContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final NavigatorContentService contentService;
    private boolean disposeContentService;
    private final boolean enforceHasChildren;
    private Viewer viewer;
    private static final boolean ELEMENTS = true;

    public NavigatorContentServiceContentProvider(String aViewerId) {
        this(new NavigatorContentService(aViewerId));
        this.disposeContentService = true;
    }

    public NavigatorContentServiceContentProvider(NavigatorContentService aContentService) {
        this.contentService = aContentService;
        INavigatorViewerDescriptor vDesc = this.contentService.getViewerDescriptor();
        this.enforceHasChildren = vDesc.getBooleanConfigProperty("org.eclipse.ui.navigator.enforceHasChildren");
    }

    public void inputChanged(Viewer aViewer, Object anOldInput, Object aNewInput) {
        this.viewer = aViewer;
        this.contentService.updateService(aViewer, anOldInput, aNewInput);
    }

    public Object[] getElements(Object anInputElement) {
        Set<NavigatorContentExtension> rootContentExtensions = this.contentService.findRootContentExtensions(anInputElement);
        return this.internalGetChildren(anInputElement, anInputElement, rootContentExtensions, true);
    }

    public Object[] getChildren(Object aParentElement) {
        Set<NavigatorContentExtension> enabledExtensions = this.contentService.findContentExtensionsByTriggerPoint(aParentElement);
        return this.internalGetChildren(aParentElement, aParentElement, enabledExtensions, false);
    }

    public Object[] getChildren(TreePath parentPath) {
        Object aParentElement = this.internalAsElement(parentPath);
        Set<NavigatorContentExtension> enabledExtensions = this.contentService.findContentExtensionsByTriggerPoint(aParentElement);
        return this.internalGetChildren(aParentElement, parentPath, enabledExtensions, false);
    }

    private Object[] internalGetChildren(final Object aParentElement, final Object aParentElementOrPath, final Set enabledExtensions, final boolean elements) {
        if (enabledExtensions.isEmpty()) {
            return NO_CHILDREN;
        }
        final LinkedHashSet finalSet = new LinkedHashSet();
        final ContributorTrackingSet localSet = new ContributorTrackingSet(this.contentService);
        Iterator itr = enabledExtensions.iterator();
        while (itr.hasNext()) {
            SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(itr){
                NavigatorContentExtension foundExtension;
                Object[] contributedChildren;
                NavigatorContentExtension[] overridingExtensions;
                {
                    this.foundExtension = (NavigatorContentExtension)iterator.next();
                    this.contributedChildren = null;
                }

                @Override
                public void run() throws Exception {
                    if (!NavigatorContentServiceContentProvider.this.isOverridingExtensionInSet(this.foundExtension.getDescriptor(), enabledExtensions)) {
                        this.contributedChildren = elements ? this.foundExtension.internalGetContentProvider().getElements(aParentElementOrPath) : this.foundExtension.internalGetContentProvider().getChildren(aParentElementOrPath);
                        this.overridingExtensions = this.foundExtension.getOverridingExtensionsForTriggerPoint(aParentElement);
                        INavigatorContentDescriptor foundDescriptor = this.foundExtension.getDescriptor();
                        localSet.setContributor(foundDescriptor, foundDescriptor);
                        localSet.setContents(this.contributedChildren);
                        if (this.overridingExtensions.length > 0) {
                            NavigatorContentServiceContentProvider.this.pipelineChildren(aParentElement, this.overridingExtensions, foundDescriptor, localSet, elements);
                        }
                        finalSet.addAll(localSet);
                    }
                }

                @Override
                public void handleException(Throwable e) {
                    NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])new Object[]{this.foundExtension.getDescriptor().getId(), aParentElement}), e);
                }
            });
        }
        return finalSet.toArray();
    }

    private void pipelineChildren(Object aParent, NavigatorContentExtension[] theOverridingExtensions, INavigatorContentDescriptor firstClassDescriptor, ContributorTrackingSet pipelinedChildren, boolean elements) {
        NavigatorContentExtension[] navigatorContentExtensionArray = theOverridingExtensions;
        int n = theOverridingExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            NavigatorContentExtension overridingExtension = navigatorContentExtensionArray[n2];
            if (overridingExtension.internalGetContentProvider().isPipelined()) {
                SafeDelegateTreeContentProvider pipelinedContentProvider = overridingExtension.internalGetContentProvider();
                pipelinedChildren.setContributor(overridingExtension.getDescriptor(), firstClassDescriptor);
                if (elements) {
                    pipelinedContentProvider.getPipelinedElements(aParent, pipelinedChildren);
                } else {
                    pipelinedContentProvider.getPipelinedChildren(aParent, pipelinedChildren);
                }
                NavigatorContentExtension[] overridingExtensions = overridingExtension.getOverridingExtensionsForTriggerPoint(aParent);
                if (overridingExtensions.length > 0) {
                    this.pipelineChildren(aParent, overridingExtensions, firstClassDescriptor, pipelinedChildren, elements);
                }
            }
            ++n2;
        }
    }

    private boolean isOverridingExtensionInSet(INavigatorContentDescriptor aDescriptor, Set theEnabledExtensions) {
        return aDescriptor.getSuppressedExtensionId() != null && aDescriptor.getOverridePolicy() == OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt && theEnabledExtensions.contains(this.contentService.getExtension(aDescriptor.getOverriddenDescriptor()));
    }

    private boolean isOverridingDescriptorInSet(INavigatorContentDescriptor aDescriptor, Set theEnabledDescriptors) {
        return aDescriptor.getSuppressedExtensionId() != null && aDescriptor.getOverridePolicy() == OverridePolicy.InvokeAlwaysRegardlessOfSuppressedExt && theEnabledDescriptors.contains(aDescriptor.getOverriddenDescriptor());
    }

    public Object getParent(final Object anElement) {
        final Set<NavigatorContentExtension> extensions = this.contentService.findContentExtensionsWithPossibleChild(anElement);
        final Object[] parent = new Object[1];
        for (final NavigatorContentExtension foundExtension : extensions) {
            SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){
                NavigatorContentExtension[] overridingExtensions;

                @Override
                public void run() throws Exception {
                    if (!NavigatorContentServiceContentProvider.this.isOverridingExtensionInSet(foundExtension.getDescriptor(), extensions)) {
                        parent[0] = foundExtension.internalGetContentProvider().getParent(anElement);
                        this.overridingExtensions = foundExtension.getOverridingExtensionsForPossibleChild(anElement);
                        if (this.overridingExtensions.length > 0) {
                            parent[0] = NavigatorContentServiceContentProvider.this.pipelineParent(anElement, this.overridingExtensions, parent);
                        }
                    }
                }

                @Override
                public void handleException(Throwable e) {
                    NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])new Object[]{foundExtension.getDescriptor().getId(), anElement}), e);
                }
            });
            if (parent[0] == null) continue;
            return parent[0];
        }
        return parent[0];
    }

    public TreePath[] getParents(Object anElement) {
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        TreePathCompiler compiler = new TreePathCompiler(anElement);
        Set compilers = this.findPaths(compiler);
        for (TreePathCompiler c : compilers) {
            paths.add(c.createParentPath());
        }
        return paths.toArray(new TreePath[paths.size()]);
    }

    private Object pipelineParent(Object anInputElement, NavigatorContentExtension[] theOverridingExtensions, Object theCurrentParent) {
        Object aSuggestedParent = null;
        NavigatorContentExtension[] navigatorContentExtensionArray = theOverridingExtensions;
        int n = theOverridingExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            NavigatorContentExtension theOverridingExtension = navigatorContentExtensionArray[n2];
            if (theOverridingExtension.internalGetContentProvider().isPipelined()) {
                SafeDelegateTreeContentProvider pipelinedContentProvider = theOverridingExtension.internalGetContentProvider();
                aSuggestedParent = pipelinedContentProvider.getPipelinedParent(anInputElement, aSuggestedParent);
                NavigatorContentExtension[] overridingExtensions = theOverridingExtension.getOverridingExtensionsForTriggerPoint(anInputElement);
                if (overridingExtensions.length > 0) {
                    aSuggestedParent = this.pipelineParent(anInputElement, overridingExtensions, aSuggestedParent);
                }
            }
            ++n2;
        }
        return aSuggestedParent != null ? aSuggestedParent : theCurrentParent;
    }

    public boolean hasChildren(final Object anElementOrPath) {
        final Object anElement = this.internalAsElement(anElementOrPath);
        final Set<NavigatorContentExtension> enabledExtensions = this.contentService.findContentExtensionsByTriggerPoint(anElement);
        final boolean[] suggestedHasChildren = new boolean[1];
        final Iterator<NavigatorContentExtension> itr = enabledExtensions.iterator();
        while (itr.hasNext()) {
            SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){
                NavigatorContentExtension ext;

                @Override
                public void run() throws Exception {
                    this.ext = (NavigatorContentExtension)itr.next();
                    if (!this.ext.isLoaded() && !NavigatorContentServiceContentProvider.this.enforceHasChildren) {
                        suggestedHasChildren[0] = true;
                        return;
                    }
                    if (!NavigatorContentServiceContentProvider.this.isOverridingExtensionInSet(this.ext.getDescriptor(), enabledExtensions)) {
                        SafeDelegateTreeContentProvider cp = this.ext.internalGetContentProvider();
                        suggestedHasChildren[0] = suggestedHasChildren[0] | NavigatorContentServiceContentProvider.this.callNormalHasChildren(anElementOrPath, anElement, cp);
                        NavigatorContentExtension[] overridingExtensions = this.ext.getOverridingExtensionsForTriggerPoint(anElement);
                        if (overridingExtensions.length > 0) {
                            suggestedHasChildren[0] = NavigatorContentServiceContentProvider.this.pipelineHasChildren(anElementOrPath, anElement, overridingExtensions, suggestedHasChildren[0]);
                        }
                        if (suggestedHasChildren[0]) {
                            return;
                        }
                    }
                }

                @Override
                public void handleException(Throwable e) {
                    NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])new Object[]{this.ext.getDescriptor().getId(), anElementOrPath}), e);
                }
            });
        }
        return suggestedHasChildren[0];
    }

    public boolean hasChildren(TreePath path) {
        return this.hasChildren((Object)path);
    }

    private boolean callNormalHasChildren(Object anElementOrPath, Object anElement, SafeDelegateTreeContentProvider cp) {
        if (cp.isTreePath() && anElementOrPath instanceof TreePath) {
            SafeDelegateTreeContentProvider tpcp = cp;
            return tpcp.hasChildren((TreePath)anElementOrPath);
        }
        return cp.hasChildren(anElement);
    }

    private boolean pipelineHasChildren(Object anElementOrPath, Object anElement, NavigatorContentExtension[] theOverridingExtensions, boolean suggestedHasChildren) {
        NavigatorContentExtension[] navigatorContentExtensionArray = theOverridingExtensions;
        int n = theOverridingExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            NavigatorContentExtension theOverridingExtension = navigatorContentExtensionArray[n2];
            SafeDelegateTreeContentProvider cp = theOverridingExtension.internalGetContentProvider();
            if (cp.isPipelinedHasChildren()) {
                suggestedHasChildren = cp.hasPipelinedChildren(anElement, suggestedHasChildren);
                NavigatorContentExtension[] overridingExtensions = theOverridingExtension.getOverridingExtensionsForTriggerPoint(anElement);
                if (overridingExtensions.length > 0) {
                    suggestedHasChildren = this.pipelineHasChildren(anElementOrPath, anElement, overridingExtensions, suggestedHasChildren);
                }
            } else {
                suggestedHasChildren |= this.callNormalHasChildren(anElementOrPath, anElement, cp);
            }
            ++n2;
        }
        return suggestedHasChildren;
    }

    public void dispose() {
        if (this.disposeContentService) {
            this.contentService.dispose();
        }
    }

    private Object internalAsElement(Object parentElementOrPath) {
        if (parentElementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)parentElementOrPath;
            if (tp.getSegmentCount() > 0) {
                return tp.getLastSegment();
            }
            return this.viewer.getInput();
        }
        return parentElementOrPath;
    }

    private Set findPaths(TreePathCompiler aPathCompiler) {
        Set parents = this.findParents(aPathCompiler.getFirstSegment());
        LinkedHashSet<TreePathCompiler> parentPaths = new LinkedHashSet<TreePathCompiler>();
        Set foundPaths = Collections.EMPTY_SET;
        if (parents.size() > 0) {
            for (Object parent : parents) {
                TreePathCompiler c = new TreePathCompiler(aPathCompiler);
                try {
                    c.addParent(parent);
                    foundPaths = this.findPaths(c);
                }
                catch (CyclicPathException cpe) {
                    String msg = cpe.getMessage() != null ? cpe.getMessage() : cpe.toString();
                    NavigatorPlugin.logError(0, msg, cpe);
                }
                if (foundPaths.isEmpty()) {
                    parentPaths.add(c);
                    continue;
                }
                parentPaths.addAll(foundPaths);
            }
        }
        return parentPaths;
    }

    private Set findParents(final Object anElement) {
        final Set<INavigatorContentDescriptor> descriptors = this.contentService.findDescriptorsWithPossibleChild(anElement, false);
        final LinkedHashSet parents = new LinkedHashSet();
        final Iterator<INavigatorContentDescriptor> itr = descriptors.iterator();
        while (itr.hasNext()) {
            SafeRunner.run((ISafeRunnable)new NavigatorSafeRunnable(){
                NavigatorContentDescriptor foundDescriptor;
                NavigatorContentExtension foundExtension;
                Object parent = null;

                @Override
                public void run() throws Exception {
                    this.foundDescriptor = (NavigatorContentDescriptor)itr.next();
                    this.foundExtension = NavigatorContentServiceContentProvider.this.contentService.getExtension(this.foundDescriptor);
                    if (!NavigatorContentServiceContentProvider.this.isOverridingDescriptorInSet(this.foundExtension.getDescriptor(), descriptors)) {
                        if (this.foundExtension.internalGetContentProvider().isTreePath()) {
                            TreePath[] parentTreePaths;
                            TreePath[] treePathArray = parentTreePaths = this.foundExtension.internalGetContentProvider().getParents(anElement);
                            int n = parentTreePaths.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TreePath parentTreePath = treePathArray[n2];
                                this.parent = parentTreePath.getLastSegment();
                                this.parent = NavigatorContentServiceContentProvider.this.findParent(this.foundExtension, anElement, this.parent);
                                if (this.parent != null) {
                                    parents.add(this.parent);
                                }
                                ++n2;
                            }
                        } else {
                            this.parent = this.foundExtension.internalGetContentProvider().getParent(anElement);
                            this.parent = NavigatorContentServiceContentProvider.this.findParent(this.foundExtension, anElement, this.parent);
                            if (this.parent != null) {
                                parents.add(this.parent);
                            }
                        }
                    }
                }

                @Override
                public void handleException(Throwable e) {
                    NavigatorPlugin.logError(0, NLS.bind((String)CommonNavigatorMessages.Exception_Invoking_Extension, (Object[])new Object[]{this.foundExtension.getDescriptor().getId(), anElement}), e);
                }
            });
        }
        return parents;
    }

    private Object findParent(NavigatorContentExtension anExtension, Object anElement, Object aSuggestedParent) {
        NavigatorContentExtension[] overridingExtensions;
        Object lastValidParent = aSuggestedParent;
        Object suggestedOverriddenParent = null;
        NavigatorContentExtension[] navigatorContentExtensionArray = overridingExtensions = anExtension.getOverridingExtensionsForPossibleChild(anElement);
        int n = overridingExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            NavigatorContentExtension overridingExtension = navigatorContentExtensionArray[n2];
            if (overridingExtension.internalGetContentProvider().isPipelined()) {
                SafeDelegateTreeContentProvider piplineContentProvider = overridingExtension.internalGetContentProvider();
                suggestedOverriddenParent = piplineContentProvider.getPipelinedParent(anElement, lastValidParent);
                if (suggestedOverriddenParent != null && !suggestedOverriddenParent.equals(aSuggestedParent)) {
                    lastValidParent = suggestedOverriddenParent;
                }
                lastValidParent = this.findParent(overridingExtension, anElement, lastValidParent);
            }
            ++n2;
        }
        return lastValidParent;
    }

    static class CyclicPathException
    extends Exception {
        private static final long serialVersionUID = 2111962579612444989L;

        protected CyclicPathException(TreePathCompiler compiler, Object invalidSegment, boolean asChild) {
            super("Cannot add " + String.valueOf(invalidSegment) + " to the list of segments in " + String.valueOf(compiler) + (asChild ? " as a child." : " as a parent."));
        }
    }

    static class TreePathCompiler {
        private final LinkedList segments = new LinkedList();

        protected TreePathCompiler(Object segment) {
            this.segments.add(segment);
        }

        protected TreePathCompiler(TreePathCompiler aCompiler) {
            this.segments.addAll(aCompiler.segments);
        }

        protected TreePathCompiler(TreePath aPath) {
            int i = 0;
            while (i < aPath.getSegmentCount()) {
                this.segments.addLast(aPath.getSegment(i));
                ++i;
            }
        }

        protected void addParent(Object segment) throws CyclicPathException {
            if (this.segments.contains(segment)) {
                throw new CyclicPathException(this, segment, false);
            }
            this.segments.addFirst(segment);
        }

        protected void addChild(Object segment) throws CyclicPathException {
            if (this.segments.contains(segment)) {
                throw new CyclicPathException(this, segment, false);
            }
            this.segments.addLast(segment);
        }

        public TreePath createPath() {
            return new TreePath(this.segments.toArray());
        }

        public TreePath createParentPath() {
            LinkedList parentSegments = new LinkedList(this.segments);
            parentSegments.removeLast();
            return new TreePath(parentSegments.toArray());
        }

        public Object getLastSegment() {
            return this.segments.getLast();
        }

        public Object getFirstSegment() {
            return this.segments.getFirst();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            for (Object segment : this.segments) {
                buffer.append(segment).append("::");
            }
            return buffer.toString();
        }
    }
}

