/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jsch.internal.core;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jsch.core.IJSchLocation;
import org.eclipse.jsch.internal.core.IUserAuthenticator;
import org.eclipse.jsch.internal.core.IUserInfo;
import org.eclipse.jsch.internal.core.Messages;

class UserInfoImpl
implements UserInfo,
UIKeyboardInteractive {
    private final String username;
    private String password;
    private String passphrase;
    private final IJSchLocation location;
    private final IUserAuthenticator authenticator;
    private int attemptCount;
    private boolean passwordChanged;
    private long startTime;
    private long endTime;
    private boolean prompting;
    private final long timeout;
    private int reuse = 0;

    UserInfoImpl(IJSchLocation location, IUserAuthenticator authenticator, long timeout) {
        this.location = location;
        this.username = location.getUsername();
        this.password = location.getPassword();
        this.authenticator = authenticator;
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public String getPassphrase() {
        return this.passphrase;
    }

    public boolean promptYesNo(String str) {
        int prompt = this.authenticator.prompt(this.location, 3, Messages.JSchSession_5, str, new int[]{2, 3}, 0);
        return prompt == 0;
    }

    private String promptSecret(String message, boolean includeLocation) {
        final String[] _password = new String[1];
        final String username = this.location.getUsername();
        IUserInfo info = new IUserInfo(){

            @Override
            public String getUsername() {
                return username;
            }

            @Override
            public boolean isUsernameMutable() {
                return false;
            }

            @Override
            public void setPassword(String password) {
                _password[0] = password;
            }

            @Override
            public void setUsername(String username2) {
            }
        };
        try {
            this.authenticator.promptForUserInfo(includeLocation ? this.location : null, info, message);
        }
        catch (OperationCanceledException operationCanceledException) {
            _password[0] = null;
        }
        return _password[0];
    }

    public boolean promptPassphrase(String message) {
        try {
            this.startTimer();
            String _passphrase = this.promptSecret(message, false);
            if (_passphrase != null) {
                this.passphrase = _passphrase;
            }
            boolean bl = _passphrase != null;
            return bl;
        }
        catch (OperationCanceledException operationCanceledException) {
            return false;
        }
        finally {
            this.endTimer();
        }
    }

    public boolean promptPassword(String message) {
        try {
            this.startTimer();
            String _password = this.promptSecret(message, true);
            if (_password != null) {
                this.password = _password;
                if (this.location != null) {
                    this.location.setPassword(this.password);
                }
            }
            boolean bl = _password != null;
            return bl;
        }
        finally {
            this.endTimer();
        }
    }

    public void showMessage(String message) {
        this.authenticator.prompt(this.location, 2, Messages.JSchSession_5, message, new int[1], 0);
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        if (prompt.length == 0) {
            return new String[0];
        }
        try {
            this.startTimer();
            if (this.attemptCount == 0 && this.password != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                ++this.attemptCount;
                String[] stringArray = new String[]{this.password};
                return stringArray;
            }
            String[] result = this.authenticator.promptForKeyboradInteractive(this.location, destination, name, instruction, prompt, echo);
            if (result == null) {
                return null;
            }
            if (result.length == 1 && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                this.password = result[0];
                this.passwordChanged = true;
            }
            ++this.attemptCount;
            String[] stringArray = result;
            return stringArray;
        }
        catch (OperationCanceledException operationCanceledException) {
            return null;
        }
        finally {
            this.endTimer();
        }
    }

    public void aboutToConnect() {
        this.attemptCount = 0;
        this.passwordChanged = false;
    }

    public void connectionMade() {
        this.attemptCount = 0;
        if (this.passwordChanged && this.password != null && this.location != null) {
            this.location.setPassword(this.password);
        }
    }

    private synchronized void startTimer() {
        this.prompting = true;
        this.startTime = System.currentTimeMillis();
    }

    private synchronized void endTimer() {
        this.prompting = false;
        this.endTime = System.currentTimeMillis();
    }

    public long getLastDuration() {
        return Math.max(0L, this.endTime - this.startTime);
    }

    public boolean hasPromptExceededTimeout() {
        if (!this.isPrompting()) {
            return this.getLastDuration() > this.timeout;
        }
        return false;
    }

    public boolean isPrompting() {
        return this.prompting;
    }

    public synchronized int incReuse() {
        return this.reuse++;
    }

    String getUsername() {
        return this.username;
    }
}

