/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Session;
import org.eclipse.userstorage.internal.util.JSONUtil;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.spi.ICredentialsProvider;

public class CredentialedSession
extends Session {
    private String sessionID;
    private String csrfToken;

    public CredentialedSession(IStorageService service, ICredentialsProvider credentialsProvider) {
        super(service, credentialsProvider);
    }

    @Override
    protected URI getServiceURI() {
        return StringUtil.newURI(this.service.getServiceURI(), "api/blob/");
    }

    @Override
    public void reset() {
        this.sessionID = null;
        this.csrfToken = null;
        super.reset();
    }

    @Override
    protected Credentials authenticate(Credentials credentials, boolean reauthentication) throws IOException {
        if (this.sessionID == null) {
            this.reset();
            HttpEntity responseEntity = null;
            try {
                credentials = this.provideCredentials(credentials, reauthentication);
                LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>();
                arguments.put("username", credentials.getUsername());
                arguments.put("password", credentials.getPassword());
                URI uri = StringUtil.newURI(this.service.getServiceURI(), "api/user/login");
                Request request = this.configureRequest(Request.Post((URI)uri), uri);
                InputStream body = JSONUtil.build(arguments);
                request.bodyStream(body);
                HttpResponse response = this.sendRequest(request, uri);
                responseEntity = response.getEntity();
                this.getStatusCode("POST", uri, response, 200);
                Map object = (Map)JSONUtil.parse(responseEntity.getContent(), null);
                this.sessionID = (String)object.get("sessid");
                if (this.sessionID == null) {
                    throw new IOException("No session ID");
                }
                this.csrfToken = (String)object.get("token");
            }
            catch (IOException ex) {
                this.reset();
                CredentialedSession.debugResponseEntity(responseEntity);
                throw ex;
            }
        }
        this.acquireCSRFToken(credentials);
        return credentials;
    }

    protected final void acquireCSRFToken(Credentials credentials) throws IOException {
        if (this.csrfToken == null) {
            HttpEntity responseEntity = null;
            try {
                URI uri = StringUtil.newURI(this.service.getServiceURI(), "api/user/token");
                Request request = this.configureRequest(Request.Post((URI)uri), uri);
                HttpResponse response = this.sendRequest(request, uri);
                responseEntity = response.getEntity();
                Map object = (Map)JSONUtil.parse(responseEntity.getContent(), null);
                this.csrfToken = (String)object.get("token");
                if (this.csrfToken == null) {
                    throw new IOException("No CSRF token");
                }
            }
            catch (IOException ex) {
                this.csrfToken = null;
                CredentialedSession.debugResponseEntity(responseEntity);
                throw ex;
            }
        }
    }

    @Override
    protected Request configureRequest(Request request, URI uri) {
        if (this.csrfToken != null) {
            request.setHeader("X-CSRF-Token", this.csrfToken);
        }
        return super.configureRequest(request, uri);
    }
}

