/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.internal.workbench.addons.CommandProcessingAddon;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCategory;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.ui.internal.WorkbenchHandlerServiceHandler;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.commands.CommandPersistence;

public class CommandToModelProcessor {
    private Map<String, MCategory> categories = new HashMap<String, MCategory>();
    private Map<String, MCommand> commands = new HashMap<String, MCommand>();
    private EModelService modelService;

    @Execute
    void process(MApplication application, IEclipseContext context, EModelService modelService) {
        this.modelService = modelService;
        for (MCategory catModel : application.getCategories()) {
            this.categories.put(catModel.getElementId(), catModel);
        }
        for (MCommand cmdModel : application.getCommands()) {
            this.commands.put(cmdModel.getElementId(), cmdModel);
        }
        CommandManager commandManager = (CommandManager)context.get(CommandManager.class);
        if (commandManager == null) {
            HandlerServiceImpl.handlerGenerator = new ContextFunction(){

                public Object compute(IEclipseContext context, String contextKey) {
                    return new WorkbenchHandlerServiceHandler(contextKey);
                }
            };
            commandManager = new CommandManager();
            context.set(CommandManager.class, (Object)commandManager);
        }
        CommandPersistence cp = new CommandPersistence(commandManager);
        cp.reRead();
        this.generateCategories(application, commandManager);
        this.generateCommands(application, commandManager);
        cp.dispose();
    }

    private void generateCommands(MApplication application, CommandManager commandManager) {
        Command[] commandArray = commandManager.getDefinedCommands();
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                Command cmd = commandArray[n2];
                MCommand mCommand = this.commands.get(cmd.getId());
                if (mCommand != null) {
                    try {
                        String cmdName = cmd.getName();
                        if (cmdName.equals(mCommand.getCommandName())) break block8;
                        mCommand.setCommandName(cmdName);
                        String cmdDesc = cmd.getDescription();
                        if (cmdDesc != null) {
                            mCommand.setDescription(cmdDesc);
                        }
                    }
                    catch (NotDefinedException e) {
                        WorkbenchPlugin.log(e);
                    }
                } else {
                    try {
                        MCategory categoryModel = this.categories.get(cmd.getCategory().getId());
                        MCommand command = CommandProcessingAddon.createCommand((Command)cmd, (EModelService)this.modelService, (MCategory)categoryModel);
                        application.getCommands().add(command);
                        this.commands.put(command.getElementId(), command);
                    }
                    catch (NotDefinedException e) {
                        WorkbenchPlugin.log(e);
                    }
                }
            }
            ++n2;
        }
    }

    private void generateCategories(MApplication application, CommandManager commandManager) {
        Category[] categoryArray = commandManager.getDefinedCategories();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Category cat = categoryArray[n2];
            if (!this.categories.containsKey(cat.getId())) {
                try {
                    MCategory catModel = (MCategory)this.modelService.createModelElement(MCategory.class);
                    catModel.setElementId(cat.getId());
                    catModel.setName(cat.getName());
                    catModel.setDescription(cat.getDescription());
                    application.getCategories().add(catModel);
                    this.categories.put(catModel.getElementId(), catModel);
                }
                catch (NotDefinedException e) {
                    WorkbenchPlugin.log(e);
                }
            }
            ++n2;
        }
    }
}

