/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.url;

import java.io.IOException;
import java.net.ContentHandler;
import java.net.URLConnection;
import org.eclipse.osgi.internal.url.URLStreamHandlerFactoryImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ContentHandlerProxy
extends ContentHandler
implements ServiceTrackerCustomizer<ContentHandler, ServiceReference<ContentHandler>> {
    protected ContentHandler realHandler;
    protected ServiceTracker<ContentHandler, ServiceReference<ContentHandler>> contentHandlerServiceTracker;
    protected BundleContext context;
    protected ServiceReference<ContentHandler> contentHandlerServiceReference;
    protected String contentType;
    protected int ranking = Integer.MIN_VALUE;

    public ContentHandlerProxy(String contentType, ServiceReference<ContentHandler> reference, BundleContext context) {
        this.context = context;
        this.contentType = contentType;
        this.setNewHandler(reference, this.getRank(reference));
        this.contentHandlerServiceTracker = new ServiceTracker<ContentHandler, ServiceReference<ContentHandler>>(context, ContentHandler.class.getName(), this);
        URLStreamHandlerFactoryImpl.secureAction.open(this.contentHandlerServiceTracker);
    }

    private void setNewHandler(ServiceReference<ContentHandler> reference, int rank) {
        if (this.contentHandlerServiceReference != null) {
            this.context.ungetService(this.contentHandlerServiceReference);
        }
        this.contentHandlerServiceReference = reference;
        this.ranking = rank;
        this.realHandler = reference == null ? new DefaultContentHandler() : URLStreamHandlerFactoryImpl.secureAction.getService(reference, this.context);
    }

    @Override
    public ServiceReference<ContentHandler> addingService(ServiceReference<ContentHandler> reference) {
        String[] contentTypes;
        String[] prop = reference.getProperty("url.content.mimetype");
        if (prop instanceof String) {
            prop = new String[]{(String)prop};
        }
        if (!(prop instanceof String[])) {
            return null;
        }
        String[] stringArray = contentTypes = (String[])prop;
        int n = contentTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String candidateContentType = stringArray[n2];
            if (candidateContentType.equals(this.contentType)) {
                int newServiceRanking = this.getRank(reference);
                if (newServiceRanking > this.ranking || this.contentHandlerServiceReference == null) {
                    this.setNewHandler(reference, newServiceRanking);
                }
                return reference;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public void modifiedService(ServiceReference<ContentHandler> reference, ServiceReference<ContentHandler> service) {
        int newrank = this.getRank(reference);
        if (reference == this.contentHandlerServiceReference) {
            ServiceReference<ContentHandler> newReference;
            if (newrank < this.ranking && (newReference = this.contentHandlerServiceTracker.getServiceReference()) != this.contentHandlerServiceReference && newReference != null) {
                this.setNewHandler(newReference, (Integer)newReference.getProperty("service.ranking"));
            }
        } else if (newrank > this.ranking) {
            this.setNewHandler(reference, newrank);
        }
    }

    @Override
    public void removedService(ServiceReference<ContentHandler> reference, ServiceReference<ContentHandler> service) {
        if (reference != this.contentHandlerServiceReference) {
            return;
        }
        ServiceReference<ContentHandler> newReference = this.contentHandlerServiceTracker.getServiceReference();
        this.setNewHandler(newReference, this.getRank(newReference));
    }

    @Override
    public Object getContent(URLConnection uConn) throws IOException {
        return this.realHandler.getContent(uConn);
    }

    private int getRank(ServiceReference<?> reference) {
        if (reference == null) {
            return Integer.MIN_VALUE;
        }
        Object property = reference.getProperty("service.ranking");
        return property instanceof Integer ? (Integer)property : 0;
    }

    class DefaultContentHandler
    extends ContentHandler {
        DefaultContentHandler() {
        }

        @Override
        public Object getContent(URLConnection uConn) throws IOException {
            return uConn.getInputStream();
        }
    }
}

