/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.outgoing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.SendFileTransferException;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.outgoing.AbstractOutgoingFileTransfer;
import org.eclipse.osgi.util.NLS;

public class LocalFileOutgoingFileTransfer
extends AbstractOutgoingFileTransfer {
    @Override
    protected void openStreams() throws SendFileTransferException {
        IFileTransferInfo localFileTransferInfo = this.getFileTransferInfo();
        Assert.isNotNull((Object)localFileTransferInfo);
        File inputFile = localFileTransferInfo.getFile();
        try {
            this.setInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
        }
        catch (Exception e) {
            this.hardClose();
            throw new SendFileTransferException(NLS.bind((String)Messages.LocalFileOutgoingFileTransfer_EXCEPTION_OPENING_FOR_INPUT, (Object)inputFile));
        }
        URL url = this.getRemoteFileURL();
        Assert.isNotNull((Object)url);
        try {
            File outputFile = new File(url.getPath());
            this.setOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
        }
        catch (Exception e) {
            this.hardClose();
            throw new SendFileTransferException(NLS.bind((String)Messages.LocalFileOutgoingFileTransfer_EXCEPTION_OPENING_FOR_OUTPUT, (Object)url));
        }
    }

    @Override
    protected void setupProxy(Proxy proxy) {
    }
}

