/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.providers.ViewElement;
import org.eclipse.ui.quickaccess.QuickAccessElement;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ViewProvider
extends QuickAccessProvider {
    private MApplication application;
    private MWindow window;
    private Map<String, QuickAccessElement> idToElement = new HashMap<String, QuickAccessElement>();
    private IViewRegistry viewRegistry;

    public ViewProvider(MApplication application, MWindow window) {
        this.application = application;
        this.window = window;
        this.viewRegistry = PlatformUI.getWorkbench().getViewRegistry();
    }

    @Override
    public String getId() {
        return "org.eclipse.e4.ui.parts";
    }

    @Override
    public QuickAccessElement findElement(String id, String filter) {
        this.getElements();
        return this.idToElement.get(id);
    }

    @Override
    public QuickAccessElement[] getElements() {
        IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)this.window.getContext().get(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return new QuickAccessElement[0];
        }
        if (this.idToElement.isEmpty()) {
            for (MPartDescriptor descriptor : this.application.getDescriptors()) {
                String id;
                String uri = descriptor.getContributionURI();
                if (uri == null || (id = descriptor.getElementId()) == null || id.equals("org.eclipse.e4.ui.compatibility.editor")) continue;
                ViewElement element = new ViewElement(this.window, descriptor);
                if (uri.equals("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView")) {
                    IViewDescriptor viewDescriptor = this.viewRegistry.find(element.getId());
                    if (viewDescriptor == null || WorkbenchActivityHelper.filterItem(viewDescriptor)) continue;
                    this.idToElement.put(element.getId(), element);
                    continue;
                }
                this.idToElement.put(id, element);
            }
        }
        return this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.size()]);
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_VIEW_DEFAULTVIEW_MISC");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Views;
    }

    @Override
    protected void doReset() {
        this.idToElement.clear();
    }
}

