/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Map;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.DescriptionFieldFilter;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerFieldFilter;

public abstract class SeverityAndDescriptionFieldFilter
extends DescriptionFieldFilter {
    static final int SEVERITY_ERROR = 4;
    static final int SEVERITY_WARNING = 2;
    static final int SEVERITY_INFO = 1;
    protected int selectedSeverities = 7;
    private static final String TAG_SELECTED_SEVERITIES = "selectedSeverities";

    @Override
    public void initialize(Map values) {
        Object text;
        Object modifier;
        Object value = values.get("severity");
        if (value != null && value instanceof Integer) {
            this.selectedSeverities = (Integer)value;
        }
        if ((modifier = values.get(MarkerSupportInternalUtilities.CONTAINS_MODIFIER_TOKEN)) != null && modifier instanceof String) {
            this.containsModifier = (String)modifier;
        }
        if ((text = values.get(MarkerSupportInternalUtilities.CONTAINS_TEXT_TOKEN)) != null && text instanceof String) {
            this.containsText = (String)text;
        }
    }

    @Override
    public void populateWorkingCopy(MarkerFieldFilter copy) {
        super.populateWorkingCopy(copy);
        ((SeverityAndDescriptionFieldFilter)copy).selectedSeverities = this.selectedSeverities;
    }

    @Override
    public void saveSettings(IMemento memento) {
        super.saveSettings(memento);
        memento.putInteger(TAG_SELECTED_SEVERITIES, this.selectedSeverities);
    }

    @Override
    public void loadSettings(IMemento memento) {
        super.loadSettings(memento);
        this.selectedSeverities = memento.getInteger(TAG_SELECTED_SEVERITIES);
    }

    protected boolean checkSeverity(int markerSeverity) {
        return (1 << markerSeverity & this.selectedSeverities) > 0;
    }
}

