/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.eclipse.userstorage.internal.util.StringUtil;

public final class IOUtil {
    private static final byte[] BUFFER = new byte[8192];

    private IOUtil() {
    }

    public static void mkdirs(File folder) throws RuntimeException {
        if (folder != null && !folder.isDirectory() && !folder.mkdirs()) {
            throw new RuntimeException("Unable to create directory " + folder.getAbsolutePath());
        }
    }

    public static void delete(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                IOUtil.deleteFiles(file);
            }
            file.delete();
        }
    }

    public static void deleteFiles(File folder) {
        File[] files;
        if (folder != null && (files = folder.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                IOUtil.delete(file);
                ++n2;
            }
        }
    }

    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws RuntimeException {
        try {
            int n;
            long length = 0L;
            while ((n = input.read(buffer)) != -1) {
                output.write(buffer, 0, n);
                length += (long)n;
            }
            return length;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws RuntimeException {
        if (bufferSize == BUFFER.length) {
            return IOUtil.copy(input, output);
        }
        return IOUtil.copy(input, output, new byte[bufferSize]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long copy(InputStream input, OutputStream output) throws RuntimeException {
        byte[] byArray = BUFFER;
        synchronized (BUFFER) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return IOUtil.copy(input, output, BUFFER);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readObject(File file) {
        Object object;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(inputStream);
            object = ois.readObject();
        }
        catch (RuntimeException ex) {
            try {
                throw ex;
                catch (Error ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    throw new RuntimeException(ex3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(inputStream);
                throw throwable;
            }
        }
        IOUtil.close(inputStream);
        return object;
    }

    public static void writeObject(File file, Object object) {
        IOUtil.mkdirs(file.getParentFile());
        FileOutputStream outputStream = null;
        try {
            try {
                outputStream = new FileOutputStream(file);
                ObjectOutputStream oos = new ObjectOutputStream(outputStream);
                oos.writeObject(object);
                oos.flush();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Error ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(outputStream);
            throw throwable;
        }
        IOUtil.close(outputStream);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readUTF(File file) {
        String string;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            IOUtil.copy(inputStream, outputStream);
            string = StringUtil.fromUTF(outputStream.toByteArray());
        }
        catch (RuntimeException ex) {
            try {
                throw ex;
                catch (Error ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    throw new RuntimeException(ex3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(inputStream);
                throw throwable;
            }
        }
        IOUtil.close(inputStream);
        return string;
    }

    public static void writeUTF(File file, String contents) {
        FileOutputStream outputStream = null;
        try {
            try {
                IOUtil.mkdirs(file.getParentFile());
                InputStream inputStream = IOUtil.streamUTF(contents);
                outputStream = new FileOutputStream(file);
                IOUtil.copy(inputStream, outputStream);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Error ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(outputStream);
            throw throwable;
        }
        IOUtil.close(outputStream);
    }

    public static InputStream streamUTF(String str) {
        return IOUtil.streamUTF(StringUtil.toUTF(str));
    }

    public static ByteArrayInputStream streamUTF(byte[] bytes) {
        return new ByteArrayInputStream(bytes);
    }

    public static void close(Closeable closeable) throws RuntimeException {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static IOException closeSilent(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    public static interface EndOfFileAware {
        public void reachedEndOfFile();
    }

    public static final class TeeInputStream
    extends FilterInputStream
    implements EndOfFileAware {
        private static final int EOF = -1;
        private final OutputStream out;

        public TeeInputStream(InputStream in, OutputStream out) {
            super(in);
            this.out = out;
        }

        @Override
        public int read() throws IOException {
            int c = this.in.read();
            if (c != -1) {
                this.out.write(c);
            } else {
                this.reachedEndOfFile();
            }
            return c;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n != -1) {
                this.out.write(b, off, n);
            }
            if (n < len) {
                this.reachedEndOfFile();
            }
            return n;
        }

        @Override
        public void reachedEndOfFile() {
            if (this.out instanceof EndOfFileAware) {
                EndOfFileAware endOfFileAware = (EndOfFileAware)((Object)this.out);
                endOfFileAware.reachedEndOfFile();
            }
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.out.close();
            }
        }
    }
}

