/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.query;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class QueryableProfileRegistry
implements IQueryable<IProfile> {
    private ProvisioningUI ui;

    public QueryableProfileRegistry(ProvisioningUI ui) {
        this.ui = ui;
    }

    private List<IProfile> getProfiles() {
        return Arrays.asList(ProvUI.getProfileRegistry(this.ui.getSession()).getProfiles());
    }

    public IQueryResult<IProfile> query(IQuery<IProfile> query, IProgressMonitor monitor) {
        List<IProfile> profiles = this.getProfiles();
        monitor.beginTask(ProvUIMessages.QueryableProfileRegistry_QueryProfileProgress, profiles.size());
        try {
            IQueryResult iQueryResult = query.perform(profiles.iterator());
            return iQueryResult;
        }
        finally {
            monitor.done();
        }
    }

    public boolean contains(IProfile profile) {
        return this.getProfiles().contains(profile);
    }
}

