/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureManifestParser;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.pde.internal.publishing.Activator;
import org.xml.sax.SAXException;

public class FeatureParser {
    private final FeatureManifestParser parser = new FeatureManifestParser();

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Feature parse(File location) {
        if (!location.exists()) {
            return null;
        }
        Feature feature = null;
        if (location.isDirectory()) {
            File file = new File(location, "feature.xml");
            InputStream input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(file));
                    feature = this.parser.parse(input, FeatureParser.toURL(location));
                    if (feature == null) return feature;
                    List<String> messageKeys = this.parser.getMessageKeys();
                    String[] keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                    feature.setLocalizations(LocalizationHelper.getDirPropertyLocalizations((File)location, (String)"feature", null, (String[])keyStrings));
                    return feature;
                }
                catch (FileNotFoundException e) {
                    if (input == null) return null;
                    try {
                        input.close();
                        return null;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                }
                catch (SAXException e) {
                    FeatureParser.logWarning(location, e);
                    if (input == null) return feature;
                    try {
                        input.close();
                        return feature;
                    }
                    catch (IOException iOException) {}
                    return feature;
                }
                catch (IOException e) {
                    FeatureParser.logWarning(location, e);
                    if (input == null) return feature;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        input.close();
                        return feature;
                    }
                    catch (IOException iOException) {}
                    return feature;
                }
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!location.getName().endsWith(".jar")) return feature;
        JarFile jar = null;
        try {
            jar = new JarFile(location);
            JarEntry entry = jar.getJarEntry("feature.xml");
            if (entry == null) {
                return null;
            }
            try {
                BufferedInputStream input = new BufferedInputStream(jar.getInputStream(entry));
                feature = this.parser.parse(input, FeatureParser.toURL(location));
                if (feature == null) return feature;
                List<String> messageKeys = this.parser.getMessageKeys();
                String[] keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                feature.setLocalizations(LocalizationHelper.getJarPropertyLocalizations((File)location, (String)"feature", null, (String[])keyStrings));
                return feature;
            }
            catch (SAXException e) {
                FeatureParser.logWarning(location, e);
                return feature;
            }
            catch (IOException e) {
                FeatureParser.logWarning(location, e);
                return feature;
            }
            catch (SecurityException e) {
                FeatureParser.logWarning(location, e);
            }
            return feature;
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static void logWarning(File location, Exception exception) {
        LogHelper.log((IStatus)new Status(2, Activator.ID, "Exception parsing feature: " + location.getAbsolutePath(), (Throwable)exception));
    }

    private static URL toURL(File location) {
        try {
            return location.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

