/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RepositoryType implements Enumerator
{
    METADATA(0, "Metadata", "Metadata"),
    ARTIFACT(1, "Artifact", "Artifact"),
    COMBINED(2, "Combined", "Combined");

    public static final int METADATA_VALUE = 0;
    public static final int ARTIFACT_VALUE = 1;
    public static final int COMBINED_VALUE = 2;
    private static final RepositoryType[] VALUES_ARRAY;
    public static final List<RepositoryType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RepositoryType[]{METADATA, ARTIFACT, COMBINED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RepositoryType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RepositoryType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RepositoryType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RepositoryType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RepositoryType get(int value) {
        switch (value) {
            case 0: {
                return METADATA;
            }
            case 1: {
                return ARTIFACT;
            }
            case 2: {
                return COMBINED;
            }
        }
        return null;
    }

    private RepositoryType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public boolean isMetadata() {
        return this == METADATA || this == COMBINED;
    }

    public boolean isArtifact() {
        return this == ARTIFACT || this == COMBINED;
    }
}

