/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.dialogs.WizardCollectionElement;
import org.eclipse.ui.model.AdaptableList;

public class WizardActivityFilter
extends ViewerFilter {
    private boolean filterPrimaryWizards = false;

    public void setFilterPrimaryWizards(boolean filter) {
        this.filterPrimaryWizards = filter;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (parentElement.getClass().equals(AdaptableList.class) && !this.filterPrimaryWizards) {
            return true;
        }
        return !WorkbenchActivityHelper.filterItem(element);
    }

    public Object[] filter(Viewer viewer, Object parent, Object[] elements) {
        int size = elements.length;
        ArrayList<Object> out = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            Object element = elements[i];
            if (element instanceof WizardCollectionElement) {
                WizardCollectionElement wizardCollection = WizardCollectionElement.filter(viewer, this, (WizardCollectionElement)element);
                if (wizardCollection != null) {
                    out.add(wizardCollection);
                }
            } else if (this.select(viewer, parent, element)) {
                out.add(element);
            }
            ++i;
        }
        return out.toArray();
    }
}

