/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director.app;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.CallSite;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.StringHelper;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.director.app.Activator;
import org.eclipse.equinox.internal.p2.director.app.DefaultLog;
import org.eclipse.equinox.internal.p2.director.app.ILog;
import org.eclipse.equinox.internal.p2.director.app.IUListFormatter;
import org.eclipse.equinox.internal.p2.director.app.Messages;
import org.eclipse.equinox.internal.p2.director.app.PrettyQuery;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.phases.AuthorityChecker;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.director.PlanExecutionHelper;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.VersionedId;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.publisher.actions.JREAction;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.spi.IArtifactUIServices;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.spi.IInstallableUnitUIServices;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class DirectorApplication
implements IApplication,
ProvisioningListener {
    private static final CommandLineOption OPTION_HELP = new CommandLineOption(new String[]{"-help", "-h", "-?"}, null, Messages.Help_Prints_this_command_line_help);
    private static final CommandLineOption OPTION_LIST = new CommandLineOption(new String[]{"-list", "-l"}, Messages.Help_lb_lt_comma_separated_list_gt_rb, Messages.Help_List_all_IUs_found_in_repos);
    private static final CommandLineOption OPTION_LIST_FORMAT = new CommandLineOption(new String[]{"-listFormat", "-lf"}, Messages.Help_lt_list_format_gt, Messages.Help_formats_the_IU_list);
    private static final CommandLineOption OPTION_LIST_INSTALLED = new CommandLineOption(new String[]{"-listInstalledRoots", "-lir"}, null, Messages.Help_List_installed_roots);
    private static final CommandLineOption OPTION_INSTALL_IU = new CommandLineOption(new String[]{"-installIU", "-installIUs", "-i"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_Installs_the_listed_IUs);
    private static final CommandLineOption OPTION_UNINSTALL_IU = new CommandLineOption(new String[]{"-uninstallIU", "-uninstallIUs", "-u"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_Uninstalls_the_listed_IUs);
    private static final CommandLineOption OPTION_REVERT = new CommandLineOption(new String[]{"-revert"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_Revert_to_previous_state);
    private static final CommandLineOption OPTION_DESTINATION = new CommandLineOption(new String[]{"-destination", "-d"}, Messages.Help_lt_path_gt, Messages.Help_The_folder_in_which_the_targetd_product_is_located);
    private static final CommandLineOption OPTION_METADATAREPOS = new CommandLineOption(new String[]{"-metadatarepository", "metadatarepositories", "-m"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_A_list_of_URLs_denoting_metadata_repositories);
    private static final CommandLineOption OPTION_ARTIFACTREPOS = new CommandLineOption(new String[]{"-artifactrepository", "artifactrepositories", "-a"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_A_list_of_URLs_denoting_artifact_repositories);
    private static final CommandLineOption OPTION_REPOSITORIES = new CommandLineOption(new String[]{"-repository", "repositories", "-r"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_A_list_of_URLs_denoting_colocated_repositories);
    private static final CommandLineOption OPTION_VERIFY_ONLY = new CommandLineOption(new String[]{"-verifyOnly"}, null, Messages.Help_Only_verify_dont_install);
    private static final CommandLineOption OPTION_PROFILE = new CommandLineOption(new String[]{"-profile", "-p"}, Messages.Help_lt_name_gt, Messages.Help_Defines_what_profile_to_use_for_the_actions);
    private static final CommandLineOption OPTION_FLAVOR = new CommandLineOption(new String[]{"-flavor", "-f"}, Messages.Help_lt_name_gt, Messages.Help_Defines_flavor_to_use_for_created_profile);
    private static final CommandLineOption OPTION_SHARED = new CommandLineOption(new String[]{"-shared", "-s"}, Messages.Help_lb_lt_path_gt_rb, Messages.Help_Use_a_shared_location_for_the_install);
    private static final CommandLineOption OPTION_BUNDLEPOOL = new CommandLineOption(new String[]{"-bundlepool", "-b"}, Messages.Help_lt_path_gt, Messages.Help_The_location_where_the_plugins_and_features_will_be_stored);
    private static final CommandLineOption OPTION_IU_PROFILE_PROPS = new CommandLineOption(new String[]{"-iuProfileproperties"}, Messages.Help_lt_path_gt, Messages.Help_path_to_IU_profile_properties_file);
    private static final CommandLineOption OPTION_PROFILE_PROPS = new CommandLineOption(new String[]{"-profileproperties"}, Messages.Help_lt_comma_separated_list_gt, Messages.Help_A_list_of_properties_in_the_form_key_value_pairs);
    private static final CommandLineOption OPTION_ROAMING = new CommandLineOption(new String[]{"-roaming"}, null, Messages.Help_Indicates_that_the_product_can_be_moved);
    private static final CommandLineOption OPTION_P2_OS = new CommandLineOption(new String[]{"-p2.os"}, null, Messages.Help_The_OS_when_profile_is_created);
    private static final CommandLineOption OPTION_P2_WS = new CommandLineOption(new String[]{"-p2.ws"}, null, Messages.Help_The_WS_when_profile_is_created);
    private static final CommandLineOption OPTION_P2_ARCH = new CommandLineOption(new String[]{"-p2.arch"}, null, Messages.Help_The_ARCH_when_profile_is_created);
    private static final CommandLineOption OPTION_P2_NL = new CommandLineOption(new String[]{"-p2.nl"}, null, Messages.Help_The_NL_when_profile_is_created);
    private static final CommandLineOption OPTION_PURGEHISTORY = new CommandLineOption(new String[]{"-purgeHistory"}, null, Messages.Help_Purge_the_install_registry);
    private static final CommandLineOption OPTION_FOLLOW_REFERENCES = new CommandLineOption(new String[]{"-followReferences"}, null, Messages.Help_Follow_references);
    private static final CommandLineOption OPTION_TAG = new CommandLineOption(new String[]{"-tag"}, Messages.Help_lt_name_gt, Messages.Help_Defines_a_tag_for_provisioning_session);
    private static final CommandLineOption OPTION_LIST_TAGS = new CommandLineOption(new String[]{"-listTags"}, null, Messages.Help_List_Tags);
    private static final CommandLineOption OPTION_DOWNLOAD_ONLY = new CommandLineOption(new String[]{"-downloadOnly"}, null, Messages.Help_Download_Only);
    private static final CommandLineOption OPTION_VERBOSE_TRUST = new CommandLineOption(new String[]{"-verboseTrust", "-vt"}, null, "Whether to print detailed information about the content trust.");
    private static final CommandLineOption OPTION_TRUST_SIGNED_CONTENT_ONLY = new CommandLineOption(new String[]{"-trustSignedContentOnly", "-tsco"}, null, Messages.DirectorApplication_Help_TrustSignedContentOnly);
    private static final CommandLineOption OPTION_TRUSTED_AUTHORITIES = new CommandLineOption(new String[]{"-trustedAuthorities", "-ta"}, Messages.Help_lt_comma_separated_list_gt, Messages.DirectorApplication_Help_TrustedAuthorities);
    private static final CommandLineOption OPTION_TRUSTED_PGP_KEYS = new CommandLineOption(new String[]{"-trustedPGPKeys", "-tk"}, Messages.Help_lt_comma_separated_list_gt, Messages.DirectorApplication_Help_TrustedKeys);
    private static final CommandLineOption OPTION_TRUSTED_CERTIFCATES = new CommandLineOption(new String[]{"-trustedCertificates", "-tc"}, Messages.Help_lt_comma_separated_list_gt, Messages.DirectorApplication_Help_TrustedCertificates);
    private static final CommandLineOption OPTION_IGNORED = new CommandLineOption(new String[]{"-showLocation", "-eclipse.password", "-eclipse.keyring"}, null, "");
    private static final CommandLineOption OPTION_ADD_JRE_IU = new CommandLineOption(new String[]{"-addJREIU"}, null, Messages.Help_Add_JRE_IU);
    private static final Integer EXIT_ERROR = 13;
    private static final String FLAVOR_DEFAULT = "tooling";
    private static final String PROP_P2_PROFILE = "eclipse.p2.profile";
    private static final String NO_ARTIFACT_REPOSITORIES_AVAILABLE = "noArtifactRepositoriesAvailable";
    private static final String LIST_GROUPS_SHORTCUT = "Q:GROUP";
    private static final String QUERY_SEPARATOR = "Q:";
    private static final String QUERY_SEPARATOR_SMALL = "q:";
    public static final String LINE_SEPARATOR = System.lineSeparator();
    private IArtifactRepositoryManager artifactManager;
    IMetadataRepositoryManager metadataManager;
    private URI[] artifactReposForRemoval;
    private URI[] metadataReposForRemoval;
    private final List<URI> artifactRepositoryLocations = new ArrayList<URI>();
    private final List<URI> metadataRepositoryLocations = new ArrayList<URI>();
    private final List<IQuery<IInstallableUnit>> rootsToInstall = new ArrayList<IQuery<IInstallableUnit>>();
    private final List<IQuery<IInstallableUnit>> rootsToUninstall = new ArrayList<IQuery<IInstallableUnit>>();
    private final List<IQuery<IInstallableUnit>> rootsToList = new ArrayList<IQuery<IInstallableUnit>>();
    private File bundlePool = null;
    private File destination;
    private File sharedLocation;
    private String flavor;
    private boolean printHelpInfo = false;
    private boolean printIUList = false;
    private boolean printRootIUList = false;
    private boolean printTags = false;
    private IUListFormatter listFormat;
    private String revertToPreviousState = NOTHING_TO_REVERT_TO;
    private static String NOTHING_TO_REVERT_TO = "-1";
    private static String REVERT_TO_PREVIOUS = "0";
    private boolean verifyOnly;
    private boolean roamingProfile;
    private boolean purgeRegistry;
    private boolean followReferences;
    private boolean downloadOnly;
    private String profileId;
    private String profileProperties;
    private String iuProfileProperties;
    private String ws;
    private String os;
    private String arch;
    private String nl;
    private String tag;
    private boolean verboseTrust;
    private boolean trustSignedContentOnly;
    private Set<URI> trustedAuthorityURIs;
    private Set<String> trustedPGPKeys;
    private Set<String> trustedCertificates;
    private IEngine engine;
    private boolean noProfileId;
    private IPlanner planner;
    private ILog log = new DefaultLog();
    private IProvisioningAgent targetAgent;
    private boolean targetAgentIsSelfAndUp;
    private boolean noArtifactRepositorySpecified;
    private AvoidTrustPromptService trustService;
    private boolean addJREIU;

    private static Set<URI> getAuthorityURIs(String spec) throws CoreException {
        LinkedHashSet<URI> result = new LinkedHashSet<URI>();
        ArrayList<URI> rawURIs = new ArrayList<URI>();
        DirectorApplication.getURIs(rawURIs, spec);
        for (URI uri : rawURIs) {
            List authorityChain = AuthorityChecker.getAuthorityChain((URI)uri);
            URI mainAuthority = (URI)authorityChain.get(0);
            if (authorityChain.size() == 2 && (String.valueOf(mainAuthority) + "/").equals(((URI)authorityChain.get(1)).toString())) {
                result.add(mainAuthority);
                continue;
            }
            if (uri.toString().endsWith("/")) {
                result.add(uri);
            }
            result.add(URI.create(String.valueOf(uri) + "/"));
        }
        return result;
    }

    private static void getURIs(List<URI> uris, String spec) throws CoreException {
        String[] urlSpecs;
        if (spec == null) {
            return;
        }
        String[] stringArray = urlSpecs = StringHelper.getArrayFromString((String)spec, (char)',');
        int n = urlSpecs.length;
        int n2 = 0;
        while (n2 < n) {
            String urlSpec = stringArray[n2];
            try {
                uris.add(new URI(urlSpec));
            }
            catch (URISyntaxException e1) {
                try {
                    uris.add(URIUtil.fromString((String)urlSpec));
                }
                catch (URISyntaxException e) {
                    throw new ProvisionException(NLS.bind((String)Messages.unable_to_parse_0_to_uri_1, (Object)urlSpec, (Object)e.getMessage()), (Throwable)e);
                }
            }
            ++n2;
        }
    }

    private static String getRequiredArgument(String[] args, int argIdx) throws CoreException {
        String arg;
        if (argIdx < args.length && !(arg = args[argIdx]).startsWith("-")) {
            return arg;
        }
        throw new ProvisionException(NLS.bind((String)Messages.option_0_requires_an_argument, (Object)args[argIdx - 1]));
    }

    private static String getOptionalArgument(String[] args, int argIdx) {
        String arg;
        if (++argIdx < args.length && !(arg = args[argIdx]).startsWith("-")) {
            return arg;
        }
        return null;
    }

    private static void parseIUsArgument(List<IQuery<IInstallableUnit>> vnames, String arg) {
        String[] roots;
        String[] stringArray = roots = StringHelper.getArrayFromString((String)arg, (char)',');
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            if (root.equalsIgnoreCase(LIST_GROUPS_SHORTCUT)) {
                vnames.add(new PrettyQuery(QueryUtil.createIUGroupQuery(), "All groups"));
            } else if (root.startsWith(QUERY_SEPARATOR) || root.startsWith(QUERY_SEPARATOR_SMALL)) {
                String queryString = root.substring(2);
                vnames.add(new PrettyQuery(QueryUtil.createQuery((String)queryString, (Object[])new Object[0]), queryString));
            } else {
                IVersionedId vId = VersionedId.parse((String)root);
                Version v = vId.getVersion();
                PrettyQuery query = new PrettyQuery(QueryUtil.createIUQuery((String)vId.getId(), (VersionRange)(Version.emptyVersion.equals(v) ? VersionRange.emptyRange : new VersionRange(v, true, v, true))), root);
                vnames.add(query);
            }
            ++n2;
        }
    }

    private static File processFileArgument(String arg) {
        if (arg.startsWith("file:")) {
            arg = arg.substring(5);
        }
        return IPath.fromOSString((String)arg).toFile();
    }

    protected ProfileChangeRequest buildProvisioningRequest(IProfile profile, Collection<IInstallableUnit> installs, Collection<IInstallableUnit> uninstalls) {
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        this.markRoots((IProfileChangeRequest)request, installs);
        this.markRoots((IProfileChangeRequest)request, uninstalls);
        request.addAll(installs);
        request.removeAll(uninstalls);
        this.buildIUProfileProperties((IProfileChangeRequest)request);
        return request;
    }

    private Properties loadProperties(File file) {
        if (!file.exists()) {
            this.log.log((IStatus)new Status(2, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.File_does_not_exist, (Object)file.getAbsolutePath())));
            return null;
        }
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));){
                properties.load(input);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.log.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Problem_loading_file, (Object)file.getAbsolutePath()), (Throwable)e));
            return null;
        }
        return properties;
    }

    private void buildIUProfileProperties(IProfileChangeRequest request) {
        String KEYWORD_KEY = "key";
        String KEYWORD_VALUE = "value";
        String KEYWORD_VERSION = "version";
        if (this.iuProfileProperties == null) {
            return;
        }
        Properties properties = this.loadProperties(new File(this.iuProfileProperties));
        if (properties == null) {
            return;
        }
        HashSet<CallSite> alreadyProcessed = new HashSet<CallSite>();
        for (Object object : properties.keySet()) {
            IQueryResult<IInstallableUnit> qr;
            String line = (String)object;
            int index = line.lastIndexOf(46);
            if (index == -1) continue;
            int num = -1;
            String id = null;
            try {
                num = Integer.parseInt(line.substring(index + 1));
                line = line.substring(0, index);
                index = line.lastIndexOf(46);
                if (index == -1) continue;
                id = line.substring(0, index);
            }
            catch (NumberFormatException e) {
                this.log.log((IStatus)new Status(2, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Bad_format, (Object)line, (Object)this.iuProfileProperties), (Throwable)e));
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                this.log.log((IStatus)new Status(2, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Bad_format, (Object)line, (Object)this.iuProfileProperties), (Throwable)e));
                continue;
            }
            String versionLine = id + ".version." + num;
            String keyLine = id + ".key." + num;
            String valueLine = id + ".value." + num;
            if (alreadyProcessed.contains(versionLine) || alreadyProcessed.contains(keyLine) || alreadyProcessed.contains(valueLine)) continue;
            alreadyProcessed.add((CallSite)((Object)versionLine));
            alreadyProcessed.add((CallSite)((Object)keyLine));
            alreadyProcessed.add((CallSite)((Object)valueLine));
            Version version = Version.create((String)((String)properties.get(versionLine)));
            String key = (String)properties.get(keyLine);
            String value = (String)properties.get(valueLine);
            if (key == null || value == null) {
                String message = NLS.bind((String)Messages.Unmatched_iu_profile_property_key_value, (Object)(key + "/" + value));
                this.log.log((IStatus)new Status(2, "org.eclipse.equinox.p2.director.app", message));
                continue;
            }
            IQuery query = QueryUtil.createIUQuery((String)id, (Version)version);
            if (version == null) {
                query = QueryUtil.createLatestQuery((IQuery)query);
            }
            if ((qr = this.getInstallableUnits(null, (IQuery<IInstallableUnit>)query, null)).isEmpty()) {
                String msg = NLS.bind((String)Messages.Cannot_set_iu_profile_property_iu_does_not_exist, (Object)(id + "/" + String.valueOf(version)));
                this.log.log((IStatus)new Status(2, "org.eclipse.equinox.p2.director.app", msg));
                continue;
            }
            IInstallableUnit iu = (IInstallableUnit)qr.iterator().next();
            request.setInstallableUnitProfileProperty(iu, key, value);
        }
    }

    private void cleanupRepositories() {
        int i;
        if (this.artifactReposForRemoval != null && this.artifactManager != null) {
            i = 0;
            while (i < this.artifactReposForRemoval.length && this.artifactReposForRemoval[i] != null) {
                this.artifactManager.removeRepository(this.artifactReposForRemoval[i]);
                ++i;
            }
        }
        if (this.metadataReposForRemoval != null && this.metadataManager != null) {
            i = 0;
            while (i < this.metadataReposForRemoval.length && this.metadataReposForRemoval[i] != null) {
                this.metadataManager.removeRepository(this.metadataReposForRemoval[i]);
                ++i;
            }
        }
    }

    private IQueryResult<IInstallableUnit> collectRootIUs(IQuery<IInstallableUnit> query) {
        NullProgressMonitor nullMonitor = new NullProgressMonitor();
        int top = this.metadataRepositoryLocations.size();
        if (top == 0) {
            return this.getInstallableUnits(null, query, (IProgressMonitor)nullMonitor);
        }
        ArrayList<LocationQueryable> locationQueryables = new ArrayList<LocationQueryable>(top);
        int i = 0;
        while (i < top) {
            locationQueryables.add(new LocationQueryable(this.metadataRepositoryLocations.get(i)));
            ++i;
        }
        return QueryUtil.compoundQueryable(locationQueryables).query(query, (IProgressMonitor)nullMonitor);
    }

    private Collection<IInstallableUnit> collectRoots(IProfile profile, List<IQuery<IInstallableUnit>> rootNames, boolean forInstall) throws CoreException {
        ArrayList<IInstallableUnit> allRoots = new ArrayList<IInstallableUnit>();
        for (IQuery<IInstallableUnit> rootQuery : rootNames) {
            Iterator itor;
            IQueryResult roots = null;
            if (forInstall) {
                roots = this.collectRootIUs((IQuery<IInstallableUnit>)QueryUtil.createLatestQuery(rootQuery));
            }
            if (roots == null || roots.isEmpty()) {
                roots = profile.query(rootQuery, (IProgressMonitor)new NullProgressMonitor());
            }
            if (!(itor = roots.iterator()).hasNext()) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", NLS.bind((String)Messages.Missing_IU, rootQuery)));
            }
            do {
                allRoots.add((IInstallableUnit)itor.next());
            } while (itor.hasNext());
        }
        return allRoots;
    }

    private String getEnvironmentProperty() {
        HashMap<String, String> values = new HashMap<String, String>();
        if (this.os != null) {
            values.put("osgi.os", this.os);
        }
        if (this.nl != null) {
            values.put("osgi.nl", this.nl);
        }
        if (this.ws != null) {
            values.put("osgi.ws", this.ws);
        }
        if (this.arch != null) {
            values.put("osgi.arch", this.arch);
        }
        return values.isEmpty() ? null : this.toString(values);
    }

    private IProfile getProfile() {
        IProfileRegistry profileRegistry = (IProfileRegistry)this.targetAgent.getService(IProfileRegistry.class);
        if (this.profileId == null) {
            this.profileId = "_SELF_";
            this.noProfileId = true;
        }
        return profileRegistry.getProfile(this.profileId);
    }

    private IProfile initializeProfile() throws CoreException {
        IProfile profile = this.getProfile();
        if (profile == null) {
            String env;
            if (this.destination == null) {
                this.missingArgument("destination");
            }
            if (this.flavor == null) {
                this.flavor = System.getProperty("eclipse.p2.configurationFlavor", FLAVOR_DEFAULT);
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("org.eclipse.equinox.p2.installFolder", this.destination.toString());
            if (this.bundlePool == null) {
                props.put("org.eclipse.equinox.p2.cache", this.sharedLocation == null ? this.destination.getAbsolutePath() : this.sharedLocation.getAbsolutePath());
            } else {
                props.put("org.eclipse.equinox.p2.cache", this.bundlePool.getAbsolutePath());
            }
            if (this.roamingProfile) {
                props.put("org.eclipse.equinox.p2.roaming", Boolean.TRUE.toString());
            }
            if ((env = this.getEnvironmentProperty()) != null) {
                props.put("org.eclipse.equinox.p2.environments", env);
            }
            if (this.profileProperties != null) {
                this.putProperties(this.profileProperties, props);
            }
            profile = ((IProfileRegistry)this.targetAgent.getService(IProfileRegistry.class)).addProfile(this.profileId, props);
        }
        return profile;
    }

    private void initializeRepositories() throws CoreException {
        File[] extensions;
        if (this.rootsToInstall.isEmpty() && this.revertToPreviousState == NOTHING_TO_REVERT_TO && !this.printIUList) {
            return;
        }
        if (this.artifactRepositoryLocations == null) {
            this.missingArgument("-artifactRepository");
        }
        this.artifactManager = (IArtifactRepositoryManager)this.targetAgent.getService(IArtifactRepositoryManager.class);
        if (this.artifactManager == null) {
            throw new ProvisionException(Messages.Application_NoManager);
        }
        int removalIdx = 0;
        boolean anyValid = false;
        this.artifactReposForRemoval = new URI[this.artifactRepositoryLocations.size()];
        for (URI location : this.artifactRepositoryLocations) {
            try {
                if (!this.artifactManager.contains(location)) {
                    this.artifactManager.loadRepository(location, null);
                    this.artifactReposForRemoval[removalIdx++] = location;
                }
                anyValid = true;
            }
            catch (ProvisionException e) {
                this.log.log(e.getStatus());
            }
        }
        if (!anyValid) {
            this.noArtifactRepositorySpecified = true;
        }
        if (this.metadataRepositoryLocations == null) {
            this.missingArgument("metadataRepository");
        }
        this.metadataManager = (IMetadataRepositoryManager)this.targetAgent.getService(IMetadataRepositoryManager.class);
        if (this.metadataManager == null) {
            throw new ProvisionException(Messages.Application_NoManager);
        }
        removalIdx = 0;
        anyValid = false;
        int top = this.metadataRepositoryLocations.size();
        this.metadataReposForRemoval = new URI[top];
        int i = 0;
        while (i < top) {
            URI location = this.metadataRepositoryLocations.get(i);
            try {
                if (!this.metadataManager.contains(location)) {
                    this.metadataManager.loadRepository(location, null);
                    this.metadataReposForRemoval[removalIdx++] = location;
                }
                anyValid = true;
            }
            catch (ProvisionException e) {
                this.log.log(e.getStatus());
            }
            ++i;
        }
        if (!anyValid) {
            throw new ProvisionException(Messages.Application_NoRepositories);
        }
        if (!EngineActivator.EXTENDED) {
            return;
        }
        File[] fileArray = extensions = EngineActivator.getExtensionsDirectories();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.metadataManager.addRepository(f.toURI());
            this.metadataManager.setRepositoryProperty(f.toURI(), "p2.fragment", Boolean.TRUE.toString());
            this.metadataRepositoryLocations.add(f.toURI());
            this.artifactManager.addRepository(f.toURI());
            this.artifactManager.setRepositoryProperty(f.toURI(), "p2.fragment", Boolean.TRUE.toString());
            this.artifactRepositoryLocations.add(f.toURI());
            ++n2;
        }
    }

    private void adjustDestination() {
        if (this.destination == null) {
            return;
        }
        if ("macosx".equals(this.os) && this.destination.getName().endsWith(".app")) {
            this.destination = new File(this.destination, "Contents/Eclipse");
        }
    }

    private void initializeServices() throws CoreException {
        if (this.targetAgent == null) {
            if (this.destination != null || this.sharedLocation != null) {
                File dataAreaFile = this.sharedLocation == null ? new File(this.destination, "p2") : this.sharedLocation;
                this.targetAgent = this.createAgent(dataAreaFile.toURI());
                this.targetAgentIsSelfAndUp = false;
            } else {
                this.targetAgent = this.getDefaultAgent();
                this.targetAgentIsSelfAndUp = true;
            }
        }
        if (this.profileId == null && this.destination != null) {
            File configIni = new File(this.destination, "configuration/config.ini");
            Properties ciProps = new Properties();
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(configIni));){
                    ciProps.load(in);
                    this.profileId = ciProps.getProperty(PROP_P2_PROFILE);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (this.profileId == null) {
                this.profileId = this.destination.toString();
            }
        }
        if (this.profileId != null) {
            this.targetAgent.registerService(PROP_P2_PROFILE, (Object)this.profileId);
        } else {
            this.targetAgent.unregisterService(PROP_P2_PROFILE, null);
        }
        IDirector director = (IDirector)this.targetAgent.getService(IDirector.class);
        if (director == null) {
            throw new ProvisionException(Messages.Missing_director);
        }
        this.planner = (IPlanner)this.targetAgent.getService(IPlanner.class);
        if (this.planner == null) {
            throw new ProvisionException(Messages.Missing_planner);
        }
        this.engine = (IEngine)this.targetAgent.getService(IEngine.class);
        if (this.engine == null) {
            throw new ProvisionException(Messages.Missing_Engine);
        }
        this.trustService = new AvoidTrustPromptService(this.verboseTrust, this.trustSignedContentOnly, this.trustedAuthorityURIs, this.trustedPGPKeys, this.trustedCertificates);
        this.targetAgent.registerService(UIServices.SERVICE_NAME, (Object)this.trustService);
        IProvisioningEventBus eventBus = (IProvisioningEventBus)this.targetAgent.getService(IProvisioningEventBus.class);
        if (eventBus == null) {
            return;
        }
        eventBus.addListener((ProvisioningListener)this);
    }

    protected IProvisioningAgent getDefaultAgent() throws CoreException {
        BundleContext context = Activator.getContext();
        String currentAgentFiler = String.format("(%s=true)", "agent.current");
        try {
            Collection refs = context.getServiceReferences(IProvisioningAgent.class, currentAgentFiler);
            for (ServiceReference serviceReference : refs) {
                IProvisioningAgent service = (IProvisioningAgent)context.getService(serviceReference);
                if (service == null) continue;
                context.ungetService(serviceReference);
                return service;
            }
        }
        catch (InvalidSyntaxException e) {
            throw new CoreException(Status.error((String)"Internal error", (Throwable)e));
        }
        throw new CoreException(Status.error((String)"Can't fetch the default agent"));
    }

    protected IProvisioningAgent createAgent(URI p2DataArea) throws CoreException {
        BundleContext context = Activator.getContext();
        ServiceReference agentProviderRef = context.getServiceReference(IProvisioningAgentProvider.class);
        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)context.getService(agentProviderRef);
        IProvisioningAgent agent = provider.createAgent(p2DataArea);
        agent.registerService("org.eclipse.equinox.p2.installer.agent", (Object)provider.createAgent(null));
        context.ungetService(agentProviderRef);
        return agent;
    }

    public void notify(EventObject o) {
        if (!(o instanceof RepositoryEvent)) {
            return;
        }
        RepositoryEvent event = (RepositoryEvent)o;
        if (event.getKind() != 0) {
            return;
        }
        int type = event.getRepositoryType();
        URI location = event.getRepositoryLocation();
        if (1 == type && this.artifactReposForRemoval != null) {
            int i = 0;
            while (i < this.artifactReposForRemoval.length) {
                if (this.artifactReposForRemoval[i] != null && URIUtil.sameURI((URI)this.artifactReposForRemoval[i], (URI)location)) {
                    this.artifactReposForRemoval[i] = null;
                    break;
                }
                ++i;
            }
            return;
        }
        if (type == 0 && this.metadataReposForRemoval != null) {
            int i = 0;
            while (i < this.metadataReposForRemoval.length) {
                if (this.metadataReposForRemoval[i] != null && URIUtil.sameURI((URI)this.metadataReposForRemoval[i], (URI)location)) {
                    this.metadataReposForRemoval[i] = null;
                    break;
                }
                ++i;
            }
            return;
        }
    }

    private void markRoots(IProfileChangeRequest request, Collection<IInstallableUnit> roots) {
        for (IInstallableUnit root : roots) {
            request.setInstallableUnitProfileProperty(root, "org.eclipse.equinox.p2.type.root", Boolean.TRUE.toString());
        }
    }

    private void missingArgument(String argumentName) throws CoreException {
        throw new ProvisionException(NLS.bind((String)Messages.Missing_Required_Argument, (Object)argumentName));
    }

    private void performList() throws CoreException {
        if (this.metadataRepositoryLocations.isEmpty()) {
            this.missingArgument("metadataRepository");
        }
        ArrayList<IInstallableUnit> allRoots = new ArrayList<IInstallableUnit>();
        if (this.rootsToList.size() == 0) {
            for (IInstallableUnit element : this.collectRootIUs((IQuery<IInstallableUnit>)QueryUtil.createIUAnyQuery())) {
                allRoots.add(element);
            }
        } else {
            for (IQuery<IInstallableUnit> root : this.rootsToList) {
                for (IInstallableUnit element : this.collectRootIUs(root)) {
                    allRoots.add(element);
                }
            }
        }
        allRoots.sort(null);
        String formattedString = this.listFormat.format(allRoots);
        System.out.println(formattedString);
    }

    private void performProvisioningActions() throws CoreException {
        IProfile profile = this.initializeProfile();
        Collection<IInstallableUnit> installs = this.collectRoots(profile, this.rootsToInstall, true);
        Collection<IInstallableUnit> uninstalls = this.collectRoots(profile, this.rootsToUninstall, false);
        boolean wasRoaming = Boolean.parseBoolean(profile.getProperty("org.eclipse.equinox.p2.roaming"));
        try {
            this.updateRoamingProperties(profile);
            ProvisioningContext context = new ProvisioningContext(this.targetAgent);
            context.setMetadataRepositories((URI[])this.metadataRepositoryLocations.stream().toArray(URI[]::new));
            context.setArtifactRepositories((URI[])this.artifactRepositoryLocations.stream().toArray(URI[]::new));
            context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", String.valueOf(this.followReferences));
            context.setProperty("org.eclipse.equinox.p2.director.followArtifactRepositoryReferences", String.valueOf(this.followReferences));
            if (this.addJREIU) {
                context.setExtraInstallableUnits(List.of(JREAction.createJREIU()));
            }
            ProfileChangeRequest request = this.buildProvisioningRequest(profile, installs, uninstalls);
            this.printRequest((IProfileChangeRequest)request);
            this.planAndExecute(profile, context, request);
        }
        finally {
            if (wasRoaming && !Boolean.parseBoolean(profile.getProperty("org.eclipse.equinox.p2.roaming"))) {
                this.setRoaming(profile);
            }
        }
    }

    private void planAndExecute(IProfile profile, ProvisioningContext context, ProfileChangeRequest request) throws CoreException {
        IProvisioningPlan result = this.planner.getProvisioningPlan((IProfileChangeRequest)request, context, (IProgressMonitor)new NullProgressMonitor());
        IStatus operationStatus = result.getStatus();
        if (!operationStatus.isOK()) {
            throw new CoreException(operationStatus);
        }
        this.log.log(operationStatus);
        this.executePlan(context, result);
    }

    private void executePlan(ProvisioningContext context, IProvisioningPlan result) throws CoreException {
        if (this.verifyOnly) {
            return;
        }
        IStatus operationStatus = !this.downloadOnly ? PlanExecutionHelper.executePlan((IProvisioningPlan)result, (IEngine)this.engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor()) : PlanExecutionHelper.executePlan((IProvisioningPlan)result, (IEngine)this.engine, (IPhaseSet)PhaseSetFactory.createPhaseSetIncluding((String[])new String[]{"collect", "checkTrust"}), (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
        switch (operationStatus.getSeverity()) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                this.log.log(operationStatus);
                break;
            }
            default: {
                if (this.noArtifactRepositorySpecified && this.hasNoRepositoryFound(operationStatus)) {
                    throw new ProvisionException(Messages.Application_NoRepositories);
                }
                throw new CoreException(operationStatus);
            }
        }
        if (this.tag == null) {
            return;
        }
        long newState = result.getProfile().getTimestamp();
        IProfileRegistry registry = (IProfileRegistry)this.targetAgent.getService(IProfileRegistry.class);
        registry.setProfileStateProperty(result.getProfile().getProfileId(), newState, "org.eclipse.equinox.p2.state.tag", this.tag);
    }

    private boolean hasNoRepositoryFound(IStatus status) {
        if (status.getException() != null && NO_ARTIFACT_REPOSITORIES_AVAILABLE.equals(status.getException().getMessage())) {
            return true;
        }
        if (status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                if (this.hasNoRepositoryFound(child)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void processArguments(String[] args) throws CoreException {
        if (args == null) {
            this.printHelpInfo = true;
            return;
        }
        EnvironmentInfo info = (EnvironmentInfo)ServiceHelper.getService((BundleContext)Activator.getContext(), EnvironmentInfo.class);
        this.os = info.getOS();
        this.ws = info.getWS();
        this.nl = info.getNL();
        this.arch = info.getOSArch();
        int i = 0;
        while (i < args.length) {
            String opt = args[i];
            if (OPTION_LIST.isOption(opt)) {
                this.printIUList = true;
                optionalArgument = DirectorApplication.getOptionalArgument(args, i);
                if (optionalArgument != null) {
                    DirectorApplication.parseIUsArgument(this.rootsToList, optionalArgument);
                    ++i;
                }
            } else if (OPTION_LIST_FORMAT.isOption(opt)) {
                String formatString = DirectorApplication.getRequiredArgument(args, ++i);
                this.listFormat = new IUListFormatter(formatString);
            } else if (OPTION_LIST_INSTALLED.isOption(opt)) {
                this.printRootIUList = true;
            } else if (OPTION_LIST_TAGS.isOption(opt)) {
                this.printTags = true;
            } else if (OPTION_DOWNLOAD_ONLY.isOption(opt)) {
                this.downloadOnly = true;
            } else if (OPTION_HELP.isOption(opt)) {
                this.printHelpInfo = true;
            } else if (OPTION_INSTALL_IU.isOption(opt)) {
                DirectorApplication.parseIUsArgument(this.rootsToInstall, DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_UNINSTALL_IU.isOption(opt)) {
                DirectorApplication.parseIUsArgument(this.rootsToUninstall, DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_REVERT.isOption(opt)) {
                String targettedState = DirectorApplication.getOptionalArgument(args, i);
                if (targettedState == null) {
                    this.revertToPreviousState = REVERT_TO_PREVIOUS;
                } else {
                    ++i;
                    this.revertToPreviousState = targettedState;
                }
            } else if (OPTION_PROFILE.isOption(opt)) {
                this.profileId = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_FLAVOR.isOption(opt)) {
                this.flavor = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_SHARED.isOption(opt)) {
                if (++i < args.length) {
                    String nxt = args[i];
                    if (nxt.startsWith("-")) {
                        --i;
                    } else {
                        this.sharedLocation = DirectorApplication.processFileArgument(nxt);
                    }
                }
                if (this.sharedLocation == null) {
                    this.sharedLocation = IPath.fromOSString((String)System.getProperty("user.home")).append(".p2/").toFile();
                }
            } else if (OPTION_DESTINATION.isOption(opt)) {
                this.destination = DirectorApplication.processFileArgument(DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_BUNDLEPOOL.isOption(opt)) {
                this.bundlePool = DirectorApplication.processFileArgument(DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_METADATAREPOS.isOption(opt)) {
                DirectorApplication.getURIs(this.metadataRepositoryLocations, DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_ARTIFACTREPOS.isOption(opt)) {
                DirectorApplication.getURIs(this.artifactRepositoryLocations, DirectorApplication.getRequiredArgument(args, ++i));
            } else if (OPTION_REPOSITORIES.isOption(opt)) {
                String arg = DirectorApplication.getRequiredArgument(args, ++i);
                DirectorApplication.getURIs(this.metadataRepositoryLocations, arg);
                DirectorApplication.getURIs(this.artifactRepositoryLocations, arg);
            } else if (OPTION_PROFILE_PROPS.isOption(opt)) {
                this.profileProperties = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_IU_PROFILE_PROPS.isOption(opt)) {
                this.iuProfileProperties = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_ROAMING.isOption(opt)) {
                this.roamingProfile = true;
            } else if (OPTION_VERIFY_ONLY.isOption(opt)) {
                this.verifyOnly = true;
            } else if (OPTION_PURGEHISTORY.isOption(opt)) {
                this.purgeRegistry = true;
            } else if (OPTION_FOLLOW_REFERENCES.isOption(opt)) {
                this.followReferences = true;
            } else if (OPTION_P2_OS.isOption(opt)) {
                this.os = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_P2_WS.isOption(opt)) {
                this.ws = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_P2_NL.isOption(opt)) {
                this.nl = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_P2_ARCH.isOption(opt)) {
                this.arch = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_TAG.isOption(opt)) {
                this.tag = DirectorApplication.getRequiredArgument(args, ++i);
            } else if (OPTION_VERBOSE_TRUST.isOption(opt)) {
                this.verboseTrust = true;
            } else if (OPTION_TRUST_SIGNED_CONTENT_ONLY.isOption(opt)) {
                this.trustSignedContentOnly = true;
            } else if (OPTION_TRUSTED_AUTHORITIES.isOption(opt)) {
                optionalArgument = DirectorApplication.getOptionalArgument(args, i);
                if (optionalArgument != null) {
                    ++i;
                }
                this.trustedAuthorityURIs = DirectorApplication.getAuthorityURIs(optionalArgument);
            } else if (OPTION_TRUSTED_PGP_KEYS.isOption(opt)) {
                optionalArgument = DirectorApplication.getOptionalArgument(args, i);
                if (optionalArgument != null) {
                    ++i;
                }
                this.trustedPGPKeys = new HashSet<String>(Arrays.asList(StringHelper.getArrayFromString((String)optionalArgument, (char)',')));
            } else if (OPTION_TRUSTED_CERTIFCATES.isOption(opt)) {
                optionalArgument = DirectorApplication.getOptionalArgument(args, i);
                if (optionalArgument != null) {
                    ++i;
                }
                this.trustedCertificates = new HashSet<String>(Arrays.asList(StringHelper.getArrayFromString((String)optionalArgument, (char)',')));
            } else if (OPTION_IGNORED.isOption(opt)) {
                optionalArgument = DirectorApplication.getOptionalArgument(args, i);
                if (optionalArgument != null) {
                    ++i;
                }
            } else if (OPTION_ADD_JRE_IU.isOption(opt)) {
                this.addJREIU = true;
            } else if (opt != null && opt.length() > 0) {
                throw new ProvisionException(NLS.bind((String)Messages.unknown_option_0, (Object)opt));
            }
            ++i;
        }
        if (this.listFormat != null && !this.printIUList && !this.printRootIUList) {
            throw new ProvisionException(NLS.bind((String)Messages.ArgRequiresOtherArgs, (Object[])new String[]{DirectorApplication.OPTION_LIST_FORMAT.identifiers[0], DirectorApplication.OPTION_LIST.identifiers[0], DirectorApplication.OPTION_LIST_INSTALLED.identifiers[0]}));
        }
        if (!(this.printHelpInfo || this.printIUList || this.printRootIUList || this.printTags || this.purgeRegistry || !this.rootsToInstall.isEmpty() || !this.rootsToUninstall.isEmpty() || this.revertToPreviousState != NOTHING_TO_REVERT_TO)) {
            this.log.printOut(Messages.Help_Missing_argument);
            this.printHelpInfo = true;
        }
        if (this.listFormat == null) {
            this.listFormat = new IUListFormatter("${id}=${version}");
        }
    }

    private void putProperties(String pairs, Map<String, String> properties) {
        String[] propPairs;
        String[] stringArray = propPairs = StringHelper.getArrayFromString((String)pairs, (char)',');
        int n = propPairs.length;
        int n2 = 0;
        while (n2 < n) {
            String tagValue;
            String tagKey;
            String propPair = stringArray[n2];
            int eqIdx = propPair.indexOf(61);
            if (eqIdx >= 0 && (tagKey = propPair.substring(0, eqIdx).trim()).length() != 0 && (tagValue = propPair.substring(eqIdx + 1).trim()).length() > 0) {
                properties.put(tagKey, tagValue);
            }
            ++n2;
        }
    }

    private void cleanupServices() {
        if (this.targetAgent != null && !this.targetAgentIsSelfAndUp) {
            this.targetAgent.stop();
            this.targetAgent = null;
        }
    }

    public Object run(String[] args) {
        long time = System.currentTimeMillis();
        try {
            this.processArguments(args);
            if (this.printHelpInfo) {
                DirectorApplication.performHelpInfo(false);
            } else {
                this.adjustDestination();
                this.initializeServices();
                if (!(this.printIUList || this.printRootIUList || this.printTags || this.canInstallInDestination())) {
                    this.log.printOut(NLS.bind((String)Messages.Cant_write_in_destination, (Object)this.destination.getAbsolutePath()));
                    Integer n = EXIT_ERROR;
                    return n;
                }
                this.initializeRepositories();
                if (this.revertToPreviousState != NOTHING_TO_REVERT_TO) {
                    this.revertToPreviousState();
                } else if (!this.rootsToInstall.isEmpty() || !this.rootsToUninstall.isEmpty()) {
                    this.performProvisioningActions();
                }
                if (this.printIUList) {
                    this.performList();
                }
                if (this.printRootIUList) {
                    this.performListInstalledRoots();
                }
                if (this.printTags) {
                    this.performPrintTags();
                }
                if (this.purgeRegistry) {
                    this.purgeRegistry();
                }
                this.log.printOut(NLS.bind((String)Messages.Operation_complete, (Object)(System.currentTimeMillis() - time)));
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        catch (CoreException e) {
            IStatus error = e.getStatus();
            this.log.printOut(Messages.Operation_failed);
            this.printError(error, 0);
            this.log.log(error);
            if (error.getSeverity() == 8 && !this.verboseTrust) {
                this.trustService.dump();
            }
            this.setSystemProperty("eclipse.exitdata", "");
            Integer n = EXIT_ERROR;
            return n;
        }
        finally {
            this.log.close();
            this.cleanupRepositories();
            this.cleanupServices();
        }
    }

    private void purgeRegistry() throws ProvisionException {
        if (this.getProfile() == null) {
            return;
        }
        IProfileRegistry registry = (IProfileRegistry)this.targetAgent.getService(IProfileRegistry.class);
        long[] allProfiles = registry.listProfileTimestamps(this.profileId);
        int i = 0;
        while (i < allProfiles.length - 1) {
            registry.removeProfile(this.profileId, allProfiles[i]);
            ++i;
        }
    }

    private void revertToPreviousState() throws CoreException {
        IProfile profile = this.initializeProfile();
        IProfileRegistry profileRegistry = (IProfileRegistry)this.targetAgent.getService(IProfileRegistry.class);
        IProfile targetProfile = null;
        if (this.revertToPreviousState == REVERT_TO_PREVIOUS) {
            long[] profiles = profileRegistry.listProfileTimestamps(profile.getProfileId());
            if (profiles.length == 0) {
                return;
            }
            targetProfile = profileRegistry.getProfile(profile.getProfileId(), profiles[profiles.length - 1]);
        } else {
            targetProfile = profileRegistry.getProfile(profile.getProfileId(), this.getTimestampToRevertTo(profileRegistry, profile.getProfileId()));
        }
        if (targetProfile == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.p2.director.app", Messages.Missing_profile));
        }
        IProvisioningPlan plan = this.planner.getDiffPlan(profile, targetProfile, (IProgressMonitor)new NullProgressMonitor());
        ProvisioningContext context = new ProvisioningContext(this.targetAgent);
        context.setMetadataRepositories(this.metadataRepositoryLocations.toArray(new URI[this.metadataRepositoryLocations.size()]));
        context.setArtifactRepositories(this.artifactRepositoryLocations.toArray(new URI[this.artifactRepositoryLocations.size()]));
        context.setProperty("org.eclipse.equinox.p2.director.followRepositoryReferences", String.valueOf(this.followReferences));
        context.setProperty("org.eclipse.equinox.p2.director.followArtifactRepositoryReferences", String.valueOf(this.followReferences));
        this.executePlan(context, plan);
    }

    /*
     * Unable to fully structure code
     */
    private long getTimestampToRevertTo(IProfileRegistry profileRegistry, String profId) {
        block5: {
            timestampToRevertTo = -1L;
            try {
                timestampToRevertTo = Long.valueOf(this.revertToPreviousState);
                break block5;
            }
            catch (NumberFormatException e) {
                tags = profileRegistry.getProfileStateProperties(profId, "org.eclipse.equinox.p2.state.tag");
                entries = tags.entrySet();
                ** for (entry : entries)
            }
lbl-1000:
            // 1 sources

            {
                if (!((String)entry.getValue()).equals(this.revertToPreviousState)) continue;
                try {
                    tmp = Long.valueOf((String)entry.getKey());
                    if (tmp <= timestampToRevertTo) continue;
                    timestampToRevertTo = tmp;
                }
                catch (NumberFormatException var10_10) {
                    // empty catch block
                }
                continue;
            }
        }
        return timestampToRevertTo;
    }

    private void setSystemProperty(String key, String value) {
        EnvironmentInfo env = (EnvironmentInfo)ServiceHelper.getService((BundleContext)Activator.getContext(), EnvironmentInfo.class);
        if (env != null) {
            env.setProperty(key, value);
        } else {
            System.getProperties().put(key, value);
        }
    }

    IQueryResult<IInstallableUnit> getInstallableUnits(URI location, IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        IMetadataRepositoryManager queryable = null;
        if (location == null) {
            queryable = this.metadataManager;
        } else {
            try {
                queryable = this.metadataManager.loadRepository(location, monitor);
            }
            catch (ProvisionException provisionException) {
                // empty catch block
            }
        }
        if (queryable != null) {
            return queryable.query(query, monitor);
        }
        return Collector.emptyCollector();
    }

    private static void performHelpInfo(boolean documentation) {
        CommandLineOption[] allOptions;
        CommandLineOption[] commandLineOptionArray = allOptions = new CommandLineOption[]{OPTION_METADATAREPOS, OPTION_ARTIFACTREPOS, OPTION_REPOSITORIES, OPTION_INSTALL_IU, OPTION_UNINSTALL_IU, OPTION_REVERT, OPTION_PURGEHISTORY, OPTION_DESTINATION, OPTION_LIST, OPTION_LIST_TAGS, OPTION_LIST_INSTALLED, OPTION_LIST_FORMAT, OPTION_PROFILE, OPTION_PROFILE_PROPS, OPTION_IU_PROFILE_PROPS, OPTION_FLAVOR, OPTION_BUNDLEPOOL, OPTION_P2_OS, OPTION_P2_WS, OPTION_P2_ARCH, OPTION_P2_NL, OPTION_ROAMING, OPTION_SHARED, OPTION_TAG, OPTION_VERIFY_ONLY, OPTION_DOWNLOAD_ONLY, OPTION_FOLLOW_REFERENCES, OPTION_VERBOSE_TRUST, OPTION_TRUST_SIGNED_CONTENT_ONLY, OPTION_TRUSTED_AUTHORITIES, OPTION_TRUSTED_PGP_KEYS, OPTION_TRUSTED_CERTIFCATES, OPTION_HELP, OPTION_ADD_JRE_IU};
        int n = allOptions.length;
        int n2 = 0;
        while (n2 < n) {
            CommandLineOption allOption = commandLineOptionArray[n2];
            if (documentation) {
                allOption.appendHelpDocumentation(System.out);
            } else {
                allOption.appendHelp(System.out);
            }
            ++n2;
        }
    }

    private IStatus setRoaming(IProfile profile) {
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.setProfileProperty("org.eclipse.equinox.p2.roaming", "true");
        ProvisioningContext context = new ProvisioningContext(this.targetAgent);
        context.setMetadataRepositories(new URI[0]);
        context.setArtifactRepositories(new URI[0]);
        IProvisioningPlan result = this.planner.getProvisioningPlan((IProfileChangeRequest)request, context, (IProgressMonitor)new NullProgressMonitor());
        return PlanExecutionHelper.executePlan((IProvisioningPlan)result, (IEngine)this.engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
    }

    public Object start(IApplicationContext context) throws Exception {
        return this.run((String[])context.getArguments().get("application.args"));
    }

    private String toString(Map<String, String> context) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, String> entry : context.entrySet()) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(entry.getKey());
            result.append('=');
            result.append(entry.getValue());
        }
        return result.toString();
    }

    private void updateRoamingProperties(IProfile profile) throws CoreException {
        if (this.destination == null) {
            return;
        }
        if (this.noProfileId) {
            throw new ProvisionException(Messages.Missing_profileid);
        }
        if (!Boolean.parseBoolean(profile.getProperty("org.eclipse.equinox.p2.roaming"))) {
            return;
        }
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        if (!this.destination.equals(new File(profile.getProperty("org.eclipse.equinox.p2.installFolder")))) {
            request.setProfileProperty("org.eclipse.equinox.p2.installFolder", this.destination.getAbsolutePath());
        }
        File cacheLocation = null;
        cacheLocation = this.bundlePool == null ? (this.sharedLocation == null ? this.destination.getAbsoluteFile() : this.sharedLocation.getAbsoluteFile()) : this.bundlePool.getAbsoluteFile();
        if (!cacheLocation.equals(new File(profile.getProperty("org.eclipse.equinox.p2.cache")))) {
            request.setProfileProperty("org.eclipse.equinox.p2.cache", cacheLocation.getAbsolutePath());
        }
        if (request.getProfileProperties().size() == 0) {
            return;
        }
        request.setProfileProperty("org.eclipse.equinox.p2.roaming", "false");
        ProvisioningContext context = new ProvisioningContext(this.targetAgent);
        context.setMetadataRepositories(new URI[0]);
        context.setArtifactRepositories(new URI[0]);
        IProvisioningPlan result = this.planner.getProvisioningPlan((IProfileChangeRequest)request, context, (IProgressMonitor)new NullProgressMonitor());
        IStatus status = PlanExecutionHelper.executePlan((IProvisioningPlan)result, (IEngine)this.engine, (ProvisioningContext)context, (IProgressMonitor)new NullProgressMonitor());
        if (!status.isOK()) {
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.equinox.p2.director.app", 4, new IStatus[]{status}, NLS.bind((String)Messages.Cant_change_roaming, (Object)profile.getProfileId()), null));
        }
    }

    public void stop() {
        IProvisioningEventBus eventBus = (IProvisioningEventBus)this.targetAgent.getService(IProvisioningEventBus.class);
        if (eventBus != null) {
            eventBus.removeListener((ProvisioningListener)this);
        }
        if (this.log != null) {
            this.log.close();
        }
    }

    public void setLog(ILog log) {
        this.log = log;
    }

    private void performListInstalledRoots() throws CoreException {
        IProfile profile = this.initializeProfile();
        IQueryResult roots = profile.query((IQuery)new UserVisibleRootQuery(), null);
        TreeSet sorted = new TreeSet(roots.toUnmodifiableSet());
        for (IInstallableUnit iu : sorted) {
            System.out.println(iu.getId() + "/" + String.valueOf(iu.getVersion()));
        }
    }

    private void performPrintTags() throws CoreException {
        IProfile profile = this.initializeProfile();
        IProfileRegistry registry = (IProfileRegistry)this.targetAgent.getService(IProfileRegistry.class);
        Map tags = registry.getProfileStateProperties(profile.getProfileId(), "org.eclipse.equinox.p2.state.tag");
        ArrayList timeStamps = new ArrayList(tags.keySet());
        timeStamps.sort(Collections.reverseOrder());
        for (String timestamp : timeStamps) {
            System.out.println((String)tags.get(timestamp));
        }
    }

    private void printRequest(IProfileChangeRequest request) {
        Collection toAdd = request.getAdditions();
        for (IInstallableUnit added : toAdd) {
            this.log.printOut(NLS.bind((String)Messages.Installing, (Object)added.getId(), (Object)added.getVersion()));
        }
        Collection toRemove = request.getRemovals();
        for (IInstallableUnit removed : toRemove) {
            this.log.printOut(NLS.bind((String)Messages.Uninstalling, (Object)removed.getId(), (Object)removed.getVersion()));
        }
    }

    private void printError(IStatus status, int level) {
        String prefix = DirectorApplication.emptyString(level);
        String msg = status.getMessage();
        this.log.printErr(prefix + msg);
        Throwable cause = status.getException();
        if (cause != null) {
            boolean isCauseMsg;
            boolean bl = isCauseMsg = msg.equals(cause.getMessage()) || msg.equals(cause.toString());
            if (!isCauseMsg) {
                this.log.printErr(prefix + "Caused by: ");
                this.printError(cause, level);
            }
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            this.printError(child, level + 1);
            ++n2;
        }
    }

    private void printError(Throwable trace, int level) {
        if (trace instanceof CoreException) {
            this.printError(((CoreException)trace).getStatus(), level);
        } else {
            String prefix = DirectorApplication.emptyString(level);
            this.log.printErr(prefix + trace.toString());
            Throwable cause = trace.getCause();
            if (cause != null) {
                this.log.printErr(prefix + "Caused by: ");
                this.printError(cause, level);
            }
        }
    }

    private static String emptyString(int size) {
        return IntStream.range(0, size).mapToObj(i -> "\t").collect(Collectors.joining());
    }

    private boolean canInstallInDestination() throws CoreException {
        if (this.targetAgentIsSelfAndUp) {
            return true;
        }
        if (this.destination == null) {
            this.missingArgument("destination");
        }
        return DirectorApplication.canWrite(this.destination);
    }

    private static boolean canWrite(File installDir) {
        installDir.mkdirs();
        return installDir.isDirectory() && Files.isWritable(installDir.toPath());
    }

    public static class AvoidTrustPromptService
    extends UIServices
    implements IArtifactUIServices,
    IInstallableUnitUIServices {
        private static final Pattern IGNORED_TOUCHPOINT_DATA = Pattern.compile("manifest=Instruction\\[Bundle-SymbolicName: [^ ]+(; singleton:=true)? Bundle-Version: [^,]+( Fragment-Host: [^;]+;bundle-version=\"[^\"]+\")?,null]|zipped=Instruction\\[true,null]");
        private final PrintStream out;
        private final ByteArrayOutputStream details;
        private final boolean trustSignedContentOnly;
        private final Set<URI> trustedAuthorityURIs;
        private final Set<String> trustedPGPKeyFingerprints;
        private final Set<String> trustedCertificateFingerprints;

        public AvoidTrustPromptService() {
            this(false, false, null, null, null);
        }

        public AvoidTrustPromptService(boolean verbose, boolean trustSignedContentOnly, Set<URI> trustedAuthorityURIs, Set<String> trustedPGPKeys, Set<String> trustedCertificates) {
            if (verbose) {
                this.out = System.out;
                this.details = null;
            } else {
                this.details = new ByteArrayOutputStream();
                this.out = new PrintStream((OutputStream)this.details, false, StandardCharsets.UTF_8);
            }
            this.trustSignedContentOnly = trustSignedContentOnly;
            this.trustedAuthorityURIs = trustedAuthorityURIs;
            this.trustedPGPKeyFingerprints = trustedPGPKeys;
            this.trustedCertificateFingerprints = trustedCertificates;
        }

        public void dump() {
            if (this.details != null) {
                this.out.close();
                System.out.println(new String(this.details.toByteArray(), StandardCharsets.UTF_8));
            }
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location) {
            return null;
        }

        public UIServices.AuthenticationInfo getUsernamePassword(String location, UIServices.AuthenticationInfo previousInfo) {
            return null;
        }

        @Deprecated
        public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChains, String[] unsignedDetail) {
            throw new UnsupportedOperationException("Use AvoidTrustPromptService.getTrustAuthorityInfo(Map<URI, Set<IInstallableUnit>>, Map<URI, List<Certificate>>)");
        }

        @Deprecated
        public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChains, Collection<PGPPublicKey> untrustedPGPKeys, String[] unsignedDetail) {
            throw new UnsupportedOperationException("Use AvoidTrustPromptService.getTrustAuthorityInfo(Map<URI, Set<IInstallableUnit>>, Map<URI, List<Certificate>>)");
        }

        public IInstallableUnitUIServices.TrustAuthorityInfo getTrustAuthorityInfo(Map<URI, Set<IInstallableUnit>> siteIUs, Map<URI, List<Certificate>> siteCertificates) {
            LinkedHashSet<URI> trustedAuthorities = new LinkedHashSet<URI>();
            block0: for (Map.Entry<URI, Set<IInstallableUnit>> entry : siteIUs.entrySet()) {
                URI authority = entry.getKey();
                this.out.println(NLS.bind((String)Messages.DirectorApplication_FetchingIUsHeading, (Object)authority));
                for (IInstallableUnit iu : entry.getValue()) {
                    this.out.println("  " + String.valueOf(iu));
                    for (ITouchpointData touchpointData : iu.getTouchpointData()) {
                        for (Map.Entry data : touchpointData.getInstructions().entrySet()) {
                            String text = data.toString().replaceAll("\\s+", " ").trim();
                            if (IGNORED_TOUCHPOINT_DATA.matcher(text).matches()) continue;
                            this.out.println("    " + text);
                        }
                    }
                }
                if (this.trustedAuthorityURIs == null) continue;
                List authorityChain = AuthorityChecker.getAuthorityChain((URI)authority);
                for (URI uri : authorityChain) {
                    if (!this.trustedAuthorityURIs.contains(uri)) continue;
                    trustedAuthorities.add(authority);
                    continue block0;
                }
            }
            return new IInstallableUnitUIServices.TrustAuthorityInfo(this.trustedAuthorityURIs != null ? trustedAuthorities : siteIUs.keySet(), false, false);
        }

        public UIServices.TrustInfo getTrustInfo(Map<List<Certificate>, Set<IArtifactKey>> untrustedCertificateChains, Map<PGPPublicKey, Set<IArtifactKey>> untrustedPGPKeys, Set<IArtifactKey> unsignedArtifacts, Map<IArtifactKey, File> artifactFiles) {
            LinkedHashSet<Certificate> trustedCertificates = new LinkedHashSet<Certificate>();
            if (untrustedCertificateChains != null) {
                for (Map.Entry<List<Certificate>, Set<IArtifactKey>> entry : untrustedCertificateChains.entrySet()) {
                    this.out.println(Messages.DirectorApplication_CertficateTrustChainHeading);
                    List<Certificate> chain = entry.getKey();
                    boolean trusted = false;
                    for (Certificate certificate : chain) {
                        String fingerprint = this.getFingerprint(certificate);
                        if (this.trustedCertificateFingerprints == null || this.trustedCertificateFingerprints.contains(fingerprint)) {
                            trusted = true;
                        }
                        String text = certificate.toString().replaceAll("(\r?\n)", "$1    ");
                        this.out.println("    " + fingerprint + " -> " + text);
                    }
                    for (IArtifactKey artifactKey : entry.getValue()) {
                        File artifactFile = artifactFiles.get(artifactKey);
                        this.out.println("  " + String.valueOf(artifactKey) + " -> " + String.valueOf(artifactFile));
                    }
                    if (!trusted) continue;
                    trustedCertificates.add(chain.get(0));
                }
            }
            LinkedHashSet<PGPPublicKey> pgpKeys = new LinkedHashSet<PGPPublicKey>();
            if (untrustedPGPKeys != null) {
                for (Map.Entry<PGPPublicKey, Set<IArtifactKey>> entry : untrustedPGPKeys.entrySet()) {
                    PGPPublicKey key = entry.getKey();
                    String fingerprint = PGPPublicKeyService.toHexFingerprint((PGPPublicKey)key);
                    if (this.trustedPGPKeyFingerprints == null || this.trustedPGPKeyFingerprints.contains(fingerprint)) {
                        pgpKeys.add(key);
                    }
                    this.out.println(NLS.bind((String)Messages.DirectorApplication_PGPKeysHeading, (Object)fingerprint));
                    for (IArtifactKey artifactKey : entry.getValue()) {
                        File artifactFile = artifactFiles.get(artifactKey);
                        this.out.println("  " + String.valueOf(artifactKey) + " -> " + String.valueOf(artifactFile));
                    }
                }
            }
            if (unsignedArtifacts != null && !unsignedArtifacts.isEmpty()) {
                this.out.println(Messages.DirectorApplication_UnsignedHeading);
                for (IArtifactKey artifactKey : unsignedArtifacts) {
                    File artifactFile = artifactFiles.get(artifactKey);
                    this.out.println("  " + String.valueOf(artifactKey) + " -> " + String.valueOf(artifactFile));
                }
            }
            return new UIServices.TrustInfo(trustedCertificates, pgpKeys, false, !this.trustSignedContentOnly);
        }

        private String getFingerprint(Certificate certificate) {
            try {
                MessageDigest digester = MessageDigest.getInstance("SHA-256");
                return HexFormat.of().formatHex(digester.digest(certificate.getEncoded()));
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException e) {
                return "deadbeef";
            }
        }
    }

    private static class CommandLineOption {
        final String[] identifiers;
        private final String optionSyntaxString;
        private final String helpString;

        CommandLineOption(String[] identifiers, String optionSyntaxString, String helpString) {
            this.identifiers = identifiers;
            this.optionSyntaxString = optionSyntaxString;
            this.helpString = helpString;
        }

        boolean isOption(String opt) {
            int idx = this.identifiers.length;
            while (--idx >= 0) {
                if (!this.identifiers[idx].equalsIgnoreCase(opt)) continue;
                return true;
            }
            return false;
        }

        void appendHelp(PrintStream out) {
            out.print(this.identifiers[0]);
            int idx = 1;
            while (idx < this.identifiers.length) {
                out.print(" | ");
                out.print(this.identifiers[idx]);
                ++idx;
            }
            if (this.optionSyntaxString != null) {
                out.print(' ');
                out.print(this.optionSyntaxString);
            }
            out.println();
            out.print("  ");
            out.println(this.helpString);
        }

        void appendHelpDocumentation(PrintStream out) {
            out.print("<dt>");
            out.print(this.identifiers[0]);
            int idx = 1;
            while (idx < this.identifiers.length) {
                out.print(" | ");
                out.print(this.identifiers[idx]);
                ++idx;
            }
            if (this.optionSyntaxString != null) {
                out.print(' ');
                out.print(this.escape(this.optionSyntaxString));
            }
            out.println("</dt>");
            out.println("<dd>");
            out.println(this.escape(this.helpString));
            out.println("</dd>");
        }

        private String escape(String string) {
            return string.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
        }
    }

    class LocationQueryable
    implements IQueryable<IInstallableUnit> {
        private final URI location;

        public LocationQueryable(URI location) {
            this.location = location;
            Assert.isNotNull((Object)location);
        }

        public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
            return DirectorApplication.this.getInstallableUnits(this.location, query, monitor);
        }
    }
}

