/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.presentation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IUndecoratingLabelProvider;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DelegatingStyledCellLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.emf.edit.ui.util.FindAndReplaceTarget;
import org.eclipse.emf.edit.ui.util.IRevertablePart;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.provider.BaseItemProviderAdapterFactory;
import org.eclipse.oomph.maven.Coordinate;
import org.eclipse.oomph.maven.DOMElement;
import org.eclipse.oomph.maven.MavenFactory;
import org.eclipse.oomph.maven.Project;
import org.eclipse.oomph.maven.Realm;
import org.eclipse.oomph.maven.presentation.MavenActionBarContributor;
import org.eclipse.oomph.maven.presentation.MavenEditorPlugin;
import org.eclipse.oomph.maven.provider.MavenItemProviderAdapterFactory;
import org.eclipse.oomph.maven.provider.RealmItemProvider;
import org.eclipse.oomph.maven.provider.ReferenceGroup;
import org.eclipse.oomph.maven.util.MavenValidator;
import org.eclipse.oomph.maven.util.POMXMLUtil;
import org.eclipse.oomph.predicates.provider.PredicatesItemProviderAdapterFactory;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.resources.provider.ResourcesItemProviderAdapterFactory;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MavenEditor
extends MultiPageEditorPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker,
IRevertablePart {
    private static final String ANNOTATION_SOURCE_PROBLEM_PREFIX = "problem:/";
    protected AdapterFactoryEditingDomain editingDomain;
    protected ComposedAdapterFactory adapterFactory;
    protected IContentOutlinePage contentOutlinePage;
    protected IStatusLineManager contentOutlineStatusLineManager;
    protected TreeViewer contentOutlineViewer;
    protected List<PropertySheetPage> propertySheetPages = new ArrayList<PropertySheetPage>();
    protected TreeViewer selectionViewer;
    protected Viewer currentViewer;
    protected ISelectionChangedListener selectionChangedListener;
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    private Consumer<Resource> liveValidateScheduler;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (p instanceof ContentOutline) {
                if (((ContentOutline)p).getCurrentPage() == MavenEditor.this.contentOutlinePage) {
                    MavenEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)MavenEditor.this);
                    MavenEditor.this.setCurrentViewer((Viewer)MavenEditor.this.contentOutlineViewer);
                }
            } else if (p instanceof PropertySheet) {
                if (MavenEditor.this.propertySheetPages.contains(((PropertySheet)p).getCurrentPage())) {
                    MavenEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)MavenEditor.this);
                    MavenEditor.this.handleActivate();
                }
            } else if (p == MavenEditor.this) {
                MavenEditor.this.handleActivate();
            } else {
                MavenEditor.this.handleOtherPartActivate(p);
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){
        protected boolean dispatching;

        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = MavenEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            MavenEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            MavenEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        this.dispatchUpdateProblemIndication();
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void dispatchUpdateProblemIndication() {
            if (MavenEditor.this.updateProblemIndication && !this.dispatching) {
                this.dispatching = true;
                MavenEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        dispatching = false;
                        MavenEditor.this.updateProblemIndication();
                    }
                });
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
            MavenEditor.this.resourceToDiagnosticMap.remove(target);
            this.dispatchUpdateProblemIndication();
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).MavenEditor.this.editingDomain.getResourceSet();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() == 1) {
                            Resource resource;
                            if ((delta.getKind() == 2 || delta.getKind() == 4) && (resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
                                if (delta.getKind() == 2) {
                                    this.removedResources.add(resource);
                                } else {
                                    if ((delta.getFlags() & 0x20000) != 0) {
                                        DiagnosticDecorator.DiagnosticAdapter.update((Notifier)resource, (Diagnostic)(this).MavenEditor.this.markerHelper.getMarkerDiagnostics((Object)resource, (IFile)delta.getResource(), false));
                                    }
                                    if ((delta.getFlags() & 0x100) != 0 && !(this).MavenEditor.this.savedResources.remove(resource)) {
                                        this.changedResources.add(resource);
                                    }
                                }
                            }
                            return false;
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (!visitor.getRemovedResources().isEmpty()) {
                    MavenEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).MavenEditor.this.removedResources.addAll(visitor.getRemovedResources());
                            if (!MavenEditor.this.isDirty()) {
                                MavenEditor.this.getSite().getPage().closeEditor((IEditorPart)MavenEditor.this, false);
                            }
                        }
                    });
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    MavenEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            (this).MavenEditor.this.changedResources.addAll(visitor.getChangedResources());
                            if (MavenEditor.this.getSite().getPage().getActiveEditor() == MavenEditor.this) {
                                MavenEditor.this.handleActivate();
                            }
                        }
                    });
                }
            }
            catch (CoreException exception) {
                MavenEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    private boolean showHoverLinks;
    private ColumnViewerInformationControlToolTipSupport toolTipSupport;
    private static final Set<String> LINK_WITH_VIEWER_IDS = Set.of("org.eclipse.egit.ui.RepositoriesView", "org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.jdt.ui.PackageExplorer");
    private LinkListener linkListener = new LinkListener();

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            if (this.isDirty()) {
                this.changedResources.addAll((Collection<Resource>)resourceSet.getResources());
            }
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(resourceSet.getLoadOptions());
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.oomph.maven.editor", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                    this.showTabs();
                }
                catch (PartInitException exception) {
                    MavenEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                try {
                    this.markerHelper.updateMarkers((Diagnostic)diagnostic);
                }
                catch (CoreException exception) {
                    MavenEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)MavenEditor.getString("_UI_FileConflict_label"), (String)MavenEditor.getString("_WARN_FileConflict"));
    }

    public MavenEditor() {
        this.initializeEditingDomain();
    }

    protected void initializeEditingDomainGen() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MavenItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new BaseItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new PredicatesItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourcesItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack(){

            public void execute(Command command) {
                if (!(command instanceof AbstractCommand.NonDirtying)) {
                    DiagnosticDecorator.Styled.cancel((EditingDomain)MavenEditor.this.editingDomain);
                }
                super.execute(command);
            }
        };
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                MavenEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MavenEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            MavenEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        Iterator<PropertySheetPage> i = (this).MavenEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = i.next();
                            if (propertySheetPage.getControl() == null || propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new MavenItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new BaseItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new PredicatesItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourcesItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack(){

            public void execute(Command command) {
                Realm realm;
                if (!(command instanceof AbstractCommand.NonDirtying) || command instanceof MavenActionBarContributor.ReconcileRealmAction.ReconcileCommand || command instanceof NonDirtyingCompoundCommand) {
                    DiagnosticDecorator.Styled.cancel((EditingDomain)MavenEditor.this.editingDomain);
                }
                if (!(command instanceof MavenActionBarContributor.ReconcileRealmAction.ReconcileCommand) && (realm = MavenEditor.this.getRealm()) != null) {
                    CompoundCommand compoundCommand = NonDirtyingCompoundCommand.create(command);
                    compoundCommand.append((Command)new MavenActionBarContributor.ReconcileRealmAction.ReconcileCommand(realm));
                    command = compoundCommand;
                }
                super.execute(command);
            }
        };
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                MavenEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MavenEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            MavenEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                            if (this.shouldSchedule(mostRecentCommand)) {
                                for (Resource resource : (this).MavenEditor.this.editingDomain.getResourceSet().getResources()) {
                                    (this).MavenEditor.this.liveValidateScheduler.accept(resource);
                                }
                            }
                        }
                        Iterator<PropertySheetPage> i = (this).MavenEditor.this.propertySheetPages.iterator();
                        while (i.hasNext()) {
                            PropertySheetPage propertySheetPage = i.next();
                            if (propertySheetPage.getControl() == null || propertySheetPage.getControl().isDisposed()) {
                                i.remove();
                                continue;
                            }
                            propertySheetPage.refresh();
                        }
                    }
                });
            }

            private boolean shouldSchedule(Command mostRecentCommand) {
                if (mostRecentCommand instanceof MavenActionBarContributor.ReconcileRealmAction.ReconcileCommand) {
                    return true;
                }
                if (mostRecentCommand instanceof CompoundCommand) {
                    CompoundCommand compoundCommand = (CompoundCommand)mostRecentCommand;
                    for (Command command : compoundCommand.getCommandList()) {
                        if (!this.shouldSchedule(command)) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap()){

            public Object getWrapper(Object object) {
                return object;
            }
        };
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (MavenEditor.this.currentViewer != null) {
                        MavenEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().asyncExec(runnable);
        }
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        MavenEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    private void openEditor(Path location, Element element) {
        IWorkbenchPage page = this.getEditorSite().getPage();
        IEditorDescriptor descriptor = page.getWorkbenchWindow().getWorkbench().getEditorRegistry().getDefaultEditor(location.getFileName().toString());
        String id = descriptor.getId();
        IFile[] files = ResourcesUtil.findFilesForLocationURI((java.net.URI)location.toUri());
        FileStoreEditorInput input = files.length == 0 ? new FileStoreEditorInput(EFS.getLocalFileSystem().fromLocalFile(location.toFile())) : new FileEditorInput(files[0]);
        try {
            POMXMLUtil.TextRegion selection;
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchPart part;
                IEditorReference editorReference = iEditorReferenceArray[n2];
                if (id.equals(editorReference.getId()) && (part = editorReference.getPart(false)) != null && page.isPartVisible(part)) {
                    page.activate(part);
                    break;
                }
                ++n2;
            }
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IEditorInput)input, (String)descriptor.getId());
            if (editor != null && (selection = POMXMLUtil.getSelection((Element)element)) != null) {
                ISelectionProvider selectionProvider = editor.getEditorSite().getSelectionProvider();
                selectionProvider.setSelection((ISelection)new TextSelection(selection.start(), selection.length()));
            }
        }
        catch (PartInitException ex) {
            MavenEditorPlugin.INSTANCE.log((Object)ex);
        }
    }

    public void createModelGen() {
        URI resourceURI = EditUIUtil.getURI((IEditorInput)this.getEditorInput(), (URIConverter)this.editingDomain.getResourceSet().getURIConverter());
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        }
        catch (Exception e) {
            exception = e;
            resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
    }

    public void createModel() {
        this.createModelGen();
        Realm realm = this.getRealm();
        if (realm != null) {
            realm.reconcile();
        }
    }

    protected Realm getRealm() {
        EObject eObject;
        EList contents;
        EList resources = this.editingDomain.getResourceSet().getResources();
        if (!resources.isEmpty() && !(contents = ((Resource)resources.get(0)).getContents()).isEmpty() && (eObject = (EObject)contents.get(0)) instanceof Realm) {
            Realm realm = (Realm)eObject;
            return realm;
        }
        return null;
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        boolean hasErrors;
        boolean bl = hasErrors = !resource.getErrors().isEmpty();
        if (hasErrors || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(hasErrors ? 4 : 2, "org.eclipse.oomph.maven.editor", 0, MavenEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.oomph.maven.editor", 0, MavenEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createPagesGen() {
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setUseHashlookup(true);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DecoratingColumLabelProvider.StyledLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.adapterFactory, (Viewer)this.selectionViewer), (ILabelDecorator)new DiagnosticDecorator.Styled((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer, MavenEditorPlugin.getPlugin().getDialogSettings()))));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.selectionViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer));
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, MavenEditor.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MavenEditor.this.getContainer().isDisposed()) {
                        MavenEditor.this.setActivePage(0);
                    }
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    MavenEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MavenEditor.this.updateProblemIndication();
            }
        });
    }

    public void createPages() {
        this.getEditingDomain().getResourceSet().eAdapters().add((Object)new DiagnosticDecorator.DiagnosticAdapter(){

            protected void updateDiagnostic(Diagnostic diagnostic) {
                for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                    Resource resource = (Resource)childDiagnostic.getData().get(0);
                    LinkedHashSet<EObject> staleAnnotations = new LinkedHashSet<EObject>();
                    TreeIterator it = resource.getAllContents();
                    while (it.hasNext()) {
                        Annotation annotation;
                        String source;
                        EObject eObject = (EObject)it.next();
                        if (!(eObject instanceof Annotation) || (source = (annotation = (Annotation)eObject).getSource()) == null || !source.startsWith(MavenEditor.ANNOTATION_SOURCE_PROBLEM_PREFIX)) continue;
                        staleAnnotations.add(eObject);
                    }
                    for (EObject eObject : staleAnnotations) {
                        EObject eContainer = eObject.eContainer();
                        eContainer.eSetDeliver(false);
                        EcoreUtil.delete((EObject)eObject, (boolean)false);
                        eContainer.eSetDeliver(true);
                    }
                    for (Diagnostic grandChildDiagnostic : childDiagnostic.getChildren()) {
                        ModelElement modelElement;
                        Object object;
                        List data = grandChildDiagnostic.getData();
                        if (data.isEmpty() || !((object = data.get(0)) instanceof ModelElement) || !this.isTransientlyContained((EObject)(modelElement = (ModelElement)object))) continue;
                        try {
                            modelElement.eSetDeliver(false);
                            String message = grandChildDiagnostic.getMessage();
                            Annotation annotation = BaseFactory.eINSTANCE.createAnnotation();
                            annotation.setSource(MavenEditor.ANNOTATION_SOURCE_PROBLEM_PREFIX + URI.encodeSegment((String)DiagnosticDecorator.strip((String)message), (boolean)false));
                            modelElement.getAnnotations().add((Object)annotation);
                            MavenValidator.ElementEdit elementEdit = MavenValidator.ElementEdit.of((Diagnostic)grandChildDiagnostic);
                            if (elementEdit == null) continue;
                            Annotation elementEditAnnotation = BaseFactory.eINSTANCE.createAnnotation();
                            elementEditAnnotation.setSource(MavenEditor.ANNOTATION_SOURCE_PROBLEM_PREFIX + URI.encodeSegment((String)("ElementEdit: " + elementEdit.element().getLocalName() + " -> " + elementEdit.value()), (boolean)false));
                            modelElement.getAnnotations().add((Object)elementEditAnnotation);
                            MavenEditor.associatedElementEdit((EObject)annotation, elementEdit);
                            MavenEditor.associatedElementEdit((EObject)elementEditAnnotation, elementEdit);
                        }
                        finally {
                            modelElement.eSetDeliver(true);
                        }
                    }
                }
            }

            protected boolean isTransientlyContained(EObject eObject) {
                EObject container = eObject;
                while (container != null) {
                    EStructuralFeature eContainingFeature = eObject.eContainingFeature();
                    if (eContainingFeature.isTransient()) {
                        return true;
                    }
                    container = container.eContainer();
                }
                return false;
            }

            protected void handleResourceDiagnostics(List<Resource> resources) {
            }
        });
        this.createModel();
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            final Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.toolTipSupport = new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.selectionViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer));
            this.selectionViewer.setUseHashlookup(true);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, MavenEditor.getString("_UI_SelectionPage_label"));
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!MavenEditor.this.getContainer().isDisposed()) {
                        MavenEditor.this.setActivePage(0);
                    }
                }
            });
            tree.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent event) {
                    if (event.button == 1) {
                        try {
                            Path location;
                            Element element = this.getElement();
                            if (element != null && (location = POMXMLUtil.getLocation((Element)element)) != null) {
                                MavenEditor.this.openEditor(location, element);
                                return;
                            }
                            MavenEditor.this.getEditorSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
                        }
                        catch (PartInitException exception) {
                            MavenEditorPlugin.INSTANCE.log((Object)exception);
                        }
                    }
                }

                public void mouseUp(MouseEvent e) {
                    if ((e.stateMask & SWT.MOD3) != 0) {
                        try {
                            MavenEditor.this.showHoverLinks = true;
                            Event exitEvent = new Event();
                            exitEvent.display = e.display;
                            exitEvent.x = -1;
                            exitEvent.y = -1;
                            tree.notifyListeners(7, exitEvent);
                            ReflectUtil.setValue((String)"currentCell", (Object)MavenEditor.this.toolTipSupport, null);
                            Event event = new Event();
                            event.display = e.display;
                            event.x = e.x;
                            event.y = e.y;
                            tree.notifyListeners(32, event);
                        }
                        finally {
                            MavenEditor.this.showHoverLinks = false;
                        }
                    }
                }

                private Element getElement() {
                    Annotation annotation;
                    MavenValidator.ElementEdit elementEdit;
                    Object element = AdapterFactoryEditingDomain.unwrap((Object)MavenEditor.this.selectionViewer.getStructuredSelection().getFirstElement());
                    if (element instanceof Project) {
                        Project project = (Project)element;
                        return project.getElement(POMXMLUtil.xpath((String[])new String[]{"artifactId"}));
                    }
                    if (element instanceof DOMElement) {
                        DOMElement domElement = (DOMElement)element;
                        return domElement.getElement();
                    }
                    if (element instanceof Annotation && (elementEdit = MavenEditor.getAssociatedElementEdit((EObject)(annotation = (Annotation)element))) != null) {
                        return elementEdit.element();
                    }
                    return null;
                }
            });
            tree.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyReleased(KeyEvent e) {
                    if (e.keyCode == 13) {
                        UIUtil.toggleExpandOneLevel((Tree)tree, (e.stateMask == 0 ? 1 : 0) != 0, (int)2000);
                    }
                }
            });
            this.selectionViewer.getControl().addFocusListener(new FocusListener(){
                private IBaseLabelProvider originalSelectionViewerLabelProvider;
                {
                    this.originalSelectionViewerLabelProvider = MavenEditor.this.selectionViewer.getLabelProvider();
                }

                public void focusLost(FocusEvent e) {
                }

                public void focusGained(FocusEvent e) {
                    IBaseLabelProvider labelProvider = MavenEditor.this.selectionViewer.getLabelProvider();
                    if (labelProvider != this.originalSelectionViewerLabelProvider) {
                        this.originalSelectionViewerLabelProvider = MavenEditor.this.createLabelProvider();
                        MavenEditor.this.selectionViewer.setLabelProvider(this.originalSelectionViewerLabelProvider);
                    }
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    MavenEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MavenEditor.this.updateProblemIndication();
            }
        });
    }

    private ILabelProvider createLabelProvider() {
        return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DecoratingColumLabelProvider.StyledLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)this.adapterFactory, (Viewer)this.selectionViewer), (ILabelDecorator)new DiagnosticDecorator.Styled((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer, MavenEditorPlugin.getPlugin().getDialogSettings()){
            private ILabelProvider labelProvider;
            Function<Object, String> featureTextProvider;
            {
                MavenEditor.this.liveValidateScheduler = arg_0 -> ((DiagnosticDecorator.LiveValidator)this.getLiveValidator()).scheduleValidation(arg_0);
                this.featureTextProvider = (new RealmItemProvider((AdapterFactory)new MavenItemProviderAdapterFactory()){

                    protected String getFeatureText(Object feature) {
                        return super.getFeatureText(feature);
                    }
                })::getFeatureText;
            }

            protected ILabelProvider getLabelProvider() {
                if (this.labelProvider == null) {
                    this.labelProvider = (ILabelProvider)this.viewer.getLabelProvider();
                    if (this.labelProvider instanceof IUndecoratingLabelProvider) {
                        final IUndecoratingLabelProvider undecoratingLabelProvider = (IUndecoratingLabelProvider)this.labelProvider;
                        this.labelProvider = new ILabelProvider(){

                            public void removeListener(ILabelProviderListener listener) {
                                undecoratingLabelProvider.removeListener(listener);
                            }

                            public boolean isLabelProperty(Object element, String property) {
                                return undecoratingLabelProvider.isLabelProperty(element, property);
                            }

                            public void dispose() {
                                undecoratingLabelProvider.dispose();
                            }

                            public void addListener(ILabelProviderListener listener) {
                                undecoratingLabelProvider.addListener(listener);
                            }

                            public String getText(Object element) {
                                return undecoratingLabelProvider.getUndecoratedText(element);
                            }

                            public Image getImage(Object element) {
                                return undecoratingLabelProvider.getUndecoratedImage(element);
                            }
                        };
                    }
                }
                return this.labelProvider;
            }

            public String getToolTipText(Object element) {
                if (MavenEditor.this.showHoverLinks) {
                    Object unwrappedElement = AdapterFactoryEditingDomain.unwrap((Object)element);
                    if (element != unwrappedElement && unwrappedElement instanceof EObject) {
                        EObject eObject = (EObject)unwrappedElement;
                        return this.process(this.buildReferences(this.build(new StringBuilder(), eObject), eObject).toString());
                    }
                    if (element instanceof EObject) {
                        EObject eObject = (EObject)element;
                        return this.process(this.buildReferences(new StringBuilder(), eObject).toString());
                    }
                }
                return this.process(super.getToolTipText(element));
            }

            protected BasicDiagnostic decorate(Map<Object, BasicDiagnostic> objects, ITreeContentProvider treeContentProvider, Set<Object> visited, Object object, List<Integer> path) {
                ReferenceGroup referenceGroup;
                if (object instanceof ReferenceGroup && !(referenceGroup = (ReferenceGroup)object).getFeature().isContainment()) {
                    return null;
                }
                return super.decorate(objects, treeContentProvider, visited, object, path);
            }

            private StringBuilder buildReferences(StringBuilder result, EObject eObject) {
                EList eCrossReferences = eObject.eCrossReferences();
                if (!eCrossReferences.isEmpty()) {
                    for (EObject eCrossReference : eCrossReferences) {
                        this.build(result, eCrossReference);
                    }
                }
                return result;
            }

            private StringBuilder build(StringBuilder result, EObject eObject) {
                result.append("<div style='white-space: nowrap;'>");
                int i = 0;
                while (i <= 0) {
                    result.append("&#160;&#160;&#160;");
                    ++i;
                }
                ILabelProvider labelProvider = this.getLabelProvider();
                String text = 21.escapeContent((String)labelProvider.getText((Object)eObject));
                Image image = labelProvider.getImage((Object)eObject);
                result.append(this.featureTextProvider.apply(eObject.eContainmentFeature()));
                result.append("<img src='");
                result.append(ImageURIRegistry.INSTANCE.getImageURI(image));
                result.append("'/> <a href=\"");
                result.append(EcoreUtil.getURI((EObject)eObject));
                result.append("\">");
                result.append(text);
                result.append("</a></div>\n");
                return result;
            }

            private String process(String result) {
                if (result != null) {
                    try {
                        AbstractHoverInformationControlManager hoverInformationControlManager = (AbstractHoverInformationControlManager)ReflectUtil.getValue((String)"hoverInformationControlManager", (Object)MavenEditor.this.toolTipSupport);
                        Point size = UIUtil.caclcuateSize((String)result);
                        hoverInformationControlManager.setSizeConstraints(size.x, Math.max(3, size.y * 4 / 3), true, false);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return result;
            }
        }));
    }

    protected void hideTabs() {
        if (this.getPageCount() <= 1) {
            this.setPageText(0, "");
            if (this.getContainer() instanceof CTabFolder) {
                Point point = this.getContainer().getSize();
                Rectangle clientArea = this.getContainer().getClientArea();
                this.getContainer().setSize(point.x, 2 * point.y - clientArea.height - clientArea.y);
            }
        }
    }

    protected void showTabs() {
        if (this.getPageCount() > 1) {
            this.setPageText(0, MavenEditor.getString("_UI_SelectionPage_label"));
            if (this.getContainer() instanceof CTabFolder) {
                Point point = this.getContainer().getSize();
                Rectangle clientArea = this.getContainer().getClientArea();
                this.getContainer().setSize(point.x, clientArea.height + clientArea.y);
            }
        }
    }

    protected void pageChange(int pageIndex) {
        super.pageChange(pageIndex);
        if (this.contentOutlinePage != null) {
            this.handleContentOutlineSelection(this.contentOutlinePage.getSelection());
        }
    }

    public <T> T getAdapter(Class<T> key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.showOutlineView() ? (T)key.cast(this.getContentOutlinePage()) : null;
        }
        if (key.equals(IPropertySheetPage.class)) {
            return key.cast(this.getPropertySheetPage());
        }
        if (key.equals(IGotoMarker.class)) {
            return key.cast((Object)this);
        }
        if (key.equals(IFindReplaceTarget.class)) {
            return (T)FindAndReplaceTarget.getAdapter(key, (IWorkbenchPart)this, (AbstractUIPlugin)MavenEditorPlugin.getPlugin());
        }
        return (T)super.getAdapter(key);
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    MavenEditor.this.contentOutlineViewer = this.getTreeViewer();
                    MavenEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    MavenEditor.this.contentOutlineViewer.setUseHashlookup(true);
                    MavenEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)MavenEditor.this.adapterFactory));
                    MavenEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DecoratingColumLabelProvider.StyledLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider.StyledLabelProvider((AdapterFactory)MavenEditor.this.adapterFactory, (Viewer)MavenEditor.this.contentOutlineViewer), (ILabelDecorator)new DiagnosticDecorator.Styled((EditingDomain)MavenEditor.this.editingDomain, (StructuredViewer)MavenEditor.this.contentOutlineViewer, MavenEditorPlugin.getPlugin().getDialogSettings()))));
                    MavenEditor.this.contentOutlineViewer.setInput((Object)MavenEditor.this.editingDomain.getResourceSet());
                    new ColumnViewerInformationControlToolTipSupport((ColumnViewer)MavenEditor.this.contentOutlineViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener((EditingDomain)MavenEditor.this.editingDomain, (StructuredViewer)MavenEditor.this.contentOutlineViewer));
                    MavenEditor.this.createContextMenuFor((StructuredViewer)MavenEditor.this.contentOutlineViewer);
                    if (!MavenEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        MavenEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(MavenEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    MavenEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    MavenEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    MavenEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain, ExtendedPropertySheetPage.Decoration.LIVE, MavenEditorPlugin.getPlugin().getDialogSettings(), 0, true){

            public void setSelectionToViewer(List<?> selection) {
                MavenEditor.this.setSelectionToViewer(selection);
                MavenEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                MavenEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add((PropertySheetPage)propertySheetPage);
        return propertySheetPage;
    }

    public void handleContentOutlineSelection(ISelection selection) {
        Iterator selectedElements;
        if (this.selectionViewer != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (selectedElements = ((IStructuredSelection)selection).iterator()).hasNext()) {
            Object selectedElement = selectedElements.next();
            ArrayList selectionList = new ArrayList();
            selectionList.add(selectedElement);
            while (selectedElements.hasNext()) {
                selectionList.add(selectedElements.next());
            }
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(selectionList));
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.editingDomain.getCommandStack()).isSaveNeeded();
    }

    public void doRevert() {
        DiagnosticDecorator.cancel((EditingDomain)this.editingDomain);
        ResourceSet resourceSet = this.editingDomain.getResourceSet();
        EList resources = resourceSet.getResources();
        ArrayList<Resource> unloadedResources = new ArrayList<Resource>();
        this.updateProblemIndication = false;
        int i = 0;
        while (i < resources.size()) {
            Resource resource = (Resource)resources.get(i);
            if (resource.isLoaded()) {
                resource.unload();
                unloadedResources.add(resource);
            }
            ++i;
        }
        this.resourceToDiagnosticMap.clear();
        for (Resource resource : unloadedResources) {
            try {
                resource.load(resourceSet.getLoadOptions());
            }
            catch (IOException exception) {
                if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
            }
        }
        this.editingDomain.getCommandStack().flush();
        if (AdapterFactoryEditingDomain.isStale((Object)this.editorSelection)) {
            this.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                EList resources = MavenEditor.this.editingDomain.getResourceSet().getResources();
                int i = 0;
                while (i < resources.size()) {
                    Resource resource = (Resource)resources.get(i);
                    if ((first || !resource.getContents().isEmpty() || MavenEditor.this.isPersisted(resource)) && !MavenEditor.this.editingDomain.isReadOnly(resource)) {
                        try {
                            long timeStamp = resource.getTimeStamp();
                            resource.save(saveOptions);
                            if (resource.getTimeStamp() != timeStamp) {
                                MavenEditor.this.savedResources.add(resource);
                            }
                        }
                        catch (Exception exception) {
                            MavenEditor.this.resourceToDiagnosticMap.put(resource, MavenEditor.this.analyzeResourceProblems(resource, exception));
                        }
                        first = false;
                    }
                    ++i;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            MavenEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), (IEditorInput)new FileEditorInput(file));
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    public void gotoMarker(IMarker marker) {
        List targetObjects = this.markerHelper.getTargetObjects((Object)this.editingDomain, marker);
        if (!targetObjects.isEmpty()) {
            this.setSelectionToViewer(targetObjects);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void setFocus() {
        this.getControl(this.getActivePage()).setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection selection) {
        this.editorSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        this.setStatusLineManager(selection);
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager;
        IStatusLineManager iStatusLineManager = statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(MavenEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(MavenEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        statusLineManager.setMessage(MavenEditor.getString("_UI_MultiObjectSelected", Integer.toString(collection.size())));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return MavenEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return MavenEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void disposeGen() {
        this.updateProblemIndication = false;
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.getSite().getPage().removePartListener(this.partListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        for (PropertySheetPage propertySheetPage : this.propertySheetPages) {
            propertySheetPage.dispose();
        }
        if (this.contentOutlinePage != null) {
            this.contentOutlinePage.dispose();
        }
        super.dispose();
    }

    public void dispose() {
        this.linkListener.dispose();
        this.disposeGen();
    }

    protected boolean showOutlineView() {
        return false;
    }

    protected void handleOtherPartActivate(IWorkbenchPart part) {
        String id = part.getSite().getId();
        if (LINK_WITH_VIEWER_IDS.contains(id)) {
            ISelectionProvider selectionProvider = (ISelectionProvider)part.getAdapter(ISelectionProvider.class);
            if (selectionProvider != null) {
                this.linkListener.listenTo(selectionProvider);
            } else {
                try {
                    TreeViewer treeViewer = (TreeViewer)ReflectUtil.invokeMethod((String)"getCommonViewer", (Object)part);
                    this.linkListener.listenTo((ISelectionProvider)treeViewer);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    private static void associatedElementEdit(EObject eObject, MavenValidator.ElementEdit elementEdit) {
        eObject.eAdapters().add((Object)new ElementEditAdapter(elementEdit));
    }

    private static MavenValidator.ElementEdit getAssociatedElementEdit(EObject eObject) {
        ElementEditAdapter adapter = (ElementEditAdapter)EcoreUtil.getAdapter((List)eObject.eAdapters(), MavenValidator.ElementEdit.class);
        return adapter == null ? null : adapter.elementEdit;
    }

    private static class ElementEditAdapter
    extends AdapterImpl {
        public MavenValidator.ElementEdit elementEdit;

        public ElementEditAdapter(MavenValidator.ElementEdit elementEdit) {
            this.elementEdit = elementEdit;
        }

        public boolean isAdapterForType(Object type) {
            return type == MavenValidator.ElementEdit.class;
        }
    }

    private class LinkListener
    implements ISelectionChangedListener {
        private final Set<ISelectionProvider> selectionProviders = new HashSet<ISelectionProvider>();

        private LinkListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Realm realm;
            Project projectIgnoreVersion;
            Object firstElement;
            Path path;
            Project mavenProject;
            IStructuredSelection selection = event.getStructuredSelection();
            if (selection != null && (mavenProject = this.handleLocation(path = this.getPath(firstElement = selection.getFirstElement()))) != null && (projectIgnoreVersion = (realm = MavenEditor.this.getRealm()).getProjectIgnoreVersion((Coordinate)mavenProject)) != null) {
                MavenEditor.this.setSelectionToViewer(List.of(projectIgnoreVersion));
            }
        }

        public Path getPath(Object element) {
            block9: {
                if (element instanceof IResource) {
                    IResource resource = (IResource)element;
                    IPath location = resource.getLocation();
                    if (location != null) {
                        return location.toPath();
                    }
                } else {
                    try {
                        IPath location;
                        IPath path = (IPath)ReflectUtil.invokeMethod((String)"getPath", (Object)element);
                        Path fileSystemPath = path.toPath();
                        if (Files.exists(fileSystemPath, new LinkOption[0])) {
                            return fileSystemPath;
                        }
                        IResource resource = EcorePlugin.getWorkspaceRoot().findMember(path);
                        if (resource != null && (location = resource.getLocation()) != null) {
                            return location.toPath();
                        }
                    }
                    catch (Exception path) {
                        // empty catch block
                    }
                    try {
                        return this.getPath(ReflectUtil.invokeMethod((String)"getProject", (Object)element));
                    }
                    catch (Exception path) {
                        IAdaptable adaptable;
                        IWorkbenchAdapter workbenchAdapter;
                        if (!(element instanceof IAdaptable) || (workbenchAdapter = (IWorkbenchAdapter)(adaptable = (IAdaptable)element).getAdapter(IWorkbenchAdapter.class)) == null) break block9;
                        Object parent = workbenchAdapter.getParent(element);
                        return this.getPath(parent);
                    }
                }
            }
            return null;
        }

        public Project handleLocation(Path path) {
            Path pom;
            if (path == null) {
                return null;
            }
            if (Files.isRegularFile(path, new LinkOption[0])) {
                String fileName = path.getFileName().toString();
                if (fileName.endsWith(".jar")) {
                    Project result = this.handleLocation(path.resolve("../" + fileName.replaceAll(".jar$", ".pom")));
                    if (result != null) {
                        return result;
                    }
                } else if (fileName.equals("pom.xml") || fileName.endsWith(".pom")) {
                    return this.getMavenProject(path);
                }
            } else if (Files.isDirectory(path, new LinkOption[0]) && Files.isRegularFile(pom = path.resolve("pom.xml"), new LinkOption[0])) {
                return this.handleLocation(pom);
            }
            return this.handleLocation(path.getParent());
        }

        public Project getMavenProject(Path path) {
            try {
                Document document = POMXMLUtil.parseDocument((Path)path);
                Project mavenProject = MavenFactory.eINSTANCE.createProject();
                mavenProject.setLocation(path.toString());
                Element pom = document.getDocumentElement();
                mavenProject.setElement(pom);
                return mavenProject;
            }
            catch (IOException | SAXException ex) {
                return null;
            }
        }

        public void listenTo(ISelectionProvider selectionProvider) {
            if (this.selectionProviders.add(selectionProvider)) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        void dispose() {
            for (ISelectionProvider selectionProvider : this.selectionProviders) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }

    private static class NonDirtyingCompoundCommand
    extends CompoundCommand
    implements AbstractCommand.NonDirtying {
        public NonDirtyingCompoundCommand() {
            super(0);
        }

        public static CompoundCommand create(Command command) {
            NonDirtyingCompoundCommand result = command instanceof AbstractCommand.NonDirtying ? new NonDirtyingCompoundCommand() : new CompoundCommand(0);
            result.append(command);
            return result;
        }
    }

    public class ReverseAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public ReverseAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public Object[] getChildren(Object object) {
            Object parent = super.getParent(object);
            return (parent == null ? Collections.EMPTY_SET : Collections.singleton(parent)).toArray();
        }

        public boolean hasChildren(Object object) {
            Object parent = super.getParent(object);
            return parent != null;
        }

        public Object getParent(Object object) {
            return null;
        }
    }
}

