/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Widget;

public class WidgetSpy {
    public static boolean isEnabled;
    private static final WidgetSpy instance;
    private WidgetTracker widgetTracker;

    static {
        instance = new WidgetSpy();
    }

    private WidgetSpy() {
    }

    public static WidgetSpy getInstance() {
        return instance;
    }

    public void setWidgetTracker(WidgetTracker tracker) {
        isEnabled = tracker != null;
        this.widgetTracker = tracker;
    }

    public void widgetCreated(Widget widget) {
        if (this.widgetTracker != null) {
            this.widgetTracker.widgetCreated(widget);
        }
    }

    public void widgetDisposed(Widget widget) {
        if (this.widgetTracker != null) {
            this.widgetTracker.widgetDisposed(widget);
        }
    }

    public static class NonDisposedWidgetTracker
    implements WidgetTracker {
        private final Map<Widget, Error> nonDisposedWidgets = new LinkedHashMap<Widget, Error>();
        private final Set<Class<? extends Widget>> trackedTypes = new HashSet<Class<? extends Widget>>();

        @Override
        public void widgetCreated(Widget widget) {
            boolean isTracked = this.isTracked(widget);
            if (isTracked) {
                Error creationException = new Error("Created widget of type: " + widget.getClass().getSimpleName());
                this.nonDisposedWidgets.put(widget, creationException);
            }
        }

        @Override
        public void widgetDisposed(Widget widget) {
            boolean isTracked = this.isTracked(widget);
            if (isTracked) {
                this.nonDisposedWidgets.remove(widget);
            }
        }

        public Map<Widget, Error> getNonDisposedWidgets() {
            return Collections.unmodifiableMap(this.nonDisposedWidgets);
        }

        public void startTracking() {
            this.clearNonDisposedWidgets();
            WidgetSpy.getInstance().setWidgetTracker(this);
        }

        private void clearNonDisposedWidgets() {
            this.nonDisposedWidgets.clear();
        }

        public void stopTracking() {
            WidgetSpy.getInstance().setWidgetTracker(null);
        }

        public void setTrackingEnabled(boolean enabled) {
            if (enabled) {
                this.startTracking();
            } else {
                this.stopTracking();
            }
        }

        public void setTrackedTypes(List<Class<? extends Widget>> types) {
            this.trackedTypes.clear();
            this.trackedTypes.addAll(types);
        }

        private boolean isTracked(Widget widget) {
            boolean isTrackingAllTypes = this.trackedTypes.isEmpty();
            if (isTrackingAllTypes) {
                return true;
            }
            if (widget != null) {
                Class<?> widgetType = widget.getClass();
                if (this.trackedTypes.contains(widgetType)) {
                    return true;
                }
                for (Class<? extends Widget> filteredType : this.trackedTypes) {
                    if (!filteredType.isAssignableFrom(widgetType)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static interface WidgetTracker {
        default public void widgetCreated(Widget widget) {
        }

        default public void widgetDisposed(Widget widget) {
        }
    }
}

