/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.publisher;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.publisher.Activator;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.publisher.AbstractAdvice;
import org.eclipse.equinox.p2.publisher.AdviceFileParser;
import org.eclipse.equinox.p2.publisher.actions.IAdditionalInstallableUnitAdvice;
import org.eclipse.equinox.p2.publisher.actions.ICapabilityAdvice;
import org.eclipse.equinox.p2.publisher.actions.IPropertyAdvice;
import org.eclipse.equinox.p2.publisher.actions.ITouchpointAdvice;
import org.eclipse.equinox.p2.publisher.actions.IUpdateDescriptorAdvice;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;

public class AdviceFileAdvice
extends AbstractAdvice
implements ITouchpointAdvice,
ICapabilityAdvice,
IUpdateDescriptorAdvice,
IPropertyAdvice,
IAdditionalInstallableUnitAdvice {
    public static final IPath BUNDLE_ADVICE_FILE = IPath.fromOSString((String)"META-INF/p2.inf");
    private final String id;
    private final Version version;
    private Map<String, ITouchpointInstruction> touchpointInstructions;
    private IProvidedCapability[] providedCapabilities;
    private IRequirement[] requiredCapabilities;
    private IRequirement[] metaRequiredCapabilities;
    private Map<String, String> iuProperties;
    private MetadataFactory.InstallableUnitDescription[] additionalIUs;
    private IUpdateDescriptor updateDescriptor;
    private boolean containsAdvice = false;

    public AdviceFileAdvice(String id, Version version, IPath basePath, IPath adviceFilePath) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)version);
        Assert.isNotNull((Object)basePath);
        Assert.isNotNull((Object)adviceFilePath);
        this.id = id;
        this.version = version;
        Map<String, String> advice = AdviceFileAdvice.loadAdviceMap(basePath, adviceFilePath);
        if (advice.isEmpty()) {
            return;
        }
        AdviceFileParser parser = new AdviceFileParser(id, version, advice);
        try {
            parser.parse();
        }
        catch (Exception e) {
            String message = "An error occured while parsing advice file: basePath=" + String.valueOf(basePath) + ", adviceFilePath=" + String.valueOf(adviceFilePath) + ".";
            Status status = new Status(4, Activator.ID, message, (Throwable)e);
            LogHelper.log((IStatus)status);
            return;
        }
        this.touchpointInstructions = parser.getTouchpointInstructions();
        this.providedCapabilities = parser.getProvidedCapabilities();
        this.requiredCapabilities = parser.getRequiredCapabilities();
        this.metaRequiredCapabilities = parser.getMetaRequiredCapabilities();
        this.iuProperties = parser.getProperties();
        this.additionalIUs = parser.getAdditionalInstallableUnitDescriptions();
        this.updateDescriptor = parser.getUpdateDescriptor();
        this.containsAdvice = true;
    }

    public boolean containsAdvice() {
        return this.containsAdvice;
    }

    /*
     * Loose catch block
     */
    private static Map<String, String> loadAdviceMap(IPath basePath, IPath adviceFilePath) {
        block33: {
            File location = basePath.toFile();
            if (location != null && location.exists()) {
                try {
                    if (location.isDirectory()) {
                        File adviceFile = new File(location, adviceFilePath.toString());
                        if (adviceFile.isFile()) {
                            Throwable throwable = null;
                            Object var5_12 = null;
                            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(adviceFile));){
                                return CollectionUtils.loadProperties((InputStream)stream);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        break block33;
                    }
                    if (!location.isFile()) break block33;
                    Throwable adviceFile = null;
                    Object var4_9 = null;
                    try (ZipFile jar = new ZipFile(location);){
                        Map map;
                        BufferedInputStream stream;
                        Throwable throwable;
                        block34: {
                            ZipEntry entry = jar.getEntry(adviceFilePath.toString());
                            if (entry == null) break block33;
                            throwable = null;
                            Object var8_20 = null;
                            stream = new BufferedInputStream(jar.getInputStream(entry));
                            map = CollectionUtils.loadProperties((InputStream)stream);
                            if (stream == null) break block34;
                            ((InputStream)stream).close();
                        }
                        return map;
                        {
                            catch (Throwable throwable3) {
                                try {
                                    if (stream != null) {
                                        ((InputStream)stream).close();
                                    }
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (adviceFile == null) {
                            adviceFile = throwable;
                        } else if (adviceFile != throwable) {
                            adviceFile.addSuppressed(throwable);
                        }
                        throw adviceFile;
                    }
                }
                catch (IOException e) {
                    String message = "An error occured while reading advice file: basePath=" + String.valueOf(basePath) + ", adviceFilePath=" + String.valueOf(adviceFilePath) + ".";
                    Status status = new Status(4, Activator.ID, message, (Throwable)e);
                    LogHelper.log((IStatus)status);
                }
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isApplicable(String configSpec, boolean includeDefault, String candidateId, Version candidateVersion) {
        return this.id.equals(candidateId) && this.version.equals(candidateVersion);
    }

    @Override
    public ITouchpointData getTouchpointData(ITouchpointData existing) {
        return MetadataFactory.mergeTouchpointData((ITouchpointData)existing, this.touchpointInstructions);
    }

    @Override
    public IProvidedCapability[] getProvidedCapabilities(MetadataFactory.InstallableUnitDescription iu) {
        return this.providedCapabilities;
    }

    @Override
    public IRequirement[] getRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
        return this.requiredCapabilities;
    }

    @Override
    public IRequirement[] getMetaRequiredCapabilities(MetadataFactory.InstallableUnitDescription iu) {
        return this.metaRequiredCapabilities;
    }

    @Override
    public MetadataFactory.InstallableUnitDescription[] getAdditionalInstallableUnitDescriptions(IInstallableUnit iu) {
        return this.additionalIUs;
    }

    @Override
    public IUpdateDescriptor getUpdateDescriptor(MetadataFactory.InstallableUnitDescription iu) {
        return this.updateDescriptor;
    }

    @Override
    public Map<String, String> getArtifactProperties(IInstallableUnit iu, IArtifactDescriptor descriptor) {
        return null;
    }

    @Override
    public Map<String, String> getInstallableUnitProperties(MetadataFactory.InstallableUnitDescription iu) {
        return this.iuProperties;
    }
}

