/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.addons.minmax;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.internal.workbench.swt.AnimationEngine;
import org.eclipse.e4.ui.internal.workbench.swt.AnimationFeedbackBase;
import org.eclipse.e4.ui.internal.workbench.swt.FaderAnimationFeedback;
import org.eclipse.e4.ui.model.application.MAddon;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.addons.minmax.TrimStack;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;

public class MinMaxAddon {
    private static final String ID_EDITOR_AREA = "org.eclipse.ui.editorss";
    private static final String GLOBAL_CACHE_ID = "Global";
    static String ID_SUFFIX = "(minimized)";
    private static String MINIMIZED = "Minimized";
    private static String MAXIMIZED = "Maximized";
    private static String MINIMIZED_BY_ZOOM = "MinimizedByZoom";
    @Inject
    IEventBroker eventBroker;
    @Inject
    EModelService modelService;
    @Inject
    private IEclipseContext context;
    @Inject
    private EPartService partService;
    private boolean ignoreTagChanges = false;
    @Inject
    MAddon minMaxAddon;
    private CTabFolder2Adapter CTFButtonListener = new CTabFolder2Adapter(){

        private MUIElement getElementToChange(CTabFolderEvent event) {
            CTabFolder ctf = (CTabFolder)event.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MArea) {
                return element.getCurSharedRef();
            }
            MElementContainer parentElement = element.getParent();
            while (parentElement != null && !(parentElement instanceof MArea)) {
                parentElement = parentElement.getParent();
            }
            return parentElement != null ? parentElement.getCurSharedRef() : element;
        }

        public void maximize(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MAXIMIZED);
        }

        public void minimize(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), MINIMIZED);
        }

        public void restore(CTabFolderEvent event) {
            MinMaxAddon.this.setState(this.getElementToChange(event), null);
        }
    };
    private MouseListener CTFDblClickListener = new MouseListener(){

        public void mouseUp(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            MWindow window;
            CTabFolder ctf = (CTabFolder)e.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MPartStack && ctf.getItemCount() == 0 && (window = MinMaxAddon.this.modelService.getTopLevelWindowFor(element)) != null) {
                List tcList = MinMaxAddon.this.modelService.findElements((MUIElement)window, null, MToolControl.class, null);
                for (MToolControl tc : tcList) {
                    if (!(tc.getObject() instanceof TrimStack)) continue;
                    TrimStack ts = (TrimStack)tc.getObject();
                    ts.showStack(false);
                }
            }
        }

        private MUIElement getElementToChange(MouseEvent event) {
            CTabFolder ctf = (CTabFolder)event.widget;
            MUIElement element = (MUIElement)ctf.getData("modelElement");
            if (element instanceof MArea) {
                return element.getCurSharedRef();
            }
            MElementContainer parentElement = element.getParent();
            while (parentElement != null && !(parentElement instanceof MArea)) {
                parentElement = parentElement.getParent();
            }
            return parentElement != null ? parentElement.getCurSharedRef() : element;
        }

        public void mouseDoubleClick(MouseEvent e) {
            if (e.button == 1) {
                CTabFolder ctf = (CTabFolder)e.widget;
                if (!ctf.getMaximizeVisible()) {
                    return;
                }
                if (e.y > ctf.getTabHeight()) {
                    return;
                }
                MUIElement elementToChange = this.getElementToChange(e);
                if (!elementToChange.getTags().contains(MAXIMIZED)) {
                    MinMaxAddon.this.setState(elementToChange, MAXIMIZED);
                } else {
                    MinMaxAddon.this.setState(elementToChange, null);
                }
            }
        }
    };

    private void setState(MUIElement element, String state) {
        if (MINIMIZED.equals(state)) {
            element.getTags().remove(MAXIMIZED);
            element.getTags().add(MINIMIZED);
        } else if (MAXIMIZED.equals(state)) {
            element.getTags().remove(MINIMIZED);
            element.getTags().add(MAXIMIZED);
        } else {
            element.getTags().remove(MINIMIZED);
            element.getTags().remove(MAXIMIZED);
        }
    }

    @Inject
    @Optional
    private void subscribeTopicWidget(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/UIElement/widget/*") Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (!(changedElement instanceof MPartStack) && !(changedElement instanceof MArea)) {
            return;
        }
        CTabFolder ctf = this.getCTFFor(changedElement);
        if (ctf == null) {
            return;
        }
        MUIElement stateElement = changedElement;
        if (changedElement instanceof MPartStack) {
            MPartStack stack = (MPartStack)changedElement;
            MArea area = this.getAreaFor(stack);
            if (area != null && !(area.getWidget() instanceof CTabFolder)) {
                stateElement = area.getCurSharedRef();
            }
        } else if (changedElement instanceof MArea) {
            stateElement = changedElement.getCurSharedRef();
        }
        this.adjustCTFButtons(stateElement);
        ctf.removeCTabFolder2Listener((CTabFolder2Listener)this.CTFButtonListener);
        ctf.addCTabFolder2Listener((CTabFolder2Listener)this.CTFButtonListener);
        ctf.removeMouseListener(this.CTFDblClickListener);
        ctf.addMouseListener(this.CTFDblClickListener);
    }

    @Inject
    @Optional
    private void subscribeTopicChildren(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/children/*") Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        MWindow window = this.modelService.getTopLevelWindowFor(changedElement);
        if (!(changedElement instanceof MPerspectiveStack) || window == null || !(window instanceof MTrimmedWindow)) {
            return;
        }
        if (UIEvents.isREMOVE((Event)event)) {
            for (Object removedElement : UIEvents.asIterable((Event)event, (String)"OldValue")) {
                MUIElement removed = (MUIElement)removedElement;
                String perspectiveId = removed.getElementId();
                MTrimBar bar = this.modelService.getTrim((MTrimmedWindow)window, SideValue.TOP);
                ArrayList<MToolControl> toRemove = new ArrayList<MToolControl>();
                for (MUIElement child : bar.getChildren()) {
                    String trimElementId = child.getElementId();
                    if (!(child instanceof MToolControl) || !trimElementId.contains(perspectiveId)) continue;
                    toRemove.add((MToolControl)child);
                }
                for (MToolControl minStack : toRemove) {
                    minStack.setToBeRendered(false);
                    bar.getChildren().remove(minStack);
                }
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTopicSelectedElement(@UIEventTopic(value="org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*") Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (!(changedElement instanceof MPerspectiveStack)) {
            return;
        }
        MPerspectiveStack ps = (MPerspectiveStack)changedElement;
        MWindow window = this.modelService.getTopLevelWindowFor((MUIElement)ps);
        List tcList = this.modelService.findElements((MUIElement)window, null, MToolControl.class, null);
        MPerspective curPersp = (MPerspective)ps.getSelectedElement();
        if (curPersp != null) {
            ArrayList<String> tags = new ArrayList<String>();
            tags.add("Minimized");
            List minimizedElements = this.modelService.findElements((MUIElement)curPersp, null, MUIElement.class, tags);
            String perspId = String.valueOf('(') + curPersp.getElementId() + ')';
            for (MUIElement ele : minimizedElements) {
                String fullId = String.valueOf(ele.getElementId()) + perspId;
                for (MToolControl tc : tcList) {
                    if (!fullId.equals(tc.getElementId())) continue;
                    tc.setToBeRendered(true);
                }
            }
            MPlaceholder eaPlaceholder = (MPlaceholder)this.modelService.find(ID_EDITOR_AREA, (MUIElement)curPersp);
            this.adjustCTFButtons((MUIElement)eaPlaceholder);
        }
        if (event.getProperty("OldValue") instanceof MPerspective) {
            MPerspective oldPersp = (MPerspective)event.getProperty("OldValue");
            String perspId = String.valueOf('(') + oldPersp.getElementId() + ')';
            for (MToolControl tc : tcList) {
                if (!(tc.getObject() instanceof TrimStack) || !tc.getElementId().contains(perspId)) continue;
                TrimStack ts = (TrimStack)tc.getObject();
                ts.showStack(false);
                tc.setToBeRendered(false);
            }
        }
        final Shell winShell = (Shell)window.getWidget();
        winShell.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!winShell.isDisposed()) {
                    winShell.layout(true, true);
                }
            }
        });
    }

    @Inject
    @Optional
    private void subscribeTopicTagsChanged(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/tags/*") Event event) {
        if (this.ignoreTagChanges) {
            return;
        }
        Object changedObj = event.getProperty("ChangedElement");
        if (!(changedObj instanceof MUIElement)) {
            return;
        }
        MUIElement changedElement = (MUIElement)changedObj;
        if (UIEvents.isADD((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"NewValue", (Object)MINIMIZED)) {
                this.minimize(changedElement);
            } else if (UIEvents.contains((Event)event, (String)"NewValue", (Object)MAXIMIZED)) {
                this.maximize(changedElement);
            }
        } else if (UIEvents.isREMOVE((Event)event)) {
            if (UIEvents.contains((Event)event, (String)"OldValue", (Object)MINIMIZED)) {
                this.restore(changedElement);
            } else if (UIEvents.contains((Event)event, (String)"OldValue", (Object)MAXIMIZED)) {
                this.unzoom(changedElement);
            }
        }
    }

    @Inject
    @Optional
    private void subscribeTopicElementId(@UIEventTopic(value="org/eclipse/e4/ui/model/application/ApplicationElement/elementId/*") Event event) {
        Object changedObject = event.getProperty("ChangedElement");
        if (!(changedObject instanceof MPerspective)) {
            return;
        }
        MPerspective perspective = (MPerspective)changedObject;
        String newID = (String)event.getProperty("NewValue");
        String oldID = (String)event.getProperty("OldValue");
        newID = String.valueOf('(') + newID + ')';
        oldID = String.valueOf('(') + oldID + ')';
        MWindow perspWin = this.modelService.getTopLevelWindowFor((MUIElement)perspective);
        if (perspWin == null) {
            return;
        }
        List trimStacks = this.modelService.findElements((MUIElement)perspWin, null, MToolControl.class, null);
        for (MToolControl trimStack : trimStacks) {
            if (!TrimStack.CONTRIBUTION_URI.equals(trimStack.getContributionURI())) continue;
            trimStack.setElementId(trimStack.getElementId().replace(oldID, newID));
        }
    }

    @Inject
    @Optional
    private void subscribeTopicPerspSaved(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/perpSaved") Event event) {
        MPerspective savedPersp = (MPerspective)event.getProperty("ChangedElement");
        String cache = this.getTrimCache(savedPersp);
        this.minMaxAddon.getPersistedState().put(savedPersp.getElementId(), cache);
    }

    private String getTrimCache(MPerspective savedPersp) {
        MWindow topWin = this.modelService.getTopLevelWindowFor((MUIElement)savedPersp);
        String perspIdStr = String.valueOf('(') + savedPersp.getElementId() + ')';
        String cache = this.getWinCache(topWin, perspIdStr);
        for (MWindow dw : savedPersp.getWindows()) {
            cache = String.valueOf(cache) + this.getWinCache(dw, perspIdStr);
        }
        return cache;
    }

    private String getWinCache(MWindow win, String perspIdStr) {
        String winStr = "";
        List stackList = this.modelService.findElements((MUIElement)win, null, MPartStack.class, null);
        for (MPartStack stack : stackList) {
            winStr = String.valueOf(winStr) + this.getStackTrimLoc(stack, perspIdStr);
        }
        return winStr;
    }

    private String getStackTrimLoc(MPartStack stack, String perspIdStr) {
        MWindow stackWin = this.modelService.getTopLevelWindowFor((MUIElement)stack);
        MUIElement tcElement = this.modelService.find(String.valueOf(stack.getElementId()) + perspIdStr, (MUIElement)stackWin);
        if (tcElement == null) {
            return "";
        }
        MTrimBar bar = (MTrimBar)tcElement.getParent();
        int sideVal = bar.getSide().getValue();
        int index = bar.getChildren().indexOf(tcElement);
        return String.valueOf(stack.getElementId()) + ' ' + sideVal + ' ' + index + "#";
    }

    @Inject
    @Optional
    private void subscribeTopicPerspReset(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/perspReset") Event event) {
        MPerspective resetPersp = (MPerspective)event.getProperty("ChangedElement");
        List minimizedElements = this.modelService.findElements((MUIElement)resetPersp, null, MUIElement.class, Arrays.asList("Minimized"));
        for (MUIElement element : minimizedElements) {
            this.createTrim(element);
        }
    }

    @Inject
    @Optional
    private void subscribeTopicPerspOpened(@UIEventTopic(value="org/eclipse/e4/ui/LifeCycle/perspOpened") Event event) {
        MPerspective openedPersp = (MPerspective)event.getProperty("ChangedElement");
        List minimizedElements = this.modelService.findElements((MUIElement)openedPersp, null, MUIElement.class, Arrays.asList("Minimized"));
        for (MUIElement element : minimizedElements) {
            this.createTrim(element);
        }
    }

    private MArea getAreaFor(MPartStack stack) {
        MElementContainer parent = stack.getParent();
        while (parent != null) {
            if (parent instanceof MArea) {
                return (MArea)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private void setCTFButtons(CTabFolder ctf, MUIElement stateElement, boolean hideButtons) {
        if (hideButtons) {
            ctf.setMinimizeVisible(false);
            ctf.setMaximizeVisible(false);
        } else if (stateElement.getTags().contains(MINIMIZED)) {
            ctf.setMinimizeVisible(false);
            ctf.setMaximizeVisible(true);
            ctf.setMaximized(true);
        } else if (stateElement.getTags().contains(MAXIMIZED)) {
            ctf.setMinimizeVisible(true);
            ctf.setMaximizeVisible(true);
            ctf.setMaximized(true);
        } else {
            ctf.setMinimizeVisible(true);
            ctf.setMaximizeVisible(true);
            ctf.setMinimized(false);
            ctf.setMaximized(false);
            ctf.layout();
        }
    }

    private void adjustCTFButtons(MUIElement element) {
        if (!(element instanceof MPartStack) && !(element instanceof MPlaceholder)) {
            return;
        }
        CTabFolder ctf = this.getCTFFor(element);
        if (ctf == null) {
            return;
        }
        if (element instanceof MPlaceholder) {
            this.setCTFButtons(ctf, element, false);
        } else {
            MArea area = this.getAreaFor((MPartStack)element);
            if (area == null) {
                this.setCTFButtons(ctf, element, false);
            }
        }
    }

    private CTabFolder getCTFFor(MUIElement element) {
        if (element instanceof MArea) {
            if (element.getWidget() instanceof CTabFolder) {
                return (CTabFolder)element.getWidget();
            }
            List stacks = this.modelService.findElements(element, null, MPartStack.class, null);
            for (MPartStack stack : stacks) {
                if (!(stack.getWidget() instanceof CTabFolder)) continue;
                return (CTabFolder)stack.getWidget();
            }
        } else {
            MPlaceholder ph;
            if (element.getWidget() instanceof CTabFolder) {
                return (CTabFolder)element.getWidget();
            }
            if (element instanceof MPlaceholder && (ph = (MPlaceholder)element).getRef() instanceof MArea) {
                return this.getCTFFor(ph.getRef());
            }
        }
        return null;
    }

    boolean isEmptyPerspectiveStack(MUIElement element) {
        if (!(element instanceof MPerspectiveStack)) {
            return false;
        }
        MPerspectiveStack ps = (MPerspectiveStack)element;
        return ps.getChildren().size() == 0;
    }

    void minimize(MUIElement element) {
        if (!element.isToBeRendered()) {
            return;
        }
        if (this.isEmptyPerspectiveStack(element)) {
            element.setVisible(false);
            return;
        }
        this.createTrim(element);
        element.setVisible(false);
        this.adjustCTFButtons(element);
        this.partService.requestActivation();
    }

    void restore(MUIElement element) {
        MWindow window = this.modelService.getTopLevelWindowFor(element);
        String trimId = String.valueOf(element.getElementId()) + this.getMinimizedElementSuffix(element);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (trimStack == null || trimStack.getObject() == null) {
            if (element instanceof MPerspectiveStack) {
                element.setVisible(true);
            }
            return;
        }
        TrimStack ts = (TrimStack)trimStack.getObject();
        ts.restoreStack();
        this.adjustCTFButtons(element);
        ArrayList<String> maximizeTag = new ArrayList<String>();
        maximizeTag.add("Maximized");
        List curMax = this.modelService.findElements((MUIElement)window, null, MUIElement.class, maximizeTag, 11);
        if (curMax.size() > 0) {
            MUIElement maxElement = (MUIElement)curMax.get(0);
            List<MUIElement> elementsLeftToRestore = this.getElementsToRestore(maxElement);
            boolean unMax = true;
            for (MUIElement toRestore : elementsLeftToRestore) {
                if (toRestore.isVisible()) continue;
                unMax = false;
            }
            if (unMax) {
                maxElement.getTags().remove("Maximized");
            }
        }
    }

    void maximize(MUIElement element) {
        if (!element.isToBeRendered()) {
            return;
        }
        List<MUIElement> elementsToMinimize = this.getElementsToMinimize(element);
        Shell hostShell = (Shell)this.modelService.getTopLevelWindowFor(element).getWidget();
        MWindow win = this.getWindowFor(element);
        FaderAnimationFeedback fader = new FaderAnimationFeedback(hostShell);
        AnimationEngine engine = new AnimationEngine(win.getContext(), (AnimationFeedbackBase)fader, 300);
        engine.schedule();
        this.restoreMaximizedElement(element, win);
        for (MUIElement toMinimize : elementsToMinimize) {
            toMinimize.getTags().add(MINIMIZED);
            toMinimize.getTags().add(MINIMIZED_BY_ZOOM);
        }
        this.adjustCTFButtons(element);
    }

    private List<MUIElement> getElementsToMinimize(MUIElement element) {
        MWindow win = this.getWindowFor(element);
        MPerspective persp = this.modelService.getActivePerspective(win);
        ArrayList<MUIElement> elementsToMinimize = new ArrayList<MUIElement>();
        int loc = this.modelService.getElementLocation(element);
        if ((loc & 1) != 0) {
            List pStacks;
            List globalStacks = this.modelService.findElements((MUIElement)win, null, MPartStack.class, null, 1);
            for (MPartStack gStack : globalStacks) {
                if (gStack == element || !gStack.isToBeRendered() || gStack.getWidget() == null || gStack.getTags().contains(MINIMIZED)) continue;
                elementsToMinimize.add((MUIElement)gStack);
            }
            Object perspStack = null;
            perspStack = persp == null ? ((pStacks = this.modelService.findElements((MUIElement)win, null, MPerspectiveStack.class, null)).size() > 0 ? (MPerspectiveStack)pStacks.get(0) : null) : persp.getParent();
            if (perspStack != null) {
                if (perspStack.getElementId() == null || perspStack.getElementId().length() == 0) {
                    perspStack.setElementId("PerspectiveStack");
                }
                elementsToMinimize.add((MUIElement)perspStack);
            }
        } else {
            MPlaceholder eaPlaceholder;
            List stacks = this.modelService.findElements((MUIElement)(persp == null ? win : persp), null, MPartStack.class, null, 11);
            for (MPartStack theStack : stacks) {
                if (theStack == element || !theStack.isToBeRendered() || this.getWindowFor((MUIElement)theStack) != win || (loc = this.modelService.getElementLocation((MUIElement)theStack)) == 8 || theStack.getWidget() == null || !theStack.isVisible() || theStack.getTags().contains(MINIMIZED)) continue;
                elementsToMinimize.add((MUIElement)theStack);
            }
            ArrayList<String> standaloneTag = new ArrayList<String>();
            standaloneTag.add("Standalone");
            List standaloneViews = this.modelService.findElements((MUIElement)(persp == null ? win : persp), null, MPlaceholder.class, standaloneTag, 11);
            for (MPlaceholder part : standaloneViews) {
                if (!part.isToBeRendered()) continue;
                elementsToMinimize.add((MUIElement)part);
            }
            if (persp != null && element != (eaPlaceholder = (MPlaceholder)this.modelService.find(ID_EDITOR_AREA, (MUIElement)persp)) && eaPlaceholder != null && eaPlaceholder.getWidget() != null && eaPlaceholder.isVisible()) {
                elementsToMinimize.add((MUIElement)eaPlaceholder);
            }
        }
        return elementsToMinimize;
    }

    private void restoreMaximizedElement(MUIElement element, MWindow win) {
        MPerspective elePersp = this.modelService.getPerspectiveFor(element);
        ArrayList<String> maxTag = new ArrayList<String>();
        maxTag.add(MAXIMIZED);
        List curMax = this.modelService.findElements((MUIElement)win, null, MUIElement.class, maxTag);
        if (curMax.size() > 0) {
            for (MUIElement maxElement : curMax) {
                MPerspective maxPersp;
                if (this.getWindowFor(maxElement) != win || (maxPersp = this.modelService.getPerspectiveFor(maxElement)) != elePersp || maxElement == element) continue;
                this.ignoreTagChanges = true;
                try {
                    maxElement.getTags().remove(MAXIMIZED);
                }
                finally {
                    this.ignoreTagChanges = false;
                }
            }
        }
    }

    private MWindow getWindowFor(MUIElement element) {
        MElementContainer parent = element.getParent();
        while (parent != null && !(parent instanceof MWindow)) {
            parent = parent.getParent();
        }
        return (MWindow)parent;
    }

    void unzoom(MUIElement element) {
        MWindow win = this.getWindowFor(element);
        Shell hostShell = (Shell)win.getWidget();
        FaderAnimationFeedback fader = new FaderAnimationFeedback(hostShell);
        AnimationEngine engine = new AnimationEngine(win.getContext(), (AnimationFeedbackBase)fader, 300);
        engine.schedule();
        List<MUIElement> elementsToRestore = this.getElementsToRestore(element);
        for (MUIElement toRestore : elementsToRestore) {
            toRestore.getTags().remove("MinimizedByZoom");
            toRestore.getTags().remove("Minimized");
        }
        this.adjustCTFButtons(element);
        this.partService.requestActivation();
    }

    private List<MUIElement> getElementsToRestore(MUIElement element) {
        MPerspectiveStack perspStack;
        List psList;
        int loc;
        MWindow win = this.getWindowFor(element);
        MPerspective persp = this.modelService.getActivePerspective(win);
        ArrayList<MUIElement> elementsToRestore = new ArrayList<MUIElement>();
        ArrayList<String> minTag = new ArrayList<String>();
        minTag.add("MinimizedByZoom");
        boolean outsidePerspectives = (this.modelService.getElementLocation(element) & 1) != 0;
        List stacks = this.modelService.findElements((MUIElement)win, null, MPartStack.class, minTag, 11);
        for (MPartStack theStack : stacks) {
            int stackLoc;
            if (theStack.getWidget() == null || outsidePerspectives && ((stackLoc = this.modelService.getElementLocation((MUIElement)theStack)) & 1) == 0 || this.getWindowFor((MUIElement)theStack) != win) continue;
            elementsToRestore.add((MUIElement)theStack);
        }
        List views = this.modelService.findElements((MUIElement)win, null, MPlaceholder.class, minTag, 11);
        for (MPlaceholder ph : views) {
            if (ph.getWidget() == null || this.getWindowFor((MUIElement)ph) != win) continue;
            elementsToRestore.add((MUIElement)ph);
        }
        MPlaceholder eaPlaceholder = (MPlaceholder)this.modelService.find(ID_EDITOR_AREA, (MUIElement)(persp == null ? win : persp));
        if (element != eaPlaceholder && eaPlaceholder != null && eaPlaceholder.getTags().contains(MINIMIZED_BY_ZOOM)) {
            elementsToRestore.add((MUIElement)eaPlaceholder);
        }
        if (((loc = this.modelService.getElementLocation(element)) & 1) != 0 && (psList = this.modelService.findElements((MUIElement)win, null, MPerspectiveStack.class, null)).size() == 1 && element != (perspStack = (MPerspectiveStack)psList.get(0)) && perspStack != null && perspStack.getTags().contains(MINIMIZED_BY_ZOOM)) {
            elementsToRestore.add((MUIElement)perspStack);
        }
        return elementsToRestore;
    }

    private void createTrim(MUIElement element) {
        MWindow win = this.getWindowFor(element);
        if (!(win instanceof MTrimmedWindow)) {
            return;
        }
        MTrimmedWindow window = (MTrimmedWindow)win;
        Shell winShell = (Shell)window.getWidget();
        String trimId = String.valueOf(element.getElementId()) + this.getMinimizedElementSuffix(element);
        MToolControl trimStack = (MToolControl)this.modelService.find(trimId, (MUIElement)window);
        if (trimStack == null) {
            trimStack = MenuFactoryImpl.eINSTANCE.createToolControl();
            trimStack.setElementId(trimId);
            trimStack.setContributionURI(TrimStack.CONTRIBUTION_URI);
            trimStack.getTags().add("TrimStack");
            MTrimBar bar = this.getBarForElement(element, window);
            int index = this.getCachedIndex(element);
            if (index == -1 || index >= bar.getChildren().size()) {
                bar.getChildren().add(trimStack);
            } else {
                bar.getChildren().add(index, trimStack);
            }
            bar.setVisible(true);
            if (bar.getWidget() == null) {
                bar.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)bar, (Object)winShell, window.getContext());
            }
        } else {
            MElementContainer parent = trimStack.getParent();
            parent.setVisible(true);
            if (parent.getWidget() == null) {
                parent.setToBeRendered(true);
                ((IPresentationEngine)this.context.get(IPresentationEngine.class)).createGui((MUIElement)parent, (Object)winShell, window.getContext());
            }
            trimStack.setToBeRendered(true);
        }
    }

    private String getCachedInfo(MUIElement element) {
        String cacheId = GLOBAL_CACHE_ID;
        MPerspective persp = this.modelService.getPerspectiveFor(element);
        if (persp != null) {
            cacheId = persp.getElementId();
        }
        String cacheInfo = (String)this.minMaxAddon.getPersistedState().get(cacheId);
        return cacheInfo;
    }

    private int getCachedIndex(MUIElement element) {
        String[] stacks;
        String cache = this.getCachedInfo(element);
        if (cache == null) {
            return -1;
        }
        String[] stringArray = stacks = cache.split("#");
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            String stackInfo = stringArray[n2];
            String[] vals = stackInfo.split(" ");
            if (vals[0].equals(element.getElementId())) {
                return Integer.parseInt(vals[2]);
            }
            ++n2;
        }
        return -1;
    }

    private SideValue getCachedBar(MUIElement element) {
        String[] stacks;
        String cache = this.getCachedInfo(element);
        if (cache == null) {
            return null;
        }
        String[] stringArray = stacks = cache.split("#");
        int n = stacks.length;
        int n2 = 0;
        while (n2 < n) {
            String stackInfo = stringArray[n2];
            String[] vals = stackInfo.split(" ");
            if (vals[0].equals(element.getElementId())) {
                int sideVal = Integer.parseInt(vals[1]);
                return SideValue.get((int)sideVal);
            }
            ++n2;
        }
        return null;
    }

    private MTrimBar getBarForElement(MUIElement element, MTrimmedWindow window) {
        SideValue side = this.getCachedBar(element);
        if (side == null) {
            Shell winShell = (Shell)window.getWidget();
            Rectangle winBounds = winShell.getBounds();
            int winCenterX = winBounds.width / 2;
            Control stackCtrl = (Control)element.getWidget();
            Rectangle stackBounds = stackCtrl.getBounds();
            stackBounds = winShell.getDisplay().map(stackCtrl, (Control)winShell, stackBounds);
            int stackCenterX = stackBounds.x + stackBounds.width / 2;
            side = stackCenterX < winCenterX ? SideValue.LEFT : SideValue.RIGHT;
        }
        MTrimBar bar = this.modelService.getTrim(window, side);
        return bar;
    }

    private String getMinimizedElementSuffix(MUIElement element) {
        String id = ID_SUFFIX;
        MPerspective persp = this.modelService.getPerspectiveFor(element);
        if (persp != null) {
            id = String.valueOf('(') + persp.getElementId() + ')';
        }
        return id;
    }
}

