/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.views.markers.MarkerField;
import org.eclipse.ui.views.markers.MarkerItem;

class MarkerComparator
implements Comparator<MarkerItem> {
    private MarkerField category;
    private MarkerField[] fields;
    public static final int ASCENDING = 1;
    public static final int DESCENDING = -1;
    private static final String PRIMARY_SORT_FIELD_TAG = "PRIMARY_SORT_FIELD";
    private static final String DESCENDING_FIELDS = "DESCENDING_FIELDS";
    HashSet<MarkerField> descendingFields = new HashSet();

    public MarkerComparator(MarkerField categoryField, MarkerField[] mainFields) {
        this.category = categoryField;
        this.fields = mainFields;
    }

    public int compareCategory(MarkerItem object1, MarkerItem object2) {
        if (this.category == null) {
            return 0;
        }
        return this.category.compare(object1, object2);
    }

    Comparator<MarkerItem> getCategoryComparator() {
        return new Comparator<MarkerItem>(){

            @Override
            public int compare(MarkerItem o1, MarkerItem o2) {
                return MarkerComparator.this.compareCategory(o1, o2);
            }
        };
    }

    @Override
    public int compare(MarkerItem arg0, MarkerItem arg1) {
        int value = this.compareCategory(arg0, arg1);
        if (value == 0) {
            value = this.compareFields(arg0, arg1);
        }
        return value;
    }

    public int compareFields(MarkerItem item0, MarkerItem item1) {
        int value = 0;
        int i = 0;
        while (i < this.fields.length) {
            value = this.descendingFields.contains(this.fields[i]) ? this.fields[i].compare(item1, item0) : this.fields[i].compare(item0, item1);
            if (value != 0) break;
            ++i;
        }
        return value;
    }

    Comparator<MarkerItem> getFieldsComparator() {
        return new Comparator<MarkerItem>(){

            @Override
            public int compare(MarkerItem o1, MarkerItem o2) {
                return MarkerComparator.this.compareFields(o1, o2);
            }
        };
    }

    public void reversePriority(MarkerField field) {
        if (this.descendingFields.remove(field)) {
            return;
        }
        this.descendingFields.add(field);
    }

    void setPrimarySortField(MarkerField field) {
        if (this.fields[0] == field) {
            this.reversePriority(field);
            return;
        }
        int insertionIndex = 1;
        MarkerField[] newFields = new MarkerField[this.fields.length];
        newFields[0] = field;
        int i = 0;
        while (i < newFields.length) {
            if (this.fields[i] != field) {
                newFields[insertionIndex] = this.fields[i];
                ++insertionIndex;
            }
            ++i;
        }
        this.fields = newFields;
    }

    void restore(IMemento memento) {
        if (memento == null) {
            return;
        }
        String primaryField = memento.getString(PRIMARY_SORT_FIELD_TAG);
        if (primaryField == null || primaryField.equals(MarkerSupportInternalUtilities.getId(this.fields[0]))) {
            return;
        }
        int i = 1;
        while (i < this.fields.length) {
            if (MarkerSupportInternalUtilities.getId(this.fields[i]).equals(primaryField)) {
                this.setPrimarySortField(this.fields[i]);
                break;
            }
            ++i;
        }
        IMemento[] descending = memento.getChildren(DESCENDING_FIELDS);
        int i2 = 0;
        while (i2 < this.fields.length) {
            int j = 0;
            while (j < descending.length) {
                if (descending[j].getID().equals(MarkerSupportInternalUtilities.getId(this.fields[i2]))) {
                    this.descendingFields.add(this.fields[i2]);
                }
                ++j;
            }
            ++i2;
        }
    }

    void saveState(IMemento memento) {
        memento.putString(PRIMARY_SORT_FIELD_TAG, MarkerSupportInternalUtilities.getId(this.fields[0]));
        Iterator<MarkerField> descendingIterator = this.descendingFields.iterator();
        while (descendingIterator.hasNext()) {
            memento.createChild(DESCENDING_FIELDS, MarkerSupportInternalUtilities.getId(descendingIterator.next()));
        }
    }

    MarkerField getPrimarySortField() {
        return this.fields[0];
    }

    void setCategory(MarkerField category) {
        this.category = category;
    }
}

