/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.oomph.setup.internal.installer.KeepInstallerUtil;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class KeepInstallerDialog
extends AbstractSetupDialog {
    private final boolean startPermanentInstaller;
    private String location;
    private Button startMenuButton;
    private Button desktopButton;

    public KeepInstallerDialog(Shell parentShell, boolean startPermanentInstaller) {
        super(parentShell, "Eclipse Installer", 560, 270, (OomphUIPlugin)SetupInstallerPlugin.INSTANCE, false);
        this.startPermanentInstaller = startPermanentInstaller;
    }

    protected String getDefaultMessage() {
        return "Copy the installer to a permanent location on your disk in order to remember your settings and support self updates.";
    }

    protected int getContainerMargin() {
        return 10;
    }

    protected void createUI(Composite parent) {
        final Shell shell = this.getShell();
        this.setTitle("Keep Installer");
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = this.getContainerMargin();
        layout.marginHeight = this.getContainerMargin();
        layout.verticalSpacing = 5;
        parent.setLayout((Layout)layout);
        Label locationLabel = new Label(parent, 0);
        locationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        locationLabel.setText("Copy to:");
        final Text locationText = new Text(parent, 2048);
        locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeepInstallerDialog.this.location = locationText.getText();
                String error = this.validate();
                KeepInstallerDialog.this.setErrorMessage(error);
                Button okButton = KeepInstallerDialog.this.getButton(0);
                okButton.setEnabled(error == null && KeepInstallerDialog.this.location.length() != 0);
            }

            private String validate() {
                if (KeepInstallerDialog.this.location.length() == 0) {
                    return null;
                }
                File folder = new File(KeepInstallerDialog.this.location);
                if (!folder.exists()) {
                    return null;
                }
                if (!folder.isDirectory()) {
                    return "Path is not a directory.";
                }
                if (!this.isEmpty(folder)) {
                    return "Directory is not empty.";
                }
                return null;
            }

            private boolean isEmpty(File folder) {
                File[] children = folder.listFiles();
                return children == null || children.length == 0;
            }
        });
        Button browseButton = new Button(parent, 0);
        browseButton.setText("Browse" + StringUtil.HORIZONTAL_ELLIPSIS);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                FileDialog dialog = new FileDialog(shell, 73728);
                dialog.setText("Keep Installer");
                if (!StringUtil.isEmpty((String)KeepInstallerDialog.this.location)) {
                    File file = new File(KeepInstallerDialog.this.location).getAbsoluteFile();
                    dialog.setFilterPath(file.getParent());
                    dialog.setFileName(file.getName());
                }
                if ((dir = dialog.open()) != null) {
                    locationText.setText(dir);
                }
            }
        });
        if (KeepInstallerUtil.getPowerShell() != null) {
            new Label(parent, 0);
            this.startMenuButton = new Button(parent, 32);
            this.startMenuButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this.startMenuButton.setText("Create start menu entry");
            this.startMenuButton.setSelection(true);
            new Label(parent, 0);
            this.desktopButton = new Button(parent, 32);
            this.desktopButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this.desktopButton.setText("Create desktop shortcut");
            this.desktopButton.setSelection(true);
        }
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                File home = new File(PropertiesUtil.getUserHome());
                int i = 1;
                while (i < Integer.MAX_VALUE) {
                    File folder = new File(home, "eclipse-installer" + (i > 1 ? Integer.valueOf(i) : ""));
                    if (!folder.exists()) {
                        String path = folder.getAbsolutePath();
                        locationText.setText(path);
                        locationText.setSelection(path.length());
                        return;
                    }
                    ++i;
                }
            }
        });
    }

    protected void okPressed() {
        final String launcher = OS.getCurrentLauncher((boolean)false);
        if (launcher != null) {
            final boolean startMenu = this.startMenuButton == null ? false : this.startMenuButton.getSelection();
            final boolean desktop = this.desktopButton == null ? false : this.desktopButton.getSelection();
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog((Shell)this.getShell().getParent());
            try {
                progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Copying installer to " + KeepInstallerDialog.this.location, -1);
                        KeepInstallerUtil.keepInstaller(KeepInstallerDialog.this.location, KeepInstallerDialog.this.startPermanentInstaller, launcher, startMenu, desktop, false);
                        monitor.done();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        }
        super.okPressed();
    }
}

