/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.version.ui.actions;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.internal.version.IVersionBuilderArguments;
import org.eclipse.oomph.internal.version.VersionBuilderArguments;
import org.eclipse.oomph.version.ui.actions.AbstractAction;
import org.eclipse.oomph.version.ui.dialogs.ConfigurationDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureBuilderAction
extends AbstractAction<IVersionBuilderArguments> {
    private static final String TITLE = "Configure Version Management";

    public ConfigureBuilderAction() {
        super(TITLE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IVersionBuilderArguments promptArguments() {
        ConfigurationDialog dialog;
        VersionBuilderArguments arguments = null;
        block2: for (Object element : (IStructuredSelection)this.selection) {
            if (!(element instanceof IProject)) continue;
            IProject project = (IProject)element;
            try {
                IProjectDescription description = project.getDescription();
                ICommand[] iCommandArray = description.getBuildSpec();
                int n = iCommandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommand command = iCommandArray[n2];
                    if ("org.eclipse.oomph.version.VersionBuilder".equals(command.getBuilderName())) {
                        VersionBuilderArguments commandArguments = new VersionBuilderArguments(command.getArguments());
                        if (arguments != null && !arguments.equals((Object)commandArguments)) {
                            if (MessageDialog.openQuestion((Shell)this.shell, (String)TITLE, (String)"The selected projects have different configurations. The configuration you specify will be applied to all selected projects.\n\nWould you like to proceed?")) break block2;
                            return null;
                        }
                        arguments = commandArguments;
                    }
                    ++n2;
                }
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
        }
        if ((dialog = new ConfigurationDialog(this.shell, arguments)).open() == 0) {
            return dialog;
        }
        return null;
    }

    @Override
    protected void runWithArguments(IVersionBuilderArguments arguments) throws CoreException {
        for (Object element : (IStructuredSelection)this.selection) {
            if (!(element instanceof IProject)) continue;
            IProject project = (IProject)element;
            arguments.applyTo(project);
        }
    }
}

