/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal.util;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Random;

public final class StringUtil {
    public static final String EMPTY = "";
    public static final String UTF8 = "UTF-8";
    private static final byte[] NO_BYTES = new byte[0];
    private static final byte[] KEY = new byte[256];
    private static Random random;

    private StringUtil() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String safe(String str) {
        return StringUtil.safe(str, EMPTY);
    }

    public static String safe(String str, String def) {
        if (str == null) {
            return def;
        }
        return str;
    }

    public static String charToHex(char ch) {
        return Integer.toHexString(ch).toUpperCase(Locale.ENGLISH);
    }

    public static char hexToChar(String s) throws NumberFormatException {
        return (char)Integer.parseInt(s, 16);
    }

    public static byte[] toUTF(String str) throws RuntimeException {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return NO_BYTES;
        }
        try {
            return str.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String fromUTF(byte[] bytes) throws RuntimeException {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return EMPTY;
        }
        try {
            return new String(bytes, UTF8);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URI newURI(String uri) throws RuntimeException {
        if (StringUtil.isEmpty(uri)) {
            return null;
        }
        try {
            return new URI(uri);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URI newURI(URI uri, String path) throws RuntimeException {
        if (StringUtil.isEmpty(path)) {
            return uri;
        }
        String result = uri.toString();
        if (!result.endsWith("/")) {
            result = String.valueOf(result) + "/";
        }
        result = path.startsWith("/") ? String.valueOf(result) + path.substring(1) : String.valueOf(result) + path;
        return StringUtil.newURI(result);
    }

    public static String encodeURI(URI uri) {
        return StringUtil.encodeURI(uri.toString());
    }

    public static String encodeURI(String uri) {
        try {
            uri = URLEncoder.encode(uri, UTF8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encrypt(String str) throws RuntimeException {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return NO_BYTES;
        }
        byte[] bytes = StringUtil.toUTF(str);
        byte[] result = new byte[bytes.length + 1];
        byte[] byArray = KEY;
        synchronized (KEY) {
            if (random == null) {
                random = new Random(System.currentTimeMillis());
                random.nextBytes(KEY);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            int j = random.nextInt(KEY.length);
            result[bytes.length] = (byte)(j + -128);
            StringUtil.crypt(bytes, result, bytes.length, j);
            return result;
        }
    }

    public static String decrypt(byte[] bytes) throws RuntimeException {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return EMPTY;
        }
        byte[] result = new byte[bytes.length - 1];
        int j = bytes[result.length] - -128;
        StringUtil.crypt(bytes, result, result.length, j);
        return StringUtil.fromUTF(result);
    }

    private static void crypt(byte[] bytes, byte[] result, int length, int j) {
        int i = 0;
        while (i < length) {
            result[i] = (byte)(bytes[i] ^ KEY[j++ % KEY.length]);
            ++i;
        }
    }
}

