/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.OSGiVersion;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseResourceFactoryImpl;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.impl.RequirementImpl;
import org.eclipse.oomph.p2.internal.core.AgentImpl;
import org.eclipse.oomph.setup.EclipseIniTask;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.p2.P2Task;
import org.eclipse.oomph.setup.p2.SetupP2Factory;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IORuntimeException;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.WorkerPool;
import org.eclipse.oomph.util.XMLUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductCatalogGenerator
implements IApplication {
    private static final String JAVA_VERSION_PREFIX = "addJvmArg(jvmArg:-Dosgi.requiredJavaVersion=";
    private static final String PACKAGES = "http://download.eclipse.org/technology/epp/packages";
    private static final String RELEASES = "http://download.eclipse.org/releases";
    private static final String ICON_URL_PREFIX = "http://www.eclipse.org/downloads/images/";
    private static final URI PACKAGES_URI = URI.createURI((String)"https://www.eclipse.org/downloads/packages/");
    private static final String ICON_DEFAULT = "http://www.eclipse.org/downloads/images/committers.png";
    private static final Map<String, String> ICONS = new HashMap<String, String>();
    private static final List<String> PRODUCT_IDS = Arrays.asList("epp.package.java", "epp.package.jee", "epp.package.cpp", "epp.package.javascript", "epp.package.php", "epp.package.committers", "epp.package.dsl", "epp.package.reporting", "epp.package.modeling", "epp.package.android", "epp.package.rcp", "epp.package.testing", "epp.package.parallel", "epp.package.automotive", "epp.package.scout", "org.eclipse.platform.ide");
    private static final Set<String> EXCLUDED_IDS = new HashSet<String>(Arrays.asList("epp.package.mobile"));
    private static final String EPP_INSTALL_ROOTS_FILTER = "(org.eclipse.epp.install.roots=true)";
    private URI outputLocation;
    private String stagingTrain;
    private boolean stagingEPPLocationIsActual;
    private boolean stagingUseComposite;
    private URI stagingEPPLocation;
    private URI stagingTrainLocation;
    private final Map<String, Map<URI, Map<String, URI>>> sites = new LinkedHashMap<String, Map<URI, Map<String, URI>>>();
    private final IMetadataRepositoryManager manager = this.getMetadataRepositoryManager();
    private final Map<String, IMetadataRepository> eppMetaDataRepositories = new HashMap<String, IMetadataRepository>();
    private final Map<String, List<TrainAndVersion>> trainsAndVersions = new HashMap<String, List<TrainAndVersion>>();
    private final Map<String, String> labels = new HashMap<String, String>();
    private final Map<String, Product> products = new LinkedHashMap<String, Product>();
    private String emfRepositoryLocation;
    private final String[] TRAINS = this.getTrains();
    private final String LATEST_TRAIN = this.TRAINS[this.TRAINS.length - 1];
    private final boolean LATEST_RELEASED = !this.testNewUnreleasedProduct() && this.isLatestReleased();

    public Object start(IApplicationContext context) throws Exception {
        String[] arguments = (String[])context.getArguments().get("application.args");
        if (arguments != null) {
            int i = 0;
            while (i < arguments.length) {
                String option = arguments[i];
                if ("-outputLocation".equals(option)) {
                    this.outputLocation = URI.createURI((String)arguments[++i]);
                } else if ("-staging".equals(option)) {
                    this.stagingTrain = arguments[++i];
                    this.stagingEPPLocation = URI.createURI((String)arguments[++i]);
                    this.stagingTrainLocation = URI.createURI((String)arguments[++i]);
                } else if ("-actual".equals(option)) {
                    this.stagingEPPLocationIsActual = true;
                } else if ("-useComposite".equals(option)) {
                    this.stagingUseComposite = true;
                }
                ++i;
            }
        }
        ICONS.put("reporting", "http://www.eclipse.org/downloads/images/birt-icon_48x48.png");
        ICONS.put("cpp", "http://www.eclipse.org/downloads/images/cdt.png");
        ICONS.put("automotive", "http://www.eclipse.org/downloads/images/classic.jpg");
        ICONS.put("standard", ICON_DEFAULT);
        ICONS.put("committers", ICON_DEFAULT);
        ICONS.put("android", ICON_DEFAULT);
        ICONS.put("dsl", "http://www.eclipse.org/downloads/images/dsl-package_42.png");
        ICONS.put("java", "http://www.eclipse.org/downloads/images/java.png");
        ICONS.put("jee", "http://www.eclipse.org/downloads/images/javaee.png");
        ICONS.put("modeling", "http://www.eclipse.org/downloads/images/modeling.png");
        ICONS.put("parallel", "http://www.eclipse.org/downloads/images/parallel.png");
        ICONS.put("php", "http://www.eclipse.org/downloads/images/php.png");
        ICONS.put("rcp", "http://www.eclipse.org/downloads/images/rcp.png");
        ICONS.put("scout", "http://www.eclipse.org/downloads/images/scout.jpg");
        ICONS.put("testing", "http://www.eclipse.org/downloads/images/testing.png");
        ICONS.put("mobile", "http://www.eclipse.org/downloads/images/mobile.jpg");
        this.generate();
        return null;
    }

    public void stop() {
    }

    private String[] getTrains() {
        return new String[]{"juno", "kepler", "luna", "mars", "neon"};
    }

    private String[] getRootIUs() {
        return new String[]{"org.eclipse.platform.feature.group", "org.eclipse.rcp.feature.group", "org.eclipse.jdt.feature.group", "org.eclipse.pde.feature.group"};
    }

    private boolean isLatestReleased() {
        return false;
    }

    private boolean testNewUnreleasedProduct() {
        return false;
    }

    public void generate() {
        this.getPackageBrandingSites();
        try {
            ProductCatalog productCatalog = SetupFactory.eINSTANCE.createProductCatalog();
            productCatalog.setName("org.eclipse.products");
            productCatalog.setLabel("Eclipse.org");
            productCatalog.setDescription("The catalog of products available as <a href='https://www.eclipse.org/downloads/'>packaged downloads</a> at Eclipse.org.");
            Annotation brandingInfo = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
            brandingInfo.getDetails().put((Object)"readmePath", (Object)"readme/readme_eclipse.html");
            productCatalog.getAnnotations().add((Object)brandingInfo);
            Annotation statsSending = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/StatsSending");
            statsSending.getDetails().put((Object)"uri", (Object)"http://download.eclipse.org/stats/oomph");
            productCatalog.getAnnotations().add((Object)statsSending);
            InstallationTask installationTask = SetupFactory.eINSTANCE.createInstallationTask();
            installationTask.setID("installation");
            productCatalog.getSetupTasks().add((Object)installationTask);
            P2Task p2Task = this.createOomphP2Task();
            productCatalog.getSetupTasks().add((Object)p2Task);
            this.emfRepositoryLocation = this.trimEmptyTrailingSegment(URI.createURI((String)this.loadLatestRepository(this.manager, null, URI.createURI((String)"http://download.eclipse.org/modeling/emf/emf/updates/2.10.x/core"), true).getLocation().toString())).toString();
            new RepositoryLoader(this).perform(this.TRAINS);
            if (this.testNewUnreleasedProduct()) {
                ArrayList<TrainAndVersion> list = new ArrayList<TrainAndVersion>();
                list.add(new TrainAndVersion("mars", null, null, null, null));
                this.trainsAndVersions.put("test.product", list);
                this.labels.put("test.product", "Eclipse Test Product");
            }
            System.out.println("#################################################################################################################");
            System.out.println();
            ArrayList<String> ids = new ArrayList<String>(this.trainsAndVersions.keySet());
            Collections.sort(ids, new Comparator<String>(){

                @Override
                public int compare(String id1, String id2) {
                    int result = this.getLatestTrain(id2) - this.getLatestTrain(id1);
                    if (result == 0) {
                        String label1 = StringUtil.safe((String)((String)ProductCatalogGenerator.this.labels.get(id1)));
                        String label2 = StringUtil.safe((String)((String)ProductCatalogGenerator.this.labels.get(id2)));
                        result = label1.compareTo(label2);
                    }
                    return result;
                }

                private int getLatestTrain(String id) {
                    List list = (List)ProductCatalogGenerator.this.trainsAndVersions.get(id);
                    TrainAndVersion lastEntry = (TrainAndVersion)list.get(list.size() - 1);
                    String lastTrain = lastEntry.getTrain();
                    int i = 0;
                    while (i < ProductCatalogGenerator.this.TRAINS.length) {
                        String train = ProductCatalogGenerator.this.TRAINS[i];
                        if (train == lastTrain) {
                            return i;
                        }
                        ++i;
                    }
                    throw new IllegalStateException();
                }
            });
            for (String id : ids) {
                this.products.put(id, null);
            }
            new ProductGenerator(this).perform(ids);
            EList products = productCatalog.getProducts();
            products.addAll(this.products.values());
            UniqueEList productIDs = new UniqueEList(PRODUCT_IDS);
            for (Product product : products) {
                productIDs.add(product.getName());
            }
            ECollections.sort((EList)products, (Comparator)new Comparator<Product>((List)productIDs){
                private final /* synthetic */ List val$productIDs;
                {
                    this.val$productIDs = list;
                }

                @Override
                public int compare(Product product1, Product product2) {
                    int index1 = this.val$productIDs.indexOf(product1.getName());
                    int index2 = this.val$productIDs.indexOf(product2.getName());
                    return index1 - index2;
                }
            });
            System.out.println("#################################################################################################################");
            System.out.println();
            this.checkVersionRanges(productCatalog);
            this.postProcess(productCatalog);
            Resource resource = new BaseResourceFactoryImpl().createResource(this.outputLocation == null ? URI.createURI((String)"org.eclipse.products.setup") : this.outputLocation);
            resource.getContents().add((Object)productCatalog);
            if (this.outputLocation != null) {
                for (Product product : products) {
                    if (!"all".equals(product.getName())) continue;
                    products.remove((Object)product);
                    if (this.outputLocation == null) break;
                    URI allProductURI = this.outputLocation.trimSegments(1).appendSegment("org.eclipse.all.product.setup");
                    Resource allProductResource = new BaseResourceFactoryImpl().createResource(allProductURI);
                    EclipseIniTask eclipseIniTask = SetupFactory.eINSTANCE.createEclipseIniTask();
                    eclipseIniTask.setVm(true);
                    eclipseIniTask.setOption("-Xmx");
                    eclipseIniTask.setValue("5g");
                    product.getSetupTasks().add((Object)eclipseIniTask);
                    allProductResource.getContents().add((Object)product);
                    allProductResource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
                    break;
                }
                resource.save(Collections.singletonMap("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private P2Task createOomphP2Task() {
        Requirement oomphRequirement = P2Factory.eINSTANCE.createRequirement("org.eclipse.oomph.setup.feature.group");
        Repository oomphRepository = P2Factory.eINSTANCE.createRepository("${oomph.update.url}");
        P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
        p2Task.getRequirements().add((Object)oomphRequirement);
        p2Task.getRepositories().add((Object)oomphRepository);
        return p2Task;
    }

    private void generateProduct(String id) {
        String label;
        String p2TaskLabel = label = this.labels.get(id);
        List<TrainAndVersion> list = this.trainsAndVersions.get(id);
        int size = list.size();
        TrainAndVersion latestTrainAndVersion = list.get(size - 1);
        String latestTrain = latestTrainAndVersion.getTrain();
        String latestTrainLabel = this.getTrainLabel(latestTrain);
        Version latestVersion = latestTrainAndVersion.getVersion();
        Map<String, Set<IInstallableUnit>> latestTrainsIUs = latestTrainAndVersion.getIUs();
        boolean latestUnreleased = latestTrain == this.LATEST_TRAIN && !this.LATEST_RELEASED;
        StringBuilder log = new StringBuilder();
        log.append(label).append(" (").append(id).append(')').append('\n');
        Product product = SetupFactory.eINSTANCE.createProduct();
        product.setName(id);
        product.setLabel(label);
        this.attachBrandingInfos(log, product);
        this.products.put(id, product);
        if ("all".equals(id)) {
            product.getSetupTasks().add((Object)this.createOomphP2Task());
        }
        this.addProductVersion(log, product, latestVersion, VersionSegment.MAJOR, latestTrainAndVersion.getTrainURI(), latestTrainAndVersion.getEPPURI(), latestTrain, this.eppMetaDataRepositories, "latest", "Latest (" + latestTrainLabel + ")", p2TaskLabel, latestTrainsIUs, this.emfRepositoryLocation);
        if (!latestUnreleased || size != 1) {
            int offset = 1;
            if (latestUnreleased && size > 1) {
                ++offset;
            }
            TrainAndVersion releasedTrainAndVersion = list.get(size - offset);
            String releasedTrain = releasedTrainAndVersion.getTrain();
            String releasedTrainLabel = this.getTrainLabel(releasedTrain);
            Version releasedVersion = releasedTrainAndVersion.getVersion();
            this.addProductVersion(log, product, releasedVersion, VersionSegment.MINOR, releasedTrainAndVersion.getTrainURI(), releasedTrainAndVersion.getEPPURI(), releasedTrain, this.eppMetaDataRepositories, "latest.released", "Latest Release (" + releasedTrainLabel + ")", p2TaskLabel, releasedTrainAndVersion.getIUs(), this.emfRepositoryLocation);
        }
        int i = 0;
        while (i < size) {
            TrainAndVersion entry = list.get(size - i - 1);
            String train = entry.getTrain();
            String trainLabel = this.getTrainLabel(train);
            Version version = entry.getVersion();
            this.addProductVersion(log, product, version, VersionSegment.MINOR, entry.getTrainURI(), entry.getEPPURI(), train, this.eppMetaDataRepositories, train, trainLabel, p2TaskLabel, entry.getIUs(), this.emfRepositoryLocation);
            ++i;
        }
        System.out.println(log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(String train) throws ProvisionException, URISyntaxException {
        String id;
        Object capability;
        Object label;
        Object latestLocation;
        IMetadataRepository latestEPPMetaDataRepository;
        URI originalEPPURI;
        StringBuilder log = new StringBuilder();
        URI eppURI = originalEPPURI = URI.createURI((String)("http://download.eclipse.org/technology/epp/packages/" + train));
        log.append(eppURI);
        boolean isStaging = train.equals(this.stagingTrain);
        if (isStaging) {
            log.append(" -> ").append(this.stagingEPPLocation);
        }
        URI effectiveEPPURI = isStaging ? this.stagingEPPLocation : eppURI;
        IMetadataRepository eppMetaDataRepository = this.manager.loadRepository(new java.net.URI(effectiveEPPURI.toString()), null);
        IMetadataRepository iMetadataRepository = latestEPPMetaDataRepository = isStaging && this.stagingUseComposite ? eppMetaDataRepository : this.getLatestRepository(this.manager, eppMetaDataRepository);
        if (latestEPPMetaDataRepository != eppMetaDataRepository) {
            latestLocation = URI.createURI((String)latestEPPMetaDataRepository.getLocation().toString());
            log.append(" -> ").append(latestLocation);
            URI relativeLocation = URI.createURI((String)latestLocation.toString()).deresolve(URI.createURI((String)effectiveEPPURI.toString()).appendSegment(""));
            if (relativeLocation.isRelative()) {
                URI actualLatestEPPURI = URI.createURI((String)URI.createURI((String)eppURI.toString()).appendSegments(relativeLocation.segments()).toString());
                try {
                    this.manager.loadRepository(new java.net.URI(actualLatestEPPURI.toString()), null);
                    log.append(" -> ").append(actualLatestEPPURI);
                    eppURI = this.trimEmptyTrailingSegment(actualLatestEPPURI);
                }
                catch (Throwable throwable) {}
            }
        } else if (isStaging && this.stagingEPPLocationIsActual) {
            eppURI = this.stagingEPPLocation;
            log.append(" -> ").append(this.stagingEPPLocation);
        }
        log.append('\n');
        latestLocation = this.eppMetaDataRepositories;
        synchronized (latestLocation) {
            this.eppMetaDataRepositories.put(train, eppMetaDataRepository);
        }
        HashMap<String, IInstallableUnit> ius = new HashMap<String, IInstallableUnit>();
        URI releaseURI = URI.createURI((String)("http://download.eclipse.org/releases/" + train));
        log.append(releaseURI);
        IMetadataRepository releaseMetaDataRepository = this.loadLatestRepository(this.manager, originalEPPURI, isStaging ? this.stagingTrainLocation : releaseURI, !isStaging || !this.stagingUseComposite);
        releaseURI = this.trimEmptyTrailingSegment(URI.createURI((String)releaseMetaDataRepository.getLocation().toString()));
        log.append(" -> ").append(releaseURI).append('\n');
        this.generateFullTrainProduct(train, releaseMetaDataRepository);
        HashSet<String> requirements = new HashSet<String>();
        for (IInstallableUnit iInstallableUnit : P2Util.asIterable((IQueryResult)eppMetaDataRepository.query(QueryUtil.createLatestIUQuery(), null))) {
            IInstallableUnit existingIU;
            String id2;
            String fragment = iInstallableUnit.getProperty("org.eclipse.equinox.p2.type.fragment");
            if ("true".equals(fragment)) continue;
            label = iInstallableUnit.getProperty("org.eclipse.equinox.p2.name");
            if (label == null || ((String)label).startsWith("%") || ((String)label).equals("Uncategorized")) {
                requirements.add(iInstallableUnit.getId());
            }
            if ("epp.package.standard".equals(id2 = iInstallableUnit.getId())) {
                label = "Eclipse Standard";
            }
            if ((existingIU = (IInstallableUnit)ius.get(id2)) != null) continue;
            ius.put(id2, iInstallableUnit);
            Map<String, String> map = this.labels;
            synchronized (map) {
                this.labels.put(id2, (String)label);
            }
        }
        for (IInstallableUnit iInstallableUnit : ius.values()) {
            for (IRequirement requirement : iInstallableUnit.getRequirements()) {
                String value;
                IMatchExpression filter;
                if (!(requirement instanceof IRequiredCapability) || (filter = (capability = (IRequiredCapability)requirement).getFilter()) != null && EPP_INSTALL_ROOTS_FILTER.equals(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter)) || !"org.eclipse.equinox.p2.iu".equals(capability.getNamespace())) continue;
                requirements.add(capability.getName());
            }
        }
        ius.keySet().removeAll(requirements);
        for (IInstallableUnit iInstallableUnit : P2Util.asIterable((IQueryResult)releaseMetaDataRepository.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)"org.eclipse.platform.ide")), null))) {
            id = iInstallableUnit.getId();
            label = iInstallableUnit.getProperty("org.eclipse.equinox.p2.name");
            ius.put(id, iInstallableUnit);
            capability = this.labels;
            synchronized (capability) {
                this.labels.put(id, (String)label);
            }
        }
        block18: for (Map.Entry entry : ius.entrySet()) {
            id = (String)entry.getKey();
            label = this.labels.get(id);
            IInstallableUnit iu = (IInstallableUnit)entry.getValue();
            Version version = iu.getVersion();
            log.append("  ").append((String)label).append("  --  ").append(id).append(" ").append(version).append('\n');
            HashMap<String, Set<IInstallableUnit>> versionIUs = new HashMap<String, Set<IInstallableUnit>>();
            this.gatherReleaseIUs(versionIUs, iu, releaseMetaDataRepository, eppMetaDataRepository);
            this.filterRoots(versionIUs);
            Map<String, List<TrainAndVersion>> map = this.trainsAndVersions;
            synchronized (map) {
                List<TrainAndVersion> list = this.trainsAndVersions.get(id);
                if (list == null) {
                    list = new ArrayList<TrainAndVersion>();
                    this.trainsAndVersions.put(id, list);
                }
                int i = 0;
                int size = list.size();
                while (i < size) {
                    TrainAndVersion trainAndVersion = list.get(i);
                    if (train.compareTo(trainAndVersion.train) < 0) {
                        list.add(i, new TrainAndVersion(train, version, releaseURI, eppURI, versionIUs));
                        continue block18;
                    }
                    ++i;
                }
                list.add(new TrainAndVersion(train, version, releaseURI, eppURI, versionIUs));
            }
        }
        System.out.println(log.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFullTrainProduct(String train, IMetadataRepository releaseMetaDataRepository) {
        HashMap<String, IInstallableUnit> ius = new HashMap<String, IInstallableUnit>();
        HashSet<IInstallableUnit> categories = new HashSet<IInstallableUnit>();
        HashSet<String> categorizedIUs = new HashSet<String>();
        for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)releaseMetaDataRepository.query(QueryUtil.createLatestIUQuery(), null))) {
            boolean isIncludedCategory;
            String id = iu.getId();
            IInstallableUnit existingIU = (IInstallableUnit)ius.get(id);
            if (existingIU == null) {
                ius.put(id, iu);
            }
            boolean bl = isIncludedCategory = "true".equalsIgnoreCase(iu.getProperty("org.eclipse.equinox.p2.type.category")) && !"EclipseRT Target Platform Components".equals(id);
            if (!isIncludedCategory) continue;
            categories.add(iu);
            categorizedIUs.add(id);
        }
        categorizedIUs.add("org.eclipse.platform.ide");
        ius.keySet().retainAll(categorizedIUs);
        TreeMap<String, Set<IInstallableUnit>> versionIUs = new TreeMap<String, Set<IInstallableUnit>>();
        for (IInstallableUnit iu : ius.values()) {
            String id = iu.getId();
            CollectionUtil.add(versionIUs, (Object)id, (Object)iu);
        }
        String id = "all";
        Map<String, List<TrainAndVersion>> map = this.labels;
        synchronized (map) {
            this.labels.put(id, "Eclipse Eierlegende Wollmilchsau");
        }
        map = this.trainsAndVersions;
        synchronized (map) {
            List<TrainAndVersion> list = this.trainsAndVersions.get(id);
            if (list == null) {
                list = new ArrayList<TrainAndVersion>();
                this.trainsAndVersions.put(id, list);
            }
            IInstallableUnit ide = (IInstallableUnit)ius.get("org.eclipse.platform.ide");
            URI releaseURI = URI.createURI((String)releaseMetaDataRepository.getLocation().toString());
            boolean added = false;
            int i = 0;
            int size = list.size();
            while (i < size) {
                TrainAndVersion trainAndVersion = list.get(i);
                if (train.compareTo(trainAndVersion.train) < 0) {
                    list.add(i, new TrainAndVersion(train, ide.getVersion(), releaseURI, null, versionIUs));
                    added = true;
                    break;
                }
                ++i;
            }
            if (!added) {
                list.add(new TrainAndVersion(train, ide.getVersion(), releaseURI, null, versionIUs));
            }
        }
    }

    private URI trimEmptyTrailingSegment(URI uri) throws URISyntaxException {
        if (uri.hasTrailingPathSeparator()) {
            return uri.trimSegments(1);
        }
        return uri;
    }

    private IMetadataRepositoryManager getMetadataRepositoryManager() {
        try {
            File agentLocation = File.createTempFile("test-", "-agent");
            agentLocation.delete();
            agentLocation.mkdirs();
            AgentImpl agent = new AgentImpl(null, agentLocation);
            IMetadataRepositoryManager manager = agent.getMetadataRepositoryManager();
            return manager;
        }
        catch (IOException ex) {
            throw new IORuntimeException((Throwable)ex);
        }
    }

    private IMetadataRepository getLatestRepository(IMetadataRepositoryManager manager, IMetadataRepository repository) throws URISyntaxException, ProvisionException {
        IMetadataRepository result = repository;
        if (!this.isLatestReleased() && repository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)repository;
            long latest = Integer.MIN_VALUE;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository = manager.loadRepository(childURI = new java.net.URI(this.trimEmptyTrailingSegment(URI.createURI((String)childURI.toString())).toString()), null);
                String value = (String)childRepository.getProperties().get("p2.timestamp");
                long timestamp = Long.parseLong(value);
                if (timestamp <= latest) continue;
                result = childRepository;
                latest = timestamp;
            }
        }
        return result;
    }

    private IMetadataRepository loadLatestRepository(IMetadataRepositoryManager manager, URI eppURI, URI releaseURI, boolean loadLatestChild) throws URISyntaxException, ProvisionException {
        IMetadataRepository releaseMetaDataRepository;
        IMetadataRepository result = releaseMetaDataRepository = manager.loadRepository(new java.net.URI(releaseURI.toString()), null);
        if (loadLatestChild && releaseMetaDataRepository instanceof ICompositeRepository) {
            ICompositeRepository compositeRepository = (ICompositeRepository)releaseMetaDataRepository;
            long latest = Integer.MIN_VALUE;
            for (java.net.URI childURI : compositeRepository.getChildren()) {
                IMetadataRepository childRepository;
                String value;
                long timestamp;
                URI trimmedURI = this.trimEmptyTrailingSegment(URI.createURI((String)childURI.toString()));
                if (trimmedURI.equals(eppURI) || (timestamp = Long.parseLong(value = (String)(childRepository = manager.loadRepository(childURI = new java.net.URI(trimmedURI.toString()), null)).getProperties().get("p2.timestamp"))) <= latest) continue;
                result = childRepository;
                latest = timestamp;
            }
        }
        return result;
    }

    private void checkVersionRanges(ProductCatalog productCatalog) {
        if (!this.isLatestReleased()) {
            for (Product product : productCatalog.getProducts()) {
                EList versions = product.getVersions();
                if (versions.size() <= 3) continue;
                ProductVersion latestReleaseVersion = (ProductVersion)versions.get(1);
                ProductVersion latestDevelopmentVersion = (ProductVersion)versions.get(2);
                P2Task latestReleaseP2Task = (P2Task)latestReleaseVersion.getSetupTasks().get(0);
                P2Task latestDevelopmentP2Task = (P2Task)latestDevelopmentVersion.getSetupTasks().get(0);
                block1: for (Requirement developmentRequirement : latestDevelopmentP2Task.getRequirements()) {
                    String name = developmentRequirement.getName();
                    for (Requirement releaseRequirement : latestReleaseP2Task.getRequirements()) {
                        VersionRange releaseVersionRange;
                        if (!name.equals(releaseRequirement.getName())) continue;
                        VersionRange developmentVersionRange = developmentRequirement.getVersionRange();
                        if (!developmentVersionRange.equals((Object)(releaseVersionRange = releaseRequirement.getVersionRange()))) continue block1;
                        Version minimumVersion = developmentVersionRange.getMinimum();
                        Version maximumVersion = developmentVersionRange.getMaximum();
                        if (!(minimumVersion instanceof OSGiVersion) || !(maximumVersion instanceof OSGiVersion)) continue block1;
                        OSGiVersion minimum = (OSGiVersion)minimumVersion;
                        OSGiVersion maximum = (OSGiVersion)maximumVersion;
                        int major = minimum.getMajor();
                        if (major != maximum.getMajor()) continue block1;
                        developmentRequirement.setVersionRange(new VersionRange((Version)minimum, true, Version.createOSGi((int)major, (int)(maximum.getMinor() + 1), (int)0), false));
                        continue block1;
                    }
                }
            }
        }
    }

    private void postProcess(ProductCatalog productCatalog) {
        Iterator it = productCatalog.getProducts().iterator();
        while (it.hasNext()) {
            Product product = (Product)it.next();
            String id = product.getName();
            if (EXCLUDED_IDS.contains(id)) {
                it.remove();
            }
            if (!"epp.package.standard".equals(id)) continue;
            for (ProductVersion version : product.getVersions()) {
                if (!version.getLabel().contains("Mars")) continue;
                P2Task task = (P2Task)version.getSetupTasks().get(0);
                Requirement requirement = (Requirement)task.getRequirements().get(0);
                requirement.setName("epp.package.committers");
            }
        }
    }

    private void gatherReleaseIUs(Map<String, Set<IInstallableUnit>> releaseIUs, IInstallableUnit iu, IMetadataRepository releaseMetaDataRepository, IMetadataRepository eppMetaDataRepository) {
        for (IRequirement requirement : iu.getRequirements()) {
            String value;
            IMatchExpression filter;
            IRequiredCapability capability;
            String capabilityName;
            if (!(requirement instanceof IRequiredCapability) || !(capabilityName = (capability = (IRequiredCapability)requirement).getName()).endsWith(".feature.group") || (filter = capability.getFilter()) != null && EPP_INSTALL_ROOTS_FILTER.equals(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter))) continue;
            CompoundQueryable queriable = new CompoundQueryable(new IQueryable[]{releaseMetaDataRepository, eppMetaDataRepository});
            IQuery query = QueryUtil.createIUQuery((String)capabilityName, (VersionRange)capability.getRange());
            for (IInstallableUnit requiredIU : P2Util.asIterable((IQueryResult)queriable.query(query, null))) {
                if (!CollectionUtil.add(releaseIUs, (Object)capabilityName, (Object)requiredIU)) continue;
                this.gatherReleaseIUs(releaseIUs, requiredIU, releaseMetaDataRepository, eppMetaDataRepository);
            }
        }
    }

    private void filterRoots(Map<String, Set<IInstallableUnit>> releaseIUs) {
        Iterator<Map.Entry<String, Set<IInstallableUnit>>> it = releaseIUs.entrySet().iterator();
        while (it.hasNext()) {
            String id = it.next().getKey();
            if (id.endsWith("feature.group") && !id.startsWith("org.eclipse.epp") && !id.endsWith("epp.feature.group")) continue;
            it.remove();
        }
    }

    private void addProductVersion(StringBuilder log, Product product, Version version, VersionSegment versionSegment, URI trainURI, URI eppURI, String train, Map<String, IMetadataRepository> eppMetaDataRepositories, String name, String label, String p2TaskLabel, Map<String, Set<IInstallableUnit>> ius, String emfRepositoryLocation) {
        IMetadataRepository eppMetaDataRepository;
        log.append("  ").append(label);
        ProductVersion productVersion = SetupFactory.eINSTANCE.createProductVersion();
        productVersion.setName(name);
        productVersion.setLabel(label);
        product.getVersions().add((Object)productVersion);
        String productName = product.getName();
        VersionRange versionRange = this.createVersionRange(version, versionSegment);
        Repository packageRepository = null;
        if (eppURI != null) {
            packageRepository = P2Factory.eINSTANCE.createRepository();
            if (!"all".equals(productName) && !"org.eclipse.platform.ide".equals(productName) && train.equals(this.stagingTrain)) {
                try {
                    IMetadataRepository eppMetadataRepository = this.manager.loadRepository(new java.net.URI(eppURI.toString()), null);
                    if (!eppMetadataRepository.query(QueryUtil.createIUQuery((String)productName), null).iterator().hasNext()) {
                        eppURI = eppURI.trimSegments(1);
                        trainURI = trainURI.trimSegments(1);
                        log.append(" {missing}");
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            packageRepository.setURL(eppURI.toString());
        }
        Repository releaseRepository = P2Factory.eINSTANCE.createRepository();
        releaseRepository.setURL(trainURI.toString());
        P2Task p2Task = SetupP2Factory.eINSTANCE.createP2Task();
        p2Task.setLabel(String.valueOf(p2TaskLabel) + " (" + this.getTrainLabel(train) + ")");
        if (!"all".equals(productName)) {
            Requirement requirement = P2Factory.eINSTANCE.createRequirement();
            requirement.setName(productName);
            requirement.setVersionRange(versionRange);
            p2Task.getRequirements().add((Object)requirement);
            this.addRootIURequirements((EList<Requirement>)p2Task.getRequirements(), versionSegment, ius);
            this.addAdditionalInstallRootIURequirements((EList<Requirement>)p2Task.getRequirements(), productName, train, eppMetaDataRepositories, ius);
        } else {
            this.addAllRootIURequirements((EList<Requirement>)p2Task.getRequirements(), versionSegment, ius);
        }
        if (!"org.eclipse.platform.ide".equals(productName) && packageRepository != null) {
            p2Task.getRepositories().add((Object)packageRepository);
        }
        p2Task.getRepositories().add((Object)releaseRepository);
        if (train.compareTo("luna") < 0) {
            Repository emfRepository = P2Factory.eINSTANCE.createRepository(emfRepositoryLocation);
            p2Task.getRepositories().add((Object)emfRepository);
        }
        productVersion.getSetupTasks().add((Object)p2Task);
        String idPrefix = "tooling" + ("org.eclipse.platform.ide".equals(productName) || "all".equals(productName) ? "epp.package.java" : productName) + ".ini.";
        Version maxJavaVersion = null;
        if (train.compareTo("neon") >= 0) {
            maxJavaVersion = Version.create((String)"1.8.0");
        }
        if ((eppMetaDataRepository = eppMetaDataRepositories.get(train)) != null) {
            for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)eppMetaDataRepository.query(QueryUtil.createIUAnyQuery(), null))) {
                Collection touchpointDatas;
                String id = iu.getId();
                if (!id.startsWith(idPrefix) || !"org.eclipse.platform.ide".equals(productName) && !"all".equals(productName) && !iu.getVersion().equals(version) || (touchpointDatas = iu.getTouchpointData()) == null) continue;
                for (ITouchpointData touchpointData : touchpointDatas) {
                    int pos;
                    String body;
                    ITouchpointInstruction instruction = touchpointData.getInstruction("configure");
                    if (instruction == null || (body = instruction.getBody()) == null || (pos = body.indexOf(JAVA_VERSION_PREFIX)) == -1) continue;
                    Version javaVersion = Version.parseVersion((String)body.substring(pos += JAVA_VERSION_PREFIX.length(), body.indexOf(41, pos)));
                    if (maxJavaVersion != null && maxJavaVersion.compareTo((Object)javaVersion) >= 0) continue;
                    maxJavaVersion = javaVersion;
                }
            }
        }
        if (maxJavaVersion != null) {
            String javaVersion = maxJavaVersion.toString();
            while (javaVersion.endsWith(".0")) {
                javaVersion = javaVersion.substring(0, javaVersion.length() - 2);
            }
            productVersion.setRequiredJavaVersion(javaVersion);
            log.append(" --> Java ").append(javaVersion);
        }
        Map<URI, Map<String, URI>> releases = this.sites.get(train);
        String productLabel = product.getLabel();
        String key = this.getKey(productLabel);
        Object siteURI = null;
        for (Map.Entry<URI, Map<String, URI>> productEntry : releases.entrySet()) {
            Map<String, URI> productLocations = productEntry.getValue();
            siteURI = productLocations.get(key);
            if (siteURI != null) continue;
            siteURI = productEntry.getKey();
            log.append(" No version specific branding site -> ").append(siteURI);
        }
        if (siteURI != null) {
            BaseUtil.setAnnotation((ModelElement)productVersion, (String)"http://www.eclipse.org/oomph/setup/BrandingInfo", (String)"siteURI", (String)siteURI.toString());
        }
        log.append('\n');
    }

    private String getKey(String productLabel) {
        if (productLabel.contains("Eierlegende")) {
            return "All";
        }
        if (productLabel.contains("JavaScript")) {
            return "JavaScript";
        }
        if (productLabel.contains(" EE ") || productLabel.contains("Web")) {
            return "EE";
        }
        if (productLabel.contains("Java Developer")) {
            return "Java";
        }
        if (productLabel.contains("Mobile")) {
            return "Mobile";
        }
        if (productLabel.contains("C/C++")) {
            return "C";
        }
        if (productLabel.contains("Scout")) {
            return "Scout";
        }
        if (productLabel.contains("Parallel")) {
            return "Parallel";
        }
        if (productLabel.contains(" Report ")) {
            return "Report";
        }
        if (productLabel.contains("Automotive")) {
            return "Automotive";
        }
        if (productLabel.contains("DSL")) {
            return "DSL";
        }
        if (productLabel.contains("Modeling")) {
            return "Modeling";
        }
        if (productLabel.contains("Testers")) {
            return "Testers";
        }
        if (productLabel.contains("RCP")) {
            return "RCP";
        }
        if (productLabel.contains("Standard") || productLabel.contains("Committers")) {
            return "Committers";
        }
        if (productLabel.contains("PHP")) {
            return "PHP";
        }
        if (productLabel.contains("Classic")) {
            return "Classic";
        }
        if (productLabel.contains("SOA")) {
            return "SOA";
        }
        if (productLabel.equals("Eclipse Platform")) {
            return "Platform";
        }
        if (productLabel.contains("Android")) {
            return "Android";
        }
        throw new RuntimeException("No key for " + productLabel);
    }

    private VersionRange createVersionRange(Version version, VersionSegment versionSegment) {
        VersionRange versionRange = P2Factory.eINSTANCE.createVersionRange(version, versionSegment);
        if (versionSegment == VersionSegment.MAJOR) {
            VersionRange minorVersionRange = P2Factory.eINSTANCE.createVersionRange(version, VersionSegment.MINOR);
            versionRange = new VersionRange(minorVersionRange.getMinimum(), true, versionRange.getMaximum(), false);
        }
        return versionRange;
    }

    private void addRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, Map<String, Set<IInstallableUnit>> ius) {
        String[] stringArray = this.getRootIUs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String iu = stringArray[n2];
            Set<IInstallableUnit> rootIUs = ius.get(iu);
            if (rootIUs != null) {
                this.addRootIURequirements(requirements, versionSegment, iu, rootIUs);
            }
            ++n2;
        }
    }

    private void addAllRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, Map<String, Set<IInstallableUnit>> ius) {
        for (Map.Entry<String, Set<IInstallableUnit>> entry : ius.entrySet()) {
            this.addRootIURequirements(requirements, versionSegment, entry.getKey(), entry.getValue());
        }
    }

    private void addRootIURequirements(EList<Requirement> requirements, VersionSegment versionSegment, String id, Set<IInstallableUnit> rootIUs) {
        VersionRange range = null;
        for (IInstallableUnit rootIU : rootIUs) {
            boolean isCategory = "true".equalsIgnoreCase(rootIU.getProperty("org.eclipse.equinox.p2.type.category"));
            if (isCategory) {
                Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                requirement.setName(id);
                requirement.setVersionRange(VersionRange.emptyRange);
                if (id.equals("Linux Tools")) {
                    requirement.setFilter("(osgi.os=linux)");
                }
                requirements.add((Object)requirement);
                return;
            }
            Version version = rootIU.getVersion();
            VersionRange versionRange = this.createVersionRange(version, versionSegment);
            if (range != null) continue;
            range = versionRange;
        }
        if (range != null) {
            Requirement requirement = P2Factory.eINSTANCE.createRequirement();
            requirement.setName(id);
            requirement.setVersionRange(range);
            requirements.add((Object)requirement);
        }
    }

    private void addAdditionalInstallRootIURequirements(EList<Requirement> requirements, String productName, String train, Map<String, IMetadataRepository> eppMetaDataRepositories, Map<String, Set<IInstallableUnit>> ius) {
        Set<String> rootInstallIUs;
        IMetadataRepository eppMetadataRepository = eppMetaDataRepositories.get(train);
        IInstallableUnit maxProductIU = null;
        if (eppMetadataRepository != null) {
            for (IInstallableUnit productIU : eppMetadataRepository.query(QueryUtil.createIUQuery((String)productName), null)) {
                if (maxProductIU != null && productIU.getVersion().compareTo((Object)maxProductIU.getVersion()) <= 0) continue;
                maxProductIU = productIU;
            }
        }
        if (maxProductIU != null && (rootInstallIUs = this.getRootInstallIUs(train, maxProductIU)) != null) {
            for (String id : rootInstallIUs) {
                Requirement requirement = P2Factory.eINSTANCE.createRequirement();
                requirement.setName(id);
                requirements.add((Object)requirement);
            }
        }
    }

    private String getTrainLabel(String train) {
        return String.valueOf(Character.toString((char)(train.charAt(0) + 65 - 97))) + train.substring(1);
    }

    /*
     * Loose catch block
     */
    private void attachBrandingInfos(final StringBuilder log, final Product product) {
        String staticIconURL;
        String name = product.getName();
        if (name.equals("org.eclipse.platform.ide")) {
            product.setDescription("This package contains the absolute minimal IDE, suitable only as a base for installing other tools.");
            return;
        }
        if (name.equals("all")) {
            product.setDescription("This package contains all categorized features of the release train. It can do <a href='https://en.wiktionary.org/wiki/eierlegende_Wollmilchsau'>everything</a>, but it's not pretty.");
        }
        if (name.startsWith("epp.package.")) {
            name = name.substring("epp.package.".length());
        }
        if ((staticIconURL = ICONS.get(name)) != null) {
            this.addImageURI(product, staticIconURL);
        }
        String[] trains = this.getTrains();
        int i = trains.length;
        while (i >= 0) {
            block13: {
                InputStream in = null;
                try {
                    String branch = i == trains.length ? "master" : trains[i].toUpperCase();
                    String url = "http://git.eclipse.org/c/epp/org.eclipse.epp.packages.git/plain/packages/org.eclipse.epp.package." + name + ".feature/epp.website.xml" + "?h=" + branch;
                    in = new URL(url).openStream();
                    log.append(url).append('\n');
                    DocumentBuilder documentBuilder = XMLUtil.createDocumentBuilder();
                    Element rootElement = XMLUtil.loadRootElement((DocumentBuilder)documentBuilder, (InputStream)in);
                    XMLUtil.handleElementsByTagName((Element)rootElement, (String)"packageMetaData", (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                        public void handleElement(Element element) throws Exception {
                            if (staticIconURL != null) {
                                log.append(staticIconURL).append('\n');
                            } else {
                                String iconurl = element.getAttribute("iconurl");
                                if (iconurl != null) {
                                    ProductCatalogGenerator.this.addImageURI(product, iconurl);
                                    log.append(iconurl).append('\n');
                                }
                            }
                            XMLUtil.handleChildElements((Element)element, (XMLUtil.ElementHandler)new XMLUtil.ElementHandler(){

                                public void handleElement(Element childElement) throws Exception {
                                    String description;
                                    String localName = childElement.getLocalName();
                                    if ("description".equals(localName) && (description = childElement.getTextContent()) != null) {
                                        product.setDescription(description.trim());
                                    }
                                }
                            });
                        }
                    });
                    IOUtil.closeSilent((Closeable)in);
                }
                catch (FileNotFoundException ex) {
                    log.append(ex.getMessage()).append(" (FAILED)\n");
                    break block13;
                }
                catch (Exception ex2) {
                    ex2.printStackTrace();
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtil.closeSilent(in);
                }
                return;
            }
            --i;
        }
        if (staticIconURL != null) {
            log.append(staticIconURL).append('\n');
        }
    }

    private void addImageURI(Product product, String imageURI) {
        if (ICON_DEFAULT.equals(imageURI)) {
            return;
        }
        EMap<String, String> brandingInfos = this.getBrandingInfos(product);
        if (!brandingInfos.containsKey((Object)"imageURI")) {
            brandingInfos.put((Object)"imageURI", (Object)imageURI);
        }
    }

    private EMap<String, String> getBrandingInfos(Product product) {
        Annotation annotation = product.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
        if (annotation == null) {
            annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
            product.getAnnotations().add((Object)annotation);
        }
        return annotation.getDetails();
    }

    private void getPackageBrandingSites() {
        block6: {
            InputStream packages = null;
            try {
                try {
                    URL packagesURL = new URL(PACKAGES_URI.toString());
                    packages = packagesURL.openStream();
                    List lines = IOUtil.readLines((InputStream)packages, (String)"UTF-8");
                    Pattern pattern = Pattern.compile("<a href=\"([^\"]+)\"[^>]*><span>([\\w]+)</span> Packages</a></span>");
                    PackageLocationLoader packageLocationLoader = new PackageLocationLoader(this);
                    LinkedHashSet<URI> locations = new LinkedHashSet<URI>();
                    for (String line : lines) {
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.find()) continue;
                        URI siteURI = URI.createURI((String)matcher.group(1));
                        String releaseName = matcher.group(2);
                        System.out.println(String.valueOf(releaseName) + " -> " + siteURI);
                        LinkedHashMap releaseLocations = new LinkedHashMap();
                        LinkedHashMap packageLocations = new LinkedHashMap();
                        releaseLocations.put(siteURI, packageLocations);
                        this.sites.put(releaseName.toLowerCase(), releaseLocations);
                        locations.add(siteURI);
                    }
                    URI releasePackages = URI.createURI((String)"http://download.eclipse.org/eclipse/downloads/");
                    this.getPlatformPackageBrandingSites(releasePackages);
                    this.getPlatformPackageBrandingSites(URI.createURI((String)"http://archive.eclipse.org/eclipse/downloads/"));
                    packageLocationLoader.perform(locations);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    IOUtil.closeSilent(packages);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(packages);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)packages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getGeneralPackageBrandingSites(URI releasePackages) {
        block12: {
            InputStream inputStream = null;
            try {
                try {
                    URL releasePackagesURL = new URL(releasePackages.toString());
                    inputStream = releasePackagesURL.openStream();
                    List lines = IOUtil.readLines((InputStream)inputStream, (String)"UTF-8");
                    Pattern pattern = Pattern.compile("<div class='package-teaser-title'><a href=\"([^\"]+)\">([^<]+)</a></div>");
                    for (String line : lines) {
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.find()) continue;
                        String packageName = matcher.group(2);
                        String key = this.getKey(packageName);
                        URI packageURI = URI.createURI((String)matcher.group(1));
                        if (packageURI.isRelative()) {
                            packageURI = packageURI.resolve(PACKAGES_URI);
                        }
                        Map<String, Map<URI, Map<String, URI>>> map = this.sites;
                        synchronized (map) {
                            block8: for (Map.Entry<String, Map<URI, Map<String, URI>>> releaseEntry : this.sites.entrySet()) {
                                for (Map.Entry<URI, Map<String, URI>> productEntry : releaseEntry.getValue().entrySet()) {
                                    if (!releasePackages.equals(productEntry.getKey())) continue;
                                    System.out.println(String.valueOf(releaseEntry.getKey()) + " -> " + packageName + " -> " + packageURI);
                                    productEntry.getValue().put(key, packageURI);
                                    break block8;
                                }
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    IOUtil.closeSilent(inputStream);
                    break block12;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(inputStream);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPlatformPackageBrandingSites(URI releasePackages) {
        block11: {
            InputStream inputStream = null;
            try {
                try {
                    URL releasePackagesURL = new URL(releasePackages.toString());
                    inputStream = releasePackagesURL.openStream();
                    List lines = IOUtil.readLines((InputStream)inputStream, (String)"UTF-8");
                    Pattern pattern = Pattern.compile("<a href=\"([^\"]+)\"[^>]*>(4\\.[^<]+)</a>");
                    for (String line : lines) {
                        Matcher matcher = pattern.matcher(line);
                        if (!matcher.find()) continue;
                        String packageVersion = matcher.group(2);
                        URI packageURI = URI.createURI((String)matcher.group(1));
                        if (packageURI.isRelative()) {
                            packageURI = packageURI.resolve(releasePackages);
                        }
                        int version = Integer.parseInt(packageVersion.substring(2, 3));
                        List<String> trains = Arrays.asList(this.getTrains());
                        int index = trains.indexOf("neon") - (6 - version);
                        if (index < 0 || index >= trains.size()) continue;
                        String train = trains.get(index);
                        Map<String, Map<URI, Map<String, URI>>> map = this.sites;
                        synchronized (map) {
                            Map<String, URI> packageLocations;
                            Map<URI, Map<String, URI>> releaseLocations = this.sites.get(train);
                            Iterator<Map<String, URI>> iterator = releaseLocations.values().iterator();
                            if (iterator.hasNext() && !(packageLocations = iterator.next()).containsKey("Platform")) {
                                System.out.println(String.valueOf(train) + " -> " + packageVersion + " -> " + packageURI);
                                packageLocations.put("Platform", packageURI);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    IOUtil.closeSilent(inputStream);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(inputStream);
                throw throwable;
            }
            IOUtil.closeSilent((Closeable)inputStream);
        }
    }

    private Set<String> getRootInstallIUs(String release, IInstallableUnit productIU) {
        TreeSet<String> rootInstallIUs = new TreeSet<String>();
        for (IRequirement requirement : productIU.getRequirements()) {
            String value;
            IRequiredCapability capability;
            IMatchExpression filter;
            if (!(requirement instanceof IRequiredCapability) || (filter = (capability = (IRequiredCapability)requirement).getFilter()) == null || !EPP_INSTALL_ROOTS_FILTER.equals(value = RequirementImpl.formatMatchExpression((IMatchExpression)filter))) continue;
            rootInstallIUs.add(capability.getName());
        }
        return rootInstallIUs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PackageLocationLoader
    extends WorkerPool<PackageLocationLoader, URI, LoadJob> {
        private ProductCatalogGenerator generator;

        public PackageLocationLoader(ProductCatalogGenerator generator) {
            this.generator = generator;
        }

        protected LoadJob createWorker(URI key, int workerID, boolean secondary) {
            return new LoadJob(this, key, workerID, secondary);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class LoadJob
        extends WorkerPool.Worker<URI, PackageLocationLoader> {
            private LoadJob(PackageLocationLoader loader, URI uri, int id, boolean secondary) {
                super("Load " + uri, (WorkerPool)loader, (Object)uri, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                PackageLocationLoader.this.generator.getGeneralPackageBrandingSites((URI)this.getKey());
                return Status.OK_STATUS;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProductGenerator
    extends WorkerPool<ProductGenerator, String, GenerateJob> {
        private ProductCatalogGenerator generator;

        public ProductGenerator(ProductCatalogGenerator generator) {
            this.generator = generator;
        }

        protected GenerateJob createWorker(String key, int workerID, boolean secondary) {
            return new GenerateJob(this, key, workerID, secondary);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class GenerateJob
        extends WorkerPool.Worker<String, ProductGenerator> {
            private GenerateJob(ProductGenerator loader, String productID, int id, boolean secondary) {
                super("Load " + productID, (WorkerPool)loader, (Object)productID, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                try {
                    ProductGenerator.this.generator.generateProduct((String)this.getKey());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RepositoryLoader
    extends WorkerPool<RepositoryLoader, String, LoadJob> {
        private ProductCatalogGenerator generator;

        public RepositoryLoader(ProductCatalogGenerator generator) {
            this.generator = generator;
        }

        protected LoadJob createWorker(String key, int workerID, boolean secondary) {
            return new LoadJob(this, key, workerID, secondary);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class LoadJob
        extends WorkerPool.Worker<String, RepositoryLoader> {
            private LoadJob(RepositoryLoader loader, String train, int id, boolean secondary) {
                super("Load " + train, (WorkerPool)loader, (Object)train, id, secondary);
            }

            protected IStatus perform(IProgressMonitor monitor) {
                try {
                    RepositoryLoader.this.generator.generate((String)this.getKey());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrainAndVersion {
        private final String train;
        private final Version version;
        private final Map<String, Set<IInstallableUnit>> ius;
        private final URI trainURI;
        private URI eppURI;

        public TrainAndVersion(String train, Version version, URI trainURI, URI eppURI, Map<String, Set<IInstallableUnit>> ius) {
            this.train = train;
            this.version = version;
            this.trainURI = trainURI;
            this.eppURI = eppURI;
            this.ius = ius;
        }

        public String getTrain() {
            return this.train;
        }

        public Version getVersion() {
            return this.version;
        }

        public URI getTrainURI() {
            return this.trainURI;
        }

        public URI getEPPURI() {
            return this.eppURI;
        }

        public Map<String, Set<IInstallableUnit>> getIUs() {
            return this.ius;
        }

        public String toString() {
            return this.train + "->" + this.version;
        }
    }
}

