/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui.internal;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.ui.AbstractDialog;
import org.eclipse.userstorage.ui.internal.Activator;

public class AddServiceDialog
extends AbstractDialog
implements ModifyListener {
    private Text serviceLabelText;
    private Text serviceURIText;
    private Text createAccountURIText;
    private Text editAccountURIText;
    private Text recoverPasswordURIText;
    private Text termsOfUseLinkText;
    private Button okButton;
    private String serviceLabel;
    private URI serviceURI;
    private URI createAccountURI;
    private URI editAccountURI;
    private URI recoverPasswordURI;
    private String termsOfUseLink;

    public AddServiceDialog(Shell parentShell) {
        super(parentShell);
    }

    public String getServiceLabel() {
        return this.serviceLabel;
    }

    public URI getServiceURI() {
        return this.serviceURI;
    }

    public URI getCreateAccountURI() {
        return this.createAccountURI;
    }

    public URI getEditAccountURI() {
        return this.editAccountURI;
    }

    public URI getRecoverPasswordURI() {
        return this.recoverPasswordURI;
    }

    public String getTermsOfUseLink() {
        return this.termsOfUseLink;
    }

    @Override
    protected IDialogSettings getPluginSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    @Override
    protected Point getMinimumSize() {
        return new Point(600, 350);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("User Storage Service");
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.setTitle("Add Service");
        this.setMessage("Enter a service label and a unique service URI.");
        this.initializeDialogUnits((Control)parent);
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout containerGridLayout = new GridLayout();
        containerGridLayout.numColumns = 2;
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)containerGridLayout);
        Label serviceLabelLabel = new Label(container, 0);
        serviceLabelLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        serviceLabelLabel.setText("Service label:");
        this.serviceLabelText = new Text(container, 2048);
        this.serviceLabelText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serviceLabelText.addModifyListener((ModifyListener)this);
        Label serviceURILabel = new Label(container, 0);
        serviceURILabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        serviceURILabel.setText("Service URI:");
        this.serviceURIText = new Text(container, 2048);
        this.serviceURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.serviceURIText.addModifyListener((ModifyListener)this);
        Label createAccountURILabel = new Label(container, 0);
        createAccountURILabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        createAccountURILabel.setText("Create account URI:");
        this.createAccountURIText = new Text(container, 2048);
        this.createAccountURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createAccountURIText.addModifyListener((ModifyListener)this);
        Label editAccountURILabel = new Label(container, 0);
        editAccountURILabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        editAccountURILabel.setText("Edit account URI:");
        this.editAccountURIText = new Text(container, 2048);
        this.editAccountURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.editAccountURIText.addModifyListener((ModifyListener)this);
        Label recoverPasswordURILabel = new Label(container, 0);
        recoverPasswordURILabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        recoverPasswordURILabel.setText("Recover password URI:");
        this.recoverPasswordURIText = new Text(container, 2048);
        this.recoverPasswordURIText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.recoverPasswordURIText.addModifyListener((ModifyListener)this);
        Label termsOfUseLinkLabel = new Label(container, 0);
        termsOfUseLinkLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        termsOfUseLinkLabel.setText("Terms of Use Link:");
        this.termsOfUseLinkText = new Text(container, 2048);
        this.termsOfUseLinkText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.termsOfUseLinkText.addModifyListener((ModifyListener)this);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void modifyText(ModifyEvent e) {
        String text;
        this.okButton.setEnabled(true);
        this.setErrorMessage(null);
        this.serviceLabel = this.serviceLabelText.getText();
        try {
            text = this.serviceURIText.getText();
            if (StringUtil.isEmpty((String)text)) {
                this.serviceURI = null;
            } else {
                this.serviceURI = new URI(text);
                if (IStorageService.Registry.INSTANCE.getService(this.serviceURI) != null) {
                    this.setErrorMessage("The service URI is not unique.");
                    this.okButton.setEnabled(false);
                    return;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setErrorMessage("The service URI is invalid.");
            this.okButton.setEnabled(false);
            return;
        }
        try {
            text = this.createAccountURIText.getText();
            this.createAccountURI = StringUtil.isEmpty((String)text) ? null : new URI(text);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setErrorMessage("The create account URI is invalid.");
            this.okButton.setEnabled(false);
            return;
        }
        try {
            text = this.editAccountURIText.getText();
            this.editAccountURI = StringUtil.isEmpty((String)text) ? null : new URI(text);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setErrorMessage("The edit account URI is invalid.");
            this.okButton.setEnabled(false);
            return;
        }
        try {
            text = this.recoverPasswordURIText.getText();
            this.recoverPasswordURI = StringUtil.isEmpty((String)text) ? null : new URI(text);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setErrorMessage("The recover password URI is invalid.");
            this.okButton.setEnabled(false);
            return;
        }
        text = this.termsOfUseLinkText.getText();
        String string = this.termsOfUseLink = StringUtil.isEmpty((String)text) ? null : text;
        if (StringUtil.isEmpty((String)this.serviceLabel)) {
            this.okButton.setEnabled(false);
            return;
        }
        if (this.serviceURI == null) {
            this.okButton.setEnabled(false);
            return;
        }
    }
}

